# -*- coding: utf-8 -*-
#
#  dll.py - a pseudo DLL (SHIORI/SAORI API support) module for ninix
#  Copyright (C) 2002-2011 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import sys
import imp
import logging
import os
import codecs


class SAORI:

    RESPONSE = {204: 'SAORI/1.0 204 No Content\r\n\r\n',
                400: 'SAORI/1.0 400 Bad Request\r\n\r\n',
                500: 'SAORI/1.0 500 Internal Server Error\r\n\r\n',
                }

    def __init__(self):
        self.loaded = 0

    def check_import(self):
        return 1

    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if not self.check_import():
            pass
        elif self.loaded:
            result = 2
        else:
            if self.setup():
                self.loaded = 1
                result = 1
        return result

    def setup(self):
        return 1

    def unload(self):
        if self.loaded == 0:
            return 0
        else:
            self.loaded = 0
            return self.finalize()

    def finalize(self):
        return 1

    def request(self, req):
        req_type, argument = self.evaluate_request(req)
        if not req_type:
            return self.RESPONSE[400]
        elif req_type == 'GET Version':
            return self.RESPONSE[204]
        elif req_type == 'EXECUTE':
            result = self.execute(argument)
            return self.RESPONSE[204] if result is None else result
        else:
            return self.RESPONSE[400]

    def execute(self, args):
        return None

    def evaluate_request(self, req):
        req_type = None
        argument = []
        self.charset = 'Shift_JIS' # default
        for line in req.splitlines():
            line = line.strip()
            if not line:
                continue
            if req_type is None:
                for request in ['EXECUTE', 'GET Version']: ## FIXME
                    if line.startswith(request):
                        req_type = request
                continue
            if ':' not in line:
                continue
            key, value = line.split(':', 1)
            key = key.strip()
            if key == 'Charset':
                charset = value.strip()
                try:
                    codecs.lookup(charset)
                except:
                    logging.warning('Unsupported charset %s' % repr(charset))
                else:
                    self.charset = charset
            if key.startswith('Argument'): ## FIXME
                argument.append(unicode(value, self.charset, 'ignore').strip())
            else:
                continue
        return req_type, argument


class Library:

    def __init__(self, dll_type, dir, sakura=None, saori_lib=None):
        self.__type = dll_type
        self.__dir_list = []
        self.__dir_list.append(dir)
        self.__sakura = sakura
        self.__saori_lib = saori_lib

    def request(self, name):
        if self.__type == 'shiori':
            dll_name, name = name
            if not name and dll_name:
                name = dll_name
        name = name.replace('\\', '/')
        head, tail = os.path.split(name)
        name = tail
        if name:
            if name.lower().endswith('.dll'): # XXX
                name = name[:-4]
        else:
            return None
        module = self.__import_module(name)
        if not module:
            return None
        else:
            instance = None
            if self.__type == 'saori':
                if getattr(module, 'Saori', None):
                    saori = module.Saori()
                    if getattr(saori, 'need_ghost_backdoor', None):
                        saori.need_ghost_backdoor(self.__sakura)
                else:
                    saori = None
                instance = saori
            elif self.__type == 'shiori':
                if getattr(module, 'Shiori', None):
                    shiori = module.Shiori(dll_name)
                    if getattr(shiori, 'use_saori', None):
                        shiori.use_saori(self.__saori_lib)
                else:
                    shiori = None
                instance = shiori
            if instance is None:
                del module
                del sys.modules[name]
            return instance

    def __import_module(self, name):
        fp = None
        try:
            return sys.modules[name]
        except:
            pass
        try:
            fp, pathname, description = imp.find_module(name, self.__dir_list)
        except:
            return None
        try:
            return imp.load_module(name, fp, pathname, description)
        finally:
            if fp:
                fp.close()
        return None
