/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import java.lang.reflect.Method;

@GwtCompatible
class Platform {
    static boolean checkIsInstance(Class<?> clazz, Object obj) {
        return clazz.isInstance(obj);
    }

    static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    static void checkCast(Class<?> clazz, Object obj) {
        clazz.cast(obj);
    }

    static String format(String template, Object ... args) {
        return String.format(template, args);
    }

    static Method getMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String classGetSimpleName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    private Platform() {
    }
}

