#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "mgwtypes.h"
#include "init.h"
#include "interface.h"
#include "support.h"

int
main (int argc, char *argv[])
{
  GtkWidget *app;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

  mgw_init ();

  app = (GtkWidget *) create_app ();
  gtk_widget_show (app);

  if (argc != 1)
    display_image_file (*(argv + 1));

  gtk_main ();
  return 0;
}
