<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */
// @codingStandardsIgnoreFile

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'Captcha' => array( 'Captcha' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'Captcha' => array( 'كابتشا' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'Captcha' => array( 'كابتشا' ),
);

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = array(
	'Captcha' => array( '驗證碼' ),
);

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = array(
	'Captcha' => array( 'Kodaİtimadi' ),
);

/** Esperanto (Esperanto) */
$specialPageAliases['eo'] = array(
	'Captcha' => array( 'Kontraŭspamilo' ),
);

/** Estonian (eesti) */
$specialPageAliases['et'] = array(
	'Captcha' => array( 'Robotilõks' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'Captcha' => array( 'کپچا' ),
);

/** Finnish (suomi) */
$specialPageAliases['fi'] = array(
	'Captcha' => array( 'Ihmiskäyttäjävarmistus' ),
);

/** Galician (galego) */
$specialPageAliases['gl'] = array(
	'Captcha' => array( 'Captcha' ),
);

/** Hawaiian (Hawai`i) */
$specialPageAliases['haw'] = array(
	'Captcha' => array( 'Kapakā', 'Kapaka' ),
);

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = array(
	'Captcha' => array( 'कैप्चा', 'कैपचा' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'Captcha' => array( '画像認証' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'Captcha' => array( '캡차' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'Captcha' => array( 'Kaptscha' ),
);

/** Cornish (kernowek) */
$specialPageAliases['kw'] = array(
	'Captcha' => array( 'Captcha' ),
);

/** Macedonian (македонски) */
$specialPageAliases['mk'] = array(
	'Captcha' => array( 'Captcha' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'Captcha' => array( 'ക്യാപ്ച' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$specialPageAliases['sr-ec'] = array(
	'Captcha' => array( 'Потврдни_код' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'Captcha' => array( 'GüvenlikKodu' ),
);

/** Cantonese (粵語) */
$specialPageAliases['yue'] = array(
	'Captcha' => array( '驗證碼' ),
);

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = array(
	'Captcha' => array( '验证码' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = array(
	'Captcha' => array( '驗證碼' ),
);