/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef LYRICSCACHE_H
#define LYRICSCACHE_H

#include "song.h"

#include <QObject>
#include <QPair>
#include <QString>

#include <QtSql/qsql.h>
#include <QSqlDatabase>


class LyricsCache : public QObject {

public:
	LyricsCache(QObject * = 0);
	virtual ~LyricsCache();
	
	bool isValid();
	
	bool writeLyric(const Song &, QString);
	QString readLyric(const Song &);
	bool deleteLyric(const Song &);
	
private:
	QSqlDatabase m_database;
	bool m_valid;
};

#endif // LYRICSCACHE_H
