/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "lyrics_cache.h"

#include <QSqlQuery>
#include <QVariant>
#include <QDebug>

#include <KGlobal>
#include <KStandardDirs>

LyricsCache::LyricsCache(QObject *parent) : QObject(parent){
	m_database = QSqlDatabase::addDatabase("QSQLITE");
	//m_database.setHostName("localhost");
	QString database_name = KGlobal::dirs()->saveLocation("data", "lyricsplasmoid/") + "lyrics_db";
	qDebug() << ":::LyricsCache::: Creating the cache database in " << database_name.trimmed();
	m_database.setDatabaseName(database_name);
	
	m_valid = false;
	if(m_database.open()) {
		m_valid = true;
		
		qDebug() << ":::LyricsCache::: Creating tables in database... ";
		QSqlQuery query(m_database);
		query.prepare("CREATE TABLE IF NOT EXISTS lyrics (id int unsigned auto_increment primary key, artist varchar(200), title varchar(200), lyric text)");
		
		m_valid = query.exec();
	}
}

bool LyricsCache::isValid() {
	return m_valid;
}

bool LyricsCache::writeLyric(const Song &song, QString lyric) {
	qDebug() << ":::LyricsCache::: Writing lyrics to database for the song " << song << ". ";
	QSqlQuery query(m_database);
	query.prepare("INSERT INTO lyrics (artist, title, lyric) VALUES (:artist, :title, :lyric)");
	query.bindValue("artist", song.artist, QSql::In);
	query.bindValue("title", song.title, QSql::In);
	query.bindValue("lyric", lyric);
	
	return query.exec();
}

QString LyricsCache::readLyric(const Song &song) {
	qDebug() << ":::LyricsCache::: Reading lyrics from database for the song " << song << ".";
	QSqlQuery query(m_database);
	query.prepare("SELECT lyric FROM lyrics WHERE artist = :artist AND title = :title");
	query.bindValue("artist", song.artist, QSql::In);
	query.bindValue("title", song.title, QSql::In);
	
	if(query.exec()) {
		if(query.next()) {
			return query.value(0).toString();
		}
	}
	
	return QString();
}

bool LyricsCache::deleteLyric(const Song &song) {
	qDebug() << ":::LyricsCache::: Deleting from database the song " << song << ".";
	QSqlQuery query(m_database);
	query.prepare("DELETE FROM lyrics WHERE artist = :artist AND title = :title");
	query.bindValue("artist", song.artist, QSql::In);
	query.bindValue("title", song.title, QSql::In);
	
	return query.exec();
}



LyricsCache::~LyricsCache() {
}