package loghelper;

#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

use strict;

BEGIN {
    use Exporter   ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

    $VERSION     = 1.00;
    # if using RCS/CVS, this may be preferred
    $VERSION = do { my @r = (q$Revision: 1.1 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; # must be all one line, for MakeMaker
    @ISA         = qw(Exporter);
    @EXPORT      = qw(&set_logfile &close_logfile &log_print &setVerbose);
    %EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],
    # your exported package globals go here,
    # as well as any optionally exported functions
    @EXPORT_OK   = ( ); # qw($Var1 %Hashit &func3);
}

# ------------------------------- Log into a file -------------------------------
local *LOGFILE;
our $nGlobalLog = 0;
our $nGlobalVerbose = 0;

sub setVerbose()
{
    $nGlobalVerbose = 1;
}

sub set_logfile($)
{
    my $sLogFile = shift;

    if (open(LOGFILE, ">$sLogFile"))
    {
        $nGlobalLog = 1;
    }
}
sub close_logfile()
{
    close(LOGFILE);
    $nGlobalLog = 0;
}

sub log_print($)
{
    my $sLine = shift;
    if ($nGlobalLog)
    {
        print LOGFILE $sLine;
    }
    if ($nGlobalVerbose == 1)
    {
        print $sLine;
    }
    else
    {
        # In this special case for NetBeans, which show if a debugger can access.
        # The Line should print anyway.
        if ($sLine =~ /Listening for transport/)
        {
            print $sLine;
        }
    }
}

1;
