/*****
*
* Copyright (C) 2004-2017 CS-SI. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoann.v@prelude-ids.com>
*
* This file is part of the Prelude library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*****/

#ifndef _LIBPRELUDE_PRELUDE_H
#define _LIBPRELUDE_PRELUDE_H

/*
 * LIBPRELUDE_VERSION:
 * Version of libprelude this header come from.
 *
 * This is mostly used by the libprelude detection routine in libprelude.m4
 * to make sure that the header version is consistant with the linked library.
 */
#define LIBPRELUDE_VERSION "4.0.0"

#define LIBPRELUDE_RELEASE_LEVEL_ALPHA  0xa
#define LIBPRELUDE_RELEASE_LEVEL_BETA   0xb
#define LIBPRELUDE_RELEASE_LEVEL_RC     0xc
#define LIBPRELUDE_RELEASE_LEVEL_FINAL  0xf

#define LIBPRELUDE_MAJOR_VERSION  4
#define LIBPRELUDE_MINOR_VERSION  0
#define LIBPRELUDE_MICRO_VERSION  0
#define LIBPRELUDE_LEVEL_VERSION  LIBPRELUDE_RELEASE_LEVEL_FINAL
#define LIBPRELUDE_SERIAL_VERSION  0


#define LIBPRELUDE_HEXVERSION  ((LIBPRELUDE_MAJOR_VERSION << 24) | \
                                (LIBPRELUDE_MINOR_VERSION << 16) | \
                                (LIBPRELUDE_MICRO_VERSION <<  8) | \
                                (LIBPRELUDE_LEVEL_VERSION <<  4) | \
                                (LIBPRELUDE_SERIAL_VERSION << 0))


#include "prelude-inttypes.h"
#include "prelude-macros.h"
#include "common.h"
#include "prelude-client.h"
#include "prelude-connection.h"
#include "prelude-connection-pool.h"
#include "prelude-error.h"
#include "prelude-io.h"
#include "prelude-option.h"
#include "prelude-async.h"
#include "prelude-error.h"
#include "prelude-plugin.h"
#include "prelude-msg.h"
#include "prelude-msgbuf.h"
#include "prelude-timer.h"
#include "idmef.h"

#ifdef __cplusplus
 extern "C" {
#endif

int prelude_init(int *argc, char **argv);

void prelude_deinit(void);

int prelude_parse_version(const char *version, unsigned int *out);

const char *prelude_check_version(const char *req_version);

int prelude_thread_init(void *future_use);

void prelude_fork_prepare(void);

void prelude_fork_parent(void);

void prelude_fork_child(void);


#ifdef __cplusplus
 }
#endif

#endif /* _LIBPRELUDE_PRELUDE_H */
