
/*****
*
* Copyright (C) 2016 CS-SI. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoannv@gmail.com>
*
* This file is part of the Prelude library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
*****/

/* Auto-generated by the GenerateIDMEFMessagePrintJSONC package */

#include "config.h"
#include "libmissing.h"

#include <stdio.h>
#include <string.h>

#include "idmef.h"
#include "idmef-tree-wrap.h"
#include "idmef-message-print-json.h"


#define conv_uint8 conv_uint64
#define conv_uint16 conv_uint64
#define conv_uint32 conv_uint64
#define conv_int8 conv_int64
#define conv_int16 conv_int64
#define conv_int32 conv_int64


static int conv_uint64(prelude_io_t *fd, uint64_t value)
{
        int ret;
        char buf[32];

        ret = snprintf(buf, sizeof(buf), "%" PRELUDE_PRIu64, value);
        if ( ret < 0 || ret >= sizeof(buf) )
                return -1;

        return prelude_io_write(fd, buf, ret);
}


static int conv_int64(prelude_io_t *fd, int64_t value)
{
        int ret;
        char buf[32];

        ret = snprintf(buf, sizeof(buf), "%" PRELUDE_PRId64, value);
        if ( ret < 0 || ret >= sizeof(buf) )
                return -1;

        return prelude_io_write(fd, buf, ret);
}


static int conv_float(prelude_io_t *fd, float value)
{
        int ret;
        char buf[32];

        ret = snprintf(buf, sizeof(buf), "%f", value);
        if ( ret < 0 || ret >= sizeof(buf) )
                return -1;

        return prelude_io_write(fd, buf, ret);
}


static int conv_string(prelude_io_t *fd, prelude_string_t *string)
{
        size_t i;
        ssize_t ret;
        const unsigned char *content;

        content = (const unsigned char *) prelude_string_get_string_or_default(string, "");
        ret = prelude_io_write(fd, "\"", 1);
        if ( ret < 0 )
                return ret;

        for ( i = 0; i < prelude_string_get_len(string); i++, content++ ) {
                switch(*content) {
                        case '\\':
                        case '"':
                        case '/':
                                ret = prelude_io_write(fd, "\\", 1);
                                if ( ret < 0 )
                                        return ret;

                                ret = prelude_io_write(fd, content, 1);
                                break;
                        case '\b':
                                ret = prelude_io_write(fd, "\\b", 2);
                                break;
                        case '\t':
                                ret = prelude_io_write(fd, "\\t", 2);
                                break;
                        case '\n':
                                ret = prelude_io_write(fd, "\\n", 2);
                                break;
                        case '\f':
                                ret = prelude_io_write(fd, "\\f", 2);
                                break;
                        case '\r':
                                ret = prelude_io_write(fd, "\\r", 2);
                                break;
                        default:
                                if ( *content >= 0x20 )
                                        ret = prelude_io_write(fd, content, 1);
                                else {
                                        char seq[7];
                                        snprintf(seq, sizeof(seq), "\\u%04X", *content);
                                        ret = prelude_io_write(fd, seq, strlen(seq));
                                }
                }

                if ( ret < 0 )
                        return ret;
        }

        return prelude_io_write(fd, "\"", 1);
}


static int conv_time(prelude_io_t *fd, idmef_time_t *t)
{
        int ret;
        prelude_string_t *str;

        if ( ! t )
                return 0;

        ret = prelude_string_new(&str);
        if ( ret < 0 )
                return ret;

        ret = idmef_time_to_string(t, str);
        if ( ret < 0 )
                goto error;

        ret = conv_string(fd, str);

error:
        prelude_string_destroy(str);
        return ret;
}


static int conv_data(prelude_io_t *fd, idmef_data_t *data)
{
        int ret;
        prelude_string_t *out;

        ret = prelude_string_new(&out);
        if ( ret < 0 )
                return ret;

        ret = idmef_data_to_string(data, out);
        if ( ret < 0 )
                goto error;

        switch (idmef_data_get_type(data)) {
                case IDMEF_DATA_TYPE_INT:
                case IDMEF_DATA_TYPE_FLOAT:
                        ret = prelude_io_write(fd, prelude_string_get_string(out), prelude_string_get_len(out));
                        break;
                default:
                        ret = conv_string(fd, out);
                        break;
        }
error:
        prelude_string_destroy(out);
        return ret;
}


static int do_write(prelude_io_t *fd, const char *str)
{
        return prelude_io_write(fd, str, strlen(str));
}


/**
 * idmef_additional_data_json:
 * @ptr: Pointer to an idmef_additional_data_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_additional_data_print_json(idmef_additional_data_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_additional_data_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_additional_data_get_meaning(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"meaning\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_additional_data_get_type(ptr);

                {
                        const char *enumstr = idmef_additional_data_type_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"type\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                idmef_data_t *field;

                field = idmef_additional_data_get_data(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"data\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_data(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_reference_json:
 * @ptr: Pointer to an idmef_reference_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_reference_print_json(idmef_reference_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_reference_t\"");
        if ( ret < 0 )
                return ret;


        {
                int i = idmef_reference_get_origin(ptr);

                {
                        const char *enumstr = idmef_reference_origin_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"origin\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_reference_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_reference_get_url(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"url\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_reference_get_meaning(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"meaning\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_classification_json:
 * @ptr: Pointer to an idmef_classification_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_classification_print_json(idmef_classification_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_classification_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_classification_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_classification_get_text(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"text\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_reference_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_classification_get_next_reference(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"reference\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_reference_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_user_id_json:
 * @ptr: Pointer to an idmef_user_id_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_user_id_print_json(idmef_user_id_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_user_id_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_user_id_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_user_id_get_type(ptr);

                {
                        const char *enumstr = idmef_user_id_type_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"type\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_user_id_get_tty(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"tty\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_user_id_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_user_id_get_number(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"number\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_user_json:
 * @ptr: Pointer to an idmef_user_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_user_print_json(idmef_user_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_user_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_user_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_user_get_category(ptr);

                {
                        const char *enumstr = idmef_user_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {

                idmef_user_id_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_user_get_next_user_id(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"user_id\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_user_id_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_address_json:
 * @ptr: Pointer to an idmef_address_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_address_print_json(idmef_address_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_address_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_address_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_address_get_category(ptr);

                {
                        const char *enumstr = idmef_address_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_address_get_vlan_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"vlan_name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int32_t *field;

                field = idmef_address_get_vlan_num(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"vlan_num\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_int32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_address_get_address(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"address\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_address_get_netmask(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"netmask\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_process_json:
 * @ptr: Pointer to an idmef_process_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_process_print_json(idmef_process_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_process_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_process_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_process_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_process_get_pid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"pid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_process_get_path(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"path\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                prelude_string_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_process_get_next_arg(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"arg\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = conv_string(fd, elem);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                prelude_string_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_process_get_next_env(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"env\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = conv_string(fd, elem);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_web_service_json:
 * @ptr: Pointer to an idmef_web_service_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_web_service_print_json(idmef_web_service_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_web_service_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_web_service_get_url(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"url\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_web_service_get_cgi(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"cgi\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_web_service_get_http_method(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"http_method\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                prelude_string_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_web_service_get_next_arg(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"arg\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = conv_string(fd, elem);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_snmp_service_json:
 * @ptr: Pointer to an idmef_snmp_service_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_snmp_service_print_json(idmef_snmp_service_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_snmp_service_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_snmp_service_get_oid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"oid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_snmp_service_get_message_processing_model(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"message_processing_model\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_snmp_service_get_security_model(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"security_model\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_snmp_service_get_security_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"security_name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_snmp_service_get_security_level(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"security_level\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_snmp_service_get_context_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"context_name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_snmp_service_get_context_engine_id(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"context_engine_id\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_snmp_service_get_command(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"command\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_service_json:
 * @ptr: Pointer to an idmef_service_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_service_print_json(idmef_service_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_service_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_service_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint8_t *field;

                field = idmef_service_get_ip_version(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ip_version\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint8(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint8_t *field;

                field = idmef_service_get_iana_protocol_number(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"iana_protocol_number\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint8(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_service_get_iana_protocol_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"iana_protocol_name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_service_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint16_t *field;

                field = idmef_service_get_port(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"port\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint16(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_service_get_portlist(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"portlist\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_service_get_protocol(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"protocol\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        switch ( idmef_service_get_type(ptr) ) {
        case IDMEF_SERVICE_TYPE_WEB:
                ret = do_write(fd, ", \"web_service\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_web_service_print_json(idmef_service_get_web_service(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        case IDMEF_SERVICE_TYPE_SNMP:
                ret = do_write(fd, ", \"snmp_service\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_snmp_service_print_json(idmef_service_get_snmp_service(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        default:
                break;
        }

        return do_write(fd, "}");
}

/**
 * idmef_node_json:
 * @ptr: Pointer to an idmef_node_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_node_print_json(idmef_node_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_node_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_node_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_node_get_category(ptr);

                {
                        const char *enumstr = idmef_node_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_node_get_location(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"location\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_node_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_address_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_node_get_next_address(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"address\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_address_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_source_json:
 * @ptr: Pointer to an idmef_source_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_source_print_json(idmef_source_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_source_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_source_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_source_get_spoofed(ptr);

                {
                        const char *enumstr = idmef_source_spoofed_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"spoofed\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_source_get_interface(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"interface\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_node_t *field;

                field = idmef_source_get_node(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"node\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_node_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_user_t *field;

                field = idmef_source_get_user(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"user\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_user_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_process_t *field;

                field = idmef_source_get_process(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"process\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_process_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_service_t *field;

                field = idmef_source_get_service(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"service\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_service_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_file_access_json:
 * @ptr: Pointer to an idmef_file_access_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_file_access_print_json(idmef_file_access_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_file_access_t\"");
        if ( ret < 0 )
                return ret;


        {
                idmef_user_id_t *field;

                field = idmef_file_access_get_user_id(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"user_id\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_user_id_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                prelude_string_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_file_access_get_next_permission(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"permission\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = conv_string(fd, elem);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_inode_json:
 * @ptr: Pointer to an idmef_inode_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_inode_print_json(idmef_inode_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_inode_t\"");
        if ( ret < 0 )
                return ret;


        {
                idmef_time_t *field;

                field = idmef_inode_get_change_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"change_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_inode_get_number(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"number\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_inode_get_major_device(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"major_device\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_inode_get_minor_device(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"minor_device\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_inode_get_c_major_device(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"c_major_device\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_inode_get_c_minor_device(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"c_minor_device\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_checksum_json:
 * @ptr: Pointer to an idmef_checksum_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_checksum_print_json(idmef_checksum_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_checksum_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_checksum_get_value(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"value\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_checksum_get_key(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"key\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_checksum_get_algorithm(ptr);

                {
                        const char *enumstr = idmef_checksum_algorithm_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"algorithm\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_file_json:
 * @ptr: Pointer to an idmef_file_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_file_print_json(idmef_file_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_file_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_file_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_file_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_file_get_path(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"path\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_file_get_create_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"create_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_file_get_modify_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"modify_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_file_get_access_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"access_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint64_t *field;

                field = idmef_file_get_data_size(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"data_size\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint64(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint64_t *field;

                field = idmef_file_get_disk_size(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"disk_size\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint64(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_file_access_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_file_get_next_file_access(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"file_access\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_file_access_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_linkage_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_file_get_next_linkage(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"linkage\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_linkage_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_inode_t *field;

                field = idmef_file_get_inode(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"inode\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_inode_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_checksum_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_file_get_next_checksum(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"checksum\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_checksum_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_file_get_category(ptr);

                {
                        const char *enumstr = idmef_file_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                int *i = idmef_file_get_fstype(ptr);

                if ( i )

                {
                        const char *enumstr = idmef_file_fstype_to_string(*i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"fstype\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_file_get_file_type(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"file_type\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_linkage_json:
 * @ptr: Pointer to an idmef_linkage_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_linkage_print_json(idmef_linkage_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_linkage_t\"");
        if ( ret < 0 )
                return ret;


        {
                int i = idmef_linkage_get_category(ptr);

                {
                        const char *enumstr = idmef_linkage_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_linkage_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_linkage_get_path(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"path\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_file_t *field;

                field = idmef_linkage_get_file(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"file\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_file_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_target_json:
 * @ptr: Pointer to an idmef_target_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_target_print_json(idmef_target_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_target_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_target_get_ident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                int i = idmef_target_get_decoy(ptr);

                {
                        const char *enumstr = idmef_target_decoy_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"decoy\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_target_get_interface(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"interface\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_node_t *field;

                field = idmef_target_get_node(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"node\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_node_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_user_t *field;

                field = idmef_target_get_user(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"user\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_user_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_process_t *field;

                field = idmef_target_get_process(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"process\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_process_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_service_t *field;

                field = idmef_target_get_service(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"service\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_service_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_file_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_target_get_next_file(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"file\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_file_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_analyzer_json:
 * @ptr: Pointer to an idmef_analyzer_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_analyzer_print_json(idmef_analyzer_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_analyzer_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_analyzer_get_analyzerid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"analyzerid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_manufacturer(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"manufacturer\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_model(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"model\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_version(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"version\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_class(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"class\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_ostype(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"ostype\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_analyzer_get_osversion(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"osversion\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_node_t *field;

                field = idmef_analyzer_get_node(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"node\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_node_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_process_t *field;

                field = idmef_analyzer_get_process(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"process\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_process_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_alertident_json:
 * @ptr: Pointer to an idmef_alertident_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_alertident_print_json(idmef_alertident_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_alertident_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_alertident_get_alertident(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"alertident\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_alertident_get_analyzerid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"analyzerid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_impact_json:
 * @ptr: Pointer to an idmef_impact_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_impact_print_json(idmef_impact_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_impact_t\"");
        if ( ret < 0 )
                return ret;


        {
                int *i = idmef_impact_get_severity(ptr);

                if ( i )

                {
                        const char *enumstr = idmef_impact_severity_to_string(*i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"severity\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                int *i = idmef_impact_get_completion(ptr);

                if ( i )

                {
                        const char *enumstr = idmef_impact_completion_to_string(*i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"completion\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                int i = idmef_impact_get_type(ptr);

                {
                        const char *enumstr = idmef_impact_type_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"type\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_impact_get_description(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"description\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_action_json:
 * @ptr: Pointer to an idmef_action_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_action_print_json(idmef_action_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_action_t\"");
        if ( ret < 0 )
                return ret;


        {
                int i = idmef_action_get_category(ptr);

                {
                        const char *enumstr = idmef_action_category_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"category\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                prelude_string_t *field;

                field = idmef_action_get_description(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"description\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_confidence_json:
 * @ptr: Pointer to an idmef_confidence_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_confidence_print_json(idmef_confidence_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_confidence_t\"");
        if ( ret < 0 )
                return ret;


        {
                int i = idmef_confidence_get_rating(ptr);

                {
                        const char *enumstr = idmef_confidence_rating_to_string(i);

                        if ( enumstr ) {
                                ret = do_write(fd, ", \"rating\": \"");
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, enumstr);
                                if ( ret < 0 )
                                        return ret;

                                ret = do_write(fd, "\"");
                                if ( ret < 0 )
                                        return ret;
                        }
                }
        }

        {
                float field;

                field = idmef_confidence_get_confidence(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"confidence\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_float(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_assessment_json:
 * @ptr: Pointer to an idmef_assessment_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_assessment_print_json(idmef_assessment_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_assessment_t\"");
        if ( ret < 0 )
                return ret;


        {
                idmef_impact_t *field;

                field = idmef_assessment_get_impact(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"impact\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_impact_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_action_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_assessment_get_next_action(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"action\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_action_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_confidence_t *field;

                field = idmef_assessment_get_confidence(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"confidence\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_confidence_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_tool_alert_json:
 * @ptr: Pointer to an idmef_tool_alert_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_tool_alert_print_json(idmef_tool_alert_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_tool_alert_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_tool_alert_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                prelude_string_t *field;

                field = idmef_tool_alert_get_command(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"command\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_alertident_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_tool_alert_get_next_alertident(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"alertident\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_alertident_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_correlation_alert_json:
 * @ptr: Pointer to an idmef_correlation_alert_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_correlation_alert_print_json(idmef_correlation_alert_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_correlation_alert_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_correlation_alert_get_name(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"name\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_alertident_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_correlation_alert_get_next_alertident(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"alertident\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_alertident_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_overflow_alert_json:
 * @ptr: Pointer to an idmef_overflow_alert_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_overflow_alert_print_json(idmef_overflow_alert_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_overflow_alert_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_overflow_alert_get_program(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"program\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_overflow_alert_get_size(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"size\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_data_t *field;

                field = idmef_overflow_alert_get_buffer(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"buffer\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_data(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_alert_json:
 * @ptr: Pointer to an idmef_alert_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_alert_print_json(idmef_alert_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_alert_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_alert_get_messageid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"messageid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_analyzer_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_alert_get_next_analyzer(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"analyzer\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_analyzer_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_alert_get_create_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"create_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_classification_t *field;

                field = idmef_alert_get_classification(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"classification\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_classification_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_alert_get_detect_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"detect_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_alert_get_analyzer_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"analyzer_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_source_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_alert_get_next_source(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"source\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_source_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_target_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_alert_get_next_target(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"target\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_target_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_assessment_t *field;

                field = idmef_alert_get_assessment(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"assessment\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = idmef_assessment_print_json(field, fd);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_additional_data_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_alert_get_next_additional_data(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"additional_data\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_additional_data_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        switch ( idmef_alert_get_type(ptr) ) {
        case IDMEF_ALERT_TYPE_TOOL:
                ret = do_write(fd, ", \"tool_alert\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_tool_alert_print_json(idmef_alert_get_tool_alert(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        case IDMEF_ALERT_TYPE_CORRELATION:
                ret = do_write(fd, ", \"correlation_alert\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_correlation_alert_print_json(idmef_alert_get_correlation_alert(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        case IDMEF_ALERT_TYPE_OVERFLOW:
                ret = do_write(fd, ", \"overflow_alert\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_overflow_alert_print_json(idmef_alert_get_overflow_alert(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        default:
                break;
        }

        return do_write(fd, "}");
}

/**
 * idmef_heartbeat_json:
 * @ptr: Pointer to an idmef_heartbeat_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_heartbeat_print_json(idmef_heartbeat_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_heartbeat_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_heartbeat_get_messageid(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"messageid\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_analyzer_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_heartbeat_get_next_analyzer(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"analyzer\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_analyzer_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_heartbeat_get_create_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"create_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                idmef_time_t *field;

                field = idmef_heartbeat_get_analyzer_time(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"analyzer_time\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_time(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {
                uint32_t *field;

                field = idmef_heartbeat_get_heartbeat_interval(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"heartbeat_interval\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_uint32(fd, *field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        {

                idmef_additional_data_t *elem = NULL;
                int first = 1;

                while ( (elem = idmef_heartbeat_get_next_additional_data(ptr, elem)) ) {
                        if ( ! first )
                                ret = do_write(fd, ", ");
                        else {
                                first = 0;
                                ret = do_write(fd, ", \"additional_data\": [");
                        }

                        if ( ret < 0 )
                                return ret;


                        ret = idmef_additional_data_print_json(elem, fd);
                        if ( ret < 0 )
                                return ret;

                }

                if ( ! first ) {
                        ret = do_write(fd, "]");
                        if ( ret < 0 )
                                return ret;
                }
        }

        return do_write(fd, "}");
}

/**
 * idmef_message_json:
 * @ptr: Pointer to an idmef_message_t object.
 *
 * This function will convert @ptr to a json,
 */
int idmef_message_print_json(idmef_message_t *ptr, prelude_io_t *fd)
{
        int ret;

        if ( ! ptr )
                return 0;

        ret = do_write(fd, "{\"_self\": \"idmef_message_t\"");
        if ( ret < 0 )
                return ret;


        {
                prelude_string_t *field;

                field = idmef_message_get_version(ptr);
                if ( field ) {
                        ret = do_write(fd, ", \"version\": ");
                        if ( ret < 0 )
                                return ret;

                        ret = conv_string(fd, field);
                        if ( ret < 0 )
                                return ret;
                }
        }

        switch ( idmef_message_get_type(ptr) ) {
        case IDMEF_MESSAGE_TYPE_ALERT:
                ret = do_write(fd, ", \"alert\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_alert_print_json(idmef_message_get_alert(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        case IDMEF_MESSAGE_TYPE_HEARTBEAT:
                ret = do_write(fd, ", \"heartbeat\": ");
                if ( ret < 0 )
                        return ret;

                ret = idmef_heartbeat_print_json(idmef_message_get_heartbeat(ptr), fd);
                if ( ret < 0 )
                        return ret;
                break;

        default:
                break;
        }

        return do_write(fd, "}");
}