/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ValueRecordsAggregate
extends Record {
    public static final short sid = -1000;
    int firstcell;
    int lastcell;
    CellValueRecordInterface[][] records;

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface[] rowCells;
        int newSize;
        short column = cell.getColumn();
        int row = cell.getRow();
        if (row >= this.records.length) {
            CellValueRecordInterface[][] oldRecords = this.records;
            newSize = oldRecords.length * 2;
            if (newSize < row + 1) {
                newSize = row + 1;
            }
            this.records = new CellValueRecordInterface[newSize][];
            System.arraycopy(oldRecords, 0, this.records, 0, oldRecords.length);
        }
        if ((rowCells = this.records[row]) == null) {
            newSize = column + 1;
            if (newSize < 10) {
                newSize = 10;
            }
            rowCells = new CellValueRecordInterface[newSize];
            this.records[row] = rowCells;
        }
        if (column >= rowCells.length) {
            CellValueRecordInterface[] oldRowCells = rowCells;
            int newSize2 = oldRowCells.length * 2;
            if (newSize2 < column + 1) {
                newSize2 = column + 1;
            }
            rowCells = new CellValueRecordInterface[newSize2];
            System.arraycopy(oldRowCells, 0, rowCells, 0, oldRowCells.length);
            this.records[row] = rowCells;
        }
        rowCells[column] = cell;
        if (column < this.firstcell || this.firstcell == -1) {
            this.firstcell = column;
        }
        if (column > this.lastcell || this.lastcell == -1) {
            this.lastcell = column;
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        if (cell != null) {
            short column = cell.getColumn();
            int row = cell.getRow();
            if (row >= this.records.length) {
                return;
            }
            CellValueRecordInterface[] rowCells = this.records[row];
            if (rowCells == null) {
                return;
            }
            if (column >= rowCells.length) {
                return;
            }
            rowCells[column] = null;
        }
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        int r = 0;
        while (r < this.records.length) {
            CellValueRecordInterface[] rowCells = this.records[r];
            if (rowCells != null) {
                int c = 0;
                while (c < rowCells.length) {
                    if (rowCells[c] != null) {
                        ++count;
                    }
                    c = (short)(c + 1);
                }
            }
            ++r;
        }
        return count;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public int construct(int offset, List records) {
        int k = 0;
        FormulaRecordAggregate lastFormulaAggregate = null;
        ArrayList<Record> sharedFormulas = new ArrayList<Record>();
        k = offset;
        while (k < records.size()) {
            Record rec = (Record)records.get(k);
            if (!(rec instanceof StringRecord) && !rec.isInValueSection() && !(rec instanceof UnknownRecord)) break;
            if (rec instanceof SharedFormulaRecord) {
                sharedFormulas.add(rec);
            } else if (rec instanceof FormulaRecord) {
                FormulaRecord formula = (FormulaRecord)rec;
                if (formula.isSharedFormula()) {
                    Record nextRecord = (Record)records.get(k + 1);
                    if (nextRecord instanceof SharedFormulaRecord) {
                        sharedFormulas.add(nextRecord);
                        ++k;
                    }
                    boolean found = false;
                    int i = sharedFormulas.size() - 1;
                    while (i >= 0) {
                        SharedFormulaRecord shrd = (SharedFormulaRecord)sharedFormulas.get(i);
                        if (shrd.isFormulaInShared(formula)) {
                            shrd.convertSharedFormulaRecord(formula);
                            found = true;
                            break;
                        }
                        --i;
                    }
                }
                lastFormulaAggregate = new FormulaRecordAggregate((FormulaRecord)rec, null);
                this.insertCell(lastFormulaAggregate);
            } else if (rec instanceof StringRecord) {
                lastFormulaAggregate.setStringRecord((StringRecord)rec);
            } else if (rec.isValue()) {
                this.insertCell((CellValueRecordInterface)((Object)rec));
            }
            ++k;
        }
        return k;
    }

    public int serialize(int offset, byte[] data) {
        throw new RuntimeException("This method shouldnt be called. ValueRecordsAggregate.serializeCellRow() should be called from RowRecordsAggregate.");
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        MyIterator itr = new MyIterator(startRow, endRow);
        int size = 0;
        while (itr.hasNext()) {
            CellValueRecordInterface cell = (CellValueRecordInterface)itr.next();
            int row = cell.getRow();
            if (row > endRow) break;
            if (row < startRow || row > endRow) continue;
            size += ((Record)((Object)cell)).getRecordSize();
        }
        return size;
    }

    public boolean rowHasCells(int row) {
        if (row > this.records.length - 1) {
            return false;
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            return false;
        }
        int col = 0;
        while (col < rowCells.length) {
            if (rowCells[col] != null) {
                return true;
            }
            ++col;
        }
        return false;
    }

    public int serializeCellRow(int row, int offset, byte[] data) {
        MyIterator itr = new MyIterator(row, row);
        int pos = offset;
        while (itr.hasNext()) {
            CellValueRecordInterface cell = (CellValueRecordInterface)itr.next();
            if (cell.getRow() != row) break;
            pos += ((Record)((Object)cell)).serialize(pos, data);
        }
        return pos - offset;
    }

    protected void fillFields(RecordInputStream in) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1000;
    }

    public int getRecordSize() {
        int size = 0;
        Iterator irecs = this.getIterator();
        while (irecs.hasNext()) {
            size += ((Record)irecs.next()).getRecordSize();
        }
        return size;
    }

    public Iterator getIterator() {
        return new MyIterator();
    }

    public Object clone() {
        ValueRecordsAggregate rec = new ValueRecordsAggregate();
        Iterator valIter = this.getIterator();
        while (valIter.hasNext()) {
            CellValueRecordInterface val = (CellValueRecordInterface)((CellValueRecordInterface)valIter.next()).clone();
            rec.insertCell(val);
        }
        return rec;
    }

    private final /* synthetic */ void this() {
        this.firstcell = -1;
        this.lastcell = -1;
    }

    public ValueRecordsAggregate() {
        this.this();
        this.records = new CellValueRecordInterface[30][];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MyIterator
    implements Iterator {
        short nextColumn;
        int nextRow;
        int lastRow;

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextRow <= this.lastRow) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            CellValueRecordInterface o = ValueRecordsAggregate.this.records[this.nextRow][this.nextColumn];
            this.findNext();
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException("gibt's noch nicht");
        }

        /*
         * Unable to fully structure code
         */
        private final void findNext() {
            this.nextColumn = (short)(this.nextColumn + 1);
            while (this.nextRow <= this.lastRow) {
                block3: {
                    v0 = rowCells = this.nextRow < ValueRecordsAggregate.this.records.length ? ValueRecordsAggregate.this.records[this.nextRow] : null;
                    if (rowCells != null) ** GOTO lbl10
                    this.nextColumn = 0;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        if (rowCells[this.nextColumn] != null) {
                            return;
                        }
                        this.nextColumn = (short)(this.nextColumn + 1);
lbl10:
                        // 2 sources

                        ** while (this.nextColumn < rowCells.length)
                    }
lbl11:
                    // 1 sources

                    this.nextColumn = 0;
                }
                ++this.nextRow;
            }
        }

        private final /* synthetic */ void this() {
            this.nextColumn = (short)-1;
        }

        public MyIterator() {
            this.this();
            this.nextRow = 0;
            this.lastRow = ValueRecordsAggregate.this.records.length - 1;
            this.findNext();
        }

        public MyIterator(int firstRow, int lastRow) {
            this.this();
            this.nextRow = firstRow;
            this.lastRow = lastRow;
            this.findNext();
        }
    }
}

