/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class TrimFunction
implements Function {
    private static final long serialVersionUID = 7379670108270974597L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        String result = context.getTypeRegistry().convertToText(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        char[] chars = result.toCharArray();
        StringBuffer b = new StringBuffer(chars.length);
        boolean removeNextWs = true;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (removeNextWs) continue;
                b.append(c);
                removeNextWs = true;
                continue;
            }
            b.append(c);
            removeNextWs = false;
        }
        String trimmedResult = removeNextWs ? b.substring(0, b.length() - 1) : b.toString();
        return new TypeValuePair(TextType.TYPE, trimmedResult);
    }

    public String getCanonicalName() {
        return "TRIM";
    }
}

