/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qtabwidget.h>
#include <qlayout.h>
#include <qsplitter.h>

#include <klocale.h>

#include "KYumPreferences.h"
#include "Process.h"
#include "OutputView.h"
#include "GroupsView.h"
#include "GroupsTab.h"


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

GroupsTab::GroupsTab(QWidget * pParent)

  : QWidget(pParent)

{
    QVBoxLayout * pTopLayout = new QVBoxLayout(this);
    pTopLayout->setAutoAdd(true);

    QSplitter * pVSplitter = new QSplitter(this);
    pVSplitter->setOrientation(QSplitter::Vertical);

    m_pGroupsView = new GroupsView(pVSplitter);

    QTabWidget * pOutputWidget = new QTabWidget(pVSplitter);
    pOutputWidget->addTab(m_pOutputView = new OutputView(pOutputWidget), i18n("Output"));

    connect(m_pGroupsView, SIGNAL(yumInfo(QString)),
            this,          SLOT(slotYumInfo(QString)));

    connect(m_pGroupsView, SIGNAL(yumError(QString)),
            this,          SLOT(slotYumError(QString)));

    connect(m_pGroupsView, SIGNAL(actionStarted(Process *)),
            this,          SLOT(slotActionStarted(Process *)));

    connect(m_pGroupsView, SIGNAL(actionTerminated(Process *)),
            this,          SLOT(slotActionTerminated(Process *)));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void GroupsTab::slotActionStarted(Process * pProcess)
{
    QString strMsg,
            strCmd;

    strMsg.sprintf(i18n("Process %u (%s) has been started.\n"),
                   pProcess->processIdentifier(),
                   pProcess->getCmdName().ascii());

    strCmd.sprintf(i18n("(Command being executed: %s).\n\n"), pProcess->getCmdLine().ascii());

    m_pOutputView->setColor(KYumPreferences::c_clrInfo);
    m_pOutputView->setText(strMsg +
                           i18n("Please be patient, this may be a lengthy operation...\n\n"));

    m_pOutputView->setColor(KYumPreferences::c_clrAddInfo);
    m_pOutputView->append(strCmd);

    m_pOutputView->setText("");
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void GroupsTab::slotActionTerminated(Process * pProcess)
{
    QString strMsg;

    if ( pProcess->normalExit() )
    {
        m_pOutputView->setColor(KYumPreferences::c_clrInfo);
        strMsg = i18n("Process exited normally with code ");
    }
    else
    {
        m_pOutputView->setColor(KYumPreferences::c_clrError);
        strMsg = i18n("Process exited abnormally with code ");
    }

    strMsg += QString::number(pProcess->exitStatus(), 10);
    strMsg += ".\n";

    m_pOutputView->append(strMsg);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void GroupsTab::slotYumInfo(QString strInfo)
{
    m_pOutputView->setColor(KYumPreferences::c_clrInfo);
    m_pOutputView->append(strInfo);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void GroupsTab::slotYumError(QString strError)
{
    m_pOutputView->setColor(KYumPreferences::c_clrError);
    m_pOutputView->append(strError);
}


#include "GroupsTab.h"
