/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qtextedit.h>
#include <qregexp.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include "StrTok.h"
#include "DlgFindPackages.h"

bool                    DlgFindPackages::m_bInstall = false;
DlgFindPackages::E_Mode DlgFindPackages::m_mode     = DlgFindPackages::c_Search;
QString                 DlgFindPackages::m_strPattern;


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

DlgFindPackages::DlgFindPackages(QWidget *parent, const char *name)
  : BaseDlgFindPackages(parent, name)
{
    m_pCheckUpdates->setEnabled(false); // not used yet

    if ( c_Search == m_mode )
        m_pRadioSearch->setChecked(true);   // Default mode is "search"
    else
        m_pRadioProvides->setChecked(true);

    m_pEdPatterns->setText(m_strPattern);
    m_pEdPatterns->setFocus();
    m_pCheckInstall->setChecked(m_bInstall);

    connect(m_pEdPatterns, SIGNAL(textChanged()), this, SLOT(slotPatternsChanged()));
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgFindPackages::setOnlyUpdates(bool bOnlyUpdates)
{
    m_pCheckUpdates->setChecked(bOnlyUpdates);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgFindPackages::setPatterns(const QStringList & strList)
{
    QStringList::ConstIterator it;

    for ( it = strList.begin(); it != strList.end(); ++it )
    {
        m_pEdPatterns->append(*it);
    }
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

bool DlgFindPackages::onlyUpdates() const
{
    return m_pCheckUpdates->isChecked();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

QStringList & DlgFindPackages::getPatterns(QStringList & strList) const
{
    QString strItem,
            strPatterns = m_pEdPatterns->text();
    StrTok  strTok(strPatterns);
    QRegExp sep("( |\t|\n)+");

    strList.clear();

    while ( strTok.nextToken(sep, strItem) )
    {
        strList.push_back(strItem.stripWhiteSpace());
    }

    return strList;
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgFindPackages::slotPatternsChanged()
{
    m_pButtonOk->setEnabled(0 < m_pEdPatterns->text().length());
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/

void DlgFindPackages::accept()
{
    m_mode       = m_pRadioSearch->isChecked() ? c_Search : c_Provides;
    m_bInstall   = m_pCheckInstall->isChecked();
    m_strPattern = m_pEdPatterns->text();

    BaseDlgFindPackages::accept();
}


#include "DlgFindPackages.moc"
