/***************************************************************************
                           bilinear.cpp
                           ------------
    begin                : Mon Jun 14 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * Taken from xawtv.
 *
 * Original authors:
 * Conrad Kreyling <conrad@conrad.nerdland.org>
 * Patrick Barrett <yebyen@nerdland.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "bilinear.h"
#include "kdetvimagefilter.h"
#include "kdetvimagefiltercontext.h"


class BilinearImageFilter : public KdetvImageFilter
{
public:
    BilinearImageFilter()
        : KdetvImageFilter(i18n("Bilinear"))
    {
        _fullFrameRate = false;
    }

    virtual ~BilinearImageFilter()
    {
    }

    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx)
    {
        KdetvSharedImage* img = ctx->out;
        unsigned int bytesperline = img->bytesPerLine();
        unsigned char* buf = img->buffer();
        unsigned int x, y;

        for (y = 1; y < (unsigned)(img->size().height()) - 1; y += 2) {
            for (x = 0; x < bytesperline + 1; x++) {
                (buf[y * bytesperline + x]) =
                        ((buf[((y - 1) * bytesperline) + x]) +
                        (buf[((y + 1) * bytesperline) + x])) >> 1;
            }
        }

        return ctx;
    }

    virtual KdetvImage::ImageFormat inputFormats()
    {
        return (KdetvImage::ImageFormat)(KdetvImage::FORMAT_BGR32    |
                                         KdetvImage::FORMAT_BGR24    |
                                         KdetvImage::FORMAT_RGB15_LE |
                                         KdetvImage::FORMAT_RGB16_LE |
                                         KdetvImage::FORMAT_GREY     |
                                         KdetvImage::FORMAT_YUYV       );
    };
};

// -----------------------------------------------------------------------

BilinearPlugin::BilinearPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    _filter = new BilinearImageFilter();
}

BilinearPlugin::~BilinearPlugin()
{
    delete _filter;
}

extern "C" {
    BilinearPlugin* create_bilinear(Kdetv* ktv)
    {
        return new BilinearPlugin(ktv, "deinterlace-bilinear", 0, "Bilinear deinterlacefilter");
    }
}

#include "bilinear.moc"
