/* parts.c for kan netmaj */
#include "xnet.h"

int rnum = 0, opened_menu = -1;
int sel_reg = -1, sel_num;

extern Atom text_atom;

struct region
{
  int win;
  int x, y, width, height;
  int kind, res;
  int data1, data2, data3, data4, data5;
  char **str;
  void (*callback)();
} *reg;

#define WTH(n) reg[ (n) ].width
#define HGT(n) reg[ (n) ].height
#define X(n) reg[ (n) ].x
#define Y(n) reg[ (n) ].y
#define RES(n) reg[ (n) ].res
#define WIN(n) reg[ (n) ].win
#define DT1(n) reg[ (n) ].data1
#define DT2(n) reg[ (n) ].data2
#define DT3(n) reg[ (n) ].data3
#define DT4(n) reg[ (n) ].data4
#define DT5(n) reg[ (n) ].data5
#define KND(n) reg[ (n) ].kind

/* data of button
   data1: direction of buttons
   data2: number of buttons
   data3: width of button
   data4: height of button
   data5: status of button
*/

void
set_reg_position(num, x, y)
     int num, x, y;
{
  X(num) = x;
  Y(num) = y;
}

void
set_reg_responsive(num, set)
     int num, set;
{
  reg[num].res = set;
}

int
region_width(num)
int num;
{
  return WTH(num);
}

int
region_height(num)
int num;
{
  return HGT(num);
}

unsigned int
getbit(i, n)
     unsigned int i;
     int n;
{
  return ((i >> n) & 01);
}

unsigned int
set_bit(i, n)
     unsigned int i;
     int n;
{
  return (i | (1 << n));
}

unsigned int
unset_bit(i, n)
     unsigned int i;
     int n;
{
  return (i & ~(1 << n));
}

unsigned int
reversebit(i, n)
     unsigned int i;
     int n;
{
  return ((1 << n) ^ i);
}     


void
init_region()
{
  if (!rnum)
    reg = (struct region *)malloc(sizeof(struct region));
  else
    reg = (struct region *)realloc(reg, sizeof(struct region)*(rnum+1));

  WIN(rnum) = X(rnum) = Y(rnum) = WTH(rnum) = HGT(rnum) = 0;
  KND(rnum) = RES(rnum) = 0;
  DT1(rnum) = DT2(rnum) = DT3(rnum) = DT4(rnum) = DT5(rnum) = 0;
  reg[rnum].str = 0;
  reg[rnum].callback = 0;
}

void
set_buttonlabel(r, num, sp)
     int r, num;
     char *sp;
{
  *(reg[r].str+num) = sp;
}

void
set_button_state(num, but, set)
     int num, but, set;
{
  if (set)
    set_bit(DT5(num), but);
  else
    unset_bit(DT5(num), but);
}

void
draw_pushed_button(num, x, y)
     int num, x, y;
{
  int sel;

  if (DT1(num) == HORIZ) {
    sel = (x - X(num))/DT3(num);
    DT5(num) = (int)reversebit(DT5(num), sel);
    ThreeDframe(WIN(num), X(num)+sel*DT3(num), Y(num), DT3(num), DT4(num), 3, 
		getbit((unsigned int)DT5(num), sel));
  }
  else {
    sel = (y - Y(num))/DT4(num);
    DT5(num) = (int)reversebit(DT5(num), sel);
    ThreeDframe(WIN(num), X(num), Y(num)+sel*DT4(num), DT3(num), DT4(num), 3,
		getbit((unsigned int)DT5(num), sel));
  }
  mapping(WIN(num), X(num), Y(num), WTH(num), HGT(num));
  
  sel_reg = num;
  sel_num = sel;
}

void
draw_pushed_menubutton(num, x, y)
     int num, x, y;
{
  ThreeDframe(WIN(num), X(num), Y(num), DT2(num), DT3(num), 3, 1);

  mapping(WIN(num), X(num), Y(num), WTH(num), HGT(num));
  
  sel_reg = num;
  sel_num = 0;
}

void
draw_button(num)
     int num;
{
  int i, b;

  for (i = 0; i < DT2(num); i++) {
    b = getbit(DT5(num), i);
    win_cleararea(WIN(num), X(num)+DT3(num)*i*(!DT1(num)), 
		 Y(num)+DT4(num)*i*DT1(num), DT3(num), DT4(num));
    ThreeDframe (WIN(num), X(num)+DT3(num)*i*(!DT1(num)), 
		 Y(num)+DT4(num)*i*DT1(num), DT3(num), DT4(num), 3, b);
    draw_ctext(WIN(num), X(num)+DT3(num)*i*(!DT1(num))+DT3(num)/2, 
	       Y(num)+DT4(num)*i*DT1(num)+DT4(num)/2, 
	       cols.btntx, SLFNT, *(reg[num].str+i));
    }
  RES(num) = 1;
}

void
draw_menubutton(num)
     int num;
{
  int i, b;

  win_cleararea(WIN(num), X(num), Y(num), DT2(num), DT3(num));
  ThreeDframe (WIN(num), X(num), Y(num), DT2(num), DT3(num), 3, 0);
  draw_ctext(WIN(num), X(num)+DT2(num)/2, Y(num)+DT3(num)/2, 
	       cols.btntx, SLFNT, *reg[num].str);

  RES(num) = 1;
}

void
draw_released_button()
{
  if (sel_reg != -1) {
    if (KND(sel_reg) == BUTTON) {
      DT5(sel_reg) = (int)reversebit(DT5(sel_reg), sel_num);
      draw_button(sel_reg);
      mapping(WIN(sel_reg), X(sel_reg), Y(sel_reg), WTH(sel_reg), HGT(sel_reg));
    }
    else if (KND(sel_reg) == MENUBUTTON) {
      draw_menubutton(sel_reg);
      mapping(WIN(sel_reg), X(sel_reg), Y(sel_reg), WTH(sel_reg), HGT(sel_reg));
      if (!DT5(sel_reg)) {
	win_unmap_normal(DT1(sel_reg));
	DT4(sel_reg) = 0;
	opened_menu = -1;
      }
    }
    sel_reg = -1;
  }
}

void
check_selected_button(num, x, y)
     int num, x, y;
{
  int sel;

  if (DT1(num) == HORIZ)
    sel = (x - X(num))/DT3(num);
  else
    sel = (y - Y(num))/DT4(num);

  draw_released_button();
  (*(reg[num].callback)) (num, sel);
}

int
make_button(win, direct, num, sp, font, func)
     int win, direct, num, font;
     char **sp;
     void (*func) ();
{
  int i, w, h;

  init_region();

  reg[rnum].str = (char **)malloc(sizeof(char **)*num);

  w = h = 0;
  for (i = 0; i < num; i++) {
    *(reg[rnum].str+i) = *(sp+i);
    if (textwidth(*(sp+i), font) > w)
      w = textwidth(*(sp+i), font);
    if (textheight(*(sp+i), font) > h)
      h = textheight(*(sp+i), font);
  }
  w += 20;
  h += 12;

  if (direct == HORIZ) {
    WTH(rnum) = w*num;
    HGT(rnum) = h;
  }
  else {
    WTH(rnum) = w;
    HGT(rnum) = h*num;
  }
  DT1(rnum) = direct;
  DT2(rnum) = num;
  DT3(rnum) = w;
  DT4(rnum) = h;
  KND(rnum) = BUTTON;

  WIN(rnum) = win;
  RES(rnum) = DT5(rnum) = 0;
  reg[rnum].callback = func;

  rnum++;

  return (rnum-1);
}


int
make_menubutton(win, sp, font, menu)
     int win, menu, font;
     char **sp;
{
  init_region();

  WTH(rnum) = textwidth(*sp, font)+20;
  HGT(rnum) = textheight(*sp, font)+12;

  DT1(rnum) = menu;
  DT2(rnum) = WTH(rnum);
  DT3(rnum) = HGT(rnum);
  KND(rnum) = MENUBUTTON;

  reg[rnum].str = (char **)malloc(sizeof(char **));
  *reg[rnum].str = *sp;

  WIN(rnum) = win;
  RES(rnum) = DT4(rnum) = DT5(rnum) = 0;

  rnum++;

  return (rnum-1);
}


void
check_selection_box(num, x, y)
     int num, x, y;
{
  int sel;

  if (DT1(num) == HORIZ) {
    sel = (x - X(num))/DT3(num);
    (*(reg[num].callback)) (sel, x-sel*DT3(num)-X(num), y);
  }
  else {
    sel = (y - Y(num))/DT4(num);
    (*(reg[num].callback)) (sel, x, y-sel*DT4(num)-Y(num));
  }
}

int
make_selection_box(win, direct, num, w, h, func)
     int win, direct, num, w, h;
     void (*func) ();
{

  init_region();

  if (direct == HORIZ) {
    WTH(rnum) = w*num;
    HGT(rnum) = h;
  }
  else {
    WTH(rnum) = w;
    HGT(rnum) = h*num;
  }
  DT1(rnum) = direct;
  DT2(rnum) = num;
  DT3(rnum) = w;
  DT4(rnum) = h;
  KND(rnum) = SELBOX;
  RES(rnum) = 0;

  WIN(rnum) = win;
  reg[rnum].callback = func;

  rnum++;

  return (rnum-1);
}

int textCurX, textCurY, textCursorH;

void
set_textbox(num, str)
     char *str;
{
  strncpy(reg[num].str[0], str, DT2(num));
  DT3(num) = strlen(str);
}

void
get_textbox(num, str)
     char **str;
{
  *str = (char *)malloc(strlen(reg[num].str[0])+1);
  strcpy(*str, reg[num].str[0]);
}

extern Display *display;
extern int fonth[4], jfonth[2];

void
draw_textbox(num)
     int num;
{
  int i, x, w;

  draw_cotext(WIN(num), X(num), Y(num)+HGT(num)/2, 
	    cols.btntx, DT1(num), reg[num].str[1]);
  win_cleararea(WIN(num), X(num)+DT5(num), Y(num), 
		WTH(num)-DT5(num), HGT(num));
  ThreeDframe (WIN(num), X(num)+DT5(num), Y(num), WTH(num)-DT5(num), 
	       HGT(num), 3, 1);
  draw_cotext(WIN(num), X(num)+DT5(num)+10, Y(num)+HGT(num)/2, 
	      cols.btntx, DT1(num), reg[num].str[0]);
  RES(num) = 1;

  w = textwidth(reg[num].str[0], DT1(num))+10;
  if (DT4(num)) {
    draw_rev_text(WIN(num), X(num)+DT5(num)+w, Y(num)+HGT(num)/2, 
		  cols.mess, FFNT, " ");
  }
  textCurX = X(num)+DT5(num)+w;
  textCurY = Y(num)+(HGT(num)-jfonth[SLFNT])/2;
  textCursorH = jfonth[SLFNT];
/*  KinputTellCursorPosition(textCurX, textCurY + textCursorH);*/
}

int
input_textbox(event)
     XKeyEvent event;
{
  KeySym keysym;
  XComposeStatus compose;
  int i, x, width, flag = 0;
  char c[2];

  for (i = 0; i < rnum; i++)
    if (KND(i) == TEXTBOX && DT4(i)) break;
  
  if (i == rnum) return 0;
  
  XLookupString(&(event), c, 2, &keysym, &compose);
  if (keysym == XK_Delete) {
    if (DT3(i)) {
      if ((unsigned char)reg[i].str[0][DT3(i)-1] < 160)
	DT3(i)--;
      else
	DT3(i) -= 2;
      reg[i].str[0][DT3(i)] = '\0';
      flag = 1;
    }
  }
  else if (keysym == XK_Return && reg[i].callback)
    (*(reg[i].callback)) ();
  else if ((event.state & ControlMask) && (keysym & 0xff) == ' ')
    KinputBeginConversion ();
  else if ((DT3(i) < DT2(i)) && (c[0] > 31) && (c[0] < 127)) {
      reg[i].str[0][DT3(i)] = c[0];
      DT3(i)++;
      reg[i].str[0][DT3(i)] = '\0';
      flag = 1;
    }

  if (flag) {
    win_cleararea(WIN(i), X(i)+DT5(i)+3, Y(i)+3, WTH(i)-DT5(i)-6, HGT(i)-6);
    draw_cotext(WIN(i), X(i)+DT5(i)+10, Y(i)+HGT(i)/2,cols.btntx, DT1(i), reg[i].str[0]);
    width = textwidth(reg[i].str[0], DT1(i))+10;
    draw_rev_text(WIN(i), X(i)+DT5(i)+width, Y(i)+HGT(i)/2, cols.mess, FFNT, " ");
    mapping(WIN(i), X(i), Y(i), WTH(i), HGT(i));
    textCurX = X(i)+DT5(i)+width;
    textCurY = Y(i);
    textCursorH = HGT(i)-6;
/*    KinputTellCursorPosition(textCurX, textCurY + textCursorH);*/
  }
  return 1;
}

void
conv_string(dst, src)
     char *src, *dst;
{
  while (*src != '\0') {
    if (*src == '\n') {
      src++;
      continue;
    }
    else if (*src == '\x1b') {
      while ((*src != 'B') && (*src != 'J') && (*src != '@')) src++;
      src++;
    }
    *(dst++) = *(src++);
  }
  *dst = *src;
}

int
paste_textbox(event)
     XSelectionEvent event;
{
  int i, j, x, width, flag = 0;
  char c[2], str[80];
  unsigned char *data;
  Atom a1;
  unsigned long items, bar;

  for (i = 0; i < rnum; i++)
    if (KND(i) == TEXTBOX && DT4(i)) break;
  
  if (i == rnum) return;
  
  XGetWindowProperty(display, event.requestor, text_atom, 0, 20, True,
		     AnyPropertyType, &a1, &j, &items, &bar, &data);

  conv_string(str, data);

  j = 0;
  while (DT3(i) < DT2(i) && str[j] != '\0') {
    reg[i].str[0][DT3(i)] = str[j];
    DT3(i)++;
    j++;
  }
  reg[i].str[0][DT3(i)] = '\0';
  draw_textbox(i);
  mapping(WIN(i), X(i)+DT5(i), Y(i), WTH(i), HGT(i));

  XFree(data);
}


void
input_from_kinput(event)
     XPropertyEvent *event;
{
  char j, s[80], i = talk_txt;

  s[0] = '\0';

  KinputCheckConvProperty (event, s);

  if (s[0] != '\0') {
    j = 0;
    while (DT3(i) < DT2(i) && s[j] != '\0')
      reg[i].str[0][DT3(i)++] = s[j++];

    reg[i].str[0][DT3(i)] = '\0';
    draw_textbox(i);
    mapping(WIN(i), X(i)+DT5(i), Y(i), WTH(i), HGT(i));
  }
}

int
select_textbox(num, x)
     int num, x;
{
  int i, w;

  if (x - X(num) > DT5(num)) {
    DT4(num) = 1;
    
    draw_textbox(num);
    w = textwidth(reg[num].str[1], DT1(num));
    mapping(WIN(num), X(num), Y(num), WTH(num), HGT(num));
    
    for (i = 0; i < rnum; i++)
      if (i != num && KND(i) == TEXTBOX && DT4(i)) {
	DT4(i) = 0;
	draw_textbox(i);
	mapping(WIN(i), X(i), Y(i), WTH(i), HGT(i));
	break;
      }
  }
}

int
make_textbox(win, w, h, font, num, title, func)
     int win, w, h ,font, num;
     char *title;
     void (*func) ();
{
  int i;

  init_region();

  HGT(rnum) = h;

  DT1(rnum) = font;
  DT2(rnum) = num;
  DT3(rnum) = 0;
  DT4(rnum) = 0;
  KND(rnum) = TEXTBOX;

  reg[rnum].str = (char **)malloc(sizeof(char **)*2);
  reg[rnum].str[0] = (char *)malloc(num+1);
  reg[rnum].str[1] = (char *)malloc(strlen(title)+1);
  strcpy(reg[rnum].str[0], "");
  strcpy(reg[rnum].str[1], title);

  DT5(rnum) = textwidth(reg[rnum].str[1], DT1(rnum))+10;
  WTH(rnum) = w+DT5(rnum);
  WIN(rnum) = win;
  RES(rnum) = 0;
  reg[rnum].callback = func;

  rnum++;

  return (rnum-1);
}

int
check_region (event, win, x, y)
     int x, y, event, win;
{
  int i;

  if (opened_menu != -1 && event == ButtonPress && opened_menu != win) {
    win_unmap_normal(opened_menu);
    opened_menu = -1;
  }

  for (i = 0; i < rnum; i++) {
    if (!RES(i) || WIN(i) != win) continue;

    if ((x>=X(i)) && (x<X(i)+WTH(i)) && (y>=Y(i)) && (y<Y(i)+HGT(i))) {
      switch(KND(i))
	{
	case BUTTON:
	  if (event == ButtonPress)
	    draw_pushed_button(i, x, y);
	  else if (event == ButtonRelease)
	    check_selected_button(i, x, y);
	  break;
	case SELBOX:
	  if (event == ButtonRelease)
	    check_selection_box(i, x, y);
	  break;
	case TEXTBOX:
	  if (event == ButtonPress)
	    select_textbox(i, x);
	  break;
	case MENUBUTTON:
	  if (event == ButtonPress) {
	    draw_pushed_menubutton(i, x, y);
	    win_map_normal(DT1(i));
	    ungrab_pointer();
	    DT4(i) = 1;
	    DT5(i) = 0;
	  }
	  else if (event == ButtonRelease) {
	    DT5(i) = 1;
	    opened_menu = DT1(i);
	  }
	  break;
      }
      if (event == ButtonRelease)
	return 1;
      break;
    }
  }

  return 0;
}
