/* engine.c generated by valac 0.14.0, the Vala compiler
 * generated from engine.vala, do not modify */

/*
 * Copyright (C) 2011  Daiki Ueno
 * Copyright (C) 2011  Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <ibusvirtkbd.h>
#include <ibus/ibuspanelextensions.h>
#include <gio/gio.h>
#include <stdio.h>


#define IBUS_VIRTKBD_TYPE_ENGINE (ibus_virtkbd_engine_get_type ())
#define IBUS_VIRTKBD_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_VIRTKBD_TYPE_ENGINE, IBusVirtkbdEngine))
#define IBUS_VIRTKBD_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_VIRTKBD_TYPE_ENGINE, IBusVirtkbdEngineClass))
#define IBUS_VIRTKBD_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_VIRTKBD_TYPE_ENGINE))
#define IBUS_VIRTKBD_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_VIRTKBD_TYPE_ENGINE))
#define IBUS_VIRTKBD_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_VIRTKBD_TYPE_ENGINE, IBusVirtkbdEngineClass))

typedef struct _IBusVirtkbdEngine IBusVirtkbdEngine;
typedef struct _IBusVirtkbdEngineClass IBusVirtkbdEngineClass;
typedef struct _IBusVirtkbdEnginePrivate IBusVirtkbdEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IBusVirtkbdEngine {
	IBusEngine parent_instance;
	IBusVirtkbdEnginePrivate * priv;
};

struct _IBusVirtkbdEngineClass {
	IBusEngineClass parent_class;
};

struct _IBusVirtkbdEnginePrivate {
	gchar* keyboard_type;
	GString* preedit;
	IBusVirtkbd* virtkbd;
};


static gpointer ibus_virtkbd_engine_parent_class = NULL;
extern IBusConfig* ibus_virtkbd_engine_config;
IBusConfig* ibus_virtkbd_engine_config = NULL;

GType ibus_virtkbd_engine_get_type (void) G_GNUC_CONST;
#define IBUS_VIRTKBD_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_VIRTKBD_TYPE_ENGINE, IBusVirtkbdEnginePrivate))
enum  {
	IBUS_VIRTKBD_ENGINE_DUMMY_PROPERTY
};
static void ibus_virtkbd_engine_real_enable (IBusEngine* base);
static void ibus_virtkbd_engine_real_disable (IBusEngine* base);
static void ibus_virtkbd_engine_real_focus_in (IBusEngine* base);
static void ibus_virtkbd_engine_real_focus_out (IBusEngine* base);
static void ibus_virtkbd_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h);
static void ibus_virtkbd_engine_real_destroy (IBusObject* base);
static void ibus_virtkbd_engine_on_text_activated (IBusVirtkbdEngine* self, const gchar* text);
IBusVirtkbdEngine* ibus_virtkbd_engine_new (void);
IBusVirtkbdEngine* ibus_virtkbd_engine_construct (GType object_type);
static GObject * ibus_virtkbd_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _ibus_virtkbd_engine_on_text_activated_ibus_virtkbd_text_activated (IBusVirtkbd* _sender, const gchar* text, gpointer self);
static void ibus_virtkbd_engine_finalize (GObject* obj);


static void ibus_virtkbd_engine_real_enable (IBusEngine* base) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	ibus_panel_extension_show ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_virtkbd_engine_parent_class)->enable (IBUS_ENGINE (self));
}


static void ibus_virtkbd_engine_real_disable (IBusEngine* base) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_virtkbd_engine_parent_class)->disable (IBUS_ENGINE (self));
}


static void ibus_virtkbd_engine_real_focus_in (IBusEngine* base) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	ibus_panel_extension_show ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_virtkbd_engine_parent_class)->focus_in (IBUS_ENGINE (self));
}


static void ibus_virtkbd_engine_real_focus_out (IBusEngine* base) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_virtkbd_engine_parent_class)->focus_out (IBUS_ENGINE (self));
}


static void ibus_virtkbd_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = w;
	_tmp4_ = h;
	ibus_panel_extension_set_cursor_location ((IBusPanelExtension*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = x;
	_tmp6_ = y;
	_tmp7_ = w;
	_tmp8_ = h;
	IBUS_ENGINE_CLASS (ibus_virtkbd_engine_parent_class)->set_cursor_location (IBUS_ENGINE (self), _tmp5_, _tmp6_, _tmp7_, _tmp8_);
}


static void ibus_virtkbd_engine_real_destroy (IBusObject* base) {
	IBusVirtkbdEngine * self;
	IBusVirtkbd* _tmp0_;
	self = (IBusVirtkbdEngine*) base;
	_tmp0_ = self->priv->virtkbd;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_OBJECT_CLASS (ibus_virtkbd_engine_parent_class)->destroy ((IBusObject*) IBUS_ENGINE (self));
}


static void ibus_virtkbd_engine_on_text_activated (IBusVirtkbdEngine* self, const gchar* text) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		const gchar* _tmp3_;
		IBusText* _tmp4_;
		IBusText* _tmp5_;
		_tmp3_ = text;
		_tmp4_ = ibus_text_new_from_string (_tmp3_);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		ibus_engine_commit_text ((IBusEngine*) self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
}


IBusVirtkbdEngine* ibus_virtkbd_engine_construct (GType object_type) {
	IBusVirtkbdEngine * self = NULL;
	self = (IBusVirtkbdEngine*) g_object_new (object_type, NULL);
	return self;
}


IBusVirtkbdEngine* ibus_virtkbd_engine_new (void) {
	return ibus_virtkbd_engine_construct (IBUS_VIRTKBD_TYPE_ENGINE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _ibus_virtkbd_engine_on_text_activated_ibus_virtkbd_text_activated (IBusVirtkbd* _sender, const gchar* text, gpointer self) {
	ibus_virtkbd_engine_on_text_activated (self, text);
}


static GObject * ibus_virtkbd_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	IBusVirtkbdEngine * self;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (ibus_virtkbd_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = IBUS_VIRTKBD_ENGINE (obj);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* conn;
		GDBusConnection* _tmp2_;
		IBusVirtkbd* _tmp3_;
		IBusVirtkbd* _tmp4_;
		IBusVirtkbd* _tmp5_;
		_tmp0_ = ibus_service_get_connection ((IBusService*) self);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		conn = _tmp1_;
		_tmp2_ = conn;
		_tmp3_ = ibus_virtkbd_new (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (conn);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->virtkbd);
		self->priv->virtkbd = _tmp4_;
		_tmp5_ = self->priv->virtkbd;
		g_signal_connect_object (_tmp5_, "text-activated", (GCallback) _ibus_virtkbd_engine_on_text_activated_ibus_virtkbd_text_activated, self, 0);
		_g_object_unref0 (conn);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void ibus_virtkbd_engine_class_init (IBusVirtkbdEngineClass * klass) {
	ibus_virtkbd_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusVirtkbdEnginePrivate));
	IBUS_ENGINE_CLASS (klass)->enable = ibus_virtkbd_engine_real_enable;
	IBUS_ENGINE_CLASS (klass)->disable = ibus_virtkbd_engine_real_disable;
	IBUS_ENGINE_CLASS (klass)->focus_in = ibus_virtkbd_engine_real_focus_in;
	IBUS_ENGINE_CLASS (klass)->focus_out = ibus_virtkbd_engine_real_focus_out;
	IBUS_ENGINE_CLASS (klass)->set_cursor_location = ibus_virtkbd_engine_real_set_cursor_location;
	IBUS_OBJECT_CLASS (klass)->destroy = ibus_virtkbd_engine_real_destroy;
	G_OBJECT_CLASS (klass)->constructor = ibus_virtkbd_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = ibus_virtkbd_engine_finalize;
}


static void ibus_virtkbd_engine_instance_init (IBusVirtkbdEngine * self) {
	GString* _tmp0_;
	self->priv = IBUS_VIRTKBD_ENGINE_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->preedit = _tmp0_;
}


static void ibus_virtkbd_engine_finalize (GObject* obj) {
	IBusVirtkbdEngine * self;
	self = IBUS_VIRTKBD_ENGINE (obj);
	_g_free0 (self->priv->keyboard_type);
	_g_string_free0 (self->priv->preedit);
	_g_object_unref0 (self->priv->virtkbd);
	G_OBJECT_CLASS (ibus_virtkbd_engine_parent_class)->finalize (obj);
}


GType ibus_virtkbd_engine_get_type (void) {
	static volatile gsize ibus_virtkbd_engine_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_virtkbd_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusVirtkbdEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_virtkbd_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusVirtkbdEngine), 0, (GInstanceInitFunc) ibus_virtkbd_engine_instance_init, NULL };
		GType ibus_virtkbd_engine_type_id;
		ibus_virtkbd_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "IBusVirtkbdEngine", &g_define_type_info, 0);
		g_once_init_leave (&ibus_virtkbd_engine_type_id__volatile, ibus_virtkbd_engine_type_id);
	}
	return ibus_virtkbd_engine_type_id__volatile;
}



