/* panel.c generated by valac 0.36.3, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <libnotify/notify.h>
#include <pango/pangocairo.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define PANEL_TYPE_ICON_TYPE (panel_icon_type_get_type ())

#define TYPE_INDICATOR (indicator_get_type ())
#define INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR, Indicator))
#define INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR, IndicatorClass))
#define IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR))
#define IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR))
#define INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR, IndicatorClass))

typedef struct _Indicator Indicator;
typedef struct _IndicatorClass IndicatorClass;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;

#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;

#define PANEL_TYPE_KEYBINDING (panel_keybinding_get_type ())
#define PANEL_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANEL_TYPE_KEYBINDING, PanelKeybinding))
#define PANEL_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))
#define PANEL_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANEL_TYPE_KEYBINDING))
#define PANEL_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANEL_TYPE_KEYBINDING))
#define PANEL_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))

typedef struct _PanelKeybinding PanelKeybinding;
typedef struct _PanelKeybindingClass PanelKeybindingClass;

#define PANEL_TYPE_KEY_EVENT_FUNC_TYPE (panel_key_event_func_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define _xkb_layout_unref0(var) ((var == NULL) ? NULL : (var = (xkb_layout_unref (var), NULL)))
#define __g_list_free__panel_keybinding_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__panel_keybinding_unref0_ (var), NULL)))

#define INDICATOR_TYPE_CATEGORY (indicator_category_get_type ())

#define INDICATOR_TYPE_STATUS (indicator_status_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _panel_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _PanelKeybindingPrivate PanelKeybindingPrivate;
typedef struct _PanelParamSpecKeybinding PanelParamSpecKeybinding;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

typedef enum  {
	PANEL_ICON_TYPE_STATUS_ICON,
	PANEL_ICON_TYPE_INDICATOR
} PanelIconType;

struct _PanelPrivate {
	IBusBus* m_bus;
	GSettings* m_settings_general;
	GSettings* m_settings_hotkey;
	GSettings* m_settings_panel;
	GSettings* m_settings_emoji;
	PanelIconType m_icon_type;
	Indicator* m_indicator;
	GDBusConnection* m_session_bus_connection;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	GHashTable* m_engine_contexts;
	gchar* m_current_context_path;
	gchar* m_real_current_context_path;
	gboolean m_use_global_engine;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	guint m_switcher_focus_set_engine_id;
	IBusEmojier* m_emojier;
	guint m_emojier_set_emoji_lang_id;
	guint m_emojier_focus_commit_text_id;
	gchar** m_emojier_favorites;
	gint m_emojier_favorites_length1;
	gint _m_emojier_favorites_size_;
	PropertyManager* m_property_manager;
	PropertyPanel* m_property_panel;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	gboolean m_use_system_keyboard_layout;
	GHashTable* m_xkb_icon_pixbufs;
	GHashTable* m_xkb_icon_image;
	GdkRGBA m_xkb_icon_rgba;
	XKBLayout* m_xkblayout;
	gboolean inited_engines_order;
	guint m_preload_engines_id;
	gchar* m_icon_prop_key;
	gint m_property_icon_delay_time;
	guint m_property_icon_delay_time_id;
	GList* m_keybindings;
};

typedef enum  {
	PANEL_KEY_EVENT_FUNC_TYPE_ANY,
	PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER,
	PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING
} PanelKeyEventFuncType;

typedef enum  {
	INDICATOR_CATEGORY_APPLICATION_STATUS,
	INDICATOR_CATEGORY_COMMUNICATIONS,
	INDICATOR_CATEGORY_SYSTEM_SERVICES,
	INDICATOR_CATEGORY_HARDWARE,
	INDICATOR_CATEGORY_OTHER
} IndicatorCategory;

typedef enum  {
	INDICATOR_STATUS_PASSIVE,
	INDICATOR_STATUS_ACTIVE,
	INDICATOR_STATUS_ATTENTION
} IndicatorStatus;

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _Block5Data {
	int _ref_count_;
	Panel* self;
	gchar** names;
	gint names_length1;
	gint _names_size_;
};

struct _Block6Data {
	int _ref_count_;
	Panel* self;
	IBusEngineDesc* e;
};

struct _Block7Data {
	int _ref_count_;
	Panel* self;
	gchar* symbol;
};

struct _PanelKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PanelKeybindingPrivate * priv;
};

struct _PanelKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (PanelKeybinding *self);
};

struct _PanelKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	gboolean _reverse;
	PanelKeyEventFuncType _ftype;
};

struct _PanelParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer panel_parent_class = NULL;
static gpointer panel_keybinding_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
static GType panel_icon_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType indicator_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
GType ibus_emojier_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_manager (GValue* value, gpointer v_object);
void value_take_property_manager (GValue* value, gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
GType property_panel_get_type (void) G_GNUC_CONST;
gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_xkb_layout (GValue* value, gpointer v_object);
void value_take_xkb_layout (GValue* value, gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
static gpointer panel_keybinding_ref (gpointer instance);
static void panel_keybinding_unref (gpointer instance);
static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void panel_value_set_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void panel_value_take_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer panel_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType panel_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
enum  {
	PANEL_DUMMY_PROPERTY
};
static GType panel_key_event_func_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void panel_unbind_switch_shortcut (Panel* self, PanelKeyEventFuncType ftype);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _cairo_surface_destroy0_ (gpointer var);
XKBLayout* xkb_layout_new (void);
XKBLayout* xkb_layout_construct (GType object_type);
static void _panel_keybinding_unref0_ (gpointer var);
static void _g_list_free__panel_keybinding_unref0_ (GList* self);
#define PANEL_PRELOAD_ENGINES_DELAY_TIME ((guint) 30000)
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type, IBusBus* bus);
static void panel_init_settings (Panel* self);
static gboolean panel_is_kde (Panel* self);
static void panel_init_indicator (Panel* self);
static void panel_init_status_icon (Panel* self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda88_ (Panel* self, CandidatePanel* w);
static void ___lambda88__candidate_panel_page_up (CandidatePanel* _sender, gpointer self);
static void __lambda89_ (Panel* self, CandidatePanel* w);
static void ___lambda89__candidate_panel_page_down (CandidatePanel* _sender, gpointer self);
static void __lambda90_ (Panel* self, CandidatePanel* w);
static void ___lambda90__candidate_panel_cursor_up (CandidatePanel* _sender, gpointer self);
static void __lambda91_ (Panel* self, CandidatePanel* w);
static void ___lambda91__candidate_panel_cursor_down (CandidatePanel* _sender, gpointer self);
static void __lambda92_ (Panel* self, CandidatePanel* w, guint i, guint b, guint s);
static void ___lambda92__candidate_panel_candidate_clicked (CandidatePanel* _sender, guint index, guint button, guint state, gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
static void panel_bind_switch_shortcut (Panel* self);
void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time);
static void panel_bind_emoji_shortcut (Panel* self);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda93_ (Panel* self, PropertyManager* w, const gchar* k, gint s);
static void ___lambda93__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self);
PropertyPanel* property_panel_new (void);
PropertyPanel* property_panel_construct (GType object_type);
static void __lambda94_ (Panel* self, PropertyPanel* w, const gchar* k, gint s);
static void ___lambda94__property_panel_property_activate (PropertyPanel* _sender, const gchar* key, gint state, gpointer self);
static void __lambda44_ (Panel* self, const gchar* key);
static void panel_update_engines (Panel* self, gchar** unowned_engine_names, int unowned_engine_names_length1, gchar** order_names, int order_names_length1);
static void ___lambda44__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda46_ (Panel* self, const gchar* key);
static void panel_set_switcher_delay_time (Panel* self);
static void ___lambda46__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda47_ (Panel* self, const gchar* key);
static void panel_set_use_system_keyboard_layout (Panel* self);
static void ___lambda47__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda48_ (Panel* self, const gchar* key);
static void panel_set_embed_preedit_text (Panel* self);
static void ___lambda48__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda49_ (Panel* self, const gchar* key);
static void panel_set_use_global_engine (Panel* self);
static void ___lambda49__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda50_ (Panel* self, const gchar* key);
static void panel_set_use_xmodmap (Panel* self);
static void ___lambda50__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda51_ (Panel* self, const gchar* key);
static void ___lambda51__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda57_ (Panel* self, const gchar* key);
static void panel_set_custom_font (Panel* self);
static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda58_ (Panel* self, const gchar* key);
static void ___lambda58__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda59_ (Panel* self, const gchar* key);
static void panel_set_show_icon_on_systray (Panel* self);
static void ___lambda59__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda60_ (Panel* self, const gchar* key);
static void panel_set_lookup_table_orientation (Panel* self);
static void ___lambda60__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda61_ (Panel* self, const gchar* key);
static void panel_set_show_property_panel (Panel* self);
static void ___lambda61__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda62_ (Panel* self, const gchar* key);
static void panel_set_timeout_property_panel (Panel* self);
static void ___lambda62__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda63_ (Panel* self, const gchar* key);
static void panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self);
static void ___lambda63__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda64_ (Panel* self, const gchar* key);
static void panel_set_xkb_icon_rgba (Panel* self);
static void ___lambda64__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda65_ (Panel* self, const gchar* key);
static void panel_set_property_icon_delay_time (Panel* self);
static void ___lambda65__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda66_ (Panel* self, const gchar* key);
static void ___lambda66__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda67_ (Panel* self, const gchar* key);
static void ___lambda67__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda68_ (Panel* self, const gchar* key);
static void panel_set_emoji_favorites (Panel* self);
static void ___lambda68__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda69_ (Panel* self, const gchar* key);
static void ___lambda69__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda70_ (Panel* self, const gchar* key);
static void panel_set_emoji_lang (Panel* self);
static void ___lambda70__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda72_ (Panel* self, const gchar* key);
static void panel_set_emoji_partial_match (Panel* self);
static void ___lambda72__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda73_ (Panel* self, const gchar* key);
static void ___lambda73__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda74_ (Panel* self, const gchar* key);
static void ___lambda74__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda75_ (Panel* self, GObject* obj, GAsyncResult* res);
GType indicator_category_get_type (void) G_GNUC_CONST;
Indicator* indicator_new (const gchar* id, GDBusConnection* connection, IndicatorCategory category);
Indicator* indicator_construct (GType object_type, const gchar* id, GDBusConnection* connection, IndicatorCategory category);
void indicator_set_title (Indicator* self, const gchar* value);
static void ___lambda76_ (Panel* self);
GType indicator_status_get_type (void) G_GNUC_CONST;
void indicator_set_status (Indicator* self, IndicatorStatus status);
static void ____lambda76__indicator_registered_status_notifier_item (Indicator* _sender, gpointer self);
static void ___lambda77_ (Panel* self, guint b, guint t);
static GtkMenu* panel_create_context_menu (Panel* self);
void indicator_position_context_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _indicator_position_context_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void ____lambda77__indicator_context_menu (Indicator* _sender, guint button, guint activate_time, gpointer self);
static void ___lambda84_ (Panel* self);
static GtkMenu* panel_create_activate_menu (Panel* self);
void indicator_position_activate_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _indicator_position_activate_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void ____lambda84__indicator_activate (Indicator* _sender, gpointer self);
static void ___lambda75__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda86_ (Panel* self, guint b, guint t);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void ___lambda86__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void __lambda87_ (Panel* self);
static void ___lambda87__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator, PanelKeyEventFuncType ftype);
static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse, PanelKeyEventFuncType ftype);
static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse, PanelKeyEventFuncType ftype);
gboolean keybinding_manager_bind (KeybindingManager* self, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static void ___lambda52_ (Panel* self, GdkEvent* e);
static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert);
static void ____lambda52__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void ____lambda54_ (Panel* self, GdkEvent* e);
static void panel_handle_emoji_typing (Panel* self, GdkEvent* event);
static void _____lambda54__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void ___lambda56_ (Panel* self, GdkEvent* e);
static void ____lambda56__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
KeybindingManager* keybinding_manager_get_instance (void);
static PanelKeyEventFuncType panel_keybinding_get_ftype (PanelKeybinding* self);
void keybinding_manager_unbind (KeybindingManager* self, guint keysym, GdkModifierType modifiers);
static guint panel_keybinding_get_keysym (PanelKeybinding* self);
static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self);
static GList* panel_get_engines_from_xkb (Panel* self, GList* engines);
void xkb_layout_get_layout (gchar* * layout, gchar* * variant, gchar* * option);
static void _g_list_free__g_object_unref0_ (GList* self);
static GList* panel_get_engines_from_locale (Panel* self, GList* engines);
static gint __lambda95_ (IBusEngineDesc* a, IBusEngineDesc* b);
static gint ___lambda95__gcompare_func (gconstpointer a, gconstpointer b);
static void panel_init_engines_order (Panel* self);
void xkb_layout_set_latin_layouts (XKBLayout* self, gchar** xkb_latin_layouts, int xkb_latin_layouts_length1);
static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value);
void ibus_emojier_set_emoji_font (const gchar* emoji_font);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void xkb_layout_set_use_xmodmap (XKBLayout* self, gboolean use_xmodmap);
void candidate_panel_set_vertical (CandidatePanel* self, gboolean vertical);
void property_panel_set_show (PropertyPanel* self, gint _show);
void property_panel_set_auto_hide_timeout (PropertyPanel* self, guint timeout);
void property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self, gboolean is_follow);
void ibus_emojier_set_favorites (gchar** unowned_favorites, int unowned_favorites_length1, gchar** unowned_favorite_annotations, int unowned_favorite_annotations_length1);
static gboolean __lambda71_ (Panel* self);
void ibus_emojier_set_annotation_lang (const gchar* lang);
static gboolean ___lambda71__gsource_func (gpointer self);
void ibus_emojier_set_partial_match (gboolean has_partial_match);
void ibus_emojier_set_partial_match_length (gint length);
void ibus_emojier_set_partial_match_condition (gint condition);
static gint panel_compare_versions (Panel* self, const gchar* version1, const gchar* version2);
static void panel_update_version_1_5_3 (Panel* self);
static void panel_update_version_1_5_8 (Panel* self);
static void panel_set_version (Panel* self);
void panel_load_settings (Panel* self);
static void panel_engine_contexts_insert (Panel* self, IBusEngineDesc* engine);
static void panel_set_engine (Panel* self, IBusEngineDesc* engine);
void xkb_layout_set_layout (XKBLayout* self, IBusEngineDesc* engine);
static void panel_switch_engine (Panel* self, gint i, gboolean force);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, const gchar* input_context_path);
static void panel_switcher_focus_set_engine (Panel* self);
static void panel_show_emojier (Panel* self, GdkEvent* event);
IBusEmojier* ibus_emojier_new (void);
IBusEmojier* ibus_emojier_construct (GType object_type);
gchar* ibus_emojier_run (IBusEmojier* self, const gchar* input_context_path, GdkEvent* event);
static void panel_emojier_focus_commit (Panel* self);
gboolean ibus_emojier_is_running (IBusEmojier* self);
void ibus_emojier_present_centralize (IBusEmojier* self, GdkEvent* event);
static void panel_run_preload_engines (Panel* self, IBusEngineDesc** engines, int engines_length1, gint index);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _vala_array_add19 (gchar** * array, int* length, int* size, gchar* value);
static gboolean __lambda45_ (Block5Data* _data5_);
static gboolean ___lambda45__gsource_func (gpointer self);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static void _vala_array_add20 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add21 (gchar** * array, int* length, int* size, gchar* value);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length);
static void panel_context_render_string (Panel* self, cairo_t* cr, const gchar* symbol, gint image_width, gint image_height);
static cairo_surface_t* panel_create_cairo_image_surface_with_string (Panel* self, const gchar* symbol, gboolean cache);
static GdkPixbuf* panel_create_icon_pixbuf_with_string (Panel* self, const gchar* symbol);
static void panel_show_setup_dialog (Panel* self);
static void __lambda79_ (Panel* self, GPid pid, gint state);
static void ___lambda79__gchild_watch_func (GPid pid, gint status, gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda78_ (Panel* self, GtkMenuItem* i);
static void ____lambda78__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda80_ (Panel* self, GtkMenuItem* i);
static void _vala_GdkEvent_free (GdkEvent* self);
static void ____lambda80__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda81_ (Panel* self, GtkMenuItem* i);
static void ____lambda81__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda82_ (Panel* self, GtkMenuItem* i);
static void ____lambda82__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda83_ (Panel* self, GtkMenuItem* i);
static void ____lambda83__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gint property_manager_create_menu_items (PropertyManager* self, GtkMenu* menu);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ____lambda85_ (Block6Data* _data6_, GtkMenuItem* item);
static void _____lambda85__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void panel_set_properties (Panel* self, IBusPropList* props);
static void panel_set_property (Panel* self, IBusProperty* prop, gboolean all_update);
static void panel_animate_icon (Panel* self, const gchar* symbol, gboolean all_update);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda96_ (Block7Data* _data7_);
void indicator_set_cairo_image_surface_full (Indicator* self, cairo_surface_t* image, const gchar* icon_desc);
static gboolean ___lambda96__gsource_func (gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
void property_panel_set_cursor_location (PropertyPanel* self, gint x, gint y, gint width, gint height);
static gboolean panel_switcher_focus_set_engine_real (Panel* self);
IBusEngineDesc* switcher_get_selected_engine (Switcher* self);
gchar* switcher_get_input_context_path (Switcher* self);
void switcher_reset (Switcher* self);
gboolean switcher_is_running (Switcher* self);
static gboolean ___lambda53_ (Panel* self);
static gboolean ____lambda53__gsource_func (gpointer self);
static gboolean panel_emojier_focus_commit_real (Panel* self);
gchar* ibus_emojier_get_selected_string (IBusEmojier* self);
gchar* ibus_emojier_get_input_context_path (IBusEmojier* self);
static void _vala_array_add22 (gchar** * array, int* length, int* size, gchar* value);
static gboolean ___lambda55_ (Panel* self);
static gboolean ____lambda55__gsource_func (gpointer self);
static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
void property_panel_focus_in (PropertyPanel* self);
static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_destroy_context (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props);
void property_manager_set_properties (PropertyManager* self, IBusPropList* props);
void property_panel_set_properties (PropertyPanel* self, IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop);
void property_manager_update_property (PropertyManager* self, IBusProperty* prop);
void property_panel_update_property (PropertyPanel* self, IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
void property_panel_set_preedit_text (PropertyPanel* self, IBusText* text, guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
void property_panel_set_auxiliary_text (PropertyPanel* self, IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
void property_panel_set_lookup_table (PropertyPanel* self, IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_set_content_type (IBusPanelService* base, guint purpose, guint hints);
void candidate_panel_set_content_type (CandidatePanel* self, guint purpose, guint hints);
static void panel_real_state_changed (IBusPanelService* base);
void indicator_set_icon_full (Indicator* self, const gchar* icon_name, const gchar* icon_desc);
gchar* switcher_get_xkb_language (Switcher* self, IBusEngineDesc* engine);
static void _vala_array_add23 (gchar** * array, int* length, int* size, gchar* value);
#define PANEL_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PANEL_TYPE_KEYBINDING, PanelKeybindingPrivate))
enum  {
	PANEL_KEYBINDING_DUMMY_PROPERTY
};
static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value);
static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value);
static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value);
static void panel_keybinding_set_ftype (PanelKeybinding* self, PanelKeyEventFuncType value);
static gboolean panel_keybinding_get_reverse (PanelKeybinding* self);
static void panel_keybinding_finalize (PanelKeybinding * obj);
static void panel_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType panel_icon_type_get_type (void) {
	static volatile gsize panel_icon_type_type_id__volatile = 0;
	if (g_once_init_enter (&panel_icon_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PANEL_ICON_TYPE_STATUS_ICON, "PANEL_ICON_TYPE_STATUS_ICON", "status-icon"}, {PANEL_ICON_TYPE_INDICATOR, "PANEL_ICON_TYPE_INDICATOR", "indicator"}, {0, NULL, NULL}};
		GType panel_icon_type_type_id;
		panel_icon_type_type_id = g_enum_register_static ("PanelIconType", values);
		g_once_init_leave (&panel_icon_type_type_id__volatile, panel_icon_type_type_id);
	}
	return panel_icon_type_type_id__volatile;
}


static GType panel_key_event_func_type_get_type (void) {
	static volatile gsize panel_key_event_func_type_type_id__volatile = 0;
	if (g_once_init_enter (&panel_key_event_func_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PANEL_KEY_EVENT_FUNC_TYPE_ANY, "PANEL_KEY_EVENT_FUNC_TYPE_ANY", "any"}, {PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER, "PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER", "ime-switcher"}, {PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING, "PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING", "emoji-typing"}, {0, NULL, NULL}};
		GType panel_key_event_func_type_type_id;
		panel_key_event_func_type_type_id = g_enum_register_static ("PanelKeyEventFuncType", values);
		g_once_init_leave (&panel_key_event_func_type_type_id__volatile, panel_key_event_func_type_type_id);
	}
	return panel_key_event_func_type_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _cairo_surface_destroy0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL));
}


static void _panel_keybinding_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL));
}


static void _g_list_free__panel_keybinding_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _panel_keybinding_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda88_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void ___lambda88__candidate_panel_page_up (CandidatePanel* _sender, gpointer self) {
	__lambda88_ ((Panel*) self, _sender);
}


static void __lambda89_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void ___lambda89__candidate_panel_page_down (CandidatePanel* _sender, gpointer self) {
	__lambda89_ ((Panel*) self, _sender);
}


static void __lambda90_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_up ((IBusPanelService*) self);
}


static void ___lambda90__candidate_panel_cursor_up (CandidatePanel* _sender, gpointer self) {
	__lambda90_ ((Panel*) self, _sender);
}


static void __lambda91_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_cursor_down ((IBusPanelService*) self);
}


static void ___lambda91__candidate_panel_cursor_down (CandidatePanel* _sender, gpointer self) {
	__lambda91_ ((Panel*) self, _sender);
}


static void __lambda92_ (Panel* self, CandidatePanel* w, guint i, guint b, guint s) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (w != NULL);
	_tmp0_ = i;
	_tmp1_ = b;
	_tmp2_ = s;
	ibus_panel_service_candidate_clicked ((IBusPanelService*) self, _tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda92__candidate_panel_candidate_clicked (CandidatePanel* _sender, guint index, guint button, guint state, gpointer self) {
	__lambda92_ ((Panel*) self, _sender, index, button, state);
}


static void __lambda93_ (Panel* self, PropertyManager* w, const gchar* k, gint s) {
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda93__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self) {
	__lambda93_ ((Panel*) self, _sender, key, state);
}


static void __lambda94_ (Panel* self, PropertyPanel* w, const gchar* k, gint s) {
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda94__property_panel_property_activate (PropertyPanel* _sender, const gchar* key, gint state, gpointer self) {
	__lambda94_ ((Panel*) self, _sender, key, state);
}


Panel* panel_construct (GType object_type, IBusBus* bus) {
	Panel * self = NULL;
	IBusBus* _tmp0_;
	gboolean _tmp1_;
	IBusBus* _tmp2_;
	GDBusConnection* _tmp3_;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	gboolean _tmp6_;
	CandidatePanel* _tmp7_;
	CandidatePanel* _tmp8_;
	CandidatePanel* _tmp9_;
	CandidatePanel* _tmp10_;
	CandidatePanel* _tmp11_;
	CandidatePanel* _tmp12_;
	Switcher* _tmp13_;
	gint _tmp14_;
	PropertyManager* _tmp17_;
	PropertyManager* _tmp18_;
	PropertyPanel* _tmp19_;
	PropertyPanel* _tmp20_;
	g_return_val_if_fail (bus != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (Panel*) g_object_new (object_type, "connection", _tmp3_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	panel_init_settings (self);
	_tmp6_ = panel_is_kde (self);
	if (_tmp6_) {
		panel_init_indicator (self);
	} else {
		panel_init_status_icon (self);
	}
	_tmp7_ = candidate_panel_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp7_;
	_tmp8_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp8_, "page-up", (GCallback) ___lambda88__candidate_panel_page_up, self, 0);
	_tmp9_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp9_, "page-down", (GCallback) ___lambda89__candidate_panel_page_down, self, 0);
	_tmp10_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp10_, "cursor-up", (GCallback) ___lambda90__candidate_panel_cursor_up, self, 0);
	_tmp11_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp11_, "cursor-down", (GCallback) ___lambda91__candidate_panel_cursor_down, self, 0);
	_tmp12_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp12_, "candidate-clicked", (GCallback) ___lambda92__candidate_panel_candidate_clicked, self, 0);
	_tmp13_ = switcher_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp13_;
	panel_bind_switch_shortcut (self);
	_tmp14_ = self->priv->m_switcher_delay_time;
	if (_tmp14_ >= 0) {
		Switcher* _tmp15_;
		gint _tmp16_;
		_tmp15_ = self->priv->m_switcher;
		_tmp16_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp15_, (guint) _tmp16_);
	}
	panel_bind_emoji_shortcut (self);
	_tmp17_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp17_;
	_tmp18_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp18_, "property-activate", (GCallback) ___lambda93__property_manager_property_activate, self, 0);
	_tmp19_ = property_panel_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->m_property_panel);
	self->priv->m_property_panel = _tmp19_;
	_tmp20_ = self->priv->m_property_panel;
	g_signal_connect_object (_tmp20_, "property-activate", (GCallback) ___lambda94__property_panel_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel* panel_new (IBusBus* bus) {
	return panel_construct (TYPE_PANEL, bus);
}


static void __lambda44_ (Panel* self, const gchar* key) {
	GSettings* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = key;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp0_, _tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	panel_update_engines (self, _tmp4_, _vala_array_length (_tmp2_), NULL, 0);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}


static void ___lambda44__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda44_ ((Panel*) self, key);
}


static void __lambda46_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_switcher_delay_time (self);
}


static void ___lambda46__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda46_ ((Panel*) self, key);
}


static void __lambda47_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_use_system_keyboard_layout (self);
}


static void ___lambda47__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda47_ ((Panel*) self, key);
}


static void __lambda48_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_embed_preedit_text (self);
}


static void ___lambda48__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda48_ ((Panel*) self, key);
}


static void __lambda49_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_use_global_engine (self);
}


static void ___lambda49__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda49_ ((Panel*) self, key);
}


static void __lambda50_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_use_xmodmap (self);
}


static void ___lambda50__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda50_ ((Panel*) self, key);
}


static void __lambda51_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_unbind_switch_shortcut (self, PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER);
	panel_bind_switch_shortcut (self);
}


static void ___lambda51__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda51_ ((Panel*) self, key);
}


static void __lambda57_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_custom_font (self);
}


static void ___lambda57__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda57_ ((Panel*) self, key);
}


static void __lambda58_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_custom_font (self);
}


static void ___lambda58__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda58_ ((Panel*) self, key);
}


static void __lambda59_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_show_icon_on_systray (self);
}


static void ___lambda59__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda59_ ((Panel*) self, key);
}


static void __lambda60_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_lookup_table_orientation (self);
}


static void ___lambda60__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda60_ ((Panel*) self, key);
}


static void __lambda61_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_show_property_panel (self);
}


static void ___lambda61__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda61_ ((Panel*) self, key);
}


static void __lambda62_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_timeout_property_panel (self);
}


static void ___lambda62__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda62_ ((Panel*) self, key);
}


static void __lambda63_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
}


static void ___lambda63__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda63_ ((Panel*) self, key);
}


static void __lambda64_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_xkb_icon_rgba (self);
}


static void ___lambda64__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda64_ ((Panel*) self, key);
}


static void __lambda65_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_property_icon_delay_time (self);
}


static void ___lambda65__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda65_ ((Panel*) self, key);
}


static void __lambda66_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_unbind_switch_shortcut (self, PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING);
	panel_bind_emoji_shortcut (self);
}


static void ___lambda66__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda66_ ((Panel*) self, key);
}


static void __lambda67_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_custom_font (self);
}


static void ___lambda67__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda67_ ((Panel*) self, key);
}


static void __lambda68_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_favorites (self);
}


static void ___lambda68__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda68_ ((Panel*) self, key);
}


static void __lambda69_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_favorites (self);
}


static void ___lambda69__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda69_ ((Panel*) self, key);
}


static void __lambda70_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_lang (self);
}


static void ___lambda70__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda70_ ((Panel*) self, key);
}


static void __lambda72_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_partial_match (self);
}


static void ___lambda72__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda72_ ((Panel*) self, key);
}


static void __lambda73_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_partial_match (self);
}


static void ___lambda73__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda73_ ((Panel*) self, key);
}


static void __lambda74_ (Panel* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_set_emoji_partial_match (self);
}


static void ___lambda74__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda74_ ((Panel*) self, key);
}


static void panel_init_settings (Panel* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	GSettings* _tmp24_;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	GSettings* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.general");
	_g_object_unref0 (self->priv->m_settings_general);
	self->priv->m_settings_general = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.general.hotkey");
	_g_object_unref0 (self->priv->m_settings_hotkey);
	self->priv->m_settings_hotkey = _tmp1_;
	_tmp2_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp2_;
	_tmp3_ = g_settings_new ("org.freedesktop.ibus.panel.emoji");
	_g_object_unref0 (self->priv->m_settings_emoji);
	self->priv->m_settings_emoji = _tmp3_;
	_tmp4_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp4_, "changed::preload-engines", (GCallback) ___lambda44__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp5_, "changed::switcher-delay-time", (GCallback) ___lambda46__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp6_, "changed::use-system-keyboard-layout", (GCallback) ___lambda47__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp7_, "changed::embed-preedit-text", (GCallback) ___lambda48__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp8_, "changed::use-global-engine", (GCallback) ___lambda49__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_general;
	g_signal_connect_object (_tmp9_, "changed::use-xmodmap", (GCallback) ___lambda50__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_hotkey;
	g_signal_connect_object (_tmp10_, "changed::triggers", (GCallback) ___lambda51__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp11_, "changed::custom-font", (GCallback) ___lambda57__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp12_, "changed::use-custom-font", (GCallback) ___lambda58__g_settings_changed, self, 0);
	_tmp13_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp13_, "changed::show-icon-on-systray", (GCallback) ___lambda59__g_settings_changed, self, 0);
	_tmp14_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp14_, "changed::lookup-table-orientation", (GCallback) ___lambda60__g_settings_changed, self, 0);
	_tmp15_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp15_, "changed::show", (GCallback) ___lambda61__g_settings_changed, self, 0);
	_tmp16_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp16_, "changed::timeout", (GCallback) ___lambda62__g_settings_changed, self, 0);
	_tmp17_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp17_, "changed::follow-input-cursor-when-always-shown", (GCallback) ___lambda63__g_settings_changed, self, 0);
	_tmp18_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp18_, "changed::xkb-icon-rgba", (GCallback) ___lambda64__g_settings_changed, self, 0);
	_tmp19_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp19_, "changed::property-icon-delay-time", (GCallback) ___lambda65__g_settings_changed, self, 0);
	_tmp20_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp20_, "changed::hotkey", (GCallback) ___lambda66__g_settings_changed, self, 0);
	_tmp21_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp21_, "changed::font", (GCallback) ___lambda67__g_settings_changed, self, 0);
	_tmp22_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp22_, "changed::favorites", (GCallback) ___lambda68__g_settings_changed, self, 0);
	_tmp23_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp23_, "changed::favorite-annotations", (GCallback) ___lambda69__g_settings_changed, self, 0);
	_tmp24_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp24_, "changed::lang", (GCallback) ___lambda70__g_settings_changed, self, 0);
	_tmp25_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp25_, "changed::has-partial-match", (GCallback) ___lambda72__g_settings_changed, self, 0);
	_tmp26_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp26_, "changed::partial-match-length", (GCallback) ___lambda73__g_settings_changed, self, 0);
	_tmp27_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp27_, "changed::partial-match-condition", (GCallback) ___lambda74__g_settings_changed, self, 0);
}


static gboolean panel_is_kde (Panel* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	if (g_strcmp0 (_tmp0_, "KDE") == 0) {
		result = TRUE;
		return result;
	}
	g_warning ("panel.vala:274: %s", "If you launch KDE5 on xterm, " "export XDG_CURRENT_DESKTOP=KDE before launch KDE5.");
	result = FALSE;
	return result;
}


static void ___lambda76_ (Panel* self) {
	Indicator* _tmp0_;
	_tmp0_ = self->priv->m_indicator;
	indicator_set_status (_tmp0_, INDICATOR_STATUS_ACTIVE);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
}


static void ____lambda76__indicator_registered_status_notifier_item (Indicator* _sender, gpointer self) {
	___lambda76_ ((Panel*) self);
}


static void _indicator_position_context_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	indicator_position_context_menu ((Indicator*) self, menu, x, y, push_in);
	g_object_unref (self);
}


static void ___lambda77_ (Panel* self, guint b, guint t) {
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	Indicator* _tmp1_;
	guint32 _tmp2_;
	_tmp0_ = panel_create_context_menu (self);
	menu = _tmp0_;
	_tmp1_ = self->priv->m_indicator;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, _indicator_position_context_menu_gtk_menu_position_func, g_object_ref (_tmp1_), (guint) 0, _tmp2_);
	_g_object_unref0 (menu);
}


static void ____lambda77__indicator_context_menu (Indicator* _sender, guint button, guint activate_time, gpointer self) {
	___lambda77_ ((Panel*) self, button, activate_time);
}


static void _indicator_position_activate_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	indicator_position_activate_menu ((Indicator*) self, menu, x, y, push_in);
	g_object_unref (self);
}


static void ___lambda84_ (Panel* self) {
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	Indicator* _tmp1_;
	guint32 _tmp2_;
	_tmp0_ = panel_create_activate_menu (self);
	menu = _tmp0_;
	_tmp1_ = self->priv->m_indicator;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, _indicator_position_activate_menu_gtk_menu_position_func, g_object_ref (_tmp1_), (guint) 0, _tmp2_);
	_g_object_unref0 (menu);
}


static void ____lambda84__indicator_activate (Indicator* _sender, gpointer self) {
	___lambda84_ ((Panel*) self);
}


static void __lambda75_ (Panel* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		GDBusConnection* _tmp2_;
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp4_;
		Indicator* _tmp5_;
		Indicator* _tmp6_;
		Indicator* _tmp7_;
		Indicator* _tmp8_;
		Indicator* _tmp9_;
		_tmp1_ = res;
		_tmp2_ = g_bus_get_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch11_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->m_session_bus_connection);
		self->priv->m_session_bus_connection = _tmp3_;
		_tmp4_ = self->priv->m_session_bus_connection;
		_tmp5_ = indicator_new ("ibus-ui-gtk3", _tmp4_, INDICATOR_CATEGORY_APPLICATION_STATUS);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->m_indicator);
		self->priv->m_indicator = _tmp5_;
		_tmp6_ = self->priv->m_indicator;
		indicator_set_title (_tmp6_, _ ("IBus Panel"));
		_tmp7_ = self->priv->m_indicator;
		g_signal_connect_object (_tmp7_, "registered-status-notifier-item", (GCallback) ____lambda76__indicator_registered_status_notifier_item, self, 0);
		_tmp8_ = self->priv->m_indicator;
		g_signal_connect_object (_tmp8_, "context-menu", (GCallback) ____lambda77__indicator_context_menu, self, 0);
		_tmp9_ = self->priv->m_indicator;
		g_signal_connect_object (_tmp9_, "activate", (GCallback) ____lambda84__indicator_activate, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally11;
	__catch11_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("panel.vala:310: Failed to get the session bus: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda75__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda75_ ((Panel*) self, source_object, res);
	g_object_unref (self);
}


static void panel_init_indicator (Panel* self) {
	g_return_if_fail (self != NULL);
	self->priv->m_icon_type = PANEL_ICON_TYPE_INDICATOR;
	g_bus_get (G_BUS_TYPE_SESSION, NULL, ___lambda75__gasync_ready_callback, g_object_ref (self));
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, (GtkStatusIcon*) self);
	g_object_unref (self);
}


static void __lambda86_ (Panel* self, guint b, guint t) {
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkStatusIcon* _tmp1_;
	guint32 _tmp2_;
	_tmp0_ = panel_create_context_menu (self);
	menu = _tmp0_;
	_tmp1_ = self->priv->m_status_icon;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, g_object_ref (_tmp1_), (guint) 0, _tmp2_);
	_g_object_unref0 (menu);
}


static void ___lambda86__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	__lambda86_ ((Panel*) self, button, activate_time);
}


static void __lambda87_ (Panel* self) {
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GtkStatusIcon* _tmp1_;
	guint32 _tmp2_;
	_tmp0_ = panel_create_activate_menu (self);
	menu = _tmp0_;
	_tmp1_ = self->priv->m_status_icon;
	_tmp2_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, g_object_ref (_tmp1_), (guint) 0, _tmp2_);
	_g_object_unref0 (menu);
}


static void ___lambda87__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	__lambda87_ ((Panel*) self);
}


static void panel_init_status_icon (Panel* self) {
	GtkStatusIcon* _tmp0_;
	GtkStatusIcon* _tmp1_;
	GtkStatusIcon* _tmp2_;
	GtkStatusIcon* _tmp3_;
	GtkStatusIcon* _tmp4_;
	GtkStatusIcon* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp0_;
	_tmp1_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp1_, "ibus-ui-gtk");
	_tmp2_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp2_, _ ("IBus Panel"));
	_tmp3_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp3_, "popup-menu", (GCallback) ___lambda86__gtk_status_icon_popup_menu, self, 0);
	_tmp4_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) ___lambda87__gtk_status_icon_activate, self, 0);
	_tmp5_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp5_, "ibus-keyboard");
}


static gpointer _panel_keybinding_ref0 (gpointer self) {
	return self ? panel_keybinding_ref (self) : NULL;
}


static void ___lambda52_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, FALSE);
}


static void ____lambda52__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	___lambda52_ ((Panel*) self, event);
}


static void ____lambda54_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_emoji_typing (self, _tmp0_);
}


static void _____lambda54__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	____lambda54_ ((Panel*) self, event);
}


static void ___lambda56_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, TRUE);
}


static void ____lambda56__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	___lambda56_ ((Panel*) self, event);
}


static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator, PanelKeyEventFuncType ftype) {
	guint switch_keysym = 0U;
	GdkModifierType switch_modifiers = 0;
	GdkModifierType reverse_modifier = 0;
	PanelKeybinding* keybinding = NULL;
	const gchar* _tmp0_;
	guint _tmp1_ = 0U;
	GdkModifierType _tmp2_ = 0;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	GdkModifierType _tmp3_;
	gboolean _tmp6_ = FALSE;
	guint _tmp7_;
	guint _tmp10_;
	GdkModifierType _tmp11_;
	PanelKeyEventFuncType _tmp12_;
	PanelKeybinding* _tmp13_;
	PanelKeybinding* _tmp14_;
	PanelKeybinding* _tmp15_;
	PanelKeyEventFuncType _tmp16_;
	GdkModifierType _tmp24_;
	GdkModifierType _tmp25_;
	GdkModifierType _tmp26_;
	GdkModifierType _tmp27_;
	guint _tmp28_;
	GdkModifierType _tmp29_;
	PanelKeyEventFuncType _tmp30_;
	PanelKeybinding* _tmp31_;
	PanelKeybinding* _tmp32_;
	PanelKeybinding* _tmp33_;
	PanelKeyEventFuncType _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keybinding_manager != NULL);
	switch_keysym = (guint) 0;
	switch_modifiers = 0;
	reverse_modifier = GDK_SHIFT_MASK;
	_tmp0_ = accelerator;
	gtk_accelerator_parse (_tmp0_, &_tmp1_, &_tmp2_);
	switch_keysym = _tmp1_;
	switch_modifiers = _tmp2_;
	_tmp3_ = switch_modifiers;
	if ((_tmp3_ & VIRTUAL_MODIFIERS) != 0) {
		GdkKeymap* _tmp4_;
		GdkModifierType _tmp5_;
		_tmp4_ = gdk_keymap_get_default ();
		gdk_keymap_map_virtual_modifiers (_tmp4_, &switch_modifiers);
		_tmp5_ = switch_modifiers;
		switch_modifiers = _tmp5_ & (~VIRTUAL_MODIFIERS);
	}
	_tmp7_ = switch_keysym;
	if (_tmp7_ == ((guint) 0)) {
		GdkModifierType _tmp8_;
		_tmp8_ = switch_modifiers;
		_tmp6_ = _tmp8_ == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		_tmp9_ = accelerator;
		g_warning ("panel.vala:371: Parse accelerator '%s' failed!", _tmp9_);
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp10_ = switch_keysym;
	_tmp11_ = switch_modifiers;
	_tmp12_ = ftype;
	_tmp13_ = panel_keybinding_new (_tmp10_, _tmp11_, FALSE, _tmp12_);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp13_;
	_tmp14_ = keybinding;
	_tmp15_ = _panel_keybinding_ref0 (_tmp14_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp15_);
	_tmp16_ = ftype;
	if (_tmp16_ == PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER) {
		KeybindingManager* _tmp17_;
		guint _tmp18_;
		GdkModifierType _tmp19_;
		_tmp17_ = keybinding_manager;
		_tmp18_ = switch_keysym;
		_tmp19_ = switch_modifiers;
		keybinding_manager_bind (_tmp17_, _tmp18_, _tmp19_, ____lambda52__keybinding_manager_keybinding_handler_func, self);
	} else {
		PanelKeyEventFuncType _tmp20_;
		_tmp20_ = ftype;
		if (_tmp20_ == PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING) {
			KeybindingManager* _tmp21_;
			guint _tmp22_;
			GdkModifierType _tmp23_;
			_tmp21_ = keybinding_manager;
			_tmp22_ = switch_keysym;
			_tmp23_ = switch_modifiers;
			keybinding_manager_bind (_tmp21_, _tmp22_, _tmp23_, _____lambda54__keybinding_manager_keybinding_handler_func, self);
			_panel_keybinding_unref0 (keybinding);
			return;
		}
	}
	_tmp24_ = switch_modifiers;
	_tmp25_ = reverse_modifier;
	if ((_tmp24_ & _tmp25_) != 0) {
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp26_ = switch_modifiers;
	_tmp27_ = reverse_modifier;
	switch_modifiers = _tmp26_ | _tmp27_;
	_tmp28_ = switch_keysym;
	_tmp29_ = switch_modifiers;
	_tmp30_ = ftype;
	_tmp31_ = panel_keybinding_new (_tmp28_, _tmp29_, TRUE, _tmp30_);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp31_;
	_tmp32_ = keybinding;
	_tmp33_ = _panel_keybinding_ref0 (_tmp32_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp33_);
	_tmp34_ = ftype;
	if (_tmp34_ == PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER) {
		KeybindingManager* _tmp35_;
		guint _tmp36_;
		GdkModifierType _tmp37_;
		_tmp35_ = keybinding_manager;
		_tmp36_ = switch_keysym;
		_tmp37_ = switch_modifiers;
		keybinding_manager_bind (_tmp35_, _tmp36_, _tmp37_, ____lambda56__keybinding_manager_keybinding_handler_func, self);
	}
	_panel_keybinding_unref0 (keybinding);
}


static void panel_bind_switch_shortcut (Panel* self) {
	gchar** accelerators = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint accelerators_length1;
	gint _accelerators_size_;
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_hotkey;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "triggers");
	accelerators = _tmp2_;
	accelerators_length1 = _vala_array_length (_tmp1_);
	_accelerators_size_ = accelerators_length1;
	_tmp3_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp3_;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < _tmp4__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				KeybindingManager* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = keybinding_manager;
				_tmp7_ = accelerator;
				panel_keybinding_manager_bind (self, _tmp6_, _tmp7_, PANEL_KEY_EVENT_FUNC_TYPE_IME_SWITCHER);
				_g_free0 (accelerator);
			}
		}
	}
	_g_object_unref0 (keybinding_manager);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}


static void panel_bind_emoji_shortcut (Panel* self) {
	gchar** accelerators = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint accelerators_length1;
	gint _accelerators_size_;
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "hotkey");
	accelerators = _tmp2_;
	accelerators_length1 = _vala_array_length (_tmp1_);
	_accelerators_size_ = accelerators_length1;
	_tmp3_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp3_;
	_tmp4_ = accelerators;
	_tmp4__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp4_;
		accelerator_collection_length1 = _tmp4__length1;
		for (accelerator_it = 0; accelerator_it < _tmp4__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp5_;
			gchar* accelerator = NULL;
			_tmp5_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp5_;
			{
				KeybindingManager* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = keybinding_manager;
				_tmp7_ = accelerator;
				panel_keybinding_manager_bind (self, _tmp6_, _tmp7_, PANEL_KEY_EVENT_FUNC_TYPE_EMOJI_TYPING);
				_g_free0 (accelerator);
			}
		}
	}
	_g_object_unref0 (keybinding_manager);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}


static void panel_unbind_switch_shortcut (Panel* self, PanelKeyEventFuncType ftype) {
	KeybindingManager* keybinding_manager = NULL;
	KeybindingManager* _tmp0_;
	GList* keybindings = NULL;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp1_ = self->priv->m_keybindings;
	keybindings = _tmp1_;
	while (TRUE) {
		GList* _tmp2_;
		PanelKeybinding* keybinding = NULL;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		PanelKeybinding* _tmp5_;
		gboolean _tmp6_ = FALSE;
		PanelKeyEventFuncType _tmp7_;
		GList* _tmp19_;
		GList* _tmp20_;
		_tmp2_ = keybindings;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = keybindings;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _panel_keybinding_ref0 ((PanelKeybinding*) _tmp4_);
		keybinding = _tmp5_;
		_tmp7_ = ftype;
		if (_tmp7_ == PANEL_KEY_EVENT_FUNC_TYPE_ANY) {
			_tmp6_ = TRUE;
		} else {
			PanelKeyEventFuncType _tmp8_;
			PanelKeybinding* _tmp9_;
			PanelKeyEventFuncType _tmp10_;
			PanelKeyEventFuncType _tmp11_;
			_tmp8_ = ftype;
			_tmp9_ = keybinding;
			_tmp10_ = panel_keybinding_get_ftype (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp6_ = _tmp8_ == _tmp11_;
		}
		if (_tmp6_) {
			KeybindingManager* _tmp12_;
			PanelKeybinding* _tmp13_;
			guint _tmp14_;
			guint _tmp15_;
			PanelKeybinding* _tmp16_;
			GdkModifierType _tmp17_;
			GdkModifierType _tmp18_;
			_tmp12_ = keybinding_manager;
			_tmp13_ = keybinding;
			_tmp14_ = panel_keybinding_get_keysym (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = keybinding;
			_tmp17_ = panel_keybinding_get_modifiers (_tmp16_);
			_tmp18_ = _tmp17_;
			keybinding_manager_unbind (_tmp12_, _tmp15_, _tmp18_);
		}
		_tmp19_ = keybindings;
		_tmp20_ = _tmp19_->next;
		keybindings = _tmp20_;
		_panel_keybinding_unref0 (keybinding);
	}
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	self->priv->m_keybindings = NULL;
	_g_object_unref0 (keybinding_manager);
}


/**
     * panel_get_engines_from_xkb:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus xkb engines
     *
     * Made ibus engines from the current XKB keymaps.
     * This returns only XKB engines whose name start with "xkb:".
     */
static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GList* panel_get_engines_from_xkb (Panel* self, GList* engines) {
	GList* result = NULL;
	gchar* layouts = NULL;
	gchar* variants = NULL;
	gchar* option = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GList* xkb_engines = NULL;
	IBusEngineDesc* us_engine = NULL;
	IBusEngineDesc* _tmp3_;
	gchar** layout_array = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint layout_array_length1;
	gint _layout_array_size_;
	gchar** variant_array = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint variant_array_length1;
	gint _variant_array_size_;
	GList* _tmp51_;
	guint _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	xkb_layout_get_layout (&_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (layouts);
	layouts = _tmp0_;
	_g_free0 (variants);
	variants = _tmp1_;
	_g_free0 (option);
	option = _tmp2_;
	xkb_engines = NULL;
	_tmp3_ = ibus_engine_desc_new ("xkb:us::eng", "", "", "", "", "", "", "");
	g_object_ref_sink (_tmp3_);
	us_engine = _tmp3_;
	_tmp4_ = layouts;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
	layout_array = _tmp6_;
	layout_array_length1 = _vala_array_length (_tmp5_);
	_layout_array_size_ = layout_array_length1;
	_tmp7_ = variants;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ",", 0);
	variant_array = _tmp9_;
	variant_array_length1 = _vala_array_length (_tmp8_);
	_variant_array_size_ = variant_array_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar* layout = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* variant = NULL;
				IBusEngineDesc* current_engine = NULL;
				gint _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp24_;
				GList* _tmp26_;
				IBusEngineDesc* _tmp41_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = layout_array;
				_tmp13__length1 = layout_array_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = layout_array;
				_tmp14__length1 = layout_array_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = g_strdup (_tmp16_);
				layout = _tmp17_;
				variant = NULL;
				current_engine = NULL;
				_tmp18_ = i;
				_tmp19_ = variant_array;
				_tmp19__length1 = variant_array_length1;
				if (_tmp18_ < _tmp19__length1) {
					gchar** _tmp20_;
					gint _tmp20__length1;
					gint _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp20_ = variant_array;
					_tmp20__length1 = variant_array_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (variant);
					variant = _tmp23_;
				}
				_tmp24_ = variant;
				if (_tmp24_ == NULL) {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("");
					_g_free0 (variant);
					variant = _tmp25_;
				}
				_tmp26_ = engines;
				{
					GList* engine_collection = NULL;
					GList* engine_it = NULL;
					engine_collection = _tmp26_;
					for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
						IBusEngineDesc* engine = NULL;
						engine = (IBusEngineDesc*) engine_it->data;
						{
							gchar* name = NULL;
							IBusEngineDesc* _tmp27_;
							const gchar* _tmp28_;
							gchar* _tmp29_;
							const gchar* _tmp30_;
							gboolean _tmp31_;
							gboolean _tmp32_ = FALSE;
							IBusEngineDesc* _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							_tmp27_ = engine;
							_tmp28_ = ibus_engine_desc_get_name (_tmp27_);
							_tmp29_ = g_strdup (_tmp28_);
							name = _tmp29_;
							_tmp30_ = name;
							_tmp31_ = g_str_has_prefix (_tmp30_, "xkb:");
							if (!_tmp31_) {
								_g_free0 (name);
								continue;
							}
							_tmp33_ = engine;
							_tmp34_ = ibus_engine_desc_get_layout (_tmp33_);
							_tmp35_ = layout;
							if (g_strcmp0 (_tmp34_, _tmp35_) == 0) {
								IBusEngineDesc* _tmp36_;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								_tmp36_ = engine;
								_tmp37_ = ibus_engine_desc_get_layout_variant (_tmp36_);
								_tmp38_ = variant;
								_tmp32_ = g_strcmp0 (_tmp37_, _tmp38_) == 0;
							} else {
								_tmp32_ = FALSE;
							}
							if (_tmp32_) {
								IBusEngineDesc* _tmp39_;
								IBusEngineDesc* _tmp40_;
								_tmp39_ = engine;
								_tmp40_ = _g_object_ref0 (_tmp39_);
								_g_object_unref0 (current_engine);
								current_engine = _tmp40_;
								_g_free0 (name);
								break;
							}
							_g_free0 (name);
						}
					}
				}
				_tmp41_ = current_engine;
				if (_tmp41_ != NULL) {
					IBusEngineDesc* _tmp42_;
					IBusEngineDesc* _tmp43_;
					_tmp42_ = current_engine;
					_tmp43_ = _g_object_ref0 (_tmp42_);
					xkb_engines = g_list_append (xkb_engines, _tmp43_);
				} else {
					GList* _tmp44_;
					IBusEngineDesc* _tmp45_;
					GList* _tmp46_;
					_tmp44_ = xkb_engines;
					_tmp45_ = us_engine;
					_tmp46_ = g_list_find (_tmp44_, _tmp45_);
					if (_tmp46_ == NULL) {
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						IBusEngineDesc* _tmp49_;
						IBusEngineDesc* _tmp50_;
						_tmp47_ = layout;
						_tmp48_ = variant;
						g_warning ("panel.vala:509: Fallback %s(%s) to us layout.", _tmp47_, _tmp48_);
						_tmp49_ = us_engine;
						_tmp50_ = _g_object_ref0 (_tmp49_);
						xkb_engines = g_list_append (xkb_engines, _tmp50_);
					}
				}
				_g_object_unref0 (current_engine);
				_g_free0 (variant);
				_g_free0 (layout);
			}
		}
	}
	_tmp51_ = xkb_engines;
	_tmp52_ = g_list_length (_tmp51_);
	if (_tmp52_ == ((guint) 0)) {
		g_warning ("panel.vala:515: Not found IBus XKB engines from the session.");
	}
	result = xkb_engines;
	variant_array = (_vala_array_free (variant_array, variant_array_length1, (GDestroyNotify) g_free), NULL);
	layout_array = (_vala_array_free (layout_array, layout_array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (us_engine);
	_g_free0 (option);
	_g_free0 (variants);
	_g_free0 (layouts);
	return result;
}


/**
     * panel_get_engines_from_locale:
     * @self: #Panel class
     * @engines: all engines from ibus_bus_list_engines()
     * @returns: ibus im engines
     *
     * Made ibus engines from the current locale and IBus.EngineDesc.lang .
     * This returns non-XKB engines whose name does not start "xkb:".
     */
static gint __lambda95_ (IBusEngineDesc* a, IBusEngineDesc* b) {
	gint result = 0;
	IBusEngineDesc* _tmp0_;
	guint _tmp1_;
	IBusEngineDesc* _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = b;
	_tmp1_ = ibus_engine_desc_get_rank (_tmp0_);
	_tmp2_ = a;
	_tmp3_ = ibus_engine_desc_get_rank (_tmp2_);
	result = ((gint) _tmp1_) - ((gint) _tmp3_);
	return result;
}


static gint ___lambda95__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda95_ ((IBusEngineDesc*) a, (IBusEngineDesc*) b);
	return result;
}


static GList* panel_get_engines_from_locale (Panel* self, GList* engines) {
	GList* result = NULL;
	gchar* locale = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lang = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GList* im_engines = NULL;
	GList* _tmp11_;
	GList* _tmp25_;
	guint _tmp26_;
	GList* _tmp47_;
	guint _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = setlocale (LC_CTYPE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	locale = _tmp1_;
	_tmp2_ = locale;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("C");
		_g_free0 (locale);
		locale = _tmp3_;
	}
	_tmp4_ = locale;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ".", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_tmp8_ = _tmp7_[0];
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	lang = _tmp10_;
	im_engines = NULL;
	_tmp11_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp11_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar* name = NULL;
				IBusEngineDesc* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_ = FALSE;
				IBusEngineDesc* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp12_ = engine;
				_tmp13_ = ibus_engine_desc_get_name (_tmp12_);
				_tmp14_ = g_strdup (_tmp13_);
				name = _tmp14_;
				_tmp15_ = name;
				_tmp16_ = g_str_has_prefix (_tmp15_, "xkb:");
				if (_tmp16_) {
					_g_free0 (name);
					continue;
				}
				_tmp18_ = engine;
				_tmp19_ = ibus_engine_desc_get_language (_tmp18_);
				_tmp20_ = lang;
				if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
					IBusEngineDesc* _tmp21_;
					guint _tmp22_;
					_tmp21_ = engine;
					_tmp22_ = ibus_engine_desc_get_rank (_tmp21_);
					_tmp17_ = _tmp22_ > ((guint) 0);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					IBusEngineDesc* _tmp23_;
					IBusEngineDesc* _tmp24_;
					_tmp23_ = engine;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					im_engines = g_list_append (im_engines, _tmp24_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp25_ = im_engines;
	_tmp26_ = g_list_length (_tmp25_);
	if (_tmp26_ == ((guint) 0)) {
		const gchar* _tmp27_;
		gchar** _tmp28_;
		gchar** _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		GList* _tmp33_;
		_tmp27_ = lang;
		_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "_", 0);
		_tmp30_ = _tmp29_;
		_tmp30__length1 = _vala_array_length (_tmp28_);
		_tmp31_ = _tmp30_[0];
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (lang);
		lang = _tmp32_;
		_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
		_tmp33_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp33_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					gchar* name = NULL;
					IBusEngineDesc* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					const gchar* _tmp37_;
					gboolean _tmp38_;
					gboolean _tmp39_ = FALSE;
					IBusEngineDesc* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp34_ = engine;
					_tmp35_ = ibus_engine_desc_get_name (_tmp34_);
					_tmp36_ = g_strdup (_tmp35_);
					name = _tmp36_;
					_tmp37_ = name;
					_tmp38_ = g_str_has_prefix (_tmp37_, "xkb:");
					if (_tmp38_) {
						_g_free0 (name);
						continue;
					}
					_tmp40_ = engine;
					_tmp41_ = ibus_engine_desc_get_language (_tmp40_);
					_tmp42_ = lang;
					if (g_strcmp0 (_tmp41_, _tmp42_) == 0) {
						IBusEngineDesc* _tmp43_;
						guint _tmp44_;
						_tmp43_ = engine;
						_tmp44_ = ibus_engine_desc_get_rank (_tmp43_);
						_tmp39_ = _tmp44_ > ((guint) 0);
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						IBusEngineDesc* _tmp45_;
						IBusEngineDesc* _tmp46_;
						_tmp45_ = engine;
						_tmp46_ = _g_object_ref0 (_tmp45_);
						im_engines = g_list_append (im_engines, _tmp46_);
					}
					_g_free0 (name);
				}
			}
		}
	}
	_tmp47_ = im_engines;
	_tmp48_ = g_list_length (_tmp47_);
	if (_tmp48_ == ((guint) 0)) {
		result = im_engines;
		_g_free0 (lang);
		_g_free0 (locale);
		return result;
	}
	im_engines = g_list_sort (im_engines, ___lambda95__gcompare_func);
	result = im_engines;
	_g_free0 (lang);
	_g_free0 (locale);
	return result;
}


static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_init_engines_order (Panel* self) {
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean _tmp5_;
	GSettings* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_;
	GList* engines = NULL;
	IBusBus* _tmp11_;
	GList* _tmp12_;
	GList* xkb_engines = NULL;
	GList* _tmp13_;
	GList* _tmp14_;
	GList* im_engines = NULL;
	GList* _tmp15_;
	GList* _tmp16_;
	gchar** names = NULL;
	gchar** _tmp17_;
	gint names_length1;
	gint _names_size_;
	GList* _tmp18_;
	GList* _tmp23_;
	GSettings* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "xkb-latin-layouts");
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	xkb_layout_set_latin_layouts (_tmp0_, _tmp4_, _vala_array_length (_tmp2_));
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = self->priv->inited_engines_order;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = self->priv->m_settings_general;
	_tmp8_ = _tmp7_ = g_settings_get_strv (_tmp6_, "preload-engines");
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	_tmp10_ = _vala_array_length (_tmp7_) > 0;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp10_) {
		return;
	}
	_tmp11_ = self->priv->m_bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	_tmp13_ = engines;
	_tmp14_ = panel_get_engines_from_xkb (self, _tmp13_);
	xkb_engines = _tmp14_;
	_tmp15_ = engines;
	_tmp16_ = panel_get_engines_from_locale (self, _tmp15_);
	im_engines = _tmp16_;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	names = _tmp17_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp18_ = xkb_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp18_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar** _tmp19_;
				gint _tmp19__length1;
				IBusEngineDesc* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp19_ = names;
				_tmp19__length1 = names_length1;
				_tmp20_ = engine;
				_tmp21_ = ibus_engine_desc_get_name (_tmp20_);
				_tmp22_ = g_strdup (_tmp21_);
				_vala_array_add17 (&names, &names_length1, &_names_size_, _tmp22_);
			}
		}
	}
	_tmp23_ = im_engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp23_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				gchar** _tmp24_;
				gint _tmp24__length1;
				IBusEngineDesc* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp24_ = names;
				_tmp24__length1 = names_length1;
				_tmp25_ = engine;
				_tmp26_ = ibus_engine_desc_get_name (_tmp25_);
				_tmp27_ = g_strdup (_tmp26_);
				_vala_array_add18 (&names, &names_length1, &_names_size_, _tmp27_);
			}
		}
	}
	_tmp28_ = self->priv->m_settings_general;
	_tmp29_ = names;
	_tmp29__length1 = names_length1;
	g_settings_set_strv (_tmp28_, "preload-engines", _tmp29_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free__g_object_unref0_0 (im_engines);
	__g_list_free__g_object_unref0_0 (xkb_engines);
	__g_list_free__g_object_unref0_0 (engines);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void panel_set_custom_font (Panel* self) {
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	gchar* emoji_font = NULL;
	GSettings* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean use_custom_font = FALSE;
	GSettings* _tmp12_;
	gboolean _tmp13_;
	GtkCssProvider* _tmp14_;
	gboolean _tmp17_;
	gchar* custom_font = NULL;
	GSettings* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	PangoFontDescription* font_desc = NULL;
	const gchar* _tmp21_;
	PangoFontDescription* _tmp22_;
	gchar* font_family = NULL;
	PangoFontDescription* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gint font_size = 0;
	PangoFontDescription* _tmp26_;
	gint _tmp27_;
	gchar* data = NULL;
	gboolean _tmp28_ = FALSE;
	GtkCssProvider* _tmp35_;
	GdkScreen* _tmp41_;
	GtkCssProvider* _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	screen = _tmp6_;
	_tmp7_ = screen;
	if (_tmp7_ == NULL) {
		g_warning ("panel.vala:606: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp8_ = self->priv->m_settings_emoji;
	_tmp9_ = g_settings_get_string (_tmp8_, "font");
	emoji_font = _tmp9_;
	_tmp10_ = emoji_font;
	if (_tmp10_ == NULL) {
		g_warning ("panel.vala:612: No config emoji:font.");
		_g_free0 (emoji_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp11_ = emoji_font;
	ibus_emojier_set_emoji_font (_tmp11_);
	_tmp12_ = self->priv->m_settings_panel;
	_tmp13_ = g_settings_get_boolean (_tmp12_, "use-custom-font");
	use_custom_font = _tmp13_;
	_tmp14_ = self->priv->m_css_provider;
	if (_tmp14_ != NULL) {
		GdkScreen* _tmp15_;
		GtkCssProvider* _tmp16_;
		_tmp15_ = screen;
		_tmp16_ = self->priv->m_css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp15_, (GtkStyleProvider*) _tmp16_);
		_g_object_unref0 (self->priv->m_css_provider);
		self->priv->m_css_provider = NULL;
	}
	_tmp17_ = use_custom_font;
	if (_tmp17_ == FALSE) {
		_g_free0 (emoji_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp18_ = self->priv->m_settings_panel;
	_tmp19_ = g_settings_get_string (_tmp18_, "custom-font");
	custom_font = _tmp19_;
	_tmp20_ = custom_font;
	if (_tmp20_ == NULL) {
		g_warning ("panel.vala:631: No config panel:custom-font.");
		_g_free0 (custom_font);
		_g_free0 (emoji_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp21_ = custom_font;
	_tmp22_ = pango_font_description_from_string (_tmp21_);
	font_desc = _tmp22_;
	_tmp23_ = font_desc;
	_tmp24_ = pango_font_description_get_family (_tmp23_);
	_tmp25_ = g_strdup (_tmp24_);
	font_family = _tmp25_;
	_tmp26_ = font_desc;
	_tmp27_ = pango_font_description_get_size (_tmp26_);
	font_size = _tmp27_ / PANGO_SCALE;
	if (GTK_MAJOR_VERSION < 3) {
		_tmp28_ = TRUE;
	} else {
		gboolean _tmp29_ = FALSE;
		if (GTK_MAJOR_VERSION == 3) {
			_tmp29_ = GTK_MINOR_VERSION < 20;
		} else {
			_tmp29_ = FALSE;
		}
		_tmp28_ = _tmp29_;
	}
	if (_tmp28_) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = custom_font;
		_tmp31_ = g_strdup_printf ("GtkLabel { font: %s; }", _tmp30_);
		_g_free0 (data);
		data = _tmp31_;
	} else {
		const gchar* _tmp32_;
		gint _tmp33_;
		gchar* _tmp34_;
		_tmp32_ = font_family;
		_tmp33_ = font_size;
		_tmp34_ = g_strdup_printf ("label { font-family: %s; font-size: %dpt; }", _tmp32_, _tmp33_);
		_g_free0 (data);
		data = _tmp34_;
	}
	_tmp35_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->m_css_provider);
	self->priv->m_css_provider = _tmp35_;
	{
		GtkCssProvider* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = self->priv->m_css_provider;
		_tmp37_ = data;
		gtk_css_provider_load_from_data (_tmp36_, _tmp37_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp38_;
		GError* _tmp39_;
		const gchar* _tmp40_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = custom_font;
		_tmp39_ = e;
		_tmp40_ = _tmp39_->message;
		g_warning ("panel.vala:654: Failed css_provider_from_data: %s: %s", _tmp38_, _tmp40_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_free0 (emoji_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (data);
		_g_free0 (font_family);
		__vala_PangoFontDescription_free0 (font_desc);
		_g_free0 (custom_font);
		_g_free0 (emoji_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp41_ = screen;
	_tmp42_ = self->priv->m_css_provider;
	gtk_style_context_add_provider_for_screen (_tmp41_, (GtkStyleProvider*) _tmp42_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (font_family);
	__vala_PangoFontDescription_free0 (font_desc);
	_g_free0 (custom_font);
	_g_free0 (emoji_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void panel_set_switcher_delay_time (Panel* self) {
	GSettings* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	Switcher* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_int (_tmp0_, "switcher-delay-time");
	self->priv->m_switcher_delay_time = _tmp1_;
	_tmp3_ = self->priv->m_switcher;
	if (_tmp3_ != NULL) {
		gint _tmp4_;
		_tmp4_ = self->priv->m_switcher_delay_time;
		_tmp2_ = _tmp4_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Switcher* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->m_switcher;
		_tmp6_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp5_, (guint) _tmp6_);
	}
}


static void panel_set_use_system_keyboard_layout (Panel* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-system-keyboard-layout");
	self->priv->m_use_system_keyboard_layout = _tmp1_;
}


static void panel_set_embed_preedit_text (Panel* self) {
	GVariant* variant = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	IBusBus* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_value (_tmp0_, "embed-preedit-text");
	variant = _tmp1_;
	_tmp2_ = variant;
	if (_tmp2_ == NULL) {
		_g_variant_unref0 (variant);
		return;
	}
	_tmp3_ = self->priv->m_bus;
	_tmp4_ = variant;
	ibus_bus_set_ibus_property (_tmp3_, "EmbedPreeditText", _tmp4_);
	_g_variant_unref0 (variant);
}


static void panel_set_use_global_engine (Panel* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-global-engine");
	self->priv->m_use_global_engine = _tmp1_;
}


static void panel_set_use_xmodmap (Panel* self) {
	XKBLayout* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_xkblayout;
	_tmp1_ = self->priv->m_settings_general;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "use-xmodmap");
	xkb_layout_set_use_xmodmap (_tmp0_, _tmp2_);
}


static void panel_set_show_icon_on_systray (Panel* self) {
	PanelIconType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_icon_type;
	if (_tmp0_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GtkStatusIcon* _tmp1_;
		GtkStatusIcon* _tmp2_;
		GSettings* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->m_status_icon;
		if (_tmp1_ == NULL) {
			return;
		}
		_tmp2_ = self->priv->m_status_icon;
		_tmp3_ = self->priv->m_settings_panel;
		_tmp4_ = g_settings_get_boolean (_tmp3_, "show-icon-on-systray");
		gtk_status_icon_set_visible (_tmp2_, _tmp4_);
	} else {
		PanelIconType _tmp5_;
		_tmp5_ = self->priv->m_icon_type;
		if (_tmp5_ == PANEL_ICON_TYPE_INDICATOR) {
			Indicator* _tmp6_;
			GSettings* _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->m_indicator;
			if (_tmp6_ == NULL) {
				return;
			}
			_tmp7_ = self->priv->m_settings_panel;
			_tmp8_ = g_settings_get_boolean (_tmp7_, "show-icon-on-systray");
			if (_tmp8_) {
				Indicator* _tmp9_;
				_tmp9_ = self->priv->m_indicator;
				indicator_set_status (_tmp9_, INDICATOR_STATUS_ACTIVE);
			} else {
				Indicator* _tmp10_;
				_tmp10_ = self->priv->m_indicator;
				indicator_set_status (_tmp10_, INDICATOR_STATUS_PASSIVE);
			}
		}
	}
}


static void panel_set_lookup_table_orientation (Panel* self) {
	CandidatePanel* _tmp0_;
	CandidatePanel* _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_candidate_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_candidate_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "lookup-table-orientation");
	candidate_panel_set_vertical (_tmp1_, _tmp3_ == ((gint) IBUS_ORIENTATION_VERTICAL));
}


static void panel_set_show_property_panel (Panel* self) {
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "show");
	property_panel_set_show (_tmp1_, _tmp3_);
}


static void panel_set_timeout_property_panel (Panel* self) {
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_int (_tmp2_, "auto-hide-timeout");
	property_panel_set_auto_hide_timeout (_tmp1_, (guint) _tmp3_);
}


static void panel_set_follow_input_cursor_when_always_shown_property_panel (Panel* self) {
	PropertyPanel* _tmp0_;
	PropertyPanel* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_property_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_property_panel;
	_tmp2_ = self->priv->m_settings_panel;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "follow-input-cursor-when-always-shown");
	property_panel_set_follow_input_cursor_when_always_shown (_tmp1_, _tmp3_);
}


static void panel_set_xkb_icon_rgba (Panel* self) {
	gchar* spec = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp2_ = {0};
	const gchar* _tmp3_;
	gboolean _tmp4_;
	PanelIconType _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = g_settings_get_string (_tmp0_, "xkb-icon-rgba");
	spec = _tmp1_;
	_tmp2_.red = (gdouble) 0;
	rgba = _tmp2_;
	_tmp3_ = spec;
	_tmp4_ = gdk_rgba_parse (&rgba, _tmp3_);
	if (!_tmp4_) {
		const gchar* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		GdkRGBA _tmp7_;
		_tmp5_ = spec;
		g_warning ("panel.vala:757: invalid format of xkb-icon-rgba: %s", _tmp5_);
		memset (&_tmp6_, 0, sizeof (GdkRGBA));
		_tmp6_.red = 0.0;
		_tmp6_.green = 0.0;
		_tmp6_.blue = 0.0;
		_tmp6_.alpha = 1.0;
		self->priv->m_xkb_icon_rgba = _tmp6_;
		_tmp7_ = self->priv->m_xkb_icon_rgba;
	} else {
		GdkRGBA _tmp8_;
		_tmp8_ = rgba;
		self->priv->m_xkb_icon_rgba = _tmp8_;
	}
	_tmp9_ = self->priv->m_icon_type;
	if (_tmp9_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GHashTable* _tmp10_;
		guint _tmp11_;
		_tmp10_ = self->priv->m_xkb_icon_pixbufs;
		_tmp11_ = g_hash_table_size (_tmp10_);
		if (_tmp11_ > ((guint) 0)) {
			GHashTable* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GtkStatusIcon* _tmp14_;
			_tmp12_ = self->priv->m_xkb_icon_pixbufs;
			g_hash_table_remove_all (_tmp12_);
			_tmp14_ = self->priv->m_status_icon;
			if (_tmp14_ != NULL) {
				Switcher* _tmp15_;
				_tmp15_ = self->priv->m_switcher;
				_tmp13_ = _tmp15_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
			}
		}
	} else {
		PanelIconType _tmp16_;
		_tmp16_ = self->priv->m_icon_type;
		if (_tmp16_ == PANEL_ICON_TYPE_INDICATOR) {
			GHashTable* _tmp17_;
			guint _tmp18_;
			_tmp17_ = self->priv->m_xkb_icon_image;
			_tmp18_ = g_hash_table_size (_tmp17_);
			if (_tmp18_ > ((guint) 0)) {
				GHashTable* _tmp19_;
				gboolean _tmp20_ = FALSE;
				Indicator* _tmp21_;
				_tmp19_ = self->priv->m_xkb_icon_image;
				g_hash_table_remove_all (_tmp19_);
				_tmp21_ = self->priv->m_indicator;
				if (_tmp21_ != NULL) {
					Switcher* _tmp22_;
					_tmp22_ = self->priv->m_switcher;
					_tmp20_ = _tmp22_ != NULL;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
				}
			}
		}
	}
	_g_free0 (spec);
}


static void panel_set_property_icon_delay_time (Panel* self) {
	GSettings* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = g_settings_get_int (_tmp0_, "property-icon-delay-time");
	self->priv->m_property_icon_delay_time = _tmp1_;
}


static void panel_set_emoji_favorites (Panel* self) {
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "favorites");
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_emojier_favorites = _tmp2_;
	self->priv->m_emojier_favorites_length1 = _vala_array_length (_tmp1_);
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	_tmp3_ = self->priv->m_emojier_favorites;
	_tmp3__length1 = self->priv->m_emojier_favorites_length1;
	_tmp4_ = self->priv->m_settings_emoji;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "favorite-annotations");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	ibus_emojier_set_favorites (_tmp3_, _tmp3__length1, _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
}


static gboolean __lambda71_ (Panel* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_string (_tmp0_, "lang");
	_tmp2_ = _tmp1_;
	ibus_emojier_set_annotation_lang (_tmp2_);
	_g_free0 (_tmp2_);
	self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ___lambda71__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda71_ ((Panel*) self);
	return result;
}


static void panel_set_emoji_lang (Panel* self) {
	guint _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier_set_emoji_lang_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_emojier_set_emoji_lang_id;
		g_source_remove (_tmp1_);
		self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	}
	_tmp2_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda71__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->m_emojier_set_emoji_lang_id = _tmp2_;
}


static void panel_set_emoji_partial_match (Panel* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "has-partial-match");
	ibus_emojier_set_partial_match (_tmp1_);
	_tmp2_ = self->priv->m_settings_emoji;
	_tmp3_ = g_settings_get_int (_tmp2_, "partial-match-length");
	ibus_emojier_set_partial_match_length (_tmp3_);
	_tmp4_ = self->priv->m_settings_emoji;
	_tmp5_ = g_settings_get_int (_tmp4_, "partial-match-condition");
	ibus_emojier_set_partial_match_condition (_tmp5_);
}


static gint panel_compare_versions (Panel* self, const gchar* version1, const gchar* version2) {
	gint result = 0;
	gchar** version1_list = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint version1_list_length1;
	gint _version1_list_size_;
	gchar** version2_list = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint version2_list_length1;
	gint _version2_list_size_;
	gint major1 = 0;
	gint minor1 = 0;
	gint micro1 = 0;
	gint major2 = 0;
	gint minor2 = 0;
	gint micro2 = 0;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp16_;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gint _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gint _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	gint _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gint _tmp40_;
	gint _tmp41_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (version1 != NULL, 0);
	g_return_val_if_fail (version2 != NULL, 0);
	_tmp0_ = version1;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	version1_list = _tmp2_;
	version1_list_length1 = _vala_array_length (_tmp1_);
	_version1_list_size_ = version1_list_length1;
	_tmp3_ = version2;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ".", 0);
	version2_list = _tmp5_;
	version2_list_length1 = _vala_array_length (_tmp4_);
	_version2_list_size_ = version2_list_length1;
	_tmp6_ = version1;
	_tmp7_ = version2;
	if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = version1;
	if (g_strcmp0 (_tmp8_, "") == 0) {
		result = -1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp9_ = version2;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp10_ = version1_list;
	_tmp10__length1 = version1_list_length1;
	_vala_assert (_tmp10__length1 >= 3, "version1_list.length >= 3");
	_tmp11_ = version2_list;
	_tmp11__length1 = version2_list_length1;
	_vala_assert (_tmp11__length1 >= 3, "version2_list.length >= 3");
	_tmp12_ = version1_list;
	_tmp12__length1 = version1_list_length1;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = atoi (_tmp13_);
	major1 = _tmp14_;
	_tmp15_ = version1_list;
	_tmp15__length1 = version1_list_length1;
	_tmp16_ = _tmp15_[1];
	_tmp17_ = atoi (_tmp16_);
	minor1 = _tmp17_;
	_tmp18_ = version1_list;
	_tmp18__length1 = version1_list_length1;
	_tmp19_ = _tmp18_[2];
	_tmp20_ = atoi (_tmp19_);
	micro1 = _tmp20_;
	_tmp21_ = version2_list;
	_tmp21__length1 = version2_list_length1;
	_tmp22_ = _tmp21_[0];
	_tmp23_ = atoi (_tmp22_);
	major2 = _tmp23_;
	_tmp24_ = version2_list;
	_tmp24__length1 = version2_list_length1;
	_tmp25_ = _tmp24_[1];
	_tmp26_ = atoi (_tmp25_);
	minor2 = _tmp26_;
	_tmp27_ = version2_list;
	_tmp27__length1 = version2_list_length1;
	_tmp28_ = _tmp27_[2];
	_tmp29_ = atoi (_tmp28_);
	micro2 = _tmp29_;
	_tmp32_ = major1;
	_tmp33_ = minor1;
	if (_tmp32_ == _tmp33_) {
		gint _tmp34_;
		gint _tmp35_;
		_tmp34_ = minor1;
		_tmp35_ = minor2;
		_tmp31_ = _tmp34_ == _tmp35_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gint _tmp36_;
		gint _tmp37_;
		_tmp36_ = micro1;
		_tmp37_ = micro2;
		_tmp30_ = _tmp36_ == _tmp37_;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = 0;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp40_ = major1;
	_tmp41_ = major2;
	if (_tmp40_ > _tmp41_) {
		_tmp39_ = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		gint _tmp43_;
		gint _tmp44_;
		_tmp43_ = major1;
		_tmp44_ = major2;
		if (_tmp43_ == _tmp44_) {
			gint _tmp45_;
			gint _tmp46_;
			_tmp45_ = minor1;
			_tmp46_ = minor2;
			_tmp42_ = _tmp45_ > _tmp46_;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp39_ = _tmp42_;
	}
	if (_tmp39_) {
		_tmp38_ = TRUE;
	} else {
		gboolean _tmp47_ = FALSE;
		gboolean _tmp48_ = FALSE;
		gint _tmp49_;
		gint _tmp50_;
		_tmp49_ = major1;
		_tmp50_ = major2;
		if (_tmp49_ == _tmp50_) {
			gint _tmp51_;
			gint _tmp52_;
			_tmp51_ = minor1;
			_tmp52_ = minor2;
			_tmp48_ = _tmp51_ == _tmp52_;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			gint _tmp53_;
			gint _tmp54_;
			_tmp53_ = micro1;
			_tmp54_ = micro2;
			_tmp47_ = _tmp53_ > _tmp54_;
		} else {
			_tmp47_ = FALSE;
		}
		_tmp38_ = _tmp47_;
	}
	if (_tmp38_) {
		result = 1;
		version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
		version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = -1;
	version2_list = (_vala_array_free (version2_list, version2_list_length1, (GDestroyNotify) g_free), NULL);
	version1_list = (_vala_array_free (version1_list, version1_list_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void panel_update_version_1_5_3 (Panel* self) {
	gboolean _tmp0_;
	NotifyNotification* notification = NULL;
	NotifyNotification* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = notify_is_initted ();
	if (!_tmp0_) {
		notify_init ("ibus");
	}
	_tmp1_ = notify_notification_new (_ ("IBus Update"), _ ("Super+space is now the default hotkey."), "ibus");
	notification = _tmp1_;
	notify_notification_set_timeout (notification, 30 * 1000);
	notify_notification_set_category (notification, "hotkey");
	{
		notify_notification_show (notification, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("panel.vala:870: Notification is failed for IBus 1.5.3: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (notification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (notification);
}


static void panel_update_version_1_5_8 (Panel* self) {
	g_return_if_fail (self != NULL);
	self->priv->inited_engines_order = FALSE;
}


static void panel_set_version (Panel* self) {
	gchar* prev_version = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* current_version = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_general;
	_tmp1_ = g_settings_get_string (_tmp0_, "version");
	prev_version = _tmp1_;
	current_version = NULL;
	_tmp2_ = prev_version;
	_tmp3_ = panel_compare_versions (self, _tmp2_, "1.5.3");
	if (_tmp3_ < 0) {
		panel_update_version_1_5_3 (self);
	}
	_tmp4_ = prev_version;
	_tmp5_ = panel_compare_versions (self, _tmp4_, "1.5.8");
	if (_tmp5_ < 0) {
		panel_update_version_1_5_8 (self);
	}
	_tmp6_ = g_strdup_printf ("%d.%d.%d", IBUS_MAJOR_VERSION, IBUS_MINOR_VERSION, IBUS_MICRO_VERSION);
	_g_free0 (current_version);
	current_version = _tmp6_;
	_tmp7_ = prev_version;
	_tmp8_ = current_version;
	if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
		_g_free0 (current_version);
		_g_free0 (prev_version);
		return;
	}
	_tmp9_ = self->priv->m_settings_general;
	_tmp10_ = current_version;
	g_settings_set_string (_tmp9_, "version", _tmp10_);
	_g_free0 (current_version);
	_g_free0 (prev_version);
}


void panel_load_settings (Panel* self) {
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	panel_set_version (self);
	panel_init_engines_order (self);
	panel_set_use_system_keyboard_layout (self);
	panel_set_use_global_engine (self);
	panel_set_use_xmodmap (self);
	_tmp0_ = self->priv->m_settings_general;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "preload-engines");
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = self->priv->m_settings_general;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "engines-order");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	panel_update_engines (self, _tmp3_, _vala_array_length (_tmp1_), _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	panel_unbind_switch_shortcut (self, PANEL_KEY_EVENT_FUNC_TYPE_ANY);
	panel_bind_switch_shortcut (self);
	panel_bind_emoji_shortcut (self);
	panel_set_switcher_delay_time (self);
	panel_set_embed_preedit_text (self);
	panel_set_custom_font (self);
	panel_set_show_icon_on_systray (self);
	panel_set_lookup_table_orientation (self);
	panel_set_show_property_panel (self);
	panel_set_timeout_property_panel (self);
	panel_set_follow_input_cursor_when_always_shown_property_panel (self);
	panel_set_xkb_icon_rgba (self);
	panel_set_property_icon_delay_time (self);
	panel_set_emoji_favorites (self);
	panel_set_emoji_lang (self);
	panel_set_emoji_partial_match (self);
}


static void panel_engine_contexts_insert (Panel* self, IBusEngineDesc* engine) {
	gboolean _tmp0_;
	GHashTable* _tmp1_;
	guint _tmp2_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	IBusEngineDesc* _tmp7_;
	IBusEngineDesc* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	_tmp2_ = g_hash_table_size (_tmp1_);
	if (_tmp2_ >= ((guint) 200)) {
		GHashTable* _tmp3_;
		g_warning ("panel.vala:937: Contexts by windows are too much counted!");
		_tmp3_ = self->priv->m_engine_contexts;
		g_hash_table_remove_all (_tmp3_);
	}
	_tmp4_ = self->priv->m_engine_contexts;
	_tmp5_ = self->priv->m_current_context_path;
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = engine;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	g_hash_table_replace (_tmp4_, _tmp6_, _tmp8_);
}


static void panel_set_engine (Panel* self, IBusEngineDesc* engine) {
	guint _tmp0_;
	IBusBus* _tmp2_;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	IBusEngineDesc* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = self->priv->m_property_icon_delay_time_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_property_icon_delay_time_id;
		g_source_remove (_tmp1_);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	_tmp2_ = self->priv->m_bus;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_name (_tmp3_);
	_tmp5_ = ibus_bus_set_global_engine (_tmp2_, _tmp4_);
	if (!_tmp5_) {
		IBusEngineDesc* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = engine;
		_tmp7_ = ibus_engine_desc_get_name (_tmp6_);
		g_warning ("panel.vala:951: Switch engine to %s failed.", _tmp7_);
		return;
	}
	_tmp8_ = g_strdup ("");
	_g_free0 (self->priv->m_icon_prop_key);
	self->priv->m_icon_prop_key = _tmp8_;
	_tmp9_ = self->priv->m_use_system_keyboard_layout;
	if (!_tmp9_) {
		XKBLayout* _tmp10_;
		IBusEngineDesc* _tmp11_;
		_tmp10_ = self->priv->m_xkblayout;
		_tmp11_ = engine;
		xkb_layout_set_layout (_tmp10_, _tmp11_);
	}
	_tmp12_ = engine;
	panel_engine_contexts_insert (self, _tmp12_);
}


static void panel_switch_engine (Panel* self, gint i, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	IBusEngineDesc* engine = NULL;
	IBusEngineDesc** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	IBusEngineDesc* _tmp9_;
	IBusEngineDesc* _tmp10_;
	IBusEngineDesc* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp1_ = i;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		IBusEngineDesc** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = i;
		_tmp3_ = self->priv->m_engines;
		_tmp3__length1 = self->priv->m_engines_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "i >= 0 && i < m_engines.length");
	_tmp5_ = i;
	if (_tmp5_ == 0) {
		gboolean _tmp6_;
		_tmp6_ = force;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		return;
	}
	_tmp7_ = self->priv->m_engines;
	_tmp7__length1 = self->priv->m_engines_length1;
	_tmp8_ = i;
	_tmp9_ = _tmp7_[_tmp8_];
	_tmp10_ = _g_object_ref0 (_tmp9_);
	engine = _tmp10_;
	_tmp11_ = engine;
	panel_set_engine (self, _tmp11_);
	_g_object_unref0 (engine);
}


static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert) {
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	guint keyval = 0U;
	GdkEvent* _tmp1_;
	GdkEventKey* _tmp2_;
	GdkEventKey* _tmp3_;
	guint _tmp4_;
	guint modifiers = 0U;
	GdkEvent* _tmp5_;
	GdkEventKey* _tmp6_;
	GdkEventKey* _tmp7_;
	GdkModifierType _tmp8_;
	guint primary_modifiers = 0U;
	GdkEvent* _tmp9_;
	GdkEventKey* _tmp10_;
	GdkEventKey* _tmp11_;
	GdkModifierType _tmp12_;
	GdkModifierType _tmp13_;
	gboolean pressed = FALSE;
	GdkEvent* _tmp14_;
	guint _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = event;
	_tmp2_ = (GdkEventKey *) (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->keyval;
	keyval = _tmp4_;
	_tmp5_ = event;
	_tmp6_ = (GdkEventKey *) (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->state;
	modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp8_;
	_tmp9_ = event;
	_tmp10_ = (GdkEventKey *) (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->state;
	_tmp13_ = keybinding_manager_get_primary_modifier ((guint) _tmp12_);
	primary_modifiers = (guint) _tmp13_;
	_tmp14_ = event;
	_tmp15_ = primary_modifiers;
	_tmp16_ = keybinding_manager_primary_modifier_still_pressed (_tmp14_, _tmp15_);
	pressed = _tmp16_;
	_tmp17_ = revert;
	if (_tmp17_) {
		guint _tmp18_;
		_tmp18_ = modifiers;
		modifiers = _tmp18_ & (~GDK_SHIFT_MASK);
	}
	_tmp20_ = pressed;
	if (_tmp20_) {
		gint _tmp21_;
		_tmp21_ = self->priv->m_switcher_delay_time;
		_tmp19_ = _tmp21_ >= 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gint _tmp22_ = 0;
		gboolean _tmp23_;
		gint i = 0;
		Switcher* _tmp25_;
		guint _tmp26_;
		guint _tmp27_;
		GdkEvent* _tmp28_;
		IBusEngineDesc** _tmp29_;
		gint _tmp29__length1;
		gint _tmp30_;
		const gchar* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp23_ = revert;
		if (_tmp23_) {
			IBusEngineDesc** _tmp24_;
			gint _tmp24__length1;
			_tmp24_ = self->priv->m_engines;
			_tmp24__length1 = self->priv->m_engines_length1;
			_tmp22_ = _tmp24__length1 - 1;
		} else {
			_tmp22_ = 1;
		}
		i = _tmp22_;
		_tmp25_ = self->priv->m_switcher;
		_tmp26_ = keyval;
		_tmp27_ = modifiers;
		_tmp28_ = event;
		_tmp29_ = self->priv->m_engines;
		_tmp29__length1 = self->priv->m_engines_length1;
		_tmp30_ = i;
		_tmp31_ = self->priv->m_real_current_context_path;
		_tmp32_ = switcher_run (_tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp29__length1, _tmp30_, _tmp31_);
		i = _tmp32_;
		_tmp33_ = i;
		if (_tmp33_ < 0) {
			g_debug ("panel.vala:1014: switch cancelled");
		} else {
			gint _tmp34_;
			_tmp34_ = i;
			if (_tmp34_ == 0) {
				g_debug ("panel.vala:1016: do not have to switch");
			} else {
				panel_switcher_focus_set_engine (self);
			}
		}
	} else {
		gint _tmp35_ = 0;
		gboolean _tmp36_;
		gint i = 0;
		gint _tmp38_;
		_tmp36_ = revert;
		if (_tmp36_) {
			IBusEngineDesc** _tmp37_;
			gint _tmp37__length1;
			_tmp37_ = self->priv->m_engines;
			_tmp37__length1 = self->priv->m_engines_length1;
			_tmp35_ = _tmp37__length1 - 1;
		} else {
			_tmp35_ = 1;
		}
		i = _tmp35_;
		_tmp38_ = i;
		panel_switch_engine (self, _tmp38_, FALSE);
	}
}


static void panel_show_emojier (Panel* self, GdkEvent* event) {
	IBusEmojier* _tmp0_;
	gchar* emoji = NULL;
	IBusEmojier* _tmp1_;
	const gchar* _tmp2_;
	GdkEvent* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = ibus_emojier_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier = _tmp0_;
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = self->priv->m_real_current_context_path;
	_tmp3_ = event;
	_tmp4_ = ibus_emojier_run (_tmp1_, _tmp2_, _tmp3_);
	emoji = _tmp4_;
	_tmp5_ = emoji;
	if (_tmp5_ == NULL) {
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
		_g_free0 (emoji);
		return;
	}
	panel_emojier_focus_commit (self);
	_g_free0 (emoji);
}


static void panel_handle_emoji_typing (Panel* self, GdkEvent* event) {
	gboolean _tmp0_ = FALSE;
	IBusEmojier* _tmp1_;
	GdkEvent* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = self->priv->m_emojier;
	if (_tmp1_ != NULL) {
		IBusEmojier* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->m_emojier;
		_tmp3_ = ibus_emojier_is_running (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IBusEmojier* _tmp4_;
		GdkEvent* _tmp5_;
		_tmp4_ = self->priv->m_emojier;
		_tmp5_ = event;
		ibus_emojier_present_centralize (_tmp4_, _tmp5_);
		return;
	}
	_tmp6_ = event;
	panel_show_emojier (self, _tmp6_);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Panel* self;
		self = _data5_->self;
		_data5_->names = (_vala_array_free (_data5_->names, _data5_->names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _vala_array_add19 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean __lambda45_ (Block5Data* _data5_) {
	Panel* self;
	gboolean result = FALSE;
	IBusBus* _tmp0_;
	gboolean _tmp1_;
	IBusBus* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	self = _data5_->self;
	_tmp0_ = self->priv->m_bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->m_bus;
	_tmp3_ = _data5_->names;
	_tmp3__length1 = _data5_->names_length1;
	ibus_bus_preload_engines_async (_tmp2_, _tmp3_, -1, NULL, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda45__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda45_ (self);
	return result;
}


static void panel_run_preload_engines (Panel* self, IBusEngineDesc** engines, int engines_length1, gint index) {
	Block5Data* _data5_;
	gchar** _tmp0_;
	IBusEngineDesc** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	guint _tmp3_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	IBusEngineDesc* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	guint _tmp11_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data5_->names = _tmp0_;
	_data5_->names_length1 = 0;
	_data5_->_names_size_ = _data5_->names_length1;
	_tmp1_ = engines;
	_tmp1__length1 = engines_length1;
	_tmp2_ = index;
	if (_tmp1__length1 <= _tmp2_) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp3_ = self->priv->m_preload_engines_id;
	if (_tmp3_ != ((guint) 0)) {
		guint _tmp4_;
		_tmp4_ = self->priv->m_preload_engines_id;
		g_source_remove (_tmp4_);
		self->priv->m_preload_engines_id = (guint) 0;
	}
	_tmp5_ = _data5_->names;
	_tmp5__length1 = _data5_->names_length1;
	_tmp6_ = engines;
	_tmp6__length1 = engines_length1;
	_tmp7_ = index;
	_tmp8_ = _tmp6_[_tmp7_];
	_tmp9_ = ibus_engine_desc_get_name (_tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	_vala_array_add19 (&_data5_->names, &_data5_->names_length1, &_data5_->_names_size_, _tmp10_);
	_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, PANEL_PRELOAD_ENGINES_DELAY_TIME, ___lambda45__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	self->priv->m_preload_engines_id = _tmp11_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add20 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add21 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void panel_update_engines (Panel* self, gchar** unowned_engine_names, int unowned_engine_names_length1, gchar** order_names, int order_names_length1) {
	gchar** engine_names = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint engine_names_length1;
	gint _engine_names_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** names = NULL;
	gchar** _tmp7_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	IBusEngineDesc** engines = NULL;
	IBusBus* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	IBusEngineDesc** _tmp24_;
	IBusEngineDesc** _tmp25_;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp26_;
	gint _tmp26__length1;
	IBusEngineDesc** _tmp35_;
	gint _tmp35__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = unowned_engine_names;
	_tmp0__length1 = unowned_engine_names_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup2 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	engine_names = _tmp1_;
	engine_names_length1 = _tmp1__length1;
	_engine_names_size_ = engine_names_length1;
	_tmp3_ = engine_names;
	_tmp3__length1 = engine_names_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = engine_names;
		_tmp4__length1 = engine_names_length1;
		_tmp2_ = _tmp4__length1 == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		gchar** _tmp6_;
		_tmp5_ = g_strdup ("xkb:us::eng");
		_tmp6_ = g_new0 (gchar*, 1 + 1);
		_tmp6_[0] = _tmp5_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp6_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	names = _tmp7_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp8_ = order_names;
	_tmp8__length1 = order_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp8_;
		name_collection_length1 = _tmp8__length1;
		for (name_it = 0; name_it < _tmp8__length1; name_it = name_it + 1) {
			gchar* _tmp9_;
			gchar* name = NULL;
			_tmp9_ = g_strdup (name_collection[name_it]);
			name = _tmp9_;
			{
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				_tmp10_ = name;
				_tmp11_ = engine_names;
				_tmp11__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp11_, _tmp11__length1, _tmp10_)) {
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = names;
					_tmp12__length1 = names_length1;
					_tmp13_ = name;
					_tmp14_ = g_strdup (_tmp13_);
					_vala_array_add20 (&names, &names_length1, &_names_size_, _tmp14_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp15_ = engine_names;
	_tmp15__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp15_;
		name_collection_length1 = _tmp15__length1;
		for (name_it = 0; name_it < _tmp15__length1; name_it = name_it + 1) {
			gchar* _tmp16_;
			gchar* name = NULL;
			_tmp16_ = g_strdup (name_collection[name_it]);
			name = _tmp16_;
			{
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp17_ = name;
				_tmp18_ = names;
				_tmp18__length1 = names_length1;
				if (_vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_)) {
					_g_free0 (name);
					continue;
				}
				_tmp19_ = names;
				_tmp19__length1 = names_length1;
				_tmp20_ = name;
				_tmp21_ = g_strdup (_tmp20_);
				_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp21_);
				_g_free0 (name);
			}
		}
	}
	_tmp22_ = self->priv->m_bus;
	_tmp23_ = names;
	_tmp23__length1 = names_length1;
	_tmp25_ = _tmp24_ = ibus_bus_get_engines_by_names (_tmp22_, _tmp23_);
	engines = _tmp25_;
	engines_length1 = _vala_array_length (_tmp24_);
	_engines_size_ = engines_length1;
	_tmp26_ = engines;
	_tmp26__length1 = engines_length1;
	if (_tmp26__length1 == 0) {
		gchar* _tmp27_;
		gchar** _tmp28_;
		GSettings* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		IBusBus* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		IBusEngineDesc** _tmp33_;
		IBusEngineDesc** _tmp34_;
		_tmp27_ = g_strdup ("xkb:us::eng");
		_tmp28_ = g_new0 (gchar*, 1 + 1);
		_tmp28_[0] = _tmp27_;
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		names = _tmp28_;
		names_length1 = 1;
		_names_size_ = names_length1;
		_tmp29_ = self->priv->m_settings_general;
		_tmp30_ = names;
		_tmp30__length1 = names_length1;
		g_settings_set_strv (_tmp29_, "preload-engines", _tmp30_);
		_tmp31_ = self->priv->m_bus;
		_tmp32_ = names;
		_tmp32__length1 = names_length1;
		_tmp34_ = _tmp33_ = ibus_bus_get_engines_by_names (_tmp31_, _tmp32_);
		engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
		engines = _tmp34_;
		engines_length1 = _vala_array_length (_tmp33_);
		_engines_size_ = engines_length1;
	}
	_tmp35_ = self->priv->m_engines;
	_tmp35__length1 = self->priv->m_engines_length1;
	if (_tmp35__length1 == 0) {
		IBusEngineDesc** _tmp36_;
		gint _tmp36__length1;
		IBusEngineDesc** _tmp37_;
		gint _tmp37__length1;
		IBusEngineDesc** _tmp38_;
		gint _tmp38__length1;
		_tmp36_ = engines;
		_tmp36__length1 = engines_length1;
		_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup3 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
		_tmp37__length1 = _tmp36__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp37_;
		self->priv->m_engines_length1 = _tmp37__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
		_tmp38_ = engines;
		_tmp38__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp38_, _tmp38__length1, 1);
	} else {
		IBusEngineDesc* current_engine = NULL;
		IBusEngineDesc** _tmp39_;
		gint _tmp39__length1;
		IBusEngineDesc* _tmp40_;
		IBusEngineDesc* _tmp41_;
		IBusEngineDesc** _tmp42_;
		gint _tmp42__length1;
		IBusEngineDesc** _tmp43_;
		gint _tmp43__length1;
		gint i = 0;
		IBusEngineDesc** _tmp58_;
		gint _tmp58__length1;
		_tmp39_ = self->priv->m_engines;
		_tmp39__length1 = self->priv->m_engines_length1;
		_tmp40_ = _tmp39_[0];
		_tmp41_ = _g_object_ref0 (_tmp40_);
		current_engine = _tmp41_;
		_tmp42_ = engines;
		_tmp42__length1 = engines_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup4 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp43_;
		self->priv->m_engines_length1 = _tmp43__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp44_ = FALSE;
			i = 0;
			_tmp44_ = TRUE;
			while (TRUE) {
				gint _tmp46_;
				IBusEngineDesc** _tmp47_;
				gint _tmp47__length1;
				IBusEngineDesc* _tmp48_;
				const gchar* _tmp49_;
				IBusEngineDesc** _tmp50_;
				gint _tmp50__length1;
				gint _tmp51_;
				IBusEngineDesc* _tmp52_;
				const gchar* _tmp53_;
				if (!_tmp44_) {
					gint _tmp45_;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp46_ = i;
				_tmp47_ = self->priv->m_engines;
				_tmp47__length1 = self->priv->m_engines_length1;
				if (!(_tmp46_ < _tmp47__length1)) {
					break;
				}
				_tmp48_ = current_engine;
				_tmp49_ = ibus_engine_desc_get_name (_tmp48_);
				_tmp50_ = engines;
				_tmp50__length1 = engines_length1;
				_tmp51_ = i;
				_tmp52_ = _tmp50_[_tmp51_];
				_tmp53_ = ibus_engine_desc_get_name (_tmp52_);
				if (g_strcmp0 (_tmp49_, _tmp53_) == 0) {
					gint _tmp54_;
					gint _tmp55_;
					_tmp54_ = i;
					panel_switch_engine (self, _tmp54_, FALSE);
					_tmp55_ = i;
					if (_tmp55_ != 0) {
						IBusEngineDesc** _tmp56_;
						gint _tmp56__length1;
						_tmp56_ = engines;
						_tmp56__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp56_, _tmp56__length1, 0);
					} else {
						IBusEngineDesc** _tmp57_;
						gint _tmp57__length1;
						_tmp57_ = engines;
						_tmp57__length1 = engines_length1;
						panel_run_preload_engines (self, _tmp57_, _tmp57__length1, 1);
					}
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_tmp58_ = engines;
		_tmp58__length1 = engines_length1;
		panel_run_preload_engines (self, _tmp58_, _tmp58__length1, 1);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void panel_context_render_string (Panel* self, cairo_t* cr, const gchar* symbol, gint image_width, gint image_height) {
	gint lwidth = 0;
	gint lheight = 0;
	PangoFontDescription* desc = NULL;
	PangoFontDescription* _tmp0_;
	PangoLayout* layout = NULL;
	cairo_t* _tmp1_;
	PangoLayout* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	PangoLayout* _tmp7_;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	const gchar* _tmp10_;
	PangoLayout* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	cairo_t* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	cairo_t* _tmp19_;
	GdkRGBA _tmp20_;
	gdouble _tmp21_;
	GdkRGBA _tmp22_;
	gdouble _tmp23_;
	GdkRGBA _tmp24_;
	gdouble _tmp25_;
	GdkRGBA _tmp26_;
	gdouble _tmp27_;
	cairo_t* _tmp28_;
	PangoLayout* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (symbol != NULL);
	lwidth = 0;
	lheight = 0;
	_tmp0_ = pango_font_description_from_string ("Monospace Bold 22");
	desc = _tmp0_;
	_tmp1_ = cr;
	_tmp2_ = pango_cairo_create_layout (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = symbol;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ >= 3) {
		PangoFontDescription* _tmp6_;
		_tmp6_ = pango_font_description_from_string ("Monospace Bold 18");
		__vala_PangoFontDescription_free0 (desc);
		desc = _tmp6_;
	}
	_tmp7_ = layout;
	_tmp8_ = desc;
	pango_layout_set_font_description (_tmp7_, _tmp8_);
	_tmp9_ = layout;
	_tmp10_ = symbol;
	pango_layout_set_text (_tmp9_, _tmp10_, -1);
	_tmp11_ = layout;
	pango_layout_get_size (_tmp11_, &_tmp12_, &_tmp13_);
	lwidth = _tmp12_;
	lheight = _tmp13_;
	_tmp14_ = cr;
	_tmp15_ = image_width;
	_tmp16_ = lwidth;
	_tmp17_ = image_height;
	_tmp18_ = lheight;
	cairo_move_to (_tmp14_, (gdouble) ((_tmp15_ - (_tmp16_ / PANGO_SCALE)) / 2), (gdouble) ((_tmp17_ - (_tmp18_ / PANGO_SCALE)) / 2));
	_tmp19_ = cr;
	_tmp20_ = self->priv->m_xkb_icon_rgba;
	_tmp21_ = _tmp20_.red;
	_tmp22_ = self->priv->m_xkb_icon_rgba;
	_tmp23_ = _tmp22_.green;
	_tmp24_ = self->priv->m_xkb_icon_rgba;
	_tmp25_ = _tmp24_.blue;
	_tmp26_ = self->priv->m_xkb_icon_rgba;
	_tmp27_ = _tmp26_.alpha;
	cairo_set_source_rgba (_tmp19_, _tmp21_, _tmp23_, _tmp25_, _tmp27_);
	_tmp28_ = cr;
	_tmp29_ = layout;
	pango_cairo_show_layout (_tmp28_, _tmp29_);
	_g_object_unref0 (layout);
	__vala_PangoFontDescription_free0 (desc);
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static cairo_surface_t* panel_create_cairo_image_surface_with_string (Panel* self, const gchar* symbol, gboolean cache) {
	cairo_surface_t* result = NULL;
	cairo_surface_t* image = NULL;
	gboolean _tmp0_;
	cairo_surface_t* _tmp6_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp7_;
	cairo_t* _tmp8_;
	gint width = 0;
	cairo_surface_t* _tmp9_;
	gint _tmp10_;
	gint height = 0;
	cairo_surface_t* _tmp11_;
	gint _tmp12_;
	gint stride = 0;
	cairo_surface_t* _tmp13_;
	gint _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	cairo_surface_t* _tmp23_;
	PanelIconType _tmp24_;
	gboolean _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	image = NULL;
	_tmp0_ = cache;
	if (_tmp0_) {
		GHashTable* _tmp1_;
		const gchar* _tmp2_;
		gconstpointer _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp1_ = self->priv->m_xkb_icon_image;
		_tmp2_ = symbol;
		_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
		_tmp4_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp3_);
		_cairo_surface_destroy0 (image);
		image = _tmp4_;
		_tmp5_ = image;
		if (_tmp5_ != NULL) {
			result = image;
			return result;
		}
	}
	_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 48, 48);
	_cairo_surface_destroy0 (image);
	image = _tmp6_;
	_tmp7_ = image;
	_tmp8_ = cairo_create (_tmp7_);
	cr = _tmp8_;
	_tmp9_ = image;
	_tmp10_ = cairo_image_surface_get_width (_tmp9_);
	width = _tmp10_;
	_tmp11_ = image;
	_tmp12_ = cairo_image_surface_get_height (_tmp11_);
	height = _tmp12_;
	_tmp13_ = image;
	_tmp14_ = cairo_image_surface_get_stride (_tmp13_);
	stride = _tmp14_;
	_tmp15_ = cr;
	cairo_set_source_rgba (_tmp15_, 0.0, 0.0, 0.0, 0.0);
	_tmp16_ = cr;
	cairo_set_operator (_tmp16_, CAIRO_OPERATOR_SOURCE);
	_tmp17_ = cr;
	cairo_paint (_tmp17_);
	_tmp18_ = cr;
	cairo_set_operator (_tmp18_, CAIRO_OPERATOR_OVER);
	_tmp19_ = cr;
	_tmp20_ = symbol;
	_tmp21_ = width;
	_tmp22_ = height;
	panel_context_render_string (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
	_tmp23_ = image;
	cairo_surface_flush (_tmp23_);
	_tmp24_ = self->priv->m_icon_type;
	if (_tmp24_ == PANEL_ICON_TYPE_INDICATOR) {
		if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
			guint* data = NULL;
			cairo_surface_t* _tmp25_;
			guchar* _tmp26_;
			gint data_length1;
			gint _data_size_;
			gint length = 0;
			gint _tmp27_;
			gint _tmp28_;
			_tmp25_ = image;
			_tmp26_ = cairo_image_surface_get_data (_tmp25_);
			data = (guint*) _tmp26_;
			data_length1 = (-1 * sizeof (guchar)) / sizeof (guint);
			_data_size_ = data_length1;
			_tmp27_ = stride;
			_tmp28_ = height;
			length = (_tmp27_ * _tmp28_) / ((gint) sizeof (guint));
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp29_ = FALSE;
					_tmp29_ = TRUE;
					while (TRUE) {
						gint _tmp31_;
						gint _tmp32_;
						guint* _tmp33_;
						gint _tmp33__length1;
						gint _tmp34_;
						guint* _tmp35_;
						gint _tmp35__length1;
						gint _tmp36_;
						guint _tmp37_;
						guint _tmp38_;
						guint _tmp39_;
						if (!_tmp29_) {
							gint _tmp30_;
							_tmp30_ = i;
							i = _tmp30_ + 1;
						}
						_tmp29_ = FALSE;
						_tmp31_ = i;
						_tmp32_ = length;
						if (!(_tmp31_ < _tmp32_)) {
							break;
						}
						_tmp33_ = data;
						_tmp33__length1 = data_length1;
						_tmp34_ = i;
						_tmp35_ = data;
						_tmp35__length1 = data_length1;
						_tmp36_ = i;
						_tmp37_ = _tmp35_[_tmp36_];
						_tmp38_ = GUINT_TO_BE (_tmp37_);
						_tmp33_[_tmp34_] = _tmp38_;
						_tmp39_ = _tmp33_[_tmp34_];
					}
				}
			}
		}
	}
	_tmp40_ = cache;
	if (_tmp40_) {
		GHashTable* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		cairo_surface_t* _tmp44_;
		cairo_surface_t* _tmp45_;
		_tmp41_ = self->priv->m_xkb_icon_image;
		_tmp42_ = symbol;
		_tmp43_ = g_strdup (_tmp42_);
		_tmp44_ = image;
		_tmp45_ = _cairo_surface_reference0 (_tmp44_);
		g_hash_table_insert (_tmp41_, _tmp43_, _tmp45_);
	}
	result = image;
	_cairo_destroy0 (cr);
	return result;
}


static GdkPixbuf* panel_create_icon_pixbuf_with_string (Panel* self, const gchar* symbol) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_surface_t* image = NULL;
	const gchar* _tmp5_;
	cairo_surface_t* _tmp6_;
	gint width = 0;
	cairo_surface_t* _tmp7_;
	gint _tmp8_;
	gint height = 0;
	cairo_surface_t* _tmp9_;
	gint _tmp10_;
	cairo_surface_t* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkPixbuf* _tmp14_;
	GHashTable* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->m_xkb_icon_pixbufs;
	_tmp1_ = symbol;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((GdkPixbuf*) _tmp2_);
	pixbuf = _tmp3_;
	_tmp4_ = pixbuf;
	if (_tmp4_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp5_ = symbol;
	_tmp6_ = panel_create_cairo_image_surface_with_string (self, _tmp5_, FALSE);
	image = _tmp6_;
	_tmp7_ = image;
	_tmp8_ = cairo_image_surface_get_width (_tmp7_);
	width = _tmp8_;
	_tmp9_ = image;
	_tmp10_ = cairo_image_surface_get_height (_tmp9_);
	height = _tmp10_;
	_tmp11_ = image;
	_tmp12_ = width;
	_tmp13_ = height;
	_tmp14_ = gdk_pixbuf_get_from_surface (_tmp11_, 0, 0, _tmp12_, _tmp13_);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp14_;
	_tmp15_ = self->priv->m_xkb_icon_pixbufs;
	_tmp16_ = symbol;
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = pixbuf;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	g_hash_table_insert (_tmp15_, _tmp17_, _tmp19_);
	result = pixbuf;
	_cairo_surface_destroy0 (image);
	return result;
}


static void __lambda79_ (Panel* self, GPid pid, gint state) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	_tmp0_ = pid;
	_tmp1_ = self->priv->m_setup_pid;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
}


static void ___lambda79__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda79_ ((Panel*) self, pid, status);
}


static void panel_show_setup_dialog (Panel* self) {
	GPid _tmp0_;
	gchar* binary = NULL;
	gchar* _tmp3_;
	GPid _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->m_setup_pid;
		_tmp2_ = kill ((pid_t) _tmp1_, SIGUSR1);
		if (_tmp2_ == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp3_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GPid _tmp9_ = 0;
		_tmp4_ = binary;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_strdup ("ibus-setup");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp9_, &_inner_error_);
		self->priv->m_setup_pid = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch14_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally14;
	__catch14_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = binary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("panel.vala:1219: Execute %s failed! %s", _tmp10_, _tmp12_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, ___lambda79__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void panel_show_about_dialog (Panel* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp21_;
	gboolean _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		gchar* copyright = NULL;
		gchar* _tmp4_;
		GtkAboutDialog* _tmp5_;
		const gchar* _tmp6_;
		GtkAboutDialog* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		GtkAboutDialog* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		GtkAboutDialog* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		GtkAboutDialog* _tmp18_;
		GtkAboutDialog* _tmp19_;
		GtkAboutDialog* _tmp20_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = g_strdup ("Copyright © 2007-2015 Peng Huang\n" "Copyright © 2015 Takao Fujiwara\n" "Copyright © 2007-2015 Red Hat, Inc.\n");
		copyright = _tmp4_;
		_tmp5_ = self->priv->m_about_dialog;
		_tmp6_ = copyright;
		gtk_about_dialog_set_copyright (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp7_, "LGPL");
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_comments (_tmp8_, _ ("IBus is an intelligent input bus for Linux/Unix."));
		_tmp9_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp9_, "https://github.com/ibus/ibus/wiki");
		_tmp10_ = self->priv->m_about_dialog;
		_tmp11_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp12_ = g_new0 (gchar*, 1 + 1);
		_tmp12_[0] = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		gtk_about_dialog_set_authors (_tmp10_, _tmp13_);
		_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->priv->m_about_dialog;
		_tmp15_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp16_ = g_new0 (gchar*, 1 + 1);
		_tmp16_[0] = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp17__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp14_, _tmp17_);
		_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_translator_credits (_tmp18_, _ ("translator-credits"));
		_tmp19_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp19_, "ibus");
		_tmp20_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp20_, "ibus");
		_g_free0 (copyright);
	}
	_tmp21_ = self->priv->m_about_dialog;
	_tmp22_ = gtk_widget_get_visible ((GtkWidget*) _tmp21_);
	if (!_tmp22_) {
		GtkAboutDialog* _tmp23_;
		GtkAboutDialog* _tmp24_;
		_tmp23_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp23_);
		_tmp24_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp24_);
	} else {
		GtkAboutDialog* _tmp25_;
		_tmp25_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp25_);
	}
}


static void ___lambda78_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void ____lambda78__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda78_ ((Panel*) self, _sender);
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static void ___lambda80_ (Panel* self, GtkMenuItem* i) {
	GdkEvent* event = NULL;
	GdkEvent* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = gdk_event_new (GDK_KEY_PRESS);
	event = _tmp0_;
	panel_handle_emoji_typing (self, event);
	__vala_GdkEvent_free0 (event);
}


static void ____lambda80__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda80_ ((Panel*) self, _sender);
}


static void ___lambda81_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void ____lambda81__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda81_ ((Panel*) self, _sender);
}


static void ___lambda82_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void ____lambda82__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda82_ ((Panel*) self, _sender);
}


static void ___lambda83_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void ____lambda83__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda83_ ((Panel*) self, _sender);
}


static GtkMenu* panel_create_context_menu (Panel* self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp26_;
	GtkMenu* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkMenuItem* item = NULL;
		GtkMenu* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenuItem* _tmp6_;
		GtkMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenuItem* _tmp10_;
		GtkMenuItem* _tmp11_;
		GtkMenu* _tmp12_;
		GtkMenuItem* _tmp13_;
		GtkMenu* _tmp14_;
		GtkSeparatorMenuItem* _tmp15_;
		GtkSeparatorMenuItem* _tmp16_;
		GtkMenuItem* _tmp17_;
		GtkMenuItem* _tmp18_;
		GtkMenu* _tmp19_;
		GtkMenuItem* _tmp20_;
		GtkMenuItem* _tmp21_;
		GtkMenuItem* _tmp22_;
		GtkMenu* _tmp23_;
		GtkMenuItem* _tmp24_;
		GtkMenu* _tmp25_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Preferences"));
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object (_tmp3_, "activate", (GCallback) ____lambda78__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Emoji Choice"));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object (_tmp7_, "activate", (GCallback) ____lambda80__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("About"));
		g_object_ref_sink (_tmp10_);
		_g_object_unref0 (item);
		item = _tmp10_;
		_tmp11_ = item;
		g_signal_connect_object (_tmp11_, "activate", (GCallback) ____lambda81__gtk_menu_item_activate, self, 0);
		_tmp12_ = self->priv->m_sys_menu;
		_tmp13_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->m_sys_menu;
		_tmp15_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp14_, (GtkWidget*) ((GtkMenuItem*) _tmp16_));
		_g_object_unref0 (_tmp16_);
		_tmp17_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Restart"));
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (item);
		item = _tmp17_;
		_tmp18_ = item;
		g_signal_connect_object (_tmp18_, "activate", (GCallback) ____lambda82__gtk_menu_item_activate, self, 0);
		_tmp19_ = self->priv->m_sys_menu;
		_tmp20_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp19_, (GtkWidget*) _tmp20_);
		_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Quit"));
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (item);
		item = _tmp21_;
		_tmp22_ = item;
		g_signal_connect_object (_tmp22_, "activate", (GCallback) ____lambda83__gtk_menu_item_activate, self, 0);
		_tmp23_ = self->priv->m_sys_menu;
		_tmp24_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp25_);
		_g_object_unref0 (item);
	}
	_tmp26_ = self->priv->m_sys_menu;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	result = _tmp27_;
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Panel* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->e);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void ____lambda85_ (Block6Data* _data6_, GtkMenuItem* item) {
	Panel* self;
	self = _data6_->self;
	g_return_if_fail (item != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				IBusEngineDesc** _tmp3_;
				gint _tmp3__length1;
				IBusEngineDesc* _tmp4_;
				IBusEngineDesc** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				IBusEngineDesc* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->m_engines;
				_tmp3__length1 = self->priv->m_engines_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = _data6_->e;
				_tmp5_ = self->priv->m_engines;
				_tmp5__length1 = self->priv->m_engines_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				if (_tmp4_ == _tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					panel_switch_engine (self, _tmp8_, FALSE);
					break;
				}
			}
		}
	}
}


static void _____lambda85__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda85_ (self, _sender);
}


static GtkMenu* panel_create_activate_menu (Panel* self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_;
	PropertyManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	GtkMenu* _tmp26_;
	GtkMenu* _tmp27_;
	GtkMenu* _tmp28_;
	GtkMenu* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->m_engines;
	_tmp6__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp6_;
		engine_collection_length1 = _tmp6__length1;
		for (engine_it = 0; engine_it < _tmp6__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp7_;
			IBusEngineDesc* engine = NULL;
			_tmp7_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp7_;
			{
				Block6Data* _data6_;
				gchar* language = NULL;
				IBusEngineDesc* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				GtkMenuItem* item = NULL;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GtkMenuItem* _tmp19_;
				GtkMenuItem* _tmp20_;
				IBusEngineDesc* _tmp21_;
				IBusEngineDesc* _tmp22_;
				GtkMenuItem* _tmp23_;
				GtkMenu* _tmp24_;
				GtkMenuItem* _tmp25_;
				_data6_ = g_slice_new0 (Block6Data);
				_data6_->_ref_count_ = 1;
				_data6_->self = g_object_ref (self);
				_tmp8_ = engine;
				_tmp9_ = ibus_engine_desc_get_language (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				language = _tmp10_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_longname (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				longname = _tmp13_;
				_tmp14_ = language;
				_tmp15_ = ibus_get_language_name (_tmp14_);
				_tmp16_ = longname;
				_tmp17_ = g_strdup_printf ("%s - %s", _tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp18_);
				g_object_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				item = _tmp20_;
				_tmp21_ = engine;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_data6_->e = _tmp22_;
				_tmp23_ = item;
				g_signal_connect_data (_tmp23_, "activate", (GCallback) _____lambda85__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
				_tmp24_ = self->priv->m_ime_menu;
				_tmp25_ = item;
				gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
				_g_object_unref0 (item);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block6_data_unref (_data6_);
				_data6_ = NULL;
			}
		}
	}
	_tmp26_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp27_, FALSE);
	_tmp28_ = self->priv->m_ime_menu;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	result = _tmp29_;
	return result;
}


static void panel_set_properties (Panel* self, IBusPropList* props) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusPropList* _tmp0_;
		gint _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		IBusProperty* _tmp4_;
		IBusPropList* _tmp5_;
		gint _tmp6_;
		IBusProperty* _tmp7_;
		gint _tmp8_;
		_tmp0_ = props;
		_tmp1_ = i;
		_tmp2_ = ibus_prop_list_get (_tmp0_, (guint) _tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		prop = _tmp3_;
		_tmp4_ = prop;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp5_ = props;
		_tmp6_ = i;
		_tmp7_ = ibus_prop_list_get (_tmp5_, (guint) _tmp6_);
		panel_set_property (self, _tmp7_, TRUE);
		_tmp8_ = i;
		i = _tmp8_ + 1;
		_g_object_unref0 (prop);
	}
}


static void panel_set_property (Panel* self, IBusProperty* prop, gboolean all_update) {
	gchar* symbol = NULL;
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	symbol = _tmp3_;
	_tmp6_ = self->priv->m_icon_prop_key;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		IBusProperty* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = prop;
		_tmp8_ = ibus_property_get_key (_tmp7_);
		_tmp9_ = self->priv->m_icon_prop_key;
		_tmp5_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp10_;
		_tmp10_ = symbol;
		_tmp4_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = symbol;
		_tmp12_ = all_update;
		panel_animate_icon (self, _tmp11_, _tmp12_);
	}
	_g_free0 (symbol);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		Panel* self;
		self = _data7_->self;
		_g_free0 (_data7_->symbol);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean __lambda96_ (Block7Data* _data7_) {
	Panel* self;
	gboolean result = FALSE;
	PanelIconType _tmp0_;
	self = _data7_->self;
	self->priv->m_property_icon_delay_time_id = (guint) 0;
	_tmp0_ = self->priv->m_icon_type;
	if (_tmp0_ == PANEL_ICON_TYPE_STATUS_ICON) {
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp1_;
		GdkPixbuf* _tmp2_;
		GtkStatusIcon* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp1_ = _data7_->symbol;
		_tmp2_ = panel_create_icon_pixbuf_with_string (self, _tmp1_);
		pixbuf = _tmp2_;
		_tmp3_ = self->priv->m_status_icon;
		_tmp4_ = pixbuf;
		gtk_status_icon_set_from_pixbuf (_tmp3_, _tmp4_);
		_g_object_unref0 (pixbuf);
	} else {
		PanelIconType _tmp5_;
		_tmp5_ = self->priv->m_icon_type;
		if (_tmp5_ == PANEL_ICON_TYPE_INDICATOR) {
			cairo_surface_t* image = NULL;
			const gchar* _tmp6_;
			cairo_surface_t* _tmp7_;
			Indicator* _tmp8_;
			cairo_surface_t* _tmp9_;
			_tmp6_ = _data7_->symbol;
			_tmp7_ = panel_create_cairo_image_surface_with_string (self, _tmp6_, TRUE);
			image = _tmp7_;
			_tmp8_ = self->priv->m_indicator;
			_tmp9_ = image;
			indicator_set_cairo_image_surface_full (_tmp8_, _tmp9_, "");
			_cairo_surface_destroy0 (image);
		}
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda96__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda96_ (self);
	return result;
}


static void panel_animate_icon (Panel* self, const gchar* symbol, gboolean all_update) {
	Block7Data* _data7_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	guint timeout = 0U;
	gboolean _tmp3_;
	guint _tmp5_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data7_->symbol);
	_data7_->symbol = _tmp1_;
	_tmp2_ = self->priv->m_property_icon_delay_time;
	if (_tmp2_ < 0) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	timeout = (guint) 0;
	_tmp3_ = all_update;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = self->priv->m_property_icon_delay_time;
		timeout = (guint) _tmp4_;
	}
	_tmp5_ = self->priv->m_property_icon_delay_time_id;
	if (_tmp5_ > ((guint) 0)) {
		guint _tmp6_;
		_tmp6_ = self->priv->m_property_icon_delay_time_id;
		g_source_remove (_tmp6_);
		self->priv->m_property_icon_delay_time_id = (guint) 0;
	}
	_tmp7_ = timeout;
	_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp7_, ___lambda96__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	self->priv->m_property_icon_delay_time_id = _tmp8_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height) {
	Panel * self;
	CandidatePanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	PropertyPanel* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = width;
	_tmp4_ = height;
	candidate_panel_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_property_panel;
	_tmp6_ = x;
	_tmp7_ = y;
	_tmp8_ = width;
	_tmp9_ = height;
	property_panel_set_cursor_location (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_);
}


static gboolean panel_switcher_focus_set_engine_real (Panel* self) {
	gboolean result = FALSE;
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = prev_context_path;
		_tmp9_ = self->priv->m_current_context_path;
		_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		IBusEngineDesc* _tmp10_;
		Switcher* _tmp11_;
		_tmp10_ = selected_engine;
		panel_set_engine (self, _tmp10_);
		_tmp11_ = self->priv->m_switcher;
		switcher_reset (_tmp11_);
		result = TRUE;
		_g_free0 (prev_context_path);
		_g_object_unref0 (selected_engine);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
	return result;
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean ___lambda53_ (Panel* self) {
	gboolean result = FALSE;
	panel_switcher_focus_set_engine_real (self);
	self->priv->m_switcher_focus_set_engine_id = (guint) -1;
	result = FALSE;
	return result;
}


static gboolean ____lambda53__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda53_ ((Panel*) self);
	return result;
}


static void panel_switcher_focus_set_engine (Panel* self) {
	IBusEngineDesc* selected_engine = NULL;
	Switcher* _tmp0_;
	IBusEngineDesc* _tmp1_;
	gchar* prev_context_path = NULL;
	Switcher* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_get_selected_engine (_tmp0_);
	selected_engine = _tmp1_;
	_tmp2_ = self->priv->m_switcher;
	_tmp3_ = switcher_get_input_context_path (_tmp2_);
	prev_context_path = _tmp3_;
	_tmp6_ = selected_engine;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_;
		_tmp7_ = prev_context_path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Switcher* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = self->priv->m_switcher;
		_tmp9_ = switcher_is_running (_tmp8_);
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GMainContext* context = NULL;
		GMainContext* _tmp10_;
		GMainContext* _tmp11_;
		gboolean _tmp12_ = FALSE;
		guint _tmp13_;
		guint _tmp18_;
		_tmp10_ = g_main_context_default ();
		_tmp11_ = _g_main_context_ref0 (_tmp10_);
		context = _tmp11_;
		_tmp13_ = self->priv->m_switcher_focus_set_engine_id;
		if (_tmp13_ > ((guint) 0)) {
			GMainContext* _tmp14_;
			guint _tmp15_;
			GSource* _tmp16_;
			_tmp14_ = context;
			_tmp15_ = self->priv->m_switcher_focus_set_engine_id;
			_tmp16_ = g_main_context_find_source_by_id (_tmp14_, _tmp15_);
			_tmp12_ = _tmp16_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			guint _tmp17_;
			_tmp17_ = self->priv->m_switcher_focus_set_engine_id;
			g_source_remove (_tmp17_);
		}
		_tmp18_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda53__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->m_switcher_focus_set_engine_id = _tmp18_;
		_g_main_context_unref0 (context);
	} else {
		gboolean _tmp19_;
		_tmp19_ = panel_switcher_focus_set_engine_real (self);
		if (_tmp19_) {
			GMainContext* context = NULL;
			GMainContext* _tmp20_;
			GMainContext* _tmp21_;
			gboolean _tmp22_ = FALSE;
			guint _tmp23_;
			_tmp20_ = g_main_context_default ();
			_tmp21_ = _g_main_context_ref0 (_tmp20_);
			context = _tmp21_;
			_tmp23_ = self->priv->m_switcher_focus_set_engine_id;
			if (_tmp23_ > ((guint) 0)) {
				GMainContext* _tmp24_;
				guint _tmp25_;
				GSource* _tmp26_;
				_tmp24_ = context;
				_tmp25_ = self->priv->m_switcher_focus_set_engine_id;
				_tmp26_ = g_main_context_find_source_by_id (_tmp24_, _tmp25_);
				_tmp22_ = _tmp26_ != NULL;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				guint _tmp27_;
				_tmp27_ = self->priv->m_switcher_focus_set_engine_id;
				g_source_remove (_tmp27_);
			}
			self->priv->m_switcher_focus_set_engine_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_object_unref0 (selected_engine);
}


static void _vala_array_add22 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean panel_emojier_focus_commit_real (Panel* self) {
	gboolean result = FALSE;
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp7_ = selected_string;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = prev_context_path;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = prev_context_path;
		_tmp10_ = self->priv->m_current_context_path;
		_tmp5_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		IBusText* text = NULL;
		const gchar* _tmp11_;
		IBusText* _tmp12_;
		IBusText* _tmp13_;
		gboolean has_favorite = FALSE;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gboolean _tmp17_;
		_tmp11_ = selected_string;
		_tmp12_ = ibus_text_new_from_string (_tmp11_);
		g_object_ref_sink (_tmp12_);
		text = _tmp12_;
		_tmp13_ = text;
		ibus_panel_service_commit_text ((IBusPanelService*) self, _tmp13_);
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
		has_favorite = FALSE;
		_tmp14_ = self->priv->m_emojier_favorites;
		_tmp14__length1 = self->priv->m_emojier_favorites_length1;
		{
			gchar** favorite_collection = NULL;
			gint favorite_collection_length1 = 0;
			gint _favorite_collection_size_ = 0;
			gint favorite_it = 0;
			favorite_collection = _tmp14_;
			favorite_collection_length1 = _tmp14__length1;
			for (favorite_it = 0; favorite_it < _tmp14__length1; favorite_it = favorite_it + 1) {
				const gchar* favorite = NULL;
				favorite = favorite_collection[favorite_it];
				{
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = favorite;
					_tmp16_ = selected_string;
					if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
						has_favorite = TRUE;
						break;
					}
				}
			}
		}
		_tmp17_ = has_favorite;
		if (!_tmp17_) {
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			GSettings* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			_tmp18_ = self->priv->m_emojier_favorites;
			_tmp18__length1 = self->priv->m_emojier_favorites_length1;
			_tmp19_ = selected_string;
			_tmp20_ = g_strdup (_tmp19_);
			_vala_array_add22 (&self->priv->m_emojier_favorites, &self->priv->m_emojier_favorites_length1, &self->priv->_m_emojier_favorites_size_, _tmp20_);
			_tmp21_ = self->priv->m_settings_emoji;
			_tmp22_ = self->priv->m_emojier_favorites;
			_tmp22__length1 = self->priv->m_emojier_favorites_length1;
			g_settings_set_strv (_tmp21_, "favorites", _tmp22_);
		}
		result = TRUE;
		_g_object_unref0 (text);
		_g_free0 (prev_context_path);
		_g_free0 (selected_string);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
	return result;
}


static gboolean ___lambda55_ (Panel* self) {
	gboolean result = FALSE;
	panel_emojier_focus_commit_real (self);
	self->priv->m_emojier_focus_commit_text_id = (guint) -1;
	result = FALSE;
	return result;
}


static gboolean ____lambda55__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda55_ ((Panel*) self);
	return result;
}


static void panel_emojier_focus_commit (Panel* self) {
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp7_ = selected_string;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = prev_context_path;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		IBusEmojier* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = self->priv->m_emojier;
		_tmp10_ = ibus_emojier_is_running (_tmp9_);
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GMainContext* context = NULL;
		GMainContext* _tmp11_;
		GMainContext* _tmp12_;
		gboolean _tmp13_ = FALSE;
		guint _tmp14_;
		guint _tmp19_;
		_tmp11_ = g_main_context_default ();
		_tmp12_ = _g_main_context_ref0 (_tmp11_);
		context = _tmp12_;
		_tmp14_ = self->priv->m_emojier_focus_commit_text_id;
		if (_tmp14_ > ((guint) 0)) {
			GMainContext* _tmp15_;
			guint _tmp16_;
			GSource* _tmp17_;
			_tmp15_ = context;
			_tmp16_ = self->priv->m_emojier_focus_commit_text_id;
			_tmp17_ = g_main_context_find_source_by_id (_tmp15_, _tmp16_);
			_tmp13_ = _tmp17_ != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			guint _tmp18_;
			_tmp18_ = self->priv->m_emojier_focus_commit_text_id;
			g_source_remove (_tmp18_);
		}
		_tmp19_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda55__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->m_emojier_focus_commit_text_id = _tmp19_;
		_g_main_context_unref0 (context);
	} else {
		gboolean _tmp20_;
		_tmp20_ = panel_emojier_focus_commit_real (self);
		if (_tmp20_) {
			GMainContext* context = NULL;
			GMainContext* _tmp21_;
			GMainContext* _tmp22_;
			gboolean _tmp23_ = FALSE;
			guint _tmp24_;
			_tmp21_ = g_main_context_default ();
			_tmp22_ = _g_main_context_ref0 (_tmp21_);
			context = _tmp22_;
			_tmp24_ = self->priv->m_emojier_focus_commit_text_id;
			if (_tmp24_ > ((guint) 0)) {
				GMainContext* _tmp25_;
				guint _tmp26_;
				GSource* _tmp27_;
				_tmp25_ = context;
				_tmp26_ = self->priv->m_emojier_focus_commit_text_id;
				_tmp27_ = g_main_context_find_source_by_id (_tmp25_, _tmp26_);
				_tmp23_ = _tmp27_ != NULL;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				guint _tmp28_;
				_tmp28_ = self->priv->m_emojier_focus_commit_text_id;
				g_source_remove (_tmp28_);
			}
			self->priv->m_emojier_focus_commit_text_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
}


static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp7_;
	IBusEngineDesc* engine = NULL;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gconstpointer _tmp10_;
	IBusEngineDesc* _tmp11_;
	IBusEngineDesc* _tmp12_;
	IBusEngineDesc* _tmp26_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = input_context_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp1_;
	_tmp2_ = input_context_path;
	_tmp3_ = g_str_has_suffix (_tmp2_, "InputContext_1");
	if (!_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		PropertyPanel* _tmp6_;
		_tmp4_ = self->priv->m_current_context_path;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->m_real_current_context_path);
		self->priv->m_real_current_context_path = _tmp5_;
		_tmp6_ = self->priv->m_property_panel;
		property_panel_focus_in (_tmp6_);
		panel_switcher_focus_set_engine (self);
		panel_emojier_focus_commit (self);
	}
	_tmp7_ = self->priv->m_use_global_engine;
	if (_tmp7_) {
		return;
	}
	_tmp8_ = self->priv->m_engine_contexts;
	_tmp9_ = input_context_path;
	_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 ((IBusEngineDesc*) _tmp10_);
	engine = _tmp11_;
	_tmp12_ = engine;
	if (_tmp12_ == NULL) {
		IBusEngineDesc* _tmp13_ = NULL;
		IBusEngineDesc** _tmp14_;
		gint _tmp14__length1;
		IBusEngineDesc* _tmp17_;
		IBusEngineDesc* _tmp18_;
		_tmp14_ = self->priv->m_engines;
		_tmp14__length1 = self->priv->m_engines_length1;
		if (_tmp14__length1 > 0) {
			IBusEngineDesc** _tmp15_;
			gint _tmp15__length1;
			IBusEngineDesc* _tmp16_;
			_tmp15_ = self->priv->m_engines;
			_tmp15__length1 = self->priv->m_engines_length1;
			_tmp16_ = _tmp15_[0];
			_tmp13_ = _tmp16_;
		} else {
			_tmp13_ = NULL;
		}
		_tmp17_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (engine);
		engine = _tmp17_;
		_tmp18_ = engine;
		if (_tmp18_ == NULL) {
			_g_object_unref0 (engine);
			return;
		}
	} else {
		gboolean in_engines = FALSE;
		IBusEngineDesc** _tmp19_;
		gint _tmp19__length1;
		gboolean _tmp25_;
		in_engines = FALSE;
		_tmp19_ = self->priv->m_engines;
		_tmp19__length1 = self->priv->m_engines_length1;
		{
			IBusEngineDesc** e_collection = NULL;
			gint e_collection_length1 = 0;
			gint _e_collection_size_ = 0;
			gint e_it = 0;
			e_collection = _tmp19_;
			e_collection_length1 = _tmp19__length1;
			for (e_it = 0; e_it < _tmp19__length1; e_it = e_it + 1) {
				IBusEngineDesc* _tmp20_;
				IBusEngineDesc* e = NULL;
				_tmp20_ = _g_object_ref0 (e_collection[e_it]);
				e = _tmp20_;
				{
					IBusEngineDesc* _tmp21_;
					const gchar* _tmp22_;
					IBusEngineDesc* _tmp23_;
					const gchar* _tmp24_;
					_tmp21_ = engine;
					_tmp22_ = ibus_engine_desc_get_name (_tmp21_);
					_tmp23_ = e;
					_tmp24_ = ibus_engine_desc_get_name (_tmp23_);
					if (g_strcmp0 (_tmp22_, _tmp24_) == 0) {
						in_engines = TRUE;
						_g_object_unref0 (e);
						break;
					}
					_g_object_unref0 (e);
				}
			}
		}
		_tmp25_ = in_engines;
		if (!_tmp25_) {
			_g_object_unref0 (engine);
			return;
		}
	}
	_tmp26_ = engine;
	panel_set_engine (self, _tmp26_);
	_g_object_unref0 (engine);
}


static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	gchar* _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
}


static void panel_real_destroy_context (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	gboolean _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = self->priv->m_use_global_engine;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->m_engine_contexts;
	_tmp2_ = input_context_path;
	g_hash_table_remove (_tmp1_, _tmp2_);
}


static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusPropList* _tmp1_;
	PropertyPanel* _tmp2_;
	IBusPropList* _tmp3_;
	IBusPropList* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = props;
	property_manager_set_properties (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->m_property_panel;
	_tmp3_ = props;
	property_panel_set_properties (_tmp2_, _tmp3_);
	_tmp4_ = props;
	panel_set_properties (self, _tmp4_);
}


static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusProperty* _tmp1_;
	PropertyPanel* _tmp2_;
	IBusProperty* _tmp3_;
	IBusProperty* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = prop;
	property_manager_update_property (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->m_property_panel;
	_tmp3_ = prop;
	property_panel_update_property (_tmp2_, _tmp3_);
	_tmp4_ = prop;
	panel_set_property (self, _tmp4_, FALSE);
}


static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible) {
	Panel * self;
	gboolean _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		CandidatePanel* _tmp1_;
		IBusText* _tmp2_;
		guint _tmp3_;
		PropertyPanel* _tmp4_;
		IBusText* _tmp5_;
		guint _tmp6_;
		_tmp1_ = self->priv->m_candidate_panel;
		_tmp2_ = text;
		_tmp3_ = cursor_pos;
		candidate_panel_set_preedit_text (_tmp1_, _tmp2_, _tmp3_);
		_tmp4_ = self->priv->m_property_panel;
		_tmp5_ = text;
		_tmp6_ = cursor_pos;
		property_panel_set_preedit_text (_tmp4_, _tmp5_, _tmp6_);
	} else {
		CandidatePanel* _tmp7_;
		PropertyPanel* _tmp8_;
		_tmp7_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp7_, NULL, (guint) 0);
		_tmp8_ = self->priv->m_property_panel;
		property_panel_set_preedit_text (_tmp8_, NULL, (guint) 0);
	}
}


static void panel_real_hide_preedit_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible) {
	Panel * self;
	IBusText* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusText* _tmp4_ = NULL;
	gboolean _tmp5_;
	PropertyPanel* _tmp7_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusText* _tmp2_;
		_tmp2_ = text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp3_, _tmp0_);
	_tmp5_ = visible;
	if (_tmp5_) {
		IBusText* _tmp6_;
		_tmp6_ = text;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = self->priv->m_property_panel;
	property_panel_set_auxiliary_text (_tmp7_, _tmp4_);
}


static void panel_real_hide_auxiliary_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible) {
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusLookupTable* _tmp4_ = NULL;
	gboolean _tmp5_;
	PropertyPanel* _tmp7_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusLookupTable* _tmp2_;
		_tmp2_ = table;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp3_, _tmp0_);
	_tmp5_ = visible;
	if (_tmp5_) {
		IBusLookupTable* _tmp6_;
		_tmp6_ = table;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = NULL;
	}
	_tmp7_ = self->priv->m_property_panel;
	property_panel_set_lookup_table (_tmp7_, _tmp4_);
}


static void panel_real_hide_lookup_table (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static void panel_real_set_content_type (IBusPanelService* base, guint purpose, guint hints) {
	Panel * self;
	CandidatePanel* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = purpose;
	_tmp2_ = hints;
	candidate_panel_set_content_type (_tmp0_, _tmp1_, _tmp2_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void _vala_array_add23 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_real_state_changed (IBusPanelService* base) {
	Panel * self;
	Switcher* _tmp0_;
	gboolean _tmp1_;
	PanelIconType _tmp2_;
	gchar* icon_name = NULL;
	gchar* _tmp4_;
	IBusEngineDesc* engine = NULL;
	IBusBus* _tmp5_;
	IBusEngineDesc* _tmp6_;
	IBusEngineDesc* _tmp7_;
	const gchar* _tmp15_;
	gchar _tmp16_;
	IBusEngineDesc* _tmp65_;
	gint i = 0;
	gint _tmp76_;
	gint _tmp77_;
	IBusEngineDesc** _tmp78_;
	gint _tmp78__length1;
	IBusEngineDesc** _tmp90_;
	gint _tmp90__length1;
	IBusEngineDesc* _tmp91_;
	IBusEngineDesc* _tmp92_;
	IBusEngineDesc* _tmp93_;
	gchar** names = NULL;
	gchar** _tmp94_;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp95_;
	gint _tmp95__length1;
	GSettings* _tmp101_;
	gchar** _tmp102_;
	gint _tmp102__length1;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_switcher;
	_tmp1_ = switcher_is_running (_tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->m_icon_type;
	if (_tmp2_ == PANEL_ICON_TYPE_INDICATOR) {
		Indicator* _tmp3_;
		_tmp3_ = self->priv->m_indicator;
		if (_tmp3_ == NULL) {
			return;
		}
	}
	_tmp4_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp4_;
	_tmp5_ = self->priv->m_bus;
	_tmp6_ = ibus_bus_get_global_engine (_tmp5_);
	engine = _tmp6_;
	_tmp7_ = engine;
	if (_tmp7_ != NULL) {
		IBusEngineDesc* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		IBusEngineDesc* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = engine;
		_tmp9_ = ibus_engine_desc_get_icon (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (icon_name);
		icon_name = _tmp10_;
		_tmp11_ = engine;
		_tmp12_ = ibus_engine_desc_get_icon_prop_key (_tmp11_);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp13_;
	} else {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("");
		_g_free0 (self->priv->m_icon_prop_key);
		self->priv->m_icon_prop_key = _tmp14_;
	}
	_tmp15_ = icon_name;
	_tmp16_ = string_get (_tmp15_, (glong) 0);
	if (_tmp16_ == '/') {
		PanelIconType _tmp17_;
		_tmp17_ = self->priv->m_icon_type;
		if (_tmp17_ == PANEL_ICON_TYPE_STATUS_ICON) {
			GtkStatusIcon* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = self->priv->m_status_icon;
			_tmp19_ = icon_name;
			gtk_status_icon_set_from_file (_tmp18_, _tmp19_);
		} else {
			PanelIconType _tmp20_;
			_tmp20_ = self->priv->m_icon_type;
			if (_tmp20_ == PANEL_ICON_TYPE_INDICATOR) {
				Indicator* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = self->priv->m_indicator;
				_tmp22_ = icon_name;
				indicator_set_icon_full (_tmp21_, _tmp22_, "");
			}
		}
	} else {
		gchar* language = NULL;
		IBusEngineDesc* _tmp23_;
		const gchar* _tmp37_;
		language = NULL;
		_tmp23_ = engine;
		if (_tmp23_ != NULL) {
			gchar* name = NULL;
			IBusEngineDesc* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			_tmp24_ = engine;
			_tmp25_ = ibus_engine_desc_get_name (_tmp24_);
			_tmp26_ = g_strdup (_tmp25_);
			name = _tmp26_;
			_tmp28_ = name;
			_tmp29_ = strlen (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_ >= 4) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp31_ = name;
				_tmp32_ = string_slice (_tmp31_, (glong) 0, (glong) 4);
				_tmp33_ = _tmp32_;
				_tmp27_ = g_strcmp0 (_tmp33_, "xkb:") == 0;
				_g_free0 (_tmp33_);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				Switcher* _tmp34_;
				IBusEngineDesc* _tmp35_;
				gchar* _tmp36_;
				_tmp34_ = self->priv->m_switcher;
				_tmp35_ = engine;
				_tmp36_ = switcher_get_xkb_language (_tmp34_, _tmp35_);
				_g_free0 (language);
				language = _tmp36_;
			}
			_g_free0 (name);
		}
		_tmp37_ = language;
		if (_tmp37_ != NULL) {
			PanelIconType _tmp38_;
			_tmp38_ = self->priv->m_icon_type;
			if (_tmp38_ == PANEL_ICON_TYPE_STATUS_ICON) {
				GdkPixbuf* pixbuf = NULL;
				const gchar* _tmp39_;
				GdkPixbuf* _tmp40_;
				GtkStatusIcon* _tmp41_;
				GdkPixbuf* _tmp42_;
				_tmp39_ = language;
				_tmp40_ = panel_create_icon_pixbuf_with_string (self, _tmp39_);
				pixbuf = _tmp40_;
				_tmp41_ = self->priv->m_status_icon;
				_tmp42_ = pixbuf;
				gtk_status_icon_set_from_pixbuf (_tmp41_, _tmp42_);
				_g_object_unref0 (pixbuf);
			} else {
				PanelIconType _tmp43_;
				_tmp43_ = self->priv->m_icon_type;
				if (_tmp43_ == PANEL_ICON_TYPE_INDICATOR) {
					cairo_surface_t* image = NULL;
					const gchar* _tmp44_;
					cairo_surface_t* _tmp45_;
					Indicator* _tmp46_;
					cairo_surface_t* _tmp47_;
					_tmp44_ = language;
					_tmp45_ = panel_create_cairo_image_surface_with_string (self, _tmp44_, TRUE);
					image = _tmp45_;
					_tmp46_ = self->priv->m_indicator;
					_tmp47_ = image;
					indicator_set_cairo_image_surface_full (_tmp46_, _tmp47_, "");
					_cairo_surface_destroy0 (image);
				}
			}
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp48_;
			GtkIconTheme* _tmp49_;
			GtkIconTheme* _tmp50_;
			const gchar* _tmp51_;
			GtkIconInfo* _tmp52_;
			GtkIconInfo* _tmp53_;
			gboolean _tmp54_;
			_tmp48_ = gtk_icon_theme_get_default ();
			_tmp49_ = _g_object_ref0 (_tmp48_);
			theme = _tmp49_;
			_tmp50_ = theme;
			_tmp51_ = icon_name;
			_tmp52_ = gtk_icon_theme_lookup_icon (_tmp50_, _tmp51_, 48, 0);
			_tmp53_ = _tmp52_;
			_tmp54_ = _tmp53_ != NULL;
			_gtk_icon_info_free0 (_tmp53_);
			if (_tmp54_) {
				PanelIconType _tmp55_;
				_tmp55_ = self->priv->m_icon_type;
				if (_tmp55_ == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp56_;
					const gchar* _tmp57_;
					_tmp56_ = self->priv->m_status_icon;
					_tmp57_ = icon_name;
					gtk_status_icon_set_from_icon_name (_tmp56_, _tmp57_);
				} else {
					PanelIconType _tmp58_;
					_tmp58_ = self->priv->m_icon_type;
					if (_tmp58_ == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp59_;
						const gchar* _tmp60_;
						_tmp59_ = self->priv->m_indicator;
						_tmp60_ = icon_name;
						indicator_set_icon_full (_tmp59_, _tmp60_, "");
					}
				}
			} else {
				PanelIconType _tmp61_;
				_tmp61_ = self->priv->m_icon_type;
				if (_tmp61_ == PANEL_ICON_TYPE_STATUS_ICON) {
					GtkStatusIcon* _tmp62_;
					_tmp62_ = self->priv->m_status_icon;
					gtk_status_icon_set_from_icon_name (_tmp62_, "ibus-engine");
				} else {
					PanelIconType _tmp63_;
					_tmp63_ = self->priv->m_icon_type;
					if (_tmp63_ == PANEL_ICON_TYPE_INDICATOR) {
						Indicator* _tmp64_;
						_tmp64_ = self->priv->m_indicator;
						indicator_set_icon_full (_tmp64_, "ibus-engine", "");
					}
				}
			}
			_g_object_unref0 (theme);
		}
		_g_free0 (language);
	}
	_tmp65_ = engine;
	if (_tmp65_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp66_ = FALSE;
		i = 0;
		_tmp66_ = TRUE;
		while (TRUE) {
			gint _tmp68_;
			IBusEngineDesc** _tmp69_;
			gint _tmp69__length1;
			IBusEngineDesc** _tmp70_;
			gint _tmp70__length1;
			gint _tmp71_;
			IBusEngineDesc* _tmp72_;
			const gchar* _tmp73_;
			IBusEngineDesc* _tmp74_;
			const gchar* _tmp75_;
			if (!_tmp66_) {
				gint _tmp67_;
				_tmp67_ = i;
				i = _tmp67_ + 1;
			}
			_tmp66_ = FALSE;
			_tmp68_ = i;
			_tmp69_ = self->priv->m_engines;
			_tmp69__length1 = self->priv->m_engines_length1;
			if (!(_tmp68_ < _tmp69__length1)) {
				break;
			}
			_tmp70_ = self->priv->m_engines;
			_tmp70__length1 = self->priv->m_engines_length1;
			_tmp71_ = i;
			_tmp72_ = _tmp70_[_tmp71_];
			_tmp73_ = ibus_engine_desc_get_name (_tmp72_);
			_tmp74_ = engine;
			_tmp75_ = ibus_engine_desc_get_name (_tmp74_);
			if (g_strcmp0 (_tmp73_, _tmp75_) == 0) {
				break;
			}
		}
	}
	_tmp76_ = i;
	if (_tmp76_ == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp77_ = i;
	_tmp78_ = self->priv->m_engines;
	_tmp78__length1 = self->priv->m_engines_length1;
	if (_tmp77_ >= _tmp78__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint j = 0;
		gint _tmp79_;
		_tmp79_ = i;
		j = _tmp79_;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gint _tmp82_;
				IBusEngineDesc** _tmp83_;
				gint _tmp83__length1;
				gint _tmp84_;
				IBusEngineDesc** _tmp85_;
				gint _tmp85__length1;
				gint _tmp86_;
				IBusEngineDesc* _tmp87_;
				IBusEngineDesc* _tmp88_;
				IBusEngineDesc* _tmp89_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = j;
					j = _tmp81_ - 1;
				}
				_tmp80_ = FALSE;
				_tmp82_ = j;
				if (!(_tmp82_ > 0)) {
					break;
				}
				_tmp83_ = self->priv->m_engines;
				_tmp83__length1 = self->priv->m_engines_length1;
				_tmp84_ = j;
				_tmp85_ = self->priv->m_engines;
				_tmp85__length1 = self->priv->m_engines_length1;
				_tmp86_ = j;
				_tmp87_ = _tmp85_[_tmp86_ - 1];
				_tmp88_ = _g_object_ref0 (_tmp87_);
				_g_object_unref0 (_tmp83_[_tmp84_]);
				_tmp83_[_tmp84_] = _tmp88_;
				_tmp89_ = _tmp83_[_tmp84_];
			}
		}
	}
	_tmp90_ = self->priv->m_engines;
	_tmp90__length1 = self->priv->m_engines_length1;
	_tmp91_ = engine;
	_tmp92_ = _g_object_ref0 (_tmp91_);
	_g_object_unref0 (_tmp90_[0]);
	_tmp90_[0] = _tmp92_;
	_tmp93_ = _tmp90_[0];
	_tmp94_ = g_new0 (gchar*, 0 + 1);
	names = _tmp94_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp95_ = self->priv->m_engines;
	_tmp95__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp95_;
		desc_collection_length1 = _tmp95__length1;
		for (desc_it = 0; desc_it < _tmp95__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp96_;
			IBusEngineDesc* desc = NULL;
			_tmp96_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp96_;
			{
				gchar** _tmp97_;
				gint _tmp97__length1;
				IBusEngineDesc* _tmp98_;
				const gchar* _tmp99_;
				gchar* _tmp100_;
				_tmp97_ = names;
				_tmp97__length1 = names_length1;
				_tmp98_ = desc;
				_tmp99_ = ibus_engine_desc_get_name (_tmp98_);
				_tmp100_ = g_strdup (_tmp99_);
				_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp100_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp101_ = self->priv->m_settings_general;
	_tmp102_ = names;
	_tmp102__length1 = names_length1;
	g_settings_set_strv (_tmp101_, "engines-order", _tmp102_);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse, PanelKeyEventFuncType ftype) {
	PanelKeybinding* self = NULL;
	guint _tmp0_;
	GdkModifierType _tmp1_;
	gboolean _tmp2_;
	PanelKeyEventFuncType _tmp3_;
	self = (PanelKeybinding*) g_type_create_instance (object_type);
	_tmp0_ = keysym;
	panel_keybinding_set_keysym (self, _tmp0_);
	_tmp1_ = modifiers;
	panel_keybinding_set_modifiers (self, _tmp1_);
	_tmp2_ = reverse;
	panel_keybinding_set_reverse (self, _tmp2_);
	_tmp3_ = ftype;
	panel_keybinding_set_ftype (self, _tmp3_);
	return self;
}


static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse, PanelKeyEventFuncType ftype) {
	return panel_keybinding_construct (PANEL_TYPE_KEYBINDING, keysym, modifiers, reverse, ftype);
}


static guint panel_keybinding_get_keysym (PanelKeybinding* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keysym = _tmp0_;
}


static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self) {
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value) {
	GdkModifierType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
}


static gboolean panel_keybinding_get_reverse (PanelKeybinding* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_reverse;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_reverse = _tmp0_;
}


static PanelKeyEventFuncType panel_keybinding_get_ftype (PanelKeybinding* self) {
	PanelKeyEventFuncType result;
	PanelKeyEventFuncType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ftype;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_ftype (PanelKeybinding* self, PanelKeyEventFuncType value) {
	PanelKeyEventFuncType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ftype = _tmp0_;
}


static void panel_value_keybinding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void panel_value_keybinding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		panel_keybinding_unref (value->data[0].v_pointer);
	}
}


static void panel_value_keybinding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = panel_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer panel_value_keybinding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* panel_value_keybinding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PanelKeybinding * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = panel_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* panel_value_keybinding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PanelKeybinding ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = panel_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	PanelParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANEL_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer panel_value_get_keybinding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void panel_value_set_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		panel_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_value_take_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_keybinding_class_init (PanelKeybindingClass * klass) {
	panel_keybinding_parent_class = g_type_class_peek_parent (klass);
	((PanelKeybindingClass *) klass)->finalize = panel_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (PanelKeybindingPrivate));
}


static void panel_keybinding_instance_init (PanelKeybinding * self) {
	self->priv = PANEL_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void panel_keybinding_finalize (PanelKeybinding * obj) {
	PanelKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANEL_TYPE_KEYBINDING, PanelKeybinding);
	g_signal_handlers_destroy (self);
}


static GType panel_keybinding_get_type (void) {
	static volatile gsize panel_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&panel_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { panel_value_keybinding_init, panel_value_keybinding_free_value, panel_value_keybinding_copy_value, panel_value_keybinding_peek_pointer, "p", panel_value_keybinding_collect_value, "p", panel_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PanelKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PanelKeybinding), 0, (GInstanceInitFunc) panel_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType panel_keybinding_type_id;
		panel_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PanelKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&panel_keybinding_type_id__volatile, panel_keybinding_type_id);
	}
	return panel_keybinding_type_id__volatile;
}


static gpointer panel_keybinding_ref (gpointer instance) {
	PanelKeybinding * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void panel_keybinding_unref (gpointer instance) {
	PanelKeybinding * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANEL_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void panel_class_init (PanelClass * klass) {
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	((IBusPanelServiceClass *) klass)->set_cursor_location = (void (*) (IBusPanelService *, gint, gint, gint, gint)) panel_real_set_cursor_location;
	((IBusPanelServiceClass *) klass)->focus_in = (void (*) (IBusPanelService *, const gchar*)) panel_real_focus_in;
	((IBusPanelServiceClass *) klass)->focus_out = (void (*) (IBusPanelService *, const gchar*)) panel_real_focus_out;
	((IBusPanelServiceClass *) klass)->destroy_context = (void (*) (IBusPanelService *, const gchar*)) panel_real_destroy_context;
	((IBusPanelServiceClass *) klass)->register_properties = (void (*) (IBusPanelService *, IBusPropList*)) panel_real_register_properties;
	((IBusPanelServiceClass *) klass)->update_property = (void (*) (IBusPanelService *, IBusProperty*)) panel_real_update_property;
	((IBusPanelServiceClass *) klass)->update_preedit_text = (void (*) (IBusPanelService *, IBusText*, guint, gboolean)) panel_real_update_preedit_text;
	((IBusPanelServiceClass *) klass)->hide_preedit_text = (void (*) (IBusPanelService *)) panel_real_hide_preedit_text;
	((IBusPanelServiceClass *) klass)->update_auxiliary_text = (void (*) (IBusPanelService *, IBusText*, gboolean)) panel_real_update_auxiliary_text;
	((IBusPanelServiceClass *) klass)->hide_auxiliary_text = (void (*) (IBusPanelService *)) panel_real_hide_auxiliary_text;
	((IBusPanelServiceClass *) klass)->update_lookup_table = (void (*) (IBusPanelService *, IBusLookupTable*, gboolean)) panel_real_update_lookup_table;
	((IBusPanelServiceClass *) klass)->hide_lookup_table = (void (*) (IBusPanelService *)) panel_real_hide_lookup_table;
	((IBusPanelServiceClass *) klass)->set_content_type = (void (*) (IBusPanelService *, guint, guint)) panel_real_set_content_type;
	((IBusPanelServiceClass *) klass)->state_changed = (void (*) (IBusPanelService *)) panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void panel_instance_init (Panel * self) {
	IBusEngineDesc** _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GdkRGBA _tmp13_ = {0};
	XKBLayout* _tmp14_;
	gchar* _tmp15_;
	self->priv = PANEL_GET_PRIVATE (self);
	self->priv->m_settings_general = NULL;
	self->priv->m_settings_hotkey = NULL;
	self->priv->m_settings_panel = NULL;
	self->priv->m_settings_emoji = NULL;
	self->priv->m_icon_type = PANEL_ICON_TYPE_STATUS_ICON;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	self->priv->m_engine_contexts = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->m_real_current_context_path = _tmp5_;
	self->priv->m_use_global_engine = TRUE;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_emojier_favorites = _tmp6_;
	self->priv->m_emojier_favorites_length1 = 0;
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_use_system_keyboard_layout = FALSE;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_object_unref0_);
	self->priv->m_xkb_icon_pixbufs = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _cairo_surface_destroy0_);
	self->priv->m_xkb_icon_image = _tmp12_;
	memset (&_tmp13_, 0, sizeof (GdkRGBA));
	_tmp13_.red = 0.0;
	_tmp13_.green = 0.0;
	_tmp13_.blue = 0.0;
	_tmp13_.alpha = 1.0;
	self->priv->m_xkb_icon_rgba = _tmp13_;
	_tmp14_ = xkb_layout_new ();
	self->priv->m_xkblayout = _tmp14_;
	self->priv->inited_engines_order = TRUE;
	_tmp15_ = g_strdup ("");
	self->priv->m_icon_prop_key = _tmp15_;
	self->priv->m_property_icon_delay_time = 500;
	self->priv->m_keybindings = NULL;
}


static void panel_finalize (GObject * obj) {
	Panel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	panel_unbind_switch_shortcut (self, PANEL_KEY_EVENT_FUNC_TYPE_ANY);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_settings_general);
	_g_object_unref0 (self->priv->m_settings_hotkey);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_settings_emoji);
	_g_object_unref0 (self->priv->m_indicator);
	_g_object_unref0 (self->priv->m_session_bus_connection);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->m_engine_contexts);
	_g_free0 (self->priv->m_current_context_path);
	_g_free0 (self->priv->m_real_current_context_path);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_property_panel);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_pixbufs);
	_g_hash_table_unref0 (self->priv->m_xkb_icon_image);
	_xkb_layout_unref0 (self->priv->m_xkblayout);
	_g_free0 (self->priv->m_icon_prop_key);
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType panel_get_type (void) {
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



