/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "simpleprediction.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

// プライグイン化のおまじないです。
HonokaPluginRegister(SimplePrediction);
HonokaPluginSetup(SimplePrediction);

HonokaSetupCorePage *SimplePrediction::setup()
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    HonokaSetupPage *page = new HonokaSetupPage(_("SimplePrediction-plugin"),"","");
    page->append(new HonokaSetupIntItem(
        _("_max history count: "),
        HONOKA_CONFIG_SIMPLEPREDICTION_SIZE,
        _("set maximum size of history count."),
        HONOKA_DEFAULT_SIMPLEPREDICTION_SIZE,
        1,500
    ));
    HonokaSetupPage *sc = new HonokaSetupPage(_("shortcut keys: "),"","");
    sc->append(new HonokaSetupKeyItem(
        _("Simple Prediction: "),
        String(HONOKA_CONFIG_KEY_PREDICTOR_PREFIX) + String("/SimplePrediction"),
        "",
        ""
    ));
    page->append(sc);

    return page;
};

SimplePrediction::SimplePrediction(ConfigPointer cfg) : Predictor(cfg)
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    size = cfg->read(HONOKA_CONFIG_SIMPLEPREDICTION_SIZE,HONOKA_DEFAULT_SIMPLEPREDICTION_SIZE);
    if (size < 1) size = HONOKA_DEFAULT_SIMPLEPREDICTION_SIZE;
}


SimplePrediction::~SimplePrediction()
{
}



/*!
    \fn SimplePrediction::getPredictionList(const WideString &str)
 */
ResultList SimplePrediction::getPredictionList(const WideString &str)
{
    multimap<WideString,WideString> tmp;
    for(multimap<WideString,WideString>::iterator it = data.begin();it != data.end();it ++) {
        if (it->first.length() >= str.length()) {
            if (str == it->first.substr(0,str.length())) tmp.insert(*it);
        }
    }
    if (!tmp.size()) return ResultList();
    ResultList l;
    l.Title = utf8_mbstowcs(String(_("lookup result")));
    l.kType = PREDICTION;
    for(multimap<WideString,WideString>::iterator it = tmp.begin();it != tmp.end();it ++) {
        l.kouho.push_back(ResultEntry(it->second));
    }
    return l;
}


/*!
    \fn SimplePrediction::disconnect()
 */
void SimplePrediction::disconnect()
{
    return;
}


/*!
    \fn SimplePrediction::connect()
 */
bool SimplePrediction::connect()
{
    return true;
}


/*!
    \fn SimplePrediction::isConnected()
 */
bool SimplePrediction::isConnected()
{
    return true;
}


/*!
    \fn SimplePrediction::getPropertyName()
 */
String SimplePrediction::getPropertyName()
{
    return String(_("SimplePrediction"));
}

/*!
    \fn SimplePrediction::getName()
 */
String SimplePrediction::getName()
{
    return String("SimplePrediction");
}

/*!
    \fn SimplePrediction::update(const WideString str,const WideString yomi)
 */
void SimplePrediction::update(const WideString str,const WideString yomi)
{
    if ((!yomi.length()) || (!str.length())) return;
    for(multimap<WideString,WideString>::iterator it = data.begin();it != data.end();it++)
        if ((it->first == yomi) &&(it->second == str)) return;
    data.insert(pair<WideString,WideString>(yomi,str));
    if (data.size() > size) data.erase(data.begin());
    return;
}

