/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SCIM_WNN_IMENGINE_H
#define SCIM_WNN_IMENGINE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <dlfcn.h>

#define Uses_SCIM_UTILITY
#define Uses_SCIM_IMENGINE
#define Uses_SCIM_LOOKUP_TABLE
#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_ICONV
#define Uses_SCIM_TRANS_COMMANDS

#include <cstdio>
#include <cstdlib>
#include <vector>
#include <stack>
#include <map>
#include <convertor.h>
#include <preeditor.h>
#include <predictor.h>
#include <honokamultiplepluginbase.h>
#include <honokakeyeventlist.h>
#include <honokastatus.h>
#define Uses_SCIM_ICONV
#include <scim.h>
#include <scim_iconv.h>
#include <multiconvertor.h>
#include <acpredictor.h>

typedef HonokaPluginBase* createInstanceFunc(ConfigPointer);
typedef void deleteInstanceFunc(HonokaPluginBase *);
typedef int getPluginVersionFunc();

using namespace scim;
using namespace std;

class ACPredictor;

class HonokaFactory : public IMEngineFactoryBase
{
protected:
    friend class HonokaInstance;
    WideString m_name;
public:
    HonokaFactory ();
    HonokaFactory (const WideString & name, const String & languages);
    virtual ~HonokaFactory ();
    virtual WideString get_name () const;
    virtual WideString get_authors () const;
    virtual WideString get_credits () const;
    virtual WideString get_help () const;
    virtual String get_uuid () const;
    virtual String get_icon_file () const;
    virtual IMEngineInstancePointer create_instance (const String& encoding, int id = -1);
protected:

};

class HonokaPluginEntry
{
public:
    String filename;
    String name;
    void *dll;
    createInstanceFunc *createInstance;
    deleteInstanceFunc *deleteInstance;
    getPluginVersionFunc *getPluginVersion;
    HonokaPluginBase *instance;
};


class HonokaInstance : public IMEngineInstanceBase,public HonokaStatus
{
protected:
    friend class MultiConvertor;
    friend class ACPredictor;

public:
    HonokaInstance (HonokaFactory *factory, const String  &encoding, int id = -1);
    virtual ~HonokaInstance ();
    virtual bool process_key_event (const KeyEvent& key);
    virtual void move_preedit_caret (unsigned int pos);
    virtual void select_candidate (unsigned int item);
    virtual void update_lookup_table_page_size (unsigned int page_size);
    virtual void lookup_table_page_up ();
    virtual void lookup_table_page_down ();
    virtual void reset ();
    virtual void focus_in ();
    virtual void focus_out ();
    virtual void trigger_property (const String &property);
    virtual void process_helper_event (const String &helper_uuid, const Transaction &trans);
    void startLookup();

protected:
    Transaction trans;
    CommonLookupTable m_lookup_table;
    PreEditor *m_preeditor;
    Convertor *m_convertor;
    Convertor *m_def_convertor;
    Predictor *m_predictor;
    Convertor *m_splitter;
    //bool m_conversion;
    //bool m_prediction;
    //bool m_lookup;
    ResultList m_convList;
    ResultList m_convListOrig;
    PropertyList m_proplist;
    bool m_no_update;
    int alp;
    int alp_count;
    bool changeable_splitter;
    bool numkeyselect;
    bool mini_status;
    bool prediction;
    bool realtime_prediction;
    bool auto_conversion;
    bool save_setting;
    bool select_prediction_direct;
    String defaultPreEditor;
    String defaultConvertor;
    String defaultPredictor;
    IConvert m_iconv;
    //map<String,HonokaPluginEntry> plugins;
    vector<HonokaPluginEntry> plugins;
    vector<PreEditor *> preeditors;
    vector<Convertor *> convertors;
    vector<Predictor *> predictors;
    WideString yomi;
    stack<WideString> preeditStack;
    Convertor *m_multi;
    vector<Segment> segments;
    ACPredictor *acpredictor;
    int preeditKeyDelay;
    uint32 predictionDelay;
    WideString preeditCache;
    enum convertedStringType { NORMAL , HIRA , KATA , HALF , WIDE };
    WideString pString;
    convertedStringType pStringType;
protected:
    bool process_preedit_key_event(const KeyEvent &key);
    bool process_conversion_key_event(const KeyEvent &key);
    bool process_prediction_key_event(const KeyEvent &key);
    void startConversion(WideString s = WideString(), bool multi = false);
    void createLookupTable(ResultList cList);
    void loadPlugins();
    void init();
    void unload();
    void updatePreEditor();
    void updateProperty();
    void updateConversion();
    bool changePreEditor(const String &name);
    bool changeConvertor(const String &name);
    bool changePredictor(const String &name);
    bool changeSplitter(const String &name);
    void autoConversion();
    bool pluginCheck(HonokaPluginBase *p);
    WideString getPosPerCount(int p,int c);
    vector<String> split(const String &str,const char &sep = ',');
    const WideString getConvertedText();
    const AttributeList getConvertedAttributeList();
    void updateConvertedString();
    void timerEvent(int id);
private:
    HonokaKeyEventList
        k_conversion_start,     // 変換開始
        k_multi_conversion,     // 一喝
        k_cancel,               // キャンセルキー
        k_delete,               // 削除
        k_backspace,            // バックスペース
        k_commit,               // 確定
        k_conversion_next,      // 次候補
        k_conversion_prev,      // 前候補
        k_conversion_expand,    // 拡大
        k_conversion_shrink,    // 縮小
        k_conversion_forward,   // 次文節
        k_conversion_backward,  // 前文節
        k_forward,              // カーソル移動/前
        k_backward,             // カーソル移動/後ろ
        k_home,                 // カーソル移動/先頭
        k_end,                  // カーソル移動/末尾
        k_lookup_popup,         // 候補一覧表示
        k_lookup_pageup,        // 候補一覧前項
        k_lookup_pagedown,      // 候補一覧次項
        k_convert_ctype,        // 文字種変換
        k_convert_hiragana,     // ひらがな変換
        k_convert_katakana,     // カタカナ変換
        k_convert_half,         // 半角変換
        k_convert_wide,         // 全角変換
        k_auto_conversion,      // 変換モードトグル
        k_next_convertor,       // 次の変換エンジンへ
        k_prev_convertor,       // 前の変換エンジンへ
        k_reconversion,         // 再変換
        k_result_to_preedit,    // 変換結果をPreEditorにpush
        k_furigana_commit,      // ふりがな付き確定
        k_allreset,             // 機能全リセット

        // for Wnn7
        k_conversion_ikeiji,    // 異形字変換
        k_conversion_rensou,    // 連想変換
        k_select_prediction,    // 予測選択
        k_selection[9],         // 候補選択ショートカット
        k_dummy;
    vector<HonokaKeyEventList> k_convertor;
    vector<HonokaKeyEventList> k_preeditor;
    vector<HonokaKeyEventList> k_predictor;
};


#endif

