/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.javadoc.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.JUnitConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestConverter
extends Doclet {
    private static File[] m_fileNames = null;
    private static List<String> m_classNames = new ArrayList<String>();
    private static Map<File, List<MethodDoc>> m_files = new HashMap<File, List<MethodDoc>>();
    private static Map<File, List<String>> m_fileLines = new HashMap<File, List<String>>();
    private static Map<File, String> m_packageNames = new HashMap<File, String>();
    private static Map<File, Integer> m_typelines = new HashMap<File, Integer>();
    private File m_outDir = null;
    private boolean m_useAnnotations;
    private boolean m_done;

    public JUnitTestConverter(File[] fileNames, File outDir, String release, boolean useAnnotations) {
        m_fileNames = fileNames;
        this.m_outDir = outDir;
        this.m_useAnnotations = useAnnotations;
        ArrayList<String> argv = new ArrayList<String>();
        argv.add("-quiet");
        if (null != release && !"".equals(release)) {
            argv.add("-source");
            argv.add(release);
        }
        argv.add("-doclet");
        argv.add("org.testng.junit.JUnitTestConverter");
        for (File fn : fileNames) {
            argv.add(fn.getAbsolutePath());
        }
        String[] newArgv = argv.toArray(new String[argv.size()]);
        this.m_done = 0 == Main.execute((String[])newArgv);
    }

    private static File findFileName(ClassDoc cd) {
        for (File fn : m_fileNames) {
            if (!fn.getAbsolutePath().endsWith(cd.name() + ".java")) continue;
            return fn;
        }
        assert (false) : "COULDN'T FIND FILE " + cd.name();
        return null;
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classes;
        for (ClassDoc cd : classes = root.classes()) {
            if (!JUnitTestConverter.isJUnitTest(cd)) continue;
            if (!cd.isAbstract()) {
                m_classNames.add(cd.qualifiedTypeName());
            }
            File file = null != cd.position().file() ? cd.position().file() : JUnitTestConverter.findFileName(cd);
            String fqn = cd.qualifiedTypeName();
            int tn = fqn.indexOf(cd.typeName());
            if (tn > 0) {
                m_packageNames.put(file, fqn.substring(0, tn - 1));
            }
            m_typelines.put(file, new Integer(cd.position().line()));
            MethodDoc[] methods = cd.methods();
            ArrayList<MethodDoc> testMethods = new ArrayList<MethodDoc>();
            for (MethodDoc md : methods) {
                if (!JUnitTestConverter.isTest(md) && !JUnitTestConverter.isSetUp(md) && !JUnitTestConverter.isTearDown(md)) continue;
                testMethods.add(0, md);
            }
            m_files.put(file, testMethods);
        }
        return true;
    }

    private static boolean isJUnitTest(ClassDoc clsDoc) {
        if (clsDoc.isInterface()) {
            return false;
        }
        for (ClassDoc superCls = clsDoc.superclass(); null != superCls && !"java.lang.Object".equals(superCls.qualifiedTypeName()); superCls = superCls.superclass()) {
            if (!"junit.framework.TestCase".equals(superCls.qualifiedTypeName()) && !"TestCase".equals(superCls.typeName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTest(MethodDoc md) {
        return md.name().startsWith("test");
    }

    private static boolean isSetUp(MethodDoc md) {
        return "setUp".equals(md.name());
    }

    private static boolean isTearDown(MethodDoc md) {
        return "tearDown".equals(md.name());
    }

    public int convert() {
        if (!this.m_done) {
            return -1;
        }
        int converted = 0;
        for (File file : m_files.keySet()) {
            try {
                List<String> lines = this.fileToLines(file);
                List<String> finalLines = this.m_useAnnotations ? this.insertAnnotations(m_files.get(file), lines) : this.insertJavadoc(file, m_files.get(file), lines);
                m_fileLines.put(file, finalLines);
                this.writeFile(file);
                ++converted;
            }
            catch (IOException ioe) {
                JUnitTestConverter.ppp("failed to process " + file);
                ioe.printStackTrace();
            }
        }
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File filePath) {
        String fileName = filePath.getName();
        File file = new File(this.getPackageOutputDir(this.m_outDir, m_packageNames.get(filePath)), fileName);
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            List<String> lines = m_fileLines.get(filePath);
            assert (null != lines) : "NO LINES FOR " + filePath;
            for (String l : lines) {
                bw.write(l);
                bw.write(10);
            }
            JUnitTestConverter.ppp("Wrote " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (null != fw) {
                    fw.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private List<String> insertAnnotations(List<MethodDoc> methodDocs, List<String> lines) {
        int lineCount = 0;
        for (String line : lines) {
            ++lineCount;
            if (!(line = line.trim()).startsWith("import")) continue;
            lines.add(lineCount - 1, "import org.testng.annotations.*;");
            break;
        }
        for (MethodDoc md : methodDocs) {
            SourcePosition sp = md.position();
            if (JUnitTestConverter.isTest(md)) {
                lines.add(sp.line(), "  @Test");
                continue;
            }
            if (JUnitTestConverter.isSetUp(md)) {
                lines.add(sp.line(), "  @Configuration(beforeTestMethod = true)");
                continue;
            }
            if (!JUnitTestConverter.isTearDown(md)) continue;
            lines.add(sp.line(), "  @Configuration(afterTestMethod = true)");
        }
        return lines;
    }

    private List<String> insertJavadoc(File file, List<MethodDoc> methodDocs, List<String> lines) {
        for (int i = 0; i < methodDocs.size(); ++i) {
            int realInsert;
            MethodDoc md = methodDocs.get(i);
            int insertLineNo = i + 1 < methodDocs.size() ? this.findCommentLine(lines, md, methodDocs.get(i + 1).position().line()) : this.findCommentLine(lines, md, m_typelines.get(file));
            int n = realInsert = insertLineNo == 0 ? md.position().line() - 1 : insertLineNo;
            if (insertLineNo == 0) {
                lines.add(realInsert, "    */");
            }
            if (JUnitTestConverter.isTest(md)) {
                lines.add(realInsert, "    * @testng.test");
            } else if (JUnitTestConverter.isSetUp(md)) {
                lines.add(realInsert, "    * @testng.configuration beforeTestMethod=\"true\"");
            } else if (JUnitTestConverter.isTearDown(md)) {
                lines.add(realInsert, "    * @testng.configuration afterTestMethod=\"true\"");
            }
            if (insertLineNo != 0) continue;
            lines.add(realInsert, "   /**");
        }
        return lines;
    }

    private File getPackageOutputDir(File outDir, String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        return new File(outDir, packageName.replace('.', File.separatorChar));
    }

    private int findCommentLine(List<String> lines, MethodDoc md, int minLine) {
        for (int i = md.position().line() - 1; i > minLine; --i) {
            String line = lines.get(i);
            if (line.indexOf("*/") != -1 && line.indexOf("/**") == -1) {
                return i;
            }
            if (line.indexOf("*/") == -1 || line.indexOf("/**") == -1) continue;
            StringBuffer buf = new StringBuffer(line);
            int idx = buf.indexOf("*/");
            buf.deleteCharAt(idx).deleteCharAt(idx);
            lines.set(i, buf.toString());
            lines.add(i + 1, "    */");
            return i + 1;
        }
        return 0;
    }

    private List<String> fileToLines(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (null != line) {
            result.add(line);
            line = br.readLine();
        }
        return result;
    }

    private static void ppp(String s) {
        if (JUnitConverter.getLogLevel() >= 1) {
            System.out.println("[JUnitTestConverter]" + s);
        }
    }

    public String[] getClassNames() {
        return m_classNames.toArray(new String[m_classNames.size()]);
    }
}

