/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.testng.TestNG;

public class TestNGAntTask2
extends Java {
    protected List m_xmlFilesets = new ArrayList();
    protected List m_clsFilesets = new ArrayList();
    protected Path m_sourceDirPath;
    protected String m_mainClass = TestNG.class.getName();
    protected String m_outdir;
    protected String m_testjar;
    protected Path m_classpath;
    protected boolean m_enableAssert = true;
    protected boolean m_dumpCommand = false;

    public void addXmlfileset(FileSet fs) {
        this.m_xmlFilesets.add(fs);
    }

    public void setXmlfilesetRef(Reference ref) {
        this.addXmlfileset(this.createFileSet(ref));
    }

    public void addClassfileset(FileSet fs) {
        this.m_clsFilesets.add(fs);
    }

    public void setClassfilesetRef(Reference ref) {
        this.addClassfileset(this.createFileSet(ref));
    }

    public void setDumpCommand(boolean verbose) {
        this.m_dumpCommand = verbose;
    }

    public void setSuiteRunnerClass(String s) {
        this.m_mainClass = s;
    }

    public void setOutputDir(String s) {
        this.m_outdir = s;
    }

    public void setTestJar(String s) {
        this.m_testjar = s;
    }

    public Path createClasspath() {
        Path cp = super.createClasspath();
        if (this.m_classpath == null) {
            this.m_classpath = cp;
        } else {
            this.m_classpath.append(cp);
        }
        return cp;
    }

    public void setClasspath(Path s) {
        if (this.m_classpath == null) {
            this.m_classpath = this.createClasspath();
        }
        this.m_classpath.append(s);
        super.setClasspath(s);
    }

    public void setClasspathRef(Reference r) {
        if (this.m_classpath == null) {
            this.m_classpath = this.createClasspath();
        }
        this.m_classpath.setRefid(r);
        super.setClasspathRef(r);
    }

    public void setEnableAssert(boolean flag) {
        this.m_enableAssert = flag;
    }

    public void setSourcedir(Path srcDir) {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = srcDir;
        } else {
            this.m_sourceDirPath.append(srcDir);
        }
    }

    public Path createSourceDir() {
        if (this.m_sourceDirPath == null) {
            this.m_sourceDirPath = new Path(this.getProject());
        }
        return this.m_sourceDirPath.createPath();
    }

    public void setSourceDirRef(Reference r) {
        this.createSourceDir().setRefid(r);
    }

    private FileSet createFileSet(Reference ref) {
        FileSet fs = new FileSet();
        fs.setRefid(ref);
        fs.setProject(this.getProject());
        return fs;
    }

    public void execute() throws BuildException {
        if (this.m_enableAssert) {
            this.createJvmarg().setValue("-ea");
        }
        this.setClassname(this.m_mainClass);
        if (null != this.m_outdir && !"".equals(this.m_outdir)) {
            this.createArg().setValue("-d");
            this.createArg().setValue(this.m_outdir);
        }
        if (null != this.m_testjar && !"".equals(this.m_testjar)) {
            this.createArg().setValue("-testjar");
            this.createArg().setValue(this.m_testjar);
        }
        if (null != this.m_sourceDirPath) {
            String srcPath = this.createPathString(this.m_sourceDirPath, ";");
            this.createArg().setValue("-sourcedir");
            this.createArg().setValue(srcPath);
        }
        if (this.m_clsFilesets.size() > 0) {
            this.createArg().setValue("-testclass");
            this.createArg().setValue(this.filesetToString(this.m_clsFilesets, " "));
        }
        if (this.m_xmlFilesets.size() > 0) {
            this.createArg().setValue(this.filesetToString(this.m_xmlFilesets, " "));
        }
        if (this.m_dumpCommand) {
            this.log(this.dumpCommand(), 2);
        }
        super.execute();
    }

    private String filesetToString(List filesets, String sep) throws BuildException {
        StringBuffer buf = new StringBuffer();
        for (FileSet fileset : filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (int i = 0; i < ds.getIncludedFiles().length; ++i) {
                String file = ds.getIncludedFiles()[i];
                buf.append(ds.getBasedir() + File.separator + file).append(sep);
            }
        }
        return buf.toString();
    }

    private String createPathString(Path path, String sep) {
        if (path == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < path.list().length; ++i) {
            File file = this.getProject().resolveFile(path.list()[i]);
            if (!file.exists()) {
                this.log("Classpath entry not found: " + file, 1);
            }
            buf.append(file.getAbsolutePath()).append(sep);
        }
        if (path.list().length > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private String dumpCommand() {
        StringBuffer dumpBuf = new StringBuffer("java ");
        if (this.m_enableAssert) {
            dumpBuf.append("-ea ");
        }
        if (null != this.m_classpath) {
            dumpBuf.append("-cp ").append(this.createPathString(this.m_classpath, File.pathSeparator)).append(" ");
        }
        dumpBuf.append(this.m_mainClass).append(" ");
        if (null != this.m_outdir && !"".equals(this.m_outdir)) {
            dumpBuf.append("-d").append(" ").append(this.m_outdir).append(" ");
        }
        if (null != this.m_testjar && !"".equals(this.m_testjar)) {
            dumpBuf.append("-testjar").append(" ").append(this.m_testjar).append(" ");
        }
        if (null != this.m_sourceDirPath) {
            dumpBuf.append("-sourcedir").append(" ").append(this.createPathString(this.m_sourceDirPath, ";")).append(" ");
        }
        if (this.m_clsFilesets.size() > 0) {
            dumpBuf.append("-testclass").append(" ").append(this.filesetToString(this.m_clsFilesets, " ")).append(" ");
        }
        if (this.m_xmlFilesets.size() > 0) {
            dumpBuf.append(this.filesetToString(this.m_xmlFilesets, " "));
        }
        return dumpBuf.toString();
    }
}

