// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MINIOBJECT_H
#define _GSTREAMERMM_MINIOBJECT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <glibmm/value.h>
#include <sigc++/sigc++.h>

#include <map>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MiniObjectFlags MINI_OBJECT_FLAG_LOCKABLE
 *  The object can be locked and unlocked with Gst::MiniObject::lock() and Gst::MiniObject::unlock().
 * 
 *  @var MiniObjectFlags MINI_OBJECT_FLAG_LOCK_READONLY
 *  The object is permanently locked in READONLY mode. Only read locks can be performed on the object.
 * 
 *  @var MiniObjectFlags MINI_OBJECT_FLAG_LAST
 *  First flag that can be used by subclasses.
 * 
 *  @enum MiniObjectFlags
 * 
 * Flags for the mini object
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MiniObjectFlags operator|(MiniObjectFlags, MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags operator&(MiniObjectFlags, MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags operator^(MiniObjectFlags, MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags operator~(MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags& operator|=(MiniObjectFlags&, MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags& operator&=(MiniObjectFlags&, MiniObjectFlags)</tt><br>
 * <tt>%MiniObjectFlags& operator^=(MiniObjectFlags&, MiniObjectFlags)</tt><br>
 */
enum MiniObjectFlags
{
  MINI_OBJECT_FLAG_LOCKABLE = (1 << 0),
  MINI_OBJECT_FLAG_LOCK_READONLY = (1 << 1),
  MINI_OBJECT_FLAG_LAST = (1 << 4)
};

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags operator|(MiniObjectFlags lhs, MiniObjectFlags rhs)
  { return static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags operator&(MiniObjectFlags lhs, MiniObjectFlags rhs)
  { return static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags operator^(MiniObjectFlags lhs, MiniObjectFlags rhs)
  { return static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags operator~(MiniObjectFlags flags)
  { return static_cast<MiniObjectFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags& operator|=(MiniObjectFlags& lhs, MiniObjectFlags rhs)
  { return (lhs = static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags& operator&=(MiniObjectFlags& lhs, MiniObjectFlags rhs)
  { return (lhs = static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MiniObjectFlags& operator^=(MiniObjectFlags& lhs, MiniObjectFlags rhs)
  { return (lhs = static_cast<MiniObjectFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MiniObjectFlags> : public Glib::Value_Flags<Gst::MiniObjectFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/** 
 *  @var LockFlags LOCK_FLAG_READ
 *  Lock for read access.
 * 
 *  @var LockFlags LOCK_FLAG_WRITE
 *  Lock for write access.
 * 
 *  @var LockFlags LOCK_FLAG_EXCLUSIVE
 *  Lock for exclusive access.
 * 
 *  @var LockFlags LOCK_FLAG_LAST
 *  First flag that can be used for custom purposes.
 * 
 *  @enum LockFlags
 * 
 * Flags used when locking miniobjects
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%LockFlags operator|(LockFlags, LockFlags)</tt><br>
 * <tt>%LockFlags operator&(LockFlags, LockFlags)</tt><br>
 * <tt>%LockFlags operator^(LockFlags, LockFlags)</tt><br>
 * <tt>%LockFlags operator~(LockFlags)</tt><br>
 * <tt>%LockFlags& operator|=(LockFlags&, LockFlags)</tt><br>
 * <tt>%LockFlags& operator&=(LockFlags&, LockFlags)</tt><br>
 * <tt>%LockFlags& operator^=(LockFlags&, LockFlags)</tt><br>
 */
enum LockFlags
{
  LOCK_FLAG_READ = (1 << 0),
  LOCK_FLAG_WRITE = (1 << 1),
  LOCK_FLAG_EXCLUSIVE = (1 << 2),
  LOCK_FLAG_LAST = (1 << 8)
};

/** @ingroup gstreamermmEnums */
inline LockFlags operator|(LockFlags lhs, LockFlags rhs)
  { return static_cast<LockFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline LockFlags operator&(LockFlags lhs, LockFlags rhs)
  { return static_cast<LockFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline LockFlags operator^(LockFlags lhs, LockFlags rhs)
  { return static_cast<LockFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline LockFlags operator~(LockFlags flags)
  { return static_cast<LockFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline LockFlags& operator|=(LockFlags& lhs, LockFlags rhs)
  { return (lhs = static_cast<LockFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline LockFlags& operator&=(LockFlags& lhs, LockFlags rhs)
  { return (lhs = static_cast<LockFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline LockFlags& operator^=(LockFlags& lhs, LockFlags rhs)
  { return (lhs = static_cast<LockFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::LockFlags> : public Glib::Value_Flags<Gst::LockFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** This is a base class for data which represents qdata.
 */
class QuarkData
{
public:
  virtual ~QuarkData(){}
};

/** This is a base class for some gstreamermm objects.
 * It is similar to Glib::Object but has no GObject property or signal support.
 */
class MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MiniObject CppObjectType;
  typedef GstMiniObject BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstMiniObject*       gobj();

  ///Provides access to the underlying C instance.
  const GstMiniObject* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMiniObject* gobj_copy() const;

protected:
  // Do not derive this.  Gst::MiniObject can neither be constructed nor deleted.
  MiniObject();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  MiniObject(const MiniObject&);
  MiniObject& operator=(const MiniObject&);


public:
  typedef sigc::slot< void > SlotFinalizer;

  ~MiniObject();
   guint get_flags() const;
    void set_flags(const guint& value);
 
   gint get_refcount() const;
 
   gint get_lockstate() const;
 
  
  /** Lock the mini-object with the specified access mode in @a flags.
   * 
   * @param flags Gst::LockFlags.
   * @return <tt>true</tt> if @a object could be locked.
   */
  bool lock(LockFlags flags);
  
  /** Unlock the mini-object with the specified access mode in @a flags.
   * 
   * @param flags Gst::LockFlags.
   */
  void unlock(LockFlags flags);
  
  /** If @a mini_object has the LOCKABLE flag set, check if the current EXCLUSIVE
   * lock on @a object is the only one, this means that changes to the object will
   * not be visible to any other object.
   * 
   * If the LOCKABLE flag is not set, check if the refcount of @a mini_object is
   * exactly 1, meaning that no other reference exists to the object and that the
   * object is therefore writable.
   * 
   * Modification of a mini-object should only be done after verifying that it
   * is writable.
   * 
   * @return <tt>true</tt> if the object is writable.
   */
  bool is_writable() const;

  
  /** Checks if a mini-object is writable.  If not, a writable copy is made and
   * returned.  This gives away the reference to the original mini object,
   * and returns a reference to the new object.
   *
   * MT safe
   * @return A mini-object (possibly the same pointer) that
   * is writable.
   */
  Glib::RefPtr<MiniObject> create_writable();

  /** This sets an opaque, named pointer on a miniobject.
   * The name is specified through a #GQuark (retrived e.g. via
   * g_quark_from_static_string()), and the pointer
   * can be gotten back with get_qdata().
   * Setting a previously set user data pointer, overrides (frees)
   * the old pointer set, using NULL as pointer essentially
   * removes the data stored.
   * @param quark a GQuark, naming the user data pointer.
   * @param data an opaque user data pointer.
   */
  void set_qdata(GQuark quark, QuarkData *data);
  

  /** This function gets back user data pointers stored via
   * set_qdata().
   * @param quark a GQuark, naming the user data pointer.
   * @return the user data pointer set, or NULL.
   */
  QuarkData* get_qdata(GQuark quark) const;
  

  /** This function gets back user data pointers stored via set_qdata()
   * and removes the data from @a object without invoking its destroy() function (if
   * any was set).
   * 
   * @param quark A Quark, naming the user data pointer.
   * @return The user data pointer set, or <tt>0</tt>.
   */
  QuarkData* steal_qdata(GQuark quark);

  // Copying a mini object can be achieved by assignment.
  

  /** Adds notifier when mini object is finalized
   * @param slot notifier.
   */
  void add_finalize_notifier(const SlotFinalizer& slot);

  /** Remove finalize notifier
   */
  void remove_finalize_notifier();

  
private:
  // In this class non-static member cannot exists, so there is a map
  // with key = gobj() and value = handler.
  static std::map<GstMiniObject*, SlotFinalizer*> finalizers;

  static void destroy_qdata(gpointer qdata);

  static void MiniObject_Finalizer_gstreamermm_callback(gpointer userdata, GstMiniObject *obj);


};

} // namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::MiniObject
   */
  Glib::RefPtr<Gst::MiniObject> wrap(GstMiniObject* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_MINIOBJECT_H */

