
#==============================================================================#
# $Id: polygon.rb,v 1.3 2004/01/16 14:37:33 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/polygon.rb,v $
#==============================================================================#

module GRb

  class Polygon

    include Enumerable

    def initialize
      @points = []
    end

    def dup
      return Marshal.load(Marshal.dump(self))
    end

    def add(x, y)
      @points << [x, y]
      return nil
    end

    def each(&block)
      @points.each(&block)
    end

    def move(vx, vy)
      poly = self.dup
      poly.move!(vx, vy)

      return poly
    end

    def move!(vx, vy)
      @points.collect! { |x, y|
        [x + vx, y + vy]
      }

      return nil
    end

    def to_polygon(ox = 0, oy = 0)
      poly = ::GD::Polygon.new
      @points.each { |x, y| poly.addPt(x + ox, y + oy) }

      return poly
    end

  end # Polygon

end # GRb

#==============================================================================#
#==============================================================================#
