
#==============================================================================#
# $Id: color.rb,v 1.2 2004/01/16 14:37:33 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/color.rb,v $
#==============================================================================#

module GRb

  class Color

    def initialize(red, green, blue)
      @red   = red
      @green = green
      @blue  = blue
    end

    attr_reader :red, :green, :blue

    def self.hex(str)
      if /^#?([0-9a-fA-F]{6})$/ =~ str
        return self.new($1[0, 2].hex, $1[2, 2].hex, $1[4, 2].hex)
      else
        raise(ArgumentError, 'invalid color format')
      end
    end

    def self.black
      return self.new(0, 0, 0)
    end

    def self.white
      return self.new(255, 255, 255)
    end

    def self.gray(value = 128)
      return self.new(value, value, value)
    end

    def self.red(value = 255)
      return self.new(value, 0, 0)
    end

    def self.green(value = 255)
      return self.new(0, value, 0)
    end

    def self.blue(value = 255)
      return self.new(0, 0, value)
    end

    def self.yellow(value = 255)
      return self.new(value, value, 0)
    end

    def self.skyblue(value = 255)
      return self.new(0, value, value)
    end

    def self.purple(value = 255)
      return self.new(value, 0, value)
    end

    def +(other)
      red   = [[@red   + other, 255].min, 0].max
      green = [[@green + other, 255].min, 0].max
      blue  = [[@blue  + other, 255].min, 0].max

      return self.class.new(red, green, blue)
    end

    def -(other)
      red   = [[@red   - other, 255].min, 0].max
      green = [[@green - other, 255].min, 0].max
      blue  = [[@blue  - other, 255].min, 0].max

      return self.class.new(red, green, blue)
    end

    def r
      return @red
    end

    def g
      return @green
    end

    def b
      return @blue
    end

    def rgb
      return [@red, @green, @blue]
    end

    def invert
      return self.class.new(255 - @red, 255 - @green, 255 - @blue)
    end

    def set(image)
      return image.color_resolve(@red, @green, @blue)
    end

  end # Color

end # GRb

#==============================================================================#
#==============================================================================#
