
#==============================================================================#
# $Id: facade.rb,v 1.3 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/facade.rb,v $
#==============================================================================#

require 'grb/chart/base/facade'

#==============================================================================#

module GRb

  module Chart

    class XYChartFacadeBase < ChartFacadeBase

      protected

      def create_chart(property)
        major_scale = property.create_major_scale
        minor_scale = property.create_minor_scale
        items       = self.count_items

        graph_layer = self.create_layers(property, major_scale, minor_scale, items)
        scale_label = property.create_scale_label(major_scale)
        axis_label  = property.create_axis_label(items)

        return Layout.new(graph_layer, scale_label, axis_label)
      end

      def create_layers(property, major_scale, minor_scale, items)
        layer = LayerDecorator.new

        layer << property.create_axis_grid_minor(items)
        layer << property.create_scale1_grid_minor(minor_scale)
        layer << property.create_axis_grid_major(items)
        layer << property.create_scale1_grid_major(major_scale)
        layer << property.create_scale1_origin(major_scale)

        layer << property.create_scale1_tics_minor(minor_scale)
        layer << property.create_scale1_tics_major(major_scale)
        layer << property.create_axis_tics_minor(items)
        layer << property.create_axis_tics_major(items)
        layer << property.create_baseline

        layer << self.create_chart_layer(property, major_scale, items)

        return layer
      end

      def create_chart_layer(property, major_scale, items)
        raise(NotImplementedError)
      end

      # FIXME: change method name
      def count_items
        raise(NotImplementedError)
      end

      class Layout

        def initialize(chart, scale, axis)
          @chart = chart
          @scale = scale
          @axis  = axis
        end

        def draw(image, box)
          case [!@scale.nil?, !@axis.nil?]
          when [true, true]
            scale_dx = @scale.dx
            axis_dy  = @axis.dy

            chart_box = GRb::Chart::Box.new
            chart_box.x  = box.x + scale_dx
            chart_box.y  = box.y
            chart_box.dx = box.dx - scale_dx
            chart_box.dy = box.dy - axis_dy

            scale_box = GRb::Chart::Box.new
            scale_box.x  = box.x
            scale_box.y  = box.y
            scale_box.dx = scale_dx
            scale_box.dy = box.dy - axis_dy

            axis_box = GRb::Chart::Box.new
            axis_box.x  = box.x + scale_dx
            axis_box.y  = box.y + box.dy - axis_dy
            axis_box.dx = box.dx - scale_dx
            axis_box.dy = axis_dy

            @chart.draw(image, chart_box)
            @scale.draw(image, scale_box)
            @axis.draw(image, axis_box)
          when [true, false]
            scale_dx = @scale.dx

            chart_box = GRb::Chart::Box.new
            chart_box.x  = box.x + scale_dx
            chart_box.y  = box.y
            chart_box.dx = box.dx - scale_dx
            chart_box.dy = box.dy

            scale_box = GRb::Chart::Box.new
            scale_box.x  = box.x
            scale_box.y  = box.y
            scale_box.dx = scale_dx
            scale_box.dy = box.dy

            @chart.draw(image, chart_box)
            @scale.draw(image, scale_box)
          when [false, true]
            axis_dy = @axis.dy

            chart_box = GRb::Chart::Box.new
            chart_box.x  = box.x
            chart_box.y  = box.y
            chart_box.dx = box.dx
            chart_box.dy = box.dy - axis_dy

            axis_box = GRb::Chart::Box.new
            axis_box.x  = box.x
            axis_box.y  = box.y + box.dy - axis_dy
            axis_box.dx = box.dx
            axis_box.dy = axis_dy

            @chart.draw(image, chart_box)
            @axis.draw(image, axis_box)
          when [false, false]
            @chart.draw(image, box)
          else
            raise 'bug?'
          end
        end

      end # Layout

    end # XYChartFacadeBase

  end # Graph

end # GRb

#==============================================================================#
#==============================================================================#
