
#==============================================================================#
# $Id: base_line.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/xy_base/decorator/base_line.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/no_child_base'

#==============================================================================#

module GRb

  module Chart

    class BaseLineDecorator < NoChildDecoratorBase

      def initialize
        @color = nil
      end

      attr_accessor :color

      def draw(image, box)
        image.rect(box.x, box.y, box.x2, box.y2, @color)
      end

    end # BaseLineDecorator

  end # Chart

end # GRb

#==============================================================================#

if $0 == __FILE__
  require 'grb/image'

  GRb::Image.create_and_write_png_file(200, 200, false, __FILE__.sub(/\.rb/, '.png')) { |image|
    GRb::Chart::Decorator::BaseLine.new.instance_eval {
      self.color = GRb::Color.red(128)
      self.draw(image, GRb::Chart::Box.new(10, 10, 180, 180))
    }
  }
end

#==============================================================================#
#==============================================================================#
