
#==============================================================================#
# $Id: filled_base.rb,v 1.2 2004/01/23 23:02:00 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/marker/filled_base.rb,v $
#==============================================================================#

require 'grb/chart/base/marker/base'

#==============================================================================#

module GRb

  module Chart

    class FilledMarkerBase < MarkerBase

      def initialize(size, color, edge = nil)
        super(size, color)
        @edge = edge
      end

      attr_accessor :edge

      def draw(image, x, y)
        if @edge
          drawing(image, x, y, @color, @edge)
        else
          drawing(image, x, y, @color, nil)
        end
      end

      def drawing(image, x, y, color, edge)
        raise NotImpelementedError, "don't use this class"
      end

    end # FilledMarkerBase

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
