#! /usr/bin/ruby

#==============================================================================#
# $Id: line.rb,v 1.4 2004/01/13 05:35:22 yuya Exp $
#==============================================================================#

require 'grb/grb'

#==============================================================================#

img = GRb::Image.create(300, 200)

grid  = GRb::Color.new(208, 208, 208)
red   = GRb::Color.red(128)
green = GRb::Color.green(128)
blue  = GRb::Color.blue(128)

0.step(300, 10) { |x| img.line(x, 0, x, 199, grid) }
0.step(200, 10) { |y| img.line(0, y, 299, y, grid) }

img.line(10, 10, 290, 10, :color => red, :width => 1)
img.line(10, 20, 290, 20, :color => red, :width => 2)
img.line(10, 30, 290, 30, :color => red, :width => 3)
img.line(10, 40, 290, 40, :color => red, :width => 4)
img.line(10, 50, 290, 50, :color => red, :width => 5)
img.line(10, 60, 290, 60, :color => red, :width => 6)

img.line(10,  80, 290,  80, :color => green, :width => 3, :pattern => [3, 3])
img.line(10,  90, 290,  90, :color => green, :width => 3, :pattern => [5, 5])
img.line(10, 100, 290, 100, :color => green, :width => 3, :pattern => [10, 4])
img.line(10, 110, 290, 110, :color => green, :width => 3, :pattern => [5, 5, 15, 5])
img.line(10, 120, 290, 120, :color => green, :width => 3, :pattern => [5, 5, 15, 5, 30, 5])

img.line(10, 140, 290, 140, :color => blue, :width => 7, :opacity => 100)
img.line(10, 150, 290, 150, :color => blue, :width => 7, :opacity => 80)
img.line(10, 160, 290, 160, :color => blue, :width => 7, :opacity => 60)
img.line(10, 170, 290, 170, :color => blue, :width => 7, :opacity => 40)
img.line(10, 180, 290, 180, :color => blue, :width => 7, :opacity => 20)
img.line(10, 190, 290, 190, :color => blue, :width => 7, :opacity => 10)

img.write_png_file('line.png')

#==============================================================================#
#==============================================================================#
