#! /usr/bin/ruby -Ke

#==============================================================================#
# $Id: line2.rb,v 1.5 2004/01/23 23:02:25 yuya Exp $
#==============================================================================#

require 'grb/chart/line/facade'
require 'grb/chart/base/marker/marker'

#==============================================================================#

data = [
  {
    :name   => 'Circle',
    :color  => GRb::Color.red,
    :value  => [1,2,1,2,4],
    :marker => GRb::Chart::CircleMarker.new(5, GRb::Color.red),
  },
  {
    :name   => 'FilledCircle',
    :color  => GRb::Color.green,
    :value  => [2,3,2,3,5],
    :marker => GRb::Chart::FilledCircleMarker.new(5, GRb::Color.green),
  },
  {
    :name   => 'Lozenge',
    :color  => GRb::Color.blue,
    :value  => [3,4,3,4,6],
    :marker => GRb::Chart::LozengeMarker.new(5, GRb::Color.blue),
  },
  {
    :name   => 'FilledLozenge',
    :color  => GRb::Color.red,
    :value  => [4,5,4,5,7],
    :marker => GRb::Chart::FilledLozengeMarker.new(5, GRb::Color.red),
  },
  {
    :name   => 'Cross',
    :color  => GRb::Color.green,
    :value  => [5,6,5,6,8],
    :marker => GRb::Chart::CrossMarker.new(5, GRb::Color.green),
  },
  {
    :name   => 'Plus',
    :color  => GRb::Color.blue,
    :value  => [6,7,6,7,9],
    :marker => GRb::Chart::PlusMarker.new(5, GRb::Color.blue),
  },
  {
    :name   => 'Square',
    :color  => GRb::Color.red,
    :value  => [7,8,7,8,10],
    :marker => GRb::Chart::SquareMarker.new(5, GRb::Color.red),
  },
  {
    :name   => 'FilledSquare',
    :color  => GRb::Color.green,
    :value  => [8,9,8,9,11],
    :marker => GRb::Chart::FilledSquareMarker.new(5, GRb::Color.green),
  },
  {
    :name   => 'Triangle',
    :color  => GRb::Color.blue,
    :value  => [9,10,9,10,12],
    :marker => GRb::Chart::TriangleMarker.new(5, GRb::Color.blue),
  },
  {
    :name   => 'FilledTriangle',
    :color  => GRb::Color.red,
    :value  => [10,11,10,11,13],
    :marker => GRb::Chart::FilledTriangleMarker.new(5, GRb::Color.red),
  },
  {
    :name   => 'InverseTriangle',
    :color  => GRb::Color.green,
    :value  => [11,12,11,12,14],
    :marker => GRb::Chart::InverseTriangleMarker.new(5, GRb::Color.green),
  },
  {
    :name   => 'FilledInverseTriangle',
    :color  => GRb::Color.blue,
    :value  => [12,13,12,13,15],
    :marker => GRb::Chart::FilledInverseTriangleMarker.new(5, GRb::Color.blue),
  },
  {
    :name   => 'Star',
    :color  => GRb::Color.red,
    :value  => [13,14,13,14,16],
    :marker => GRb::Chart::StarMarker.new(5, GRb::Color.red),
  },
  {
    :name   => 'FilledStar',
    :color  => GRb::Color.green,
    :value  => [14,15,14,15,17],
    :marker => GRb::Chart::FilledStarMarker.new(5, GRb::Color.green),
  },
  {
    :name   => 'Pentagon',
    :color  => GRb::Color.blue,
    :value  => [15,16,15,16,18],
    :marker => GRb::Chart::PentagonMarker.new(5, GRb::Color.blue),
  },
  {
    :name   => 'FilledPentagon',
    :color  => GRb::Color.red,
    :value  => [16,17,16,17,19],
    :marker => GRb::Chart::FilledPentagonMarker.new(5, GRb::Color.red),
  },
]

#==============================================================================#

facade = GRb::Chart::LineChartFacade.create(500, 400)
facade.title.text                      = 'Line Chart Sample 2'
facade.legend.interval                 = 3
facade.legend.marker.width             = 20
facade.legend.marker.height            = 10
facade.chart.scale1.maximum            = 20
facade.chart.scale1.minimum            = 0
facade.chart.scale1.interval.major     = 5
facade.chart.scale1.interval.minor     = 1
facade.chart.scale1.grid.major.visible = false
facade.chart.scale1.grid.minor.visible = false
facade.chart.axis.grid.major.visible   = false
facade.chart.axis.grid.minor.visible   = false
facade.chart.axis.label.text           = ('A'..'E').to_a
facade.data                            = data
facade.write_png_file('line2.png')

#==============================================================================#
#==============================================================================#
