/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_ENTRY_FACTORY_H__
#define __GPASS_ENTRY_FACTORY_H__

#include "gpass/entry.h"

G_BEGIN_DECLS

typedef struct GPassEntryFactory GPassEntryFactory;

/***********************************************************
 *
 * GPassEntryFactoryCursor
 *
 ***********************************************************/
#define GPASS_TYPE_ENTRY_FACTORY_CURSOR (gpass_entry_factory_cursor_get_type())
#define GPASS_ENTRY_FACTORY_CURSOR(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ENTRY_FACTORY_CURSOR, \
                                GPassEntryFactoryCursor))
#define GPASS_ENTRY_FACTORY_CURSOR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ENTRY_FACTORY_CURSOR, \
                             GPassEntryFactoryCursorClass))
#define GPASS_IS_ENTRY_FACTORY_CURSOR(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ENTRY_FACTORY_CURSOR))
#define GPASS_IS_ENTRY_FACTORY_CURSOR_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ENTRY_FACTORY_CURSOR))
#define GPASS_ENTRY_FACTORY_CURSOR_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ENTRY_FACTORY_CURSOR, \
                               GPassEntryFactoryCursorClass))

typedef struct {
    GObject parent;

    GPassEntryFactory *entry_factory;
    gint index;
    gint max_index;
} GPassEntryFactoryCursor;

typedef struct {
    GObjectClass parent;
} GPassEntryFactoryCursorClass;

GType gpass_entry_factory_cursor_get_type(void);

void gpass_entry_factory_cursor_next(GPassEntryFactoryCursor *self);
GError *gpass_entry_factory_cursor_seek(GPassEntryFactoryCursor *self,
                                        const gchar *type);
gboolean gpass_entry_factory_cursor_is_done(GPassEntryFactoryCursor *self);

/***********************************************************
 *
 * GPassEntryFactory
 *
 ***********************************************************/
#define GPASS_TYPE_ENTRY_FACTORY (gpass_entry_factory_get_type())
#define GPASS_ENTRY_FACTORY(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ENTRY_FACTORY, \
                                GPassEntryFactory))
#define GPASS_ENTRY_FACTORY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ENTRY_FACTORY, \
                             GPassEntryFactoryClass))
#define GPASS_IS_ENTRY_FACTORY(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ENTRY_FACTORY))
#define GPASS_IS_ENTRY_FACTORY_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ENTRY_FACTORY))
#define GPASS_ENTRY_FACTORY_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ENTRY_FACTORY, \
                               GPassEntryFactoryClass))

struct GPassEntryFactory {
    GObject parent;
    
    GHashTable *get_types;
};

typedef struct {
    GObjectClass parent;
} GPassEntryFactoryClass;

GType gpass_entry_factory_get_type(void);

GError *gpass_entry_factory_create_entry(GPassEntryFactory *self,
                                         const gchar *type,
                                         GPassEntry **entry);
GError *gpass_entry_factory_create_default_entry(GPassEntryFactory *self,
                                                 GPassEntry **entry);
GPassEntryFactoryCursor *
gpass_entry_factory_create_cursor(GPassEntryFactory *self);

G_END_DECLS

#endif /* #ifndef __GPASS_ENTRY_FACTORY_H__ */
