#ifndef MAIN_H
#define MAIN_H

#include <gnome.h>

/* Maxiumum length of a person's name */
#define MAX_NAME_LENGTH 20

/* Maximum length of a file path */
#define MAX_FILE_PATH_LENGTH 255

/*#define TRACEPROCS*/
/*#define TRACEVARS*/

#ifdef TRACEPROCS
#define TRACE(x) printf( "%s:%d - %s\n", __FILE__, __LINE__, #x );
#else
#define TRACE(x)
#endif

#ifdef TRACEVARS
#define TRACEINT(var_name) printf( "%s:%d - %s=%d\n", __FILE__, __LINE__, #var_name, var_name );
#define TRACESTR(var_name) printf( "%s:%d - %s=%s\n", __FILE__, __LINE__, #var_name, var_name );
#define TRACEGSTR(var_name) if(var_name==NULL) { printf( "%s:%d - %s=%p\n", __FILE__, __LINE__, #var_name, var_name ); } else { printf( "%s:%d - %s=%s\n", __FILE__, __LINE__, #var_name, var_name->str ); }
#define TRACEPTR(var_name) printf( "%s:%d - %s=%p\n", __FILE__, __LINE__, #var_name, var_name );
#else
#define TRACEINT(var_name)
#define TRACESTR(var_name)
#define TRACEGSTR(var_name)
#define TRACEPTR(var_name)
#endif

GtkWidget *app1;	/* The main application window */
GtkWidget *about2;	/* The about box */
GtkWidget *dialog1;	/* The Reset Scores? question */
GtkWidget *dialog3;	/* The High Score question */

GtkMenuItem* new1;			/* The new game menu item */
GtkMenuItem* pause_game1;	/* The pause game menu item */
GtkMenuItem* restart_game1;	/* The restart game menu item */
GtkMenuItem* end_game1;		/* The end game menu item */
GtkMenuItem* levels1;		  /* The levels menu */

GnomeAppBar *appbar1;	/* The status bar of the main window */

/* --- */

int main( int argc, char *argv[] );

void main_quit();

void main_deallocate_memory();

/* ------------------------ */

void _init_gui();

#endif
