/* GNOME Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>


#define GNOME_SCAN_TYPE_BACKEND (gnome_scan_backend_get_type ())
#define GNOME_SCAN_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackend))
#define GNOME_SCAN_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))
#define GNOME_SCAN_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_BACKEND))
#define GNOME_SCAN_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_BACKEND, GnomeScanBackendClass))

typedef struct _GnomeScanBackend GnomeScanBackend;
typedef struct _GnomeScanBackendClass GnomeScanBackendClass;
typedef struct _GnomeScanBackendPrivate GnomeScanBackendPrivate;

#define GNOME_SCAN_TYPE_NODE (gnome_scan_node_get_type ())
#define GNOME_SCAN_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNode))
#define GNOME_SCAN_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))
#define GNOME_SCAN_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_NODE))
#define GNOME_SCAN_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_NODE, GnomeScanNodeClass))

typedef struct _GnomeScanNode GnomeScanNode;
typedef struct _GnomeScanNodeClass GnomeScanNodeClass;

#define GNOME_SCAN_TYPE_SCANNER (gnome_scan_scanner_get_type ())
#define GNOME_SCAN_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScanner))
#define GNOME_SCAN_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))
#define GNOME_SCAN_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_SCANNER))
#define GNOME_SCAN_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_SCANNER, GnomeScanScannerClass))

typedef struct _GnomeScanScanner GnomeScanScanner;
typedef struct _GnomeScanScannerClass GnomeScanScannerClass;

struct _GnomeScanBackend {
	GObject parent_instance;
	GnomeScanBackendPrivate * priv;
};

struct _GnomeScanBackendClass {
	GObjectClass parent_class;
	void* (*probe_scanners) (GnomeScanBackend* self);
};


static gpointer gnome_scan_backend_parent_class = NULL;

GType gnome_scan_backend_get_type (void);
enum  {
	GNOME_SCAN_BACKEND_DUMMY_PROPERTY
};
void* gnome_scan_backend_probe_scanners (GnomeScanBackend* self);
static void* gnome_scan_backend_real_probe_scanners (GnomeScanBackend* self);
GnomeScanBackend* gnome_scan_backend_construct (GType object_type);
GType gnome_scan_node_get_type (void);
GType gnome_scan_scanner_get_type (void);



static void* gnome_scan_backend_real_probe_scanners (GnomeScanBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gnome_scan_backend_probe_scanners'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


void* gnome_scan_backend_probe_scanners (GnomeScanBackend* self) {
	return GNOME_SCAN_BACKEND_GET_CLASS (self)->probe_scanners (self);
}


GnomeScanBackend* gnome_scan_backend_construct (GType object_type) {
	GnomeScanBackend * self;
	self = (GnomeScanBackend*) g_object_new (object_type, NULL);
	return self;
}


static void gnome_scan_backend_class_init (GnomeScanBackendClass * klass) {
	gnome_scan_backend_parent_class = g_type_class_peek_parent (klass);
	GNOME_SCAN_BACKEND_CLASS (klass)->probe_scanners = gnome_scan_backend_real_probe_scanners;
	g_signal_new ("scanner_added", GNOME_SCAN_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GNOME_SCAN_TYPE_SCANNER);
	g_signal_new ("scanner_removed", GNOME_SCAN_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GNOME_SCAN_TYPE_SCANNER);
	g_signal_new ("probe_done", GNOME_SCAN_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gnome_scan_backend_instance_init (GnomeScanBackend * self) {
}


GType gnome_scan_backend_get_type (void) {
	static GType gnome_scan_backend_type_id = 0;
	if (gnome_scan_backend_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanBackend), 0, (GInstanceInitFunc) gnome_scan_backend_instance_init, NULL };
		gnome_scan_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomeScanBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_backend_type_id;
}




