/* RecordingReader.c generated by valac 0.25.1, the Vala compiler
 * generated from RecordingReader.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>


#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;
typedef struct _DVBioRecordingReaderPrivate DVBioRecordingReaderPrivate;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBioRecordingReader {
	GObject parent_instance;
	DVBioRecordingReaderPrivate * priv;
};

struct _DVBioRecordingReaderClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingReaderPrivate {
	GFile* _directory;
	DVBRecordingsStore* _store;
	gint _max_recursion;
};


static gpointer dvb_io_recording_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_recording_reader_log;
static DVBLoggingLogger* dvb_io_recording_reader_log = NULL;

GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
#define DVB_IO_RECORDING_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderPrivate))
enum  {
	DVB_IO_RECORDING_READER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_READER_DIRECTORY,
	DVB_IO_RECORDING_READER_STORE,
	DVB_IO_RECORDING_READER_MAX_RECURSION
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_IO_RECORDING_READER_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir, gint depth);
static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gint dvb_io_recording_reader_get_max_recursion (DVBioRecordingReader* self);
GType dvb_recording_get_type (void) G_GNUC_CONST;
DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error);
DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self);
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value);
static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value);
void dvb_io_recording_reader_set_max_recursion (DVBioRecordingReader* self, gint value);
static void dvb_io_recording_reader_finalize (GObject* obj);
static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * @recordingsbasedir: The directory to search
         */
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	DVBioRecordingReader * self = NULL;
	GFile* _tmp0_ = NULL;
	DVBRecordingsStore* _tmp1_ = NULL;
	g_return_val_if_fail (recordingsbasedir != NULL, NULL);
	g_return_val_if_fail (recstore != NULL, NULL);
	_tmp0_ = recordingsbasedir;
	_tmp1_ = recstore;
	self = (DVBioRecordingReader*) g_object_new (object_type, "directory", _tmp0_, "store", _tmp1_, NULL);
	return self;
}


DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	return dvb_io_recording_reader_construct (DVB_IO_TYPE_RECORDING_READER, recordingsbasedir, recstore);
}


/**
         * Searches recursively in the given directory
         * for "info.rec" files, restores a new Recording
         * from that file and adds it to itsself.
         */
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_directory;
	_tmp1_ = g_file_query_exists (_tmp0_, NULL);
	if (!_tmp1_) {
		DVBLoggingLogger* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = dvb_io_recording_reader_log;
		_tmp3_ = self->priv->_directory;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		dvb_logging_logger_debug (_tmp2_, "RecordingReader.vala:52: Directory %s does not exist", _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_directory;
	_tmp7_ = dvb_io_recording_reader_restore_from_dir (self, _tmp6_, 0);
	result = _tmp7_;
	return result;
}


static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory) {
	gboolean result = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileType _tmp8_ = 0;
	GFileInfo* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (directory != NULL, FALSE);
	{
		GFileInfo* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		_tmp1_ = directory;
		_tmp2_ = g_file_query_info (_tmp1_, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = dvb_io_recording_reader_log;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		dvb_logging_logger_error (_tmp4_, "RecordingReader.vala:64: Could not retrieve attributes: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = info;
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
	if (_tmp8_ != G_FILE_TYPE_DIRECTORY) {
		DVBLoggingLogger* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = dvb_io_recording_reader_log;
		_tmp10_ = directory;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		dvb_logging_logger_error (_tmp9_, "RecordingReader.vala:69: %s is not a directory", _tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp13_ = info;
	_tmp14_ = g_file_info_get_attribute_boolean (_tmp13_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp14_) {
		DVBLoggingLogger* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp15_ = dvb_io_recording_reader_log;
		_tmp16_ = directory;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		dvb_logging_logger_error (_tmp15_, "RecordingReader.vala:74: Cannot read %s", _tmp18_);
		_g_free0 (_tmp18_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir, gint depth) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFileEnumerator* files = NULL;
	gboolean success = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordingsbasedir != NULL, FALSE);
	_tmp0_ = depth;
	_tmp1_ = self->priv->_max_recursion;
	if (_tmp0_ >= _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = recordingsbasedir;
	_tmp3_ = dvb_io_recording_reader_is_readable_dir (_tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		GFileEnumerator* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_ = NULL;
		GFileEnumerator* _tmp7_ = NULL;
		_tmp5_ = recordingsbasedir;
		_tmp6_ = g_file_enumerate_children (_tmp5_, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (files);
		files = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = dvb_io_recording_reader_log;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp8_, "RecordingReader.vala:92: Could not read directory: %s", _tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (files);
		return result;
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	success = TRUE;
	{
		GFileInfo* childinfo = NULL;
		while (TRUE) {
			GFileInfo* _tmp11_ = NULL;
			GFileEnumerator* _tmp12_ = NULL;
			GFileInfo* _tmp13_ = NULL;
			GFileInfo* _tmp14_ = NULL;
			GFileInfo* _tmp15_ = NULL;
			GFileInfo* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			guint32 type = 0U;
			GFileInfo* _tmp18_ = NULL;
			guint32 _tmp19_ = 0U;
			GFile* child = NULL;
			GFile* _tmp20_ = NULL;
			GFileInfo* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GFile* _tmp23_ = NULL;
			guint32 _tmp24_ = 0U;
			_tmp12_ = files;
			_tmp13_ = g_file_enumerator_next_file (_tmp12_, NULL, &_inner_error_);
			_tmp11_ = _tmp13_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (childinfo);
				goto __catch11_g_error;
			}
			_tmp14_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (childinfo);
			childinfo = _tmp14_;
			_tmp15_ = childinfo;
			if (!(_tmp15_ != NULL)) {
				_g_object_unref0 (_tmp11_);
				break;
			}
			_tmp16_ = childinfo;
			_tmp17_ = g_file_info_get_is_hidden (_tmp16_);
			if (_tmp17_) {
				_g_object_unref0 (_tmp11_);
				continue;
			}
			_tmp18_ = childinfo;
			_tmp19_ = g_file_info_get_attribute_uint32 (_tmp18_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			type = _tmp19_;
			_tmp20_ = recordingsbasedir;
			_tmp21_ = childinfo;
			_tmp22_ = g_file_info_get_name (_tmp21_);
			_tmp23_ = g_file_get_child (_tmp20_, _tmp22_);
			child = _tmp23_;
			_tmp24_ = type;
			switch (_tmp24_) {
				case G_FILE_TYPE_DIRECTORY:
				{
					GFile* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					_tmp25_ = child;
					_tmp26_ = depth;
					dvb_io_recording_reader_restore_from_dir (self, _tmp25_, _tmp26_ + 1);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					_tmp27_ = childinfo;
					_tmp28_ = g_file_info_get_name (_tmp27_);
					if (g_strcmp0 (_tmp28_, "info.rec") == 0) {
						DVBRecording* rec = NULL;
						DVBRecording* _tmp36_ = NULL;
						rec = NULL;
						{
							DVBRecording* _tmp29_ = NULL;
							GFile* _tmp30_ = NULL;
							DVBRecording* _tmp31_ = NULL;
							DVBRecording* _tmp32_ = NULL;
							_tmp30_ = child;
							_tmp31_ = dvb_io_recording_reader_deserialize (self, _tmp30_, &_inner_error_);
							_tmp29_ = _tmp31_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								goto __catch12_g_error;
							}
							_tmp32_ = _tmp29_;
							_tmp29_ = NULL;
							_g_object_unref0 (rec);
							rec = _tmp32_;
							_g_object_unref0 (_tmp29_);
						}
						goto __finally12;
						__catch12_g_error:
						{
							GError* e = NULL;
							DVBLoggingLogger* _tmp33_ = NULL;
							GError* _tmp34_ = NULL;
							const gchar* _tmp35_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp33_ = dvb_io_recording_reader_log;
							_tmp34_ = e;
							_tmp35_ = _tmp34_->message;
							dvb_logging_logger_error (_tmp33_, "RecordingReader.vala:120: Could not deserialize recording: %s", _tmp35_);
							_g_error_free0 (e);
						}
						__finally12:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (rec);
							_g_object_unref0 (child);
							_g_object_unref0 (_tmp11_);
							_g_object_unref0 (childinfo);
							goto __catch11_g_error;
						}
						_tmp36_ = rec;
						if (_tmp36_ != NULL) {
							DVBLoggingLogger* _tmp37_ = NULL;
							GFile* _tmp38_ = NULL;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_ = NULL;
							DVBRecordingsStore* _tmp41_ = NULL;
							DVBRecording* _tmp42_ = NULL;
							_tmp37_ = dvb_io_recording_reader_log;
							_tmp38_ = child;
							_tmp39_ = g_file_get_path (_tmp38_);
							_tmp40_ = _tmp39_;
							dvb_logging_logger_debug (_tmp37_, "RecordingReader.vala:125: Restored recording from %s", _tmp40_);
							_g_free0 (_tmp40_);
							_tmp41_ = self->priv->_store;
							_tmp42_ = rec;
							dvb_recordings_store_add_and_monitor (_tmp41_, _tmp42_);
						}
						_g_object_unref0 (rec);
					}
					break;
				}
				default:
				break;
			}
			_g_object_unref0 (child);
			_g_object_unref0 (_tmp11_);
		}
		_g_object_unref0 (childinfo);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp43_ = NULL;
		GError* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp43_ = dvb_io_recording_reader_log;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		dvb_logging_logger_error (_tmp43_, "RecordingReader.vala:136: %s", _tmp45_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally11:
	{
		{
			GFileEnumerator* _tmp46_ = NULL;
			_tmp46_ = files;
			g_file_enumerator_close (_tmp46_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch13_g_error;
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp47_ = NULL;
			GError* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp47_ = dvb_io_recording_reader_log;
			_tmp48_ = e;
			_tmp49_ = _tmp48_->message;
			dvb_logging_logger_error (_tmp47_, "RecordingReader.vala:142: Could not close file: %s", _tmp49_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = success;
	_g_object_unref0 (files);
	return result;
}


DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error) {
	DVBRecording* result = NULL;
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInputStream* _tmp2_ = NULL;
	GDataInputStream* reader = NULL;
	GDataInputStream* _tmp3_ = NULL;
	gchar* line = NULL;
	gsize len = 0UL;
	gint line_number = 0;
	DVBRecording* rec = NULL;
	DVBRecording* _tmp4_ = NULL;
	GString* description = NULL;
	GString* _tmp5_ = NULL;
	GDataInputStream* _tmp50_ = NULL;
	DVBRecording* _tmp51_ = NULL;
	GString* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp1_ = file;
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = g_data_input_stream_new ((GInputStream*) _tmp0_);
	reader = _tmp3_;
	line = NULL;
	line_number = 0;
	_tmp4_ = dvb_recording_new ();
	rec = _tmp4_;
	_tmp5_ = g_string_new ("");
	description = _tmp5_;
	while (TRUE) {
		gchar* _tmp6_ = NULL;
		GDataInputStream* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp49_ = 0;
		_tmp7_ = reader;
		_tmp9_ = g_data_input_stream_read_line (_tmp7_, &_tmp8_, NULL, &_inner_error_);
		len = _tmp8_;
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (description);
			_g_object_unref0 (rec);
			_g_free0 (line);
			_g_object_unref0 (reader);
			_g_object_unref0 (_tmp0_);
			return NULL;
		}
		_tmp10_ = _tmp6_;
		_tmp6_ = NULL;
		_g_free0 (line);
		line = _tmp10_;
		_tmp11_ = line;
		if (!(_tmp11_ != NULL)) {
			_g_free0 (_tmp6_);
			break;
		}
		_tmp12_ = line_number;
		switch (_tmp12_) {
			case 0:
			{
				DVBRecording* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				_tmp13_ = rec;
				_tmp14_ = line;
				_tmp15_ = atoi (_tmp14_);
				dvb_recording_set_Id (_tmp13_, (guint32) _tmp15_);
				break;
			}
			case 1:
			{
				DVBRecording* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				_tmp16_ = rec;
				_tmp17_ = line;
				dvb_recording_set_ChannelName (_tmp16_, _tmp17_);
				break;
			}
			case 2:
			{
				GFile* _tmp18_ = NULL;
				gsize _tmp19_ = 0UL;
				DVBRecording* _tmp22_ = NULL;
				_tmp19_ = len;
				if (_tmp19_ == ((gsize) 0)) {
					_g_object_unref0 (_tmp18_);
					_tmp18_ = NULL;
				} else {
					const gchar* _tmp20_ = NULL;
					GFile* _tmp21_ = NULL;
					_tmp20_ = line;
					_tmp21_ = g_file_new_for_path (_tmp20_);
					_g_object_unref0 (_tmp18_);
					_tmp18_ = _tmp21_;
				}
				_tmp22_ = rec;
				dvb_recording_set_Location (_tmp22_, _tmp18_);
				_g_object_unref0 (_tmp18_);
				break;
			}
			case 3:
			{
				{
					gint year = 0;
					gint month = 0;
					gint day = 0;
					gint hour = 0;
					gint minute = 0;
					const gchar* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					gint _tmp28_ = 0;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					_tmp23_ = line;
					sscanf (_tmp23_, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute);
					_tmp28_ = year;
					if (_tmp28_ >= 1900) {
						gint _tmp29_ = 0;
						_tmp29_ = month;
						_tmp27_ = _tmp29_ >= 1;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						gint _tmp30_ = 0;
						_tmp30_ = day;
						_tmp26_ = _tmp30_ >= 1;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						gint _tmp31_ = 0;
						_tmp31_ = hour;
						_tmp25_ = _tmp31_ >= 0;
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						gint _tmp32_ = 0;
						_tmp32_ = minute;
						_tmp24_ = _tmp32_ >= 0;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						DVBRecording* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						gint _tmp36_ = 0;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						struct tm _tmp39_ = {0};
						_tmp33_ = rec;
						_tmp34_ = year;
						_tmp35_ = month;
						_tmp36_ = day;
						_tmp37_ = hour;
						_tmp38_ = minute;
						dvb_utils_create_time (_tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_, 0, &_tmp39_);
						dvb_recording_set_StartTime (_tmp33_, &_tmp39_);
					}
					break;
				}
			}
			case 4:
			{
				DVBRecording* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				_tmp40_ = rec;
				_tmp41_ = line;
				_tmp42_ = atoi (_tmp41_);
				dvb_recording_set_Length (_tmp40_, (gint64) _tmp42_);
				break;
			}
			case 5:
			{
				const gchar* _tmp43_ = NULL;
				gsize _tmp44_ = 0UL;
				DVBRecording* _tmp46_ = NULL;
				_tmp44_ = len;
				if (_tmp44_ == ((gsize) 0)) {
					_tmp43_ = NULL;
				} else {
					const gchar* _tmp45_ = NULL;
					_tmp45_ = line;
					_tmp43_ = _tmp45_;
				}
				_tmp46_ = rec;
				dvb_recording_set_Name (_tmp46_, _tmp43_);
				break;
			}
			default:
			{
				GString* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				_tmp47_ = description;
				_tmp48_ = line;
				g_string_append (_tmp47_, _tmp48_);
				break;
			}
		}
		_tmp49_ = line_number;
		line_number = _tmp49_ + 1;
		_g_free0 (_tmp6_);
	}
	_tmp50_ = reader;
	g_input_stream_close ((GInputStream*) _tmp50_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (description);
		_g_object_unref0 (rec);
		_g_free0 (line);
		_g_object_unref0 (reader);
		_g_object_unref0 (_tmp0_);
		return NULL;
	}
	_tmp51_ = rec;
	_tmp52_ = description;
	_tmp53_ = _tmp52_->str;
	dvb_recording_set_Description (_tmp51_, _tmp53_);
	result = rec;
	_g_string_free0 (description);
	_g_free0 (line);
	_g_object_unref0 (reader);
	_g_object_unref0 (_tmp0_);
	return result;
}


GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
	g_object_notify ((GObject *) self, "directory");
}


DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self) {
	DVBRecordingsStore* result;
	DVBRecordingsStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value) {
	DVBRecordingsStore* _tmp0_ = NULL;
	DVBRecordingsStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp1_;
	g_object_notify ((GObject *) self, "store");
}


gint dvb_io_recording_reader_get_max_recursion (DVBioRecordingReader* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_recursion;
	result = _tmp0_;
	return result;
}


void dvb_io_recording_reader_set_max_recursion (DVBioRecordingReader* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_recursion = _tmp0_;
	g_object_notify ((GObject *) self, "max-recursion");
}


static void dvb_io_recording_reader_class_init (DVBioRecordingReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_recording_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_recording_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_recording_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_STORE, g_param_spec_object ("store", "store", "store", DVB_TYPE_RECORDINGS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_MAX_RECURSION, g_param_spec_int ("max-recursion", "max-recursion", "max-recursion", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_recording_reader_log = _tmp1_;
}


static void dvb_io_recording_reader_instance_init (DVBioRecordingReader * self) {
	self->priv = DVB_IO_RECORDING_READER_GET_PRIVATE (self);
	self->priv->_max_recursion = 3;
}


static void dvb_io_recording_reader_finalize (GObject* obj) {
	DVBioRecordingReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (dvb_io_recording_reader_parent_class)->finalize (obj);
}


GType dvb_io_recording_reader_get_type (void) {
	static volatile gsize dvb_io_recording_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingReader), 0, (GInstanceInitFunc) dvb_io_recording_reader_instance_init, NULL };
		GType dvb_io_recording_reader_type_id;
		dvb_io_recording_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_reader_type_id__volatile, dvb_io_recording_reader_type_id);
	}
	return dvb_io_recording_reader_type_id__volatile;
}


static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		g_value_set_object (value, dvb_io_recording_reader_get_directory (self));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		g_value_set_object (value, dvb_io_recording_reader_get_store (self));
		break;
		case DVB_IO_RECORDING_READER_MAX_RECURSION:
		g_value_set_int (value, dvb_io_recording_reader_get_max_recursion (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		dvb_io_recording_reader_set_directory (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		dvb_io_recording_reader_set_store (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_MAX_RECURSION:
		dvb_io_recording_reader_set_max_recursion (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



