/* IDBusManager.c generated by valac 0.25.1, the Vala compiler
 * generated from IDBusManager.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ADAPTER_INFO (dvb_adapter_info_get_type ())
typedef struct _DVBAdapterInfo DVBAdapterInfo;

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())
typedef GDBusProxy DVBIDBusManagerProxy;
typedef GDBusProxyClass DVBIDBusManagerProxyClass;

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBAdapterInfo {
	gchar* name;
	gboolean type_t;
	gboolean type_s;
	gboolean type_c;
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetAdapterInfo) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
};



GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_adapter_info_get_type (void) G_GNUC_CONST;
DVBAdapterInfo* dvb_adapter_info_dup (const DVBAdapterInfo* self);
void dvb_adapter_info_free (DVBAdapterInfo* self);
void dvb_adapter_info_copy (const DVBAdapterInfo* self, DVBAdapterInfo* dest);
void dvb_adapter_info_destroy (DVBAdapterInfo* self);
GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
gboolean dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
char** dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1, GError** error);
gboolean dvb_id_bus_manager_GetDeviceGroup (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
gboolean dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
gboolean dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
gint dvb_id_bus_manager_GetDeviceGroupSize (DVBIDBusManager* self, GError** error);
DVBChannelGroupInfo* dvb_id_bus_manager_GetChannelGroups (DVBIDBusManager* self, int* result_length1, GError** error);
gboolean dvb_id_bus_manager_AddChannelGroup (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
gboolean dvb_id_bus_manager_RemoveChannelGroup (DVBIDBusManager* self, gint channel_group_id, GError** error);
GHashTable** dvb_id_bus_manager_GetDevices (DVBIDBusManager* self, int* result_length1, GError** error);
gboolean dvb_id_bus_manager_GetAdapterInfo (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
static void dvb_id_bus_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_manager_group_added (DVBIDBusManager* self, GVariant* parameters);
static void _dbus_handle_dvb_id_bus_manager_group_removed (DVBIDBusManager* self, GVariant* parameters);
static gboolean dvb_id_bus_manager_proxy_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
static char** dvb_id_bus_manager_proxy_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_manager_proxy_GetDeviceGroup (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
static gboolean dvb_id_bus_manager_proxy_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
static gboolean dvb_id_bus_manager_proxy_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
static gint dvb_id_bus_manager_proxy_GetDeviceGroupSize (DVBIDBusManager* self, GError** error);
static DVBChannelGroupInfo* dvb_id_bus_manager_proxy_GetChannelGroups (DVBIDBusManager* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_manager_proxy_AddChannelGroup (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
static gboolean dvb_id_bus_manager_proxy_RemoveChannelGroup (DVBIDBusManager* self, gint channel_group_id, GError** error);
static GHashTable** dvb_id_bus_manager_proxy_GetDevices (DVBIDBusManager* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_manager_proxy_GetAdapterInfo (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
static void dvb_id_bus_manager_proxy_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface* iface);
static void _dbus_dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetDeviceGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetDeviceGroupSize (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length);
static void _dbus_dvb_id_bus_manager_GetChannelGroups (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_AddChannelGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_RemoveChannelGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetDevices (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_manager_GetAdapterInfo (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void dvb_id_bus_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dvb_id_bus_manager_group_added (GObject* _sender, guint group_id, gpointer* _data);
static void _dbus_dvb_id_bus_manager_group_removed (GObject* _sender, guint group_id, gpointer* _data);
static void _dvb_id_bus_manager_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_type = {-1, "type", "i"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_opath = {-1, "opath", "o"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_dbusiface = {-1, "dbusiface", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_in[] = {&_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_adapter, &_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_frontend, &_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_type, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_opath, &_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_dbusiface, &_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetScannerForDevice = {-1, "GetScannerForDevice", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetScannerForDevice_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_result = {-1, "result", "ao"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetRegisteredDeviceGroups = {-1, "GetRegisteredDeviceGroups", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetRegisteredDeviceGroups_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_group_id = {-1, "group_id", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_opath = {-1, "opath", "o"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_in[] = {&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_group_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_opath, &_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetDeviceGroup = {-1, "GetDeviceGroup", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroup_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_type = {-1, "type", "i"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_channels_conf = {-1, "channels_conf", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_recordings_dir = {-1, "recordings_dir", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_in[] = {&_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_adapter, &_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_frontend, &_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_type, &_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_channels_conf, &_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_recordings_dir, &_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_name, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_out[] = {&_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_AddDeviceToNewGroup = {-1, "AddDeviceToNewGroup", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_AddDeviceToNewGroup_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_in[] = {&_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_adapter, &_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_frontend, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_name, &_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetNameOfRegisteredDevice = {-1, "GetNameOfRegisteredDevice", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetNameOfRegisteredDevice_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_result = {-1, "result", "i"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetDeviceGroupSize = {-1, "GetDeviceGroupSize", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDeviceGroupSize_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_result = {-1, "result", "a(is)"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetChannelGroups = {-1, "GetChannelGroups", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetChannelGroups_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_channel_group_id = {-1, "channel_group_id", "i"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_in[] = {&_dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_name, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_out[] = {&_dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_channel_group_id, &_dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_AddChannelGroup = {-1, "AddChannelGroup", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_AddChannelGroup_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_channel_group_id = {-1, "channel_group_id", "i"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_in[] = {&_dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_channel_group_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_out[] = {&_dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_RemoveChannelGroup = {-1, "RemoveChannelGroup", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_RemoveChannelGroup_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetDevices_result = {-1, "result", "aa{ss}"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDevices_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetDevices_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetDevices_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetDevices = {-1, "GetDevices", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDevices_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetDevices_out)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_adapter = {-1, "adapter", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_frontend = {-1, "frontend", "u"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_info = {-1, "info", "(sbbb)"};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_in[] = {&_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_adapter, &_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_frontend, NULL};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_out[] = {&_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_info, &_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_manager_dbus_method_info_GetAdapterInfo = {-1, "GetAdapterInfo", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_in), (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_GetAdapterInfo_out)};
static const GDBusMethodInfo * const _dvb_id_bus_manager_dbus_method_info[] = {&_dvb_id_bus_manager_dbus_method_info_GetScannerForDevice, &_dvb_id_bus_manager_dbus_method_info_GetRegisteredDeviceGroups, &_dvb_id_bus_manager_dbus_method_info_GetDeviceGroup, &_dvb_id_bus_manager_dbus_method_info_AddDeviceToNewGroup, &_dvb_id_bus_manager_dbus_method_info_GetNameOfRegisteredDevice, &_dvb_id_bus_manager_dbus_method_info_GetDeviceGroupSize, &_dvb_id_bus_manager_dbus_method_info_GetChannelGroups, &_dvb_id_bus_manager_dbus_method_info_AddChannelGroup, &_dvb_id_bus_manager_dbus_method_info_RemoveChannelGroup, &_dvb_id_bus_manager_dbus_method_info_GetDevices, &_dvb_id_bus_manager_dbus_method_info_GetAdapterInfo, NULL};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_group_added_group_id = {-1, "group_id", "u"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_group_added[] = {&_dvb_id_bus_manager_dbus_arg_info_group_added_group_id, NULL};
static const GDBusSignalInfo _dvb_id_bus_manager_dbus_signal_info_group_added = {-1, "GroupAdded", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_group_added)};
static const GDBusArgInfo _dvb_id_bus_manager_dbus_arg_info_group_removed_group_id = {-1, "group_id", "u"};
static const GDBusArgInfo * const _dvb_id_bus_manager_dbus_arg_info_group_removed[] = {&_dvb_id_bus_manager_dbus_arg_info_group_removed_group_id, NULL};
static const GDBusSignalInfo _dvb_id_bus_manager_dbus_signal_info_group_removed = {-1, "GroupRemoved", (GDBusArgInfo **) (&_dvb_id_bus_manager_dbus_arg_info_group_removed)};
static const GDBusSignalInfo * const _dvb_id_bus_manager_dbus_signal_info[] = {&_dvb_id_bus_manager_dbus_signal_info_group_added, &_dvb_id_bus_manager_dbus_signal_info_group_removed, NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_manager_dbus_interface_info = {-1, "org.gnome.DVB.Manager", (GDBusMethodInfo **) (&_dvb_id_bus_manager_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_manager_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_manager_dbus_interface_vtable = {dvb_id_bus_manager_dbus_interface_method_call, dvb_id_bus_manager_dbus_interface_get_property, dvb_id_bus_manager_dbus_interface_set_property};

void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest) {
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
}


void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self) {
	_g_free0 ((*self).name);
}


DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self) {
	DVBChannelGroupInfo* dup;
	dup = g_new0 (DVBChannelGroupInfo, 1);
	dvb_channel_group_info_copy (self, dup);
	return dup;
}


void dvb_channel_group_info_free (DVBChannelGroupInfo* self) {
	dvb_channel_group_info_destroy (self);
	g_free (self);
}


GType dvb_channel_group_info_get_type (void) {
	static volatile gsize dvb_channel_group_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_group_info_type_id__volatile)) {
		GType dvb_channel_group_info_type_id;
		dvb_channel_group_info_type_id = g_boxed_type_register_static ("DVBChannelGroupInfo", (GBoxedCopyFunc) dvb_channel_group_info_dup, (GBoxedFreeFunc) dvb_channel_group_info_free);
		g_once_init_leave (&dvb_channel_group_info_type_id__volatile, dvb_channel_group_info_type_id);
	}
	return dvb_channel_group_info_type_id__volatile;
}


void dvb_adapter_info_copy (const DVBAdapterInfo* self, DVBAdapterInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).type_t;
	(*dest).type_t = _tmp2_;
	_tmp3_ = (*self).type_s;
	(*dest).type_s = _tmp3_;
	_tmp4_ = (*self).type_c;
	(*dest).type_c = _tmp4_;
}


void dvb_adapter_info_destroy (DVBAdapterInfo* self) {
	_g_free0 ((*self).name);
}


DVBAdapterInfo* dvb_adapter_info_dup (const DVBAdapterInfo* self) {
	DVBAdapterInfo* dup;
	dup = g_new0 (DVBAdapterInfo, 1);
	dvb_adapter_info_copy (self, dup);
	return dup;
}


void dvb_adapter_info_free (DVBAdapterInfo* self) {
	dvb_adapter_info_destroy (self);
	g_free (self);
}


GType dvb_adapter_info_get_type (void) {
	static volatile gsize dvb_adapter_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_adapter_info_type_id__volatile)) {
		GType dvb_adapter_info_type_id;
		dvb_adapter_info_type_id = g_boxed_type_register_static ("DVBAdapterInfo", (GBoxedCopyFunc) dvb_adapter_info_dup, (GBoxedFreeFunc) dvb_adapter_info_free);
		g_once_init_leave (&dvb_adapter_info_type_id__volatile, dvb_adapter_info_type_id);
	}
	return dvb_adapter_info_type_id__volatile;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @type: the type
         * @opath: Object path of the scanner service
         * @dbusiface: DBus interface of the scanner service
         * @returns: TRUE on success
         *
         * Get the object path of the channel scanner for this device.
         */
gboolean dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetScannerForDevice (self, adapter, frontend, type, opath, dbusiface, error);
}


/**
         * @returns: Device groups' DBus path
         */
char** dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetRegisteredDeviceGroups (self, result_length1, error);
}


/**
         * @group_id: A group ID
         * @opath: Device group's DBus path
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_manager_GetDeviceGroup (DVBIDBusManager* self, guint group_id, char** opath, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetDeviceGroup (self, group_id, opath, error);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @type: the type of the group
         * @channels_conf: Path to channels.conf for this device
         * @recordings_dir: Path where the recordings should be stored
         * @name: Name of group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new DeviceGroup and new DVB device whereas the
         * DVB device is the reference device of this group (i.e.
         * all other devices of this group will inherit the settings
         * of the reference device).
         */
gboolean dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->AddDeviceToNewGroup (self, adapter, frontend, type, channels_conf, recordings_dir, name, error);
}


/**
         * @adapter: Adapter of device
         * @frontend: Frontend of device
         * @name: The name of the device or "Unknown"
         * @returns: TRUE on success
         *
         * The device must be part of group, otherwise "Unknown"
         * is returned.
         */
gboolean dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetNameOfRegisteredDevice (self, adapter, frontend, name, error);
}


/**
         * @returns: the numner of configured device groups
         */
gint dvb_id_bus_manager_GetDeviceGroupSize (DVBIDBusManager* self, GError** error) {
	g_return_val_if_fail (self != NULL, 0);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetDeviceGroupSize (self, error);
}


/**
         * @returns: ID and name of each channel group
         */
DVBChannelGroupInfo* dvb_id_bus_manager_GetChannelGroups (DVBIDBusManager* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetChannelGroups (self, result_length1, error);
}


/**
         * @name: Name of the new group
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_manager_AddChannelGroup (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->AddChannelGroup (self, name, channel_group_id, error);
}


/**
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_manager_RemoveChannelGroup (DVBIDBusManager* self, gint channel_group_id, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->RemoveChannelGroup (self, channel_group_id, error);
}


/**
         * @returns: informations about all connected
         * devices retrieved via udev
         */
GHashTable** dvb_id_bus_manager_GetDevices (DVBIDBusManager* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetDevices (self, result_length1, error);
}


/**
         * @info: type and name of adapter
         * @returns: TRUE on success
         */
gboolean dvb_id_bus_manager_GetAdapterInfo (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_MANAGER_GET_INTERFACE (self)->GetAdapterInfo (self, adapter, frontend, info, error);
}


static void dvb_id_bus_manager_base_init (DVBIDBusManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("group_added", DVB_TYPE_ID_BUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("group_removed", DVB_TYPE_ID_BUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType dvb_id_bus_manager_get_type (void) {
	static volatile gsize dvb_id_bus_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusManagerIface), (GBaseInitFunc) dvb_id_bus_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_manager_type_id;
		dvb_id_bus_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_manager_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.Manager");
		g_type_set_qdata (dvb_id_bus_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_manager_register_object);
		g_once_init_leave (&dvb_id_bus_manager_type_id__volatile, dvb_id_bus_manager_type_id);
	}
	return dvb_id_bus_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusManagerProxy, dvb_id_bus_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_MANAGER, dvb_id_bus_manager_proxy_dvb_id_bus_manager_interface_init) )
static void dvb_id_bus_manager_proxy_class_init (DVBIDBusManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_manager_proxy_g_signal;
}


static void _dbus_handle_dvb_id_bus_manager_group_added (DVBIDBusManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint group_id = 0U;
	GVariant* _tmp92_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp92_ = g_variant_iter_next_value (&_arguments_iter);
	group_id = g_variant_get_uint32 (_tmp92_);
	g_variant_unref (_tmp92_);
	g_signal_emit_by_name (self, "group-added", group_id);
}


static void _dbus_handle_dvb_id_bus_manager_group_removed (DVBIDBusManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint group_id = 0U;
	GVariant* _tmp93_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp93_ = g_variant_iter_next_value (&_arguments_iter);
	group_id = g_variant_get_uint32 (_tmp93_);
	g_variant_unref (_tmp93_);
	g_signal_emit_by_name (self, "group-removed", group_id);
}


static void dvb_id_bus_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "GroupAdded") == 0) {
		_dbus_handle_dvb_id_bus_manager_group_added ((DVBIDBusManager*) proxy, parameters);
	} else if (strcmp (signal_name, "GroupRemoved") == 0) {
		_dbus_handle_dvb_id_bus_manager_group_removed ((DVBIDBusManager*) proxy, parameters);
	}
}


static void dvb_id_bus_manager_proxy_init (DVBIDBusManagerProxy* self) {
}


static gboolean dvb_id_bus_manager_proxy_GetScannerForDevice (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _vala_opath;
	GVariant* _tmp94_;
	gchar* _vala_dbusiface;
	GVariant* _tmp95_;
	gboolean _result;
	GVariant* _tmp96_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetScannerForDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp94_ = g_variant_iter_next_value (&_reply_iter);
	_vala_opath = g_variant_dup_string (_tmp94_, NULL);
	g_variant_unref (_tmp94_);
	*opath = _vala_opath;
	_tmp95_ = g_variant_iter_next_value (&_reply_iter);
	_vala_dbusiface = g_variant_dup_string (_tmp95_, NULL);
	g_variant_unref (_tmp95_);
	*dbusiface = _vala_dbusiface;
	_tmp96_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp96_);
	g_variant_unref (_tmp96_);
	g_object_unref (_reply_message);
	return _result;
}


static char** dvb_id_bus_manager_proxy_GetRegisteredDeviceGroups (DVBIDBusManager* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char** _result;
	int _result_length1;
	GVariant* _tmp97_;
	char** _tmp98_;
	int _tmp98__length;
	int _tmp98__size;
	int _tmp98__length1;
	GVariantIter _tmp99_;
	GVariant* _tmp100_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetRegisteredDeviceGroups");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp97_ = g_variant_iter_next_value (&_reply_iter);
	_tmp98_ = g_new (char*, 5);
	_tmp98__length = 0;
	_tmp98__size = 4;
	_tmp98__length1 = 0;
	g_variant_iter_init (&_tmp99_, _tmp97_);
	for (; (_tmp100_ = g_variant_iter_next_value (&_tmp99_)) != NULL; _tmp98__length1++) {
		if (_tmp98__size == _tmp98__length) {
			_tmp98__size = 2 * _tmp98__size;
			_tmp98_ = g_renew (char*, _tmp98_, _tmp98__size + 1);
		}
		_tmp98_[_tmp98__length++] = g_variant_dup_string (_tmp100_, NULL);
		g_variant_unref (_tmp100_);
	}
	_result_length1 = _tmp98__length1;
	_tmp98_[_tmp98__length] = NULL;
	_result = _tmp98_;
	g_variant_unref (_tmp97_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_GetDeviceGroup (DVBIDBusManager* self, guint group_id, char** opath, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _vala_opath;
	GVariant* _tmp101_;
	gboolean _result;
	GVariant* _tmp102_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetDeviceGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp101_ = g_variant_iter_next_value (&_reply_iter);
	_vala_opath = g_variant_dup_string (_tmp101_, NULL);
	g_variant_unref (_tmp101_);
	*opath = _vala_opath;
	_tmp102_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp102_);
	g_variant_unref (_tmp102_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_AddDeviceToNewGroup (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp103_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "AddDeviceToNewGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (type));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (channels_conf));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (recordings_dir));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp103_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp103_);
	g_variant_unref (_tmp103_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_GetNameOfRegisteredDevice (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_name;
	GVariant* _tmp104_;
	gboolean _result;
	GVariant* _tmp105_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetNameOfRegisteredDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp104_ = g_variant_iter_next_value (&_reply_iter);
	_vala_name = g_variant_dup_string (_tmp104_, NULL);
	g_variant_unref (_tmp104_);
	*name = _vala_name;
	_tmp105_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp105_);
	g_variant_unref (_tmp105_);
	g_object_unref (_reply_message);
	return _result;
}


static gint dvb_id_bus_manager_proxy_GetDeviceGroupSize (DVBIDBusManager* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _result;
	GVariant* _tmp106_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetDeviceGroupSize");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp106_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_int32 (_tmp106_);
	g_variant_unref (_tmp106_);
	g_object_unref (_reply_message);
	return _result;
}


static DVBChannelGroupInfo* dvb_id_bus_manager_proxy_GetChannelGroups (DVBIDBusManager* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBChannelGroupInfo* _result;
	int _result_length1;
	GVariant* _tmp107_;
	DVBChannelGroupInfo* _tmp108_;
	int _tmp108__length;
	int _tmp108__size;
	int _tmp108__length1;
	GVariantIter _tmp109_;
	GVariant* _tmp110_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetChannelGroups");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp107_ = g_variant_iter_next_value (&_reply_iter);
	_tmp108_ = g_new (DVBChannelGroupInfo, 5);
	_tmp108__length = 0;
	_tmp108__size = 4;
	_tmp108__length1 = 0;
	g_variant_iter_init (&_tmp109_, _tmp107_);
	for (; (_tmp110_ = g_variant_iter_next_value (&_tmp109_)) != NULL; _tmp108__length1++) {
		DVBChannelGroupInfo _tmp111_;
		GVariantIter _tmp112_;
		GVariant* _tmp113_;
		GVariant* _tmp114_;
		if (_tmp108__size == _tmp108__length) {
			_tmp108__size = 2 * _tmp108__size;
			_tmp108_ = g_renew (DVBChannelGroupInfo, _tmp108_, _tmp108__size + 1);
		}
		g_variant_iter_init (&_tmp112_, _tmp110_);
		_tmp113_ = g_variant_iter_next_value (&_tmp112_);
		_tmp111_.id = g_variant_get_int32 (_tmp113_);
		g_variant_unref (_tmp113_);
		_tmp114_ = g_variant_iter_next_value (&_tmp112_);
		_tmp111_.name = g_variant_dup_string (_tmp114_, NULL);
		g_variant_unref (_tmp114_);
		_tmp108_[_tmp108__length++] = _tmp111_;
		g_variant_unref (_tmp110_);
	}
	_result_length1 = _tmp108__length1;
	_result = _tmp108_;
	g_variant_unref (_tmp107_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_AddChannelGroup (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint _vala_channel_group_id;
	GVariant* _tmp115_;
	gboolean _result;
	GVariant* _tmp116_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "AddChannelGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp115_ = g_variant_iter_next_value (&_reply_iter);
	_vala_channel_group_id = g_variant_get_int32 (_tmp115_);
	g_variant_unref (_tmp115_);
	*channel_group_id = _vala_channel_group_id;
	_tmp116_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp116_);
	g_variant_unref (_tmp116_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_RemoveChannelGroup (DVBIDBusManager* self, gint channel_group_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp117_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "RemoveChannelGroup");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (channel_group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp117_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp117_);
	g_variant_unref (_tmp117_);
	g_object_unref (_reply_message);
	return _result;
}


static GHashTable** dvb_id_bus_manager_proxy_GetDevices (DVBIDBusManager* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable** _result;
	int _result_length1;
	GVariant* _tmp118_;
	GHashTable** _tmp119_;
	int _tmp119__length;
	int _tmp119__size;
	int _tmp119__length1;
	GVariantIter _tmp120_;
	GVariant* _tmp121_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetDevices");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp118_ = g_variant_iter_next_value (&_reply_iter);
	_tmp119_ = g_new (GHashTable*, 5);
	_tmp119__length = 0;
	_tmp119__size = 4;
	_tmp119__length1 = 0;
	g_variant_iter_init (&_tmp120_, _tmp118_);
	for (; (_tmp121_ = g_variant_iter_next_value (&_tmp120_)) != NULL; _tmp119__length1++) {
		GHashTable* _tmp122_;
		GVariantIter _tmp123_;
		GVariant* _tmp124_;
		GVariant* _tmp125_;
		if (_tmp119__size == _tmp119__length) {
			_tmp119__size = 2 * _tmp119__size;
			_tmp119_ = g_renew (GHashTable*, _tmp119_, _tmp119__size + 1);
		}
		_tmp122_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		g_variant_iter_init (&_tmp123_, _tmp121_);
		while (g_variant_iter_loop (&_tmp123_, "{?*}", &_tmp124_, &_tmp125_)) {
			g_hash_table_insert (_tmp122_, g_variant_dup_string (_tmp124_, NULL), g_variant_dup_string (_tmp125_, NULL));
		}
		_tmp119_[_tmp119__length++] = _tmp122_;
		g_variant_unref (_tmp121_);
	}
	_result_length1 = _tmp119__length1;
	_tmp119_[_tmp119__length] = NULL;
	_result = _tmp119_;
	g_variant_unref (_tmp118_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_manager_proxy_GetAdapterInfo (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBAdapterInfo _vala_info;
	GVariant* _tmp126_;
	DVBAdapterInfo _tmp127_;
	GVariantIter _tmp128_;
	GVariant* _tmp129_;
	GVariant* _tmp130_;
	GVariant* _tmp131_;
	GVariant* _tmp132_;
	gboolean _result;
	GVariant* _tmp133_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Manager", "GetAdapterInfo");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (adapter));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (frontend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp126_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp128_, _tmp126_);
	_tmp129_ = g_variant_iter_next_value (&_tmp128_);
	_tmp127_.name = g_variant_dup_string (_tmp129_, NULL);
	g_variant_unref (_tmp129_);
	_tmp130_ = g_variant_iter_next_value (&_tmp128_);
	_tmp127_.type_t = g_variant_get_boolean (_tmp130_);
	g_variant_unref (_tmp130_);
	_tmp131_ = g_variant_iter_next_value (&_tmp128_);
	_tmp127_.type_s = g_variant_get_boolean (_tmp131_);
	g_variant_unref (_tmp131_);
	_tmp132_ = g_variant_iter_next_value (&_tmp128_);
	_tmp127_.type_c = g_variant_get_boolean (_tmp132_);
	g_variant_unref (_tmp132_);
	_vala_info = _tmp127_;
	g_variant_unref (_tmp126_);
	*info = _vala_info;
	_tmp133_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp133_);
	g_variant_unref (_tmp133_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_manager_proxy_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface* iface) {
	iface->GetScannerForDevice = dvb_id_bus_manager_proxy_GetScannerForDevice;
	iface->GetRegisteredDeviceGroups = dvb_id_bus_manager_proxy_GetRegisteredDeviceGroups;
	iface->GetDeviceGroup = dvb_id_bus_manager_proxy_GetDeviceGroup;
	iface->AddDeviceToNewGroup = dvb_id_bus_manager_proxy_AddDeviceToNewGroup;
	iface->GetNameOfRegisteredDevice = dvb_id_bus_manager_proxy_GetNameOfRegisteredDevice;
	iface->GetDeviceGroupSize = dvb_id_bus_manager_proxy_GetDeviceGroupSize;
	iface->GetChannelGroups = dvb_id_bus_manager_proxy_GetChannelGroups;
	iface->AddChannelGroup = dvb_id_bus_manager_proxy_AddChannelGroup;
	iface->RemoveChannelGroup = dvb_id_bus_manager_proxy_RemoveChannelGroup;
	iface->GetDevices = dvb_id_bus_manager_proxy_GetDevices;
	iface->GetAdapterInfo = dvb_id_bus_manager_proxy_GetAdapterInfo;
}


static void _dbus_dvb_id_bus_manager_GetScannerForDevice (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp134_;
	guint frontend = 0U;
	GVariant* _tmp135_;
	DVBAdapterType type = 0;
	GVariant* _tmp136_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* opath = NULL;
	gchar* dbusiface = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp134_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp134_);
	g_variant_unref (_tmp134_);
	_tmp135_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp135_);
	g_variant_unref (_tmp135_);
	_tmp136_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp136_);
	g_variant_unref (_tmp136_);
	result = dvb_id_bus_manager_GetScannerForDevice (self, adapter, frontend, type, &opath, &dbusiface, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (opath));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (dbusiface));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (opath);
	_g_free0 (dbusiface);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char** result;
	int result_length1 = 0;
	char** _tmp137_;
	GVariantBuilder _tmp138_;
	int _tmp139_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_manager_GetRegisteredDeviceGroups (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp137_ = result;
	g_variant_builder_init (&_tmp138_, G_VARIANT_TYPE ("ao"));
	for (_tmp139_ = 0; _tmp139_ < result_length1; _tmp139_++) {
		g_variant_builder_add_value (&_tmp138_, g_variant_new_object_path (*_tmp137_));
		_tmp137_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp138_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetDeviceGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint group_id = 0U;
	GVariant* _tmp140_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* opath = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp140_ = g_variant_iter_next_value (&_arguments_iter);
	group_id = g_variant_get_uint32 (_tmp140_);
	g_variant_unref (_tmp140_);
	result = dvb_id_bus_manager_GetDeviceGroup (self, group_id, &opath, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (opath));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (opath);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_AddDeviceToNewGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp141_;
	guint frontend = 0U;
	GVariant* _tmp142_;
	DVBAdapterType type = 0;
	GVariant* _tmp143_;
	gchar* channels_conf = NULL;
	GVariant* _tmp144_;
	gchar* recordings_dir = NULL;
	GVariant* _tmp145_;
	gchar* name = NULL;
	GVariant* _tmp146_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp141_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp141_);
	g_variant_unref (_tmp141_);
	_tmp142_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp142_);
	g_variant_unref (_tmp142_);
	_tmp143_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_int32 (_tmp143_);
	g_variant_unref (_tmp143_);
	_tmp144_ = g_variant_iter_next_value (&_arguments_iter);
	channels_conf = g_variant_dup_string (_tmp144_, NULL);
	g_variant_unref (_tmp144_);
	_tmp145_ = g_variant_iter_next_value (&_arguments_iter);
	recordings_dir = g_variant_dup_string (_tmp145_, NULL);
	g_variant_unref (_tmp145_);
	_tmp146_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp146_, NULL);
	g_variant_unref (_tmp146_);
	result = dvb_id_bus_manager_AddDeviceToNewGroup (self, adapter, frontend, type, channels_conf, recordings_dir, name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (channels_conf);
	_g_free0 (recordings_dir);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp147_;
	guint frontend = 0U;
	GVariant* _tmp148_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp147_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp147_);
	g_variant_unref (_tmp147_);
	_tmp148_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp148_);
	g_variant_unref (_tmp148_);
	result = dvb_id_bus_manager_GetNameOfRegisteredDevice (self, adapter, frontend, &name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetDeviceGroupSize (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_manager_GetDeviceGroupSize (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_group_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_dvb_id_bus_manager_GetChannelGroups (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBChannelGroupInfo* result;
	int result_length1 = 0;
	DVBChannelGroupInfo* _tmp149_;
	GVariantBuilder _tmp150_;
	int _tmp151_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_manager_GetChannelGroups (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp149_ = result;
	g_variant_builder_init (&_tmp150_, G_VARIANT_TYPE ("a(is)"));
	for (_tmp151_ = 0; _tmp151_ < result_length1; _tmp151_++) {
		GVariantBuilder _tmp152_;
		g_variant_builder_init (&_tmp152_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp152_, g_variant_new_int32 ((*_tmp149_).id));
		g_variant_builder_add_value (&_tmp152_, g_variant_new_string ((*_tmp149_).name));
		g_variant_builder_add_value (&_tmp150_, g_variant_builder_end (&_tmp152_));
		_tmp149_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp150_));
	result = (_vala_DVBChannelGroupInfo_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_AddChannelGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp153_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint channel_group_id = 0;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp153_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp153_, NULL);
	g_variant_unref (_tmp153_);
	result = dvb_id_bus_manager_AddChannelGroup (self, name, &channel_group_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int32 (channel_group_id));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_RemoveChannelGroup (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint channel_group_id = 0;
	GVariant* _tmp154_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp154_ = g_variant_iter_next_value (&_arguments_iter);
	channel_group_id = g_variant_get_int32 (_tmp154_);
	g_variant_unref (_tmp154_);
	result = dvb_id_bus_manager_RemoveChannelGroup (self, channel_group_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetDevices (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	int result_length1 = 0;
	GHashTable** _tmp155_;
	GVariantBuilder _tmp156_;
	int _tmp157_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dvb_id_bus_manager_GetDevices (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp155_ = result;
	g_variant_builder_init (&_tmp156_, G_VARIANT_TYPE ("aa{ss}"));
	for (_tmp157_ = 0; _tmp157_ < result_length1; _tmp157_++) {
		GVariantBuilder _tmp158_;
		GHashTableIter _tmp159_;
		gpointer _tmp160_;
		gpointer _tmp161_;
		g_hash_table_iter_init (&_tmp159_, *_tmp155_);
		g_variant_builder_init (&_tmp158_, G_VARIANT_TYPE ("a{ss}"));
		while (g_hash_table_iter_next (&_tmp159_, &_tmp160_, &_tmp161_)) {
			gchar* _key;
			gchar* _value;
			_key = (gchar*) _tmp160_;
			_value = (gchar*) _tmp161_;
			g_variant_builder_add (&_tmp158_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
		}
		g_variant_builder_add_value (&_tmp156_, g_variant_builder_end (&_tmp158_));
		_tmp155_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp156_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_manager_GetAdapterInfo (DVBIDBusManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint adapter = 0U;
	GVariant* _tmp162_;
	guint frontend = 0U;
	GVariant* _tmp163_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBAdapterInfo info = {0};
	GVariantBuilder _tmp164_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp162_ = g_variant_iter_next_value (&_arguments_iter);
	adapter = g_variant_get_uint32 (_tmp162_);
	g_variant_unref (_tmp162_);
	_tmp163_ = g_variant_iter_next_value (&_arguments_iter);
	frontend = g_variant_get_uint32 (_tmp163_);
	g_variant_unref (_tmp163_);
	result = dvb_id_bus_manager_GetAdapterInfo (self, adapter, frontend, &info, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp164_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp164_, g_variant_new_string (info.name));
	g_variant_builder_add_value (&_tmp164_, g_variant_new_boolean (info.type_t));
	g_variant_builder_add_value (&_tmp164_, g_variant_new_boolean (info.type_s));
	g_variant_builder_add_value (&_tmp164_, g_variant_new_boolean (info.type_c));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp164_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	dvb_adapter_info_destroy (&info);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetScannerForDevice") == 0) {
		_dbus_dvb_id_bus_manager_GetScannerForDevice (object, parameters, invocation);
	} else if (strcmp (method_name, "GetRegisteredDeviceGroups") == 0) {
		_dbus_dvb_id_bus_manager_GetRegisteredDeviceGroups (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDeviceGroup") == 0) {
		_dbus_dvb_id_bus_manager_GetDeviceGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "AddDeviceToNewGroup") == 0) {
		_dbus_dvb_id_bus_manager_AddDeviceToNewGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNameOfRegisteredDevice") == 0) {
		_dbus_dvb_id_bus_manager_GetNameOfRegisteredDevice (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDeviceGroupSize") == 0) {
		_dbus_dvb_id_bus_manager_GetDeviceGroupSize (object, parameters, invocation);
	} else if (strcmp (method_name, "GetChannelGroups") == 0) {
		_dbus_dvb_id_bus_manager_GetChannelGroups (object, parameters, invocation);
	} else if (strcmp (method_name, "AddChannelGroup") == 0) {
		_dbus_dvb_id_bus_manager_AddChannelGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveChannelGroup") == 0) {
		_dbus_dvb_id_bus_manager_RemoveChannelGroup (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDevices") == 0) {
		_dbus_dvb_id_bus_manager_GetDevices (object, parameters, invocation);
	} else if (strcmp (method_name, "GetAdapterInfo") == 0) {
		_dbus_dvb_id_bus_manager_GetAdapterInfo (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dvb_id_bus_manager_group_added (GObject* _sender, guint group_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Manager", "GroupAdded", _arguments, NULL);
}


static void _dbus_dvb_id_bus_manager_group_removed (GObject* _sender, guint group_id, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (group_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.DVB.Manager", "GroupRemoved", _arguments, NULL);
}


guint dvb_id_bus_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_manager_dbus_interface_info), &_dvb_id_bus_manager_dbus_interface_vtable, data, _dvb_id_bus_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "group-added", (GCallback) _dbus_dvb_id_bus_manager_group_added, data);
	g_signal_connect (object, "group-removed", (GCallback) _dbus_dvb_id_bus_manager_group_removed, data);
	return result;
}


static void _dvb_id_bus_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_manager_group_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dvb_id_bus_manager_group_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



