/* Utils.c generated by valac 0.25.1, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>


#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern DVBLoggingLogger* main_log;

#define DVB_UTILS_NAME_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME
#define DVB_UTILS_READ_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue);
const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val);
void dvb_utils_mkdirs (GFile* directory, GError** error);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
time_t dvb_utils_difftime (struct tm* t1, struct tm* t2);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
gboolean dvb_utils_is_readable_file (GFile* file);
void dvb_utils_delete_dir_recursively (GFile* dir, GError** error);
time_t dvb_utils_t_max (time_t a, time_t b);
time_t dvb_utils_t_min (time_t a, time_t b);
glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched);
void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
static void __lambda4_ (void);
static void ___lambda4__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void __lambda5_ (void);
static void ___lambda5__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error);


inline const gchar* dvb_utils_get_nick_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GEnumClass* eclass = NULL;
	GType _tmp0_ = 0UL;
	GTypeClass* _tmp1_ = NULL;
	GEnumValue* eval = NULL;
	GEnumClass* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	_tmp0_ = enumtype;
	_tmp1_ = g_type_class_ref (_tmp0_);
	eclass = (GEnumClass*) _tmp1_;
	_tmp2_ = eclass;
	_tmp3_ = val;
	_tmp4_ = g_enum_get_value (_tmp2_, _tmp3_);
	eval = _tmp4_;
	_tmp5_ = eval;
	if (_tmp5_ == NULL) {
		DVBLoggingLogger* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = main_log;
		_tmp7_ = val;
		dvb_logging_logger_error (_tmp6_, "Utils.vala:32: Enum has no value %d", _tmp7_);
		result = NULL;
		_g_type_class_unref0 (eclass);
		return result;
	} else {
		GEnumValue* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = eval;
		_tmp9_ = (*_tmp8_).value_nick;
		result = _tmp9_;
		_g_type_class_unref0 (eclass);
		return result;
	}
	_g_type_class_unref0 (eclass);
}


inline gboolean dvb_utils_get_value_by_name_from_enum (GType enumtype, const gchar* name, gint* evalue) {
	gint _vala_evalue = 0;
	gboolean result = FALSE;
	GEnumClass* enumclass = NULL;
	GType _tmp0_ = 0UL;
	GTypeClass* _tmp1_ = NULL;
	GEnumValue* eval = NULL;
	GEnumClass* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = enumtype;
	_tmp1_ = g_type_class_ref (_tmp0_);
	enumclass = (GEnumClass*) _tmp1_;
	_tmp2_ = enumclass;
	_tmp3_ = name;
	_tmp4_ = g_enum_get_value_by_name (_tmp2_, _tmp3_);
	eval = _tmp4_;
	_tmp5_ = eval;
	if (_tmp5_ == NULL) {
		DVBLoggingLogger* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = main_log;
		_tmp7_ = name;
		dvb_logging_logger_error (_tmp6_, "Utils.vala:44: Enum has no member named %s", _tmp7_);
		_vala_evalue = 0;
		result = FALSE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _vala_evalue;
		}
		return result;
	} else {
		GEnumValue* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp8_ = eval;
		_tmp9_ = (*_tmp8_).value;
		_vala_evalue = _tmp9_;
		result = TRUE;
		_g_type_class_unref0 (enumclass);
		if (evalue) {
			*evalue = _vala_evalue;
		}
		return result;
	}
	_g_type_class_unref0 (enumclass);
	if (evalue) {
		*evalue = _vala_evalue;
	}
}


inline const gchar* dvb_utils_get_name_by_value_from_enum (GType enumtype, gint val) {
	const gchar* result = NULL;
	GEnumClass* enumclass = NULL;
	GType _tmp0_ = 0UL;
	GTypeClass* _tmp1_ = NULL;
	GEnumValue* eval = NULL;
	GEnumClass* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	_tmp0_ = enumtype;
	_tmp1_ = g_type_class_ref (_tmp0_);
	enumclass = (GEnumClass*) _tmp1_;
	_tmp2_ = enumclass;
	_tmp3_ = val;
	_tmp4_ = g_enum_get_value (_tmp2_, _tmp3_);
	eval = _tmp4_;
	_tmp5_ = eval;
	if (_tmp5_ == NULL) {
		DVBLoggingLogger* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = main_log;
		_tmp7_ = val;
		dvb_logging_logger_error (_tmp6_, "Utils.vala:58: Enum has no value %d", _tmp7_);
		result = NULL;
		_g_type_class_unref0 (enumclass);
		return result;
	} else {
		GEnumValue* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = eval;
		_tmp9_ = (*_tmp8_).value_name;
		result = _tmp9_;
		_g_type_class_unref0 (enumclass);
		return result;
	}
	_g_type_class_unref0 (enumclass);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


void dvb_utils_mkdirs (GFile* directory, GError** error) {
	GSList* create_dirs = NULL;
	GFile* current_dir = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GSList* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (directory != NULL);
	create_dirs = NULL;
	_tmp0_ = directory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	current_dir = _tmp1_;
	while (TRUE) {
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		_tmp2_ = current_dir;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = current_dir;
		_tmp4_ = g_file_query_exists (_tmp3_, NULL);
		if (_tmp4_) {
			break;
		}
		_tmp5_ = current_dir;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		create_dirs = g_slist_prepend (create_dirs, _tmp6_);
		_tmp7_ = current_dir;
		_tmp8_ = g_file_get_parent (_tmp7_);
		_g_object_unref0 (current_dir);
		current_dir = _tmp8_;
	}
	_tmp9_ = create_dirs;
	{
		GSList* dir_collection = NULL;
		GSList* dir_it = NULL;
		dir_collection = _tmp9_;
		for (dir_it = dir_collection; dir_it != NULL; dir_it = dir_it->next) {
			GFile* _tmp10_ = NULL;
			GFile* dir = NULL;
			_tmp10_ = _g_object_ref0 ((GFile*) dir_it->data);
			dir = _tmp10_;
			{
				DVBLoggingLogger* _tmp11_ = NULL;
				GFile* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				_tmp11_ = main_log;
				_tmp12_ = dir;
				_tmp13_ = g_file_get_path (_tmp12_);
				_tmp14_ = _tmp13_;
				dvb_logging_logger_debug (_tmp11_, "Utils.vala:76: Creating %s", _tmp14_);
				_g_free0 (_tmp14_);
				_tmp15_ = dir;
				g_file_make_directory (_tmp15_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dir);
					_g_object_unref0 (current_dir);
					__g_slist_free__g_object_unref0_0 (create_dirs);
					return;
				}
				_g_object_unref0 (dir);
			}
		}
	}
	_g_object_unref0 (current_dir);
	__g_slist_free__g_object_unref0_0 (create_dirs);
}


gchar* dvb_utils_remove_nonalphanums (const gchar* text) {
	gchar* result = NULL;
	GRegex* regex = NULL;
	gchar* new_text = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		_tmp1_ = g_regex_new ("[^-_\\.a-zA-Z0-9]", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch198_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally198;
	__catch198_g_regex_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = main_log;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		dvb_logging_logger_error (_tmp3_, "Utils.vala:86: RegexError: %s", _tmp5_);
		_tmp6_ = text;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		_g_error_free0 (e);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally198:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = regex;
		_tmp10_ = text;
		_tmp11_ = g_regex_replace_literal (_tmp9_, _tmp10_, (gssize) (-1), 0, "_", 0, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch199_g_regex_error;
			}
			_g_free0 (new_text);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (new_text);
		new_text = _tmp12_;
		_g_free0 (_tmp8_);
	}
	goto __finally199;
	__catch199_g_regex_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = main_log;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		dvb_logging_logger_error (_tmp13_, "Utils.vala:94: RegexError: %s", _tmp15_);
		_tmp16_ = text;
		_tmp17_ = g_strdup (_tmp16_);
		result = _tmp17_;
		_g_error_free0 (e);
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		return result;
	}
	__finally199:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (new_text);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = new_text;
	_g_regex_unref0 (regex);
	return result;
}


/**
     * @returns: Difference in seconds
     */
inline time_t dvb_utils_difftime (struct tm* t1, struct tm* t2) {
	time_t result = 0;
	time_t ts1 = 0;
	time_t _tmp0_ = 0;
	time_t ts2 = 0;
	time_t _tmp1_ = 0;
	time_t diff = 0;
	time_t _tmp2_ = 0;
	time_t _tmp3_ = 0;
	time_t _tmp4_ = 0;
	g_return_val_if_fail (t1 != NULL, 0);
	g_return_val_if_fail (t2 != NULL, 0);
	_tmp0_ = mktime (t1);
	ts1 = _tmp0_;
	_tmp1_ = mktime (t2);
	ts2 = _tmp1_;
	_tmp2_ = ts1;
	_tmp3_ = ts2;
	diff = _tmp2_ - _tmp3_;
	_tmp4_ = diff;
	if (_tmp4_ < ((time_t) 0)) {
		time_t _tmp5_ = 0;
		_tmp5_ = diff;
		result = (-1) * _tmp5_;
		return result;
	} else {
		result = diff;
		return result;
	}
}


/**
     * Creates Time of local time
     */
static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	struct tm t = {0};
	time_t _tmp11_ = 0;
	struct tm _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	_tmp5_ = year;
	if (_tmp5_ >= 1900) {
		gint _tmp6_ = 0;
		_tmp6_ = month;
		_tmp4_ = _tmp6_ >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint _tmp7_ = 0;
		_tmp7_ = day;
		_tmp3_ = _tmp7_ >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp8_ = 0;
		_tmp8_ = hour;
		_tmp2_ = _tmp8_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp9_ = 0;
		_tmp9_ = minute;
		_tmp1_ = _tmp9_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp10_ = 0;
		_tmp10_ = second;
		_tmp0_ = _tmp10_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "year >= 1900 && month >= 1 && day >= 1 && hour >= 0 && minute >= 0             && second >= 0");
	_tmp11_ = time (NULL);
	g_time_local (_tmp11_, &_tmp12_);
	t = _tmp12_;
	_tmp13_ = year;
	t.tm_year = _tmp13_ - 1900;
	_tmp14_ = month;
	t.tm_mon = _tmp14_ - 1;
	_tmp15_ = day;
	t.tm_mday = _tmp15_;
	_tmp16_ = hour;
	t.tm_hour = _tmp16_;
	_tmp17_ = minute;
	t.tm_min = _tmp17_;
	_tmp18_ = second;
	t.tm_sec = _tmp18_;
	*result = t;
	return;
}


/**
     * Creates Time of UTC time
     */
static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


inline void dvb_utils_create_utc_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	struct tm t = {0};
	time_t _tmp11_ = 0;
	struct tm _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	_tmp5_ = year;
	if (_tmp5_ >= 1900) {
		gint _tmp6_ = 0;
		_tmp6_ = month;
		_tmp4_ = _tmp6_ >= 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint _tmp7_ = 0;
		_tmp7_ = day;
		_tmp3_ = _tmp7_ >= 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gint _tmp8_ = 0;
		_tmp8_ = hour;
		_tmp2_ = _tmp8_ >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp9_ = 0;
		_tmp9_ = minute;
		_tmp1_ = _tmp9_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp10_ = 0;
		_tmp10_ = second;
		_tmp0_ = _tmp10_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "year >= 1900 && month >= 1 && day >= 1 && hour >= 0 && minute >= 0             && second >= 0");
	_tmp11_ = time (NULL);
	g_time_gm (_tmp11_, &_tmp12_);
	t = _tmp12_;
	_tmp13_ = year;
	t.tm_year = _tmp13_ - 1900;
	_tmp14_ = month;
	t.tm_mon = _tmp14_ - 1;
	_tmp15_ = day;
	t.tm_mday = _tmp15_;
	_tmp16_ = hour;
	t.tm_hour = _tmp16_;
	_tmp17_ = minute;
	t.tm_min = _tmp17_;
	_tmp18_ = second;
	t.tm_sec = _tmp18_;
	t.tm_isdst = -1;
	*result = t;
	return;
}


gboolean dvb_utils_is_readable_file (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileType _tmp8_ = 0;
	GFileInfo* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GFileInfo* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		_tmp1_ = file;
		_tmp2_ = g_file_query_info (_tmp1_, DVB_UTILS_READ_ATTRS, 0, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch200_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally200;
	__catch200_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = main_log;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		dvb_logging_logger_error (_tmp4_, "Utils.vala:163: Could not retrieve attributes: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally200:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = info;
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
	if (_tmp8_ != G_FILE_TYPE_REGULAR) {
		DVBLoggingLogger* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = main_log;
		_tmp10_ = file;
		_tmp11_ = g_file_get_path (_tmp10_);
		_tmp12_ = _tmp11_;
		dvb_logging_logger_error (_tmp9_, "Utils.vala:168: %s is not a regular file", _tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp13_ = info;
	_tmp14_ = g_file_info_get_attribute_boolean (_tmp13_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp14_) {
		DVBLoggingLogger* _tmp15_ = NULL;
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp15_ = main_log;
		_tmp16_ = file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		dvb_logging_logger_error (_tmp15_, "Utils.vala:173: Cannot read %s", _tmp18_);
		_g_free0 (_tmp18_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


void dvb_utils_delete_dir_recursively (GFile* dir, GError** error) {
	GFileEnumerator* files = NULL;
	GFileEnumerator* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileEnumerator* _tmp2_ = NULL;
	GFileEnumerator* _tmp3_ = NULL;
	GFileEnumerator* _tmp4_ = NULL;
	GFileInfo* childinfo = NULL;
	DVBLoggingLogger* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GFile* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dir != NULL);
	_tmp1_ = dir;
	_tmp2_ = g_file_enumerate_children (_tmp1_, DVB_UTILS_NAME_ATTRS, 0, NULL, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (files);
		return;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (files);
	files = _tmp3_;
	_tmp4_ = files;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (files);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
		GFileInfo* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		guint32 type = 0U;
		GFileInfo* _tmp10_ = NULL;
		guint32 _tmp11_ = 0U;
		GFile* child = NULL;
		GFile* _tmp12_ = NULL;
		GFileInfo* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		guint32 _tmp16_ = 0U;
		_tmp6_ = files;
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (childinfo);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (files);
			return;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (childinfo);
		childinfo = _tmp8_;
		_tmp9_ = childinfo;
		if (!(_tmp9_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			break;
		}
		_tmp10_ = childinfo;
		_tmp11_ = g_file_info_get_attribute_uint32 (_tmp10_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
		type = _tmp11_;
		_tmp12_ = dir;
		_tmp13_ = childinfo;
		_tmp14_ = g_file_info_get_name (_tmp13_);
		_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
		child = _tmp15_;
		_tmp16_ = type;
		switch (_tmp16_) {
			case G_FILE_TYPE_DIRECTORY:
			{
				GFile* _tmp17_ = NULL;
				_tmp17_ = child;
				dvb_utils_delete_dir_recursively (_tmp17_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (_tmp5_);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (_tmp0_);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			case G_FILE_TYPE_REGULAR:
			{
				DVBLoggingLogger* _tmp18_ = NULL;
				GFile* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				GFile* _tmp22_ = NULL;
				_tmp18_ = main_log;
				_tmp19_ = child;
				_tmp20_ = g_file_get_path (_tmp19_);
				_tmp21_ = _tmp20_;
				dvb_logging_logger_debug (_tmp18_, "Utils.vala:198: Deleting file %s", _tmp21_);
				_g_free0 (_tmp21_);
				_tmp22_ = child;
				g_file_delete (_tmp22_, NULL, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (child);
					_g_object_unref0 (_tmp5_);
					_g_object_unref0 (childinfo);
					_g_object_unref0 (_tmp0_);
					_g_object_unref0 (files);
					return;
				}
				break;
			}
			default:
			break;
		}
		_g_object_unref0 (child);
		_g_object_unref0 (_tmp5_);
	}
	_tmp23_ = main_log;
	_tmp24_ = dir;
	_tmp25_ = g_file_get_path (_tmp24_);
	_tmp26_ = _tmp25_;
	dvb_logging_logger_debug (_tmp23_, "Utils.vala:204: Deleting directory %s", _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = dir;
	g_file_delete (_tmp27_, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (childinfo);
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (files);
		return;
	}
	_g_object_unref0 (childinfo);
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (files);
}


time_t dvb_utils_t_max (time_t a, time_t b) {
	time_t result = 0;
	time_t _tmp0_ = 0;
	time_t _tmp1_ = 0;
	time_t _tmp2_ = 0;
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ < _tmp2_) {
		time_t _tmp3_ = 0;
		_tmp3_ = b;
		_tmp0_ = _tmp3_;
	} else {
		time_t _tmp4_ = 0;
		_tmp4_ = a;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


time_t dvb_utils_t_min (time_t a, time_t b) {
	time_t result = 0;
	time_t _tmp0_ = 0;
	time_t _tmp1_ = 0;
	time_t _tmp2_ = 0;
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ < _tmp2_) {
		time_t _tmp3_ = 0;
		_tmp3_ = a;
		_tmp0_ = _tmp3_;
	} else {
		time_t _tmp4_ = 0;
		_tmp4_ = b;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


glong dvb_utils_strdiff (const gchar* a, const gchar* b, glong* unmatched) {
	glong _vala_unmatched = 0L;
	glong result = 0L;
	glong len_a = 0L;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	glong len_b = 0L;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	glong max = 0L;
	glong _tmp6_ = 0L;
	glong _tmp7_ = 0L;
	glong diff = 0L;
	g_return_val_if_fail (a != NULL, 0L);
	g_return_val_if_fail (b != NULL, 0L);
	_tmp0_ = a;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	len_a = (glong) _tmp2_;
	_tmp3_ = b;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	len_b = (glong) _tmp5_;
	_tmp6_ = len_a;
	_tmp7_ = len_b;
	if (_tmp6_ < _tmp7_) {
		glong _tmp8_ = 0L;
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		_tmp8_ = len_b;
		max = _tmp8_;
		_tmp9_ = len_b;
		_tmp10_ = len_a;
		_vala_unmatched = _tmp9_ - _tmp10_;
	} else {
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp11_ = len_a;
		max = _tmp11_;
		_tmp12_ = len_a;
		_tmp13_ = len_b;
		_vala_unmatched = _tmp12_ - _tmp13_;
	}
	diff = (glong) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_ = 0;
				glong _tmp17_ = 0L;
				const gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gchar _tmp20_ = '\0';
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gchar _tmp23_ = '\0';
				if (!_tmp14_) {
					gint _tmp15_ = 0;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				_tmp17_ = max;
				if (!(((glong) _tmp16_) < _tmp17_)) {
					break;
				}
				_tmp18_ = a;
				_tmp19_ = i;
				_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
				_tmp21_ = b;
				_tmp22_ = i;
				_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
				if (_tmp20_ != _tmp23_) {
					glong _tmp24_ = 0L;
					_tmp24_ = diff;
					diff = _tmp24_ + 1;
				}
			}
		}
	}
	result = diff;
	if (unmatched) {
		*unmatched = _vala_unmatched;
	}
	return result;
}


static void __lambda4_ (void) {
}


static void ___lambda4__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda4_ ();
}


static void __lambda5_ (void) {
	g_warning ("Utils.vala:244: Could not acquire name");
}


static void ___lambda5__gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda5_ ();
}


void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target) {
	DVBLoggingLogger* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GBusAcquiredCallback _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	g_return_if_fail (service_name != NULL);
	_tmp0_ = main_log;
	_tmp1_ = service_name;
	dvb_logging_logger_info (_tmp0_, "Utils.vala:240: Creating D-Bus service %s", _tmp1_);
	_tmp2_ = service_name;
	_tmp3_ = cb;
	_tmp3__target = cb_target;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, _tmp2_, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_tmp3_ == NULL) ? NULL : g_cclosure_new ((GCallback) _tmp3_, _tmp3__target, NULL)), (GClosure*) ((___lambda4__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda4__gbus_name_acquired_callback, NULL, NULL)), (GClosure*) ((___lambda5__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda5__gbus_name_lost_callback, NULL, NULL)));
}


static guint _vala_g_dbus_connection_register_object (GType type, void* object, GDBusConnection* connection, const gchar* path, GError** error) {
	void *func;
	func = g_type_get_qdata (type, g_quark_from_static_string ("vala-dbus-register-object"));
	if (!func) {
		g_set_error_literal (error, G_IO_ERROR, G_IO_ERROR_FAILED, "The specified type does not support D-Bus registration");
		return 0;
	}
	return ((guint (*) (void *, GDBusConnection *, const gchar *, GError **)) func) (object, connection, path, error);
}


inline void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (object_path != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		_tmp0_ = conn;
		_tmp1_ = object_path;
		_tmp2_ = obj;
		_vala_g_dbus_connection_register_object (t_type, _tmp2_, _tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch201_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally201;
	__catch201_g_io_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = main_log;
		_tmp4_ = object_path;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		dvb_logging_logger_error (_tmp3_, "Utils.vala:251: Could not register object '%s': %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally201:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}



