/* EventStorage.c generated by valac 0.25.1, the Vala compiler
 * generated from EventStorage.vala, do not modify */

/*
 * Copyright (C) 2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define DVB_TYPE_EVENT_ELEMENT (dvb_event_element_get_type ())
#define DVB_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElement))
#define DVB_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))
#define DVB_IS_EVENT_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_ELEMENT))
#define DVB_IS_EVENT_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_ELEMENT))
#define DVB_EVENT_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_ELEMENT, DVBEventElementClass))

typedef struct _DVBEventElement DVBEventElement;
typedef struct _DVBEventElementClass DVBEventElementClass;
typedef struct _DVBEventElementPrivate DVBEventElementPrivate;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_EVENT_STORAGE (dvb_event_storage_get_type ())
#define DVB_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorage))
#define DVB_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))
#define DVB_IS_EVENT_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT_STORAGE))
#define DVB_IS_EVENT_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT_STORAGE))
#define DVB_EVENT_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT_STORAGE, DVBEventStorageClass))

typedef struct _DVBEventStorage DVBEventStorage;
typedef struct _DVBEventStorageClass DVBEventStorageClass;
typedef struct _DVBEventStoragePrivate DVBEventStoragePrivate;
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

#define DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR (dvb_event_storage_event_iterator_get_type ())
#define DVB_EVENT_STORAGE_EVENT_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIterator))
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorClass))
#define DVB_EVENT_STORAGE_IS_EVENT_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR))
#define DVB_EVENT_STORAGE_IS_EVENT_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR))
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorClass))

typedef struct _DVBEventStorageEventIterator DVBEventStorageEventIterator;
typedef struct _DVBEventStorageEventIteratorClass DVBEventStorageEventIteratorClass;
typedef struct _DVBEventStorageEventIteratorPrivate DVBEventStorageEventIteratorPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DVBEventElement {
	GObject parent_instance;
	DVBEventElementPrivate * priv;
	guint id;
	time_t starttime;
};

struct _DVBEventElementClass {
	GObjectClass parent_class;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	DVBEventVideoComponent* video_component;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};

struct _DVBEventStorage {
	GObject parent_instance;
	DVBEventStoragePrivate * priv;
};

struct _DVBEventStorageClass {
	GObjectClass parent_class;
};

struct _DVBEventStoragePrivate {
	GSequence* events;
	GeeMap* event_id_map;
	gint _stamp;
};

struct _DVBEventStorageEventIterator {
	GObject parent_instance;
	DVBEventStorageEventIteratorPrivate * priv;
};

struct _DVBEventStorageEventIteratorClass {
	GObjectClass parent_class;
};

struct _DVBEventStorageEventIteratorPrivate {
	DVBEventStorage* _storage;
	GSequenceIter* _iter;
	gint _stamp;
};


static gpointer dvb_event_element_parent_class = NULL;
static gpointer dvb_event_storage_parent_class = NULL;
static gpointer dvb_event_storage_event_iterator_parent_class = NULL;
static GeeTraversableIface* dvb_event_storage_event_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* dvb_event_storage_event_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* dvb_event_storage_event_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeTraversableIface* dvb_event_storage_gee_traversable_parent_iface = NULL;
static GeeIterableIface* dvb_event_storage_gee_iterable_parent_iface = NULL;

GType dvb_event_element_get_type (void) G_GNUC_CONST;
enum  {
	DVB_EVENT_ELEMENT_DUMMY_PROPERTY
};
gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
DVBEventElement* dvb_event_element_new_from_event (DVBEvent* event);
DVBEventElement* dvb_event_element_new (void);
DVBEventElement* dvb_event_element_construct (GType object_type);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
time_t dvb_event_get_start_timestamp (DVBEvent* self);
static void dvb_event_element_finalize (GObject* obj);
GType dvb_event_storage_get_type (void) G_GNUC_CONST;
#define DVB_EVENT_STORAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EVENT_STORAGE, DVBEventStoragePrivate))
enum  {
	DVB_EVENT_STORAGE_DUMMY_PROPERTY,
	DVB_EVENT_STORAGE_SIZE,
	DVB_EVENT_STORAGE_ELEMENT_TYPE
};
DVBEventStorage* dvb_event_storage_new (void);
DVBEventStorage* dvb_event_storage_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event);
static gint _dvb_event_element_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end);
void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events);
DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index);
DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id);
gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id);
DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element);
DVBEventElement* dvb_event_storage_prev (DVBEventStorage* self, DVBEventElement* element);
GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
static gboolean dvb_event_storage_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static GeeIterator* dvb_event_storage_real_iterator (GeeIterable* base);
static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_new (DVBEventStorage* storage);
static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_construct (GType object_type, DVBEventStorage* storage);
static GType dvb_event_storage_event_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GeeBidirIterator* dvb_event_storage_bidir_iterator (DVBEventStorage* self);
gint dvb_event_storage_get_size (DVBEventStorage* self);
#define DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIteratorPrivate))
enum  {
	DVB_EVENT_STORAGE_EVENT_ITERATOR_DUMMY_PROPERTY,
	DVB_EVENT_STORAGE_EVENT_ITERATOR_VALID,
	DVB_EVENT_STORAGE_EVENT_ITERATOR_READ_ONLY
};
static gboolean dvb_event_storage_event_iterator_real_next (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_has_next (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_first (GeeBidirIterator* base);
static DVBEventElement* dvb_event_storage_event_iterator_real_get (GeeIterator* base);
static void dvb_event_storage_event_iterator_real_remove (GeeIterator* base);
static gboolean dvb_event_storage_event_iterator_real_previous (GeeBidirIterator* base);
static gboolean dvb_event_storage_event_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean dvb_event_storage_event_iterator_real_last (GeeBidirIterator* base);
static gboolean dvb_event_storage_event_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static void dvb_event_storage_event_iterator_finalize (GObject* obj);
static void _vala_dvb_event_storage_event_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_event_storage_finalize (GObject* obj);
static void _vala_dvb_event_storage_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


gint dvb_event_element_compare (DVBEventElement* event1, DVBEventElement* event2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	DVBEventElement* _tmp1_ = NULL;
	DVBEventElement* _tmp9_ = NULL;
	time_t _tmp10_ = 0;
	DVBEventElement* _tmp11_ = NULL;
	time_t _tmp12_ = 0;
	g_return_val_if_fail (event1 != NULL, 0);
	g_return_val_if_fail (event2 != NULL, 0);
	_tmp1_ = event1;
	if (_tmp1_ == NULL) {
		DVBEventElement* _tmp2_ = NULL;
		_tmp2_ = event2;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		DVBEventElement* _tmp4_ = NULL;
		_tmp4_ = event1;
		if (_tmp4_ == NULL) {
			DVBEventElement* _tmp5_ = NULL;
			_tmp5_ = event2;
			_tmp3_ = _tmp5_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = +1;
			return result;
		} else {
			gboolean _tmp6_ = FALSE;
			DVBEventElement* _tmp7_ = NULL;
			_tmp7_ = event1;
			if (_tmp7_ != NULL) {
				DVBEventElement* _tmp8_ = NULL;
				_tmp8_ = event2;
				_tmp6_ = _tmp8_ == NULL;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = -1;
				return result;
			}
		}
	}
	_tmp9_ = event1;
	_tmp10_ = _tmp9_->starttime;
	_tmp11_ = event2;
	_tmp12_ = _tmp11_->starttime;
	if (_tmp10_ < _tmp12_) {
		result = -1;
		return result;
	} else {
		DVBEventElement* _tmp13_ = NULL;
		time_t _tmp14_ = 0;
		DVBEventElement* _tmp15_ = NULL;
		time_t _tmp16_ = 0;
		_tmp13_ = event1;
		_tmp14_ = _tmp13_->starttime;
		_tmp15_ = event2;
		_tmp16_ = _tmp15_->starttime;
		if (_tmp14_ > _tmp16_) {
			result = +1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


DVBEventElement* dvb_event_element_new_from_event (DVBEvent* event) {
	DVBEventElement* result = NULL;
	DVBEventElement* element = NULL;
	DVBEventElement* _tmp0_ = NULL;
	DVBEvent* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	DVBEvent* _tmp3_ = NULL;
	time_t _tmp4_ = 0;
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = dvb_event_element_new ();
	element = _tmp0_;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->id;
	element->id = _tmp2_;
	_tmp3_ = event;
	_tmp4_ = dvb_event_get_start_timestamp (_tmp3_);
	element->starttime = _tmp4_;
	result = element;
	return result;
}


DVBEventElement* dvb_event_element_construct (GType object_type) {
	DVBEventElement * self = NULL;
	self = (DVBEventElement*) g_object_new (object_type, NULL);
	return self;
}


DVBEventElement* dvb_event_element_new (void) {
	return dvb_event_element_construct (DVB_TYPE_EVENT_ELEMENT);
}


static void dvb_event_element_class_init (DVBEventElementClass * klass) {
	dvb_event_element_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_event_element_finalize;
}


static void dvb_event_element_instance_init (DVBEventElement * self) {
}


static void dvb_event_element_finalize (GObject* obj) {
	DVBEventElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_EVENT_ELEMENT, DVBEventElement);
	G_OBJECT_CLASS (dvb_event_element_parent_class)->finalize (obj);
}


/**
     * We don't want to hold the complete information about
     * every event in memory. Just remember id and starttime
     * so we can have a sorted list.
     */
GType dvb_event_element_get_type (void) {
	static volatile gsize dvb_event_element_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventElement), 0, (GInstanceInitFunc) dvb_event_element_instance_init, NULL };
		GType dvb_event_element_type_id;
		dvb_event_element_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventElement", &g_define_type_info, 0);
		g_once_init_leave (&dvb_event_element_type_id__volatile, dvb_event_element_type_id);
	}
	return dvb_event_element_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


DVBEventStorage* dvb_event_storage_construct (GType object_type) {
	DVBEventStorage * self = NULL;
	GSequence* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self = (DVBEventStorage*) g_object_new (object_type, NULL);
	_tmp0_ = g_sequence_new (_g_object_unref0_);
	_g_sequence_free0 (self->priv->events);
	self->priv->events = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->event_id_map);
	self->priv->event_id_map = (GeeMap*) _tmp1_;
	return self;
}


DVBEventStorage* dvb_event_storage_new (void) {
	return dvb_event_storage_construct (DVB_TYPE_EVENT_STORAGE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint _dvb_event_element_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = dvb_event_element_compare ((DVBEventElement*) a, (DVBEventElement*) b);
	return result;
}


void dvb_event_storage_insert (DVBEventStorage* self, DVBEvent* event) {
	DVBEventElement* element = NULL;
	DVBEvent* _tmp0_ = NULL;
	DVBEventElement* _tmp1_ = NULL;
	GSequenceIter* iter = NULL;
	GSequence* _tmp2_ = NULL;
	DVBEventElement* _tmp3_ = NULL;
	GSequenceIter* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	DVBEvent* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	GSequence* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GeeMap* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = dvb_event_element_new_from_event (_tmp0_);
	element = _tmp1_;
	_tmp2_ = self->priv->events;
	_tmp3_ = _g_object_ref0 (element);
	_tmp4_ = g_sequence_insert_sorted (_tmp2_, _tmp3_, _dvb_event_element_compare_gcompare_data_func, NULL);
	iter = _tmp4_;
	_tmp5_ = self->priv->event_id_map;
	_tmp6_ = event;
	_tmp7_ = _tmp6_->id;
	gee_map_set (_tmp5_, (gpointer) ((guintptr) _tmp7_), iter);
	_tmp8_ = self->priv->_stamp;
	self->priv->_stamp = _tmp8_ + 1;
	_tmp9_ = self->priv->events;
	_tmp10_ = g_sequence_get_length (_tmp9_);
	_tmp11_ = self->priv->event_id_map;
	_tmp12_ = gee_map_get_size (_tmp11_);
	_tmp13_ = _tmp12_;
	_vala_assert (_tmp10_ == _tmp13_, "this.events.get_length () == this.event_id_map.size");
	_g_object_unref0 (element);
}


void dvb_event_storage_remove_range (DVBEventStorage* self, gint start, gint end) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSequence* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSequenceIter* begin_iter = NULL;
	GSequence* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSequenceIter* _tmp6_ = NULL;
	GSequenceIter* end_iter = NULL;
	GSequence* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GSequenceIter* _tmp9_ = NULL;
	GSequenceIter* iter = NULL;
	GSequenceIter* _tmp10_ = NULL;
	GSequenceIter* _tmp21_ = NULL;
	GSequenceIter* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GSequence* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GeeMap* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	_vala_assert (_tmp0_ >= 0, "start >= 0");
	_tmp1_ = end;
	_tmp2_ = self->priv->events;
	_tmp3_ = g_sequence_get_length (_tmp2_);
	_vala_assert (_tmp1_ < _tmp3_, "end < this.events.get_length ()");
	_tmp4_ = self->priv->events;
	_tmp5_ = start;
	_tmp6_ = g_sequence_get_iter_at_pos (_tmp4_, _tmp5_);
	begin_iter = _tmp6_;
	_tmp7_ = self->priv->events;
	_tmp8_ = end;
	_tmp9_ = g_sequence_get_iter_at_pos (_tmp7_, _tmp8_);
	end_iter = _tmp9_;
	_tmp10_ = begin_iter;
	iter = _tmp10_;
	while (TRUE) {
		GSequenceIter* _tmp11_ = NULL;
		GSequenceIter* _tmp12_ = NULL;
		DVBEventElement* element = NULL;
		GSequenceIter* _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		DVBEventElement* _tmp15_ = NULL;
		GeeMap* _tmp16_ = NULL;
		DVBEventElement* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		GSequenceIter* _tmp19_ = NULL;
		GSequenceIter* _tmp20_ = NULL;
		_tmp11_ = iter;
		_tmp12_ = end_iter;
		if (!(_tmp11_ != _tmp12_)) {
			break;
		}
		_tmp13_ = iter;
		_tmp14_ = g_sequence_get (_tmp13_);
		_tmp15_ = _g_object_ref0 ((DVBEventElement*) _tmp14_);
		element = _tmp15_;
		_tmp16_ = self->priv->event_id_map;
		_tmp17_ = element;
		_tmp18_ = _tmp17_->id;
		gee_map_unset (_tmp16_, (gpointer) ((guintptr) _tmp18_), NULL);
		_tmp19_ = iter;
		_tmp20_ = g_sequence_iter_next (_tmp19_);
		iter = _tmp20_;
		_g_object_unref0 (element);
	}
	_tmp21_ = begin_iter;
	_tmp22_ = end_iter;
	g_sequence_remove_range (_tmp21_, _tmp22_);
	_tmp23_ = self->priv->_stamp;
	self->priv->_stamp = _tmp23_ + 1;
	_tmp24_ = self->priv->events;
	_tmp25_ = g_sequence_get_length (_tmp24_);
	_tmp26_ = self->priv->event_id_map;
	_tmp27_ = gee_map_get_size (_tmp26_);
	_tmp28_ = _tmp27_;
	_vala_assert (_tmp25_ == _tmp28_, "this.events.get_length () == this.event_id_map.size");
}


void dvb_event_storage_remove_all (DVBEventStorage* self, GeeList* events) {
	gint _tmp20_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	{
		GeeList* _event_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _event_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _event_index = 0;
		_tmp0_ = events;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_event_list = _tmp1_;
		_tmp2_ = _event_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_event_size = _tmp4_;
		_event_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBEvent* event = NULL;
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GSequenceIter* iter = NULL;
			GeeMap* _tmp11_ = NULL;
			DVBEvent* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			gpointer _tmp14_ = NULL;
			GSequenceIter* _tmp15_ = NULL;
			_tmp5_ = _event_index;
			_event_index = _tmp5_ + 1;
			_tmp6_ = _event_index;
			_tmp7_ = _event_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _event_list;
			_tmp9_ = _event_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			event = (DVBEvent*) _tmp10_;
			_tmp11_ = self->priv->event_id_map;
			_tmp12_ = event;
			_tmp13_ = _tmp12_->id;
			_tmp14_ = gee_map_get (_tmp11_, (gpointer) ((guintptr) _tmp13_));
			iter = (GSequenceIter*) _tmp14_;
			_tmp15_ = iter;
			if (_tmp15_ != NULL) {
				GSequenceIter* _tmp16_ = NULL;
				GeeMap* _tmp17_ = NULL;
				DVBEvent* _tmp18_ = NULL;
				guint _tmp19_ = 0U;
				_tmp16_ = iter;
				g_sequence_remove (_tmp16_);
				_tmp17_ = self->priv->event_id_map;
				_tmp18_ = event;
				_tmp19_ = _tmp18_->id;
				gee_map_unset (_tmp17_, (gpointer) ((guintptr) _tmp19_), NULL);
			}
			_dvb_event_unref0 (event);
		}
		_g_object_unref0 (_event_list);
	}
	_tmp20_ = self->priv->_stamp;
	self->priv->_stamp = _tmp20_ + 1;
}


DVBEventElement* dvb_event_storage_get (DVBEventStorage* self, gint index) {
	DVBEventElement* result = NULL;
	gint _tmp0_ = 0;
	GSequence* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* iter = NULL;
	GSequence* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSequenceIter* _tmp5_ = NULL;
	DVBEventElement* element = NULL;
	gconstpointer _tmp6_ = NULL;
	DVBEventElement* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = self->priv->events;
	_tmp2_ = g_sequence_get_length (_tmp1_);
	_vala_assert (_tmp0_ < _tmp2_, "index < this.events.get_length ()");
	_tmp3_ = self->priv->events;
	_tmp4_ = index;
	_tmp5_ = g_sequence_get_iter_at_pos (_tmp3_, _tmp4_);
	iter = _tmp5_;
	_tmp6_ = g_sequence_get (iter);
	_tmp7_ = _g_object_ref0 ((DVBEventElement*) _tmp6_);
	element = _tmp7_;
	result = element;
	return result;
}


DVBEventElement* dvb_event_storage_get_by_id (DVBEventStorage* self, guint event_id) {
	DVBEventElement* result = NULL;
	GSequenceIter* iter = NULL;
	GeeMap* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gpointer _tmp2_ = NULL;
	DVBEventElement* element = NULL;
	gconstpointer _tmp3_ = NULL;
	DVBEventElement* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->event_id_map;
	_tmp1_ = event_id;
	_tmp2_ = gee_map_get (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	iter = (GSequenceIter*) _tmp2_;
	_tmp3_ = g_sequence_get (iter);
	_tmp4_ = _g_object_ref0 ((DVBEventElement*) _tmp3_);
	element = _tmp4_;
	result = element;
	return result;
}


gboolean dvb_event_storage_contains_event_with_id (DVBEventStorage* self, guint event_id) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->event_id_map;
	_tmp1_ = event_id;
	_tmp2_ = gee_map_has_key (_tmp0_, (gpointer) ((guintptr) _tmp1_));
	result = _tmp2_;
	return result;
}


DVBEventElement* dvb_event_storage_next (DVBEventStorage* self, DVBEventElement* element) {
	DVBEventElement* result = NULL;
	GSequenceIter* iter = NULL;
	GeeMap* _tmp0_ = NULL;
	DVBEventElement* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gpointer _tmp3_ = NULL;
	GSequenceIter* _tmp4_ = NULL;
	GSequenceIter* next = NULL;
	GSequenceIter* _tmp5_ = NULL;
	GSequenceIter* _tmp6_ = NULL;
	DVBEventElement* _tmp7_ = NULL;
	GSequenceIter* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	DVBEventElement* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->event_id_map;
	_tmp1_ = element;
	_tmp2_ = _tmp1_->id;
	_tmp3_ = gee_map_get (_tmp0_, (gpointer) ((guintptr) _tmp2_));
	iter = (GSequenceIter*) _tmp3_;
	_tmp4_ = iter;
	_vala_assert (_tmp4_ != NULL, "iter != null");
	_tmp5_ = iter;
	_tmp6_ = g_sequence_iter_next (_tmp5_);
	next = _tmp6_;
	_tmp8_ = next;
	_tmp9_ = g_sequence_iter_is_end (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = NULL;
	} else {
		GSequenceIter* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		_tmp10_ = next;
		_tmp11_ = g_sequence_get (_tmp10_);
		_tmp7_ = (DVBEventElement*) _tmp11_;
	}
	_tmp12_ = _g_object_ref0 (_tmp7_);
	result = _tmp12_;
	return result;
}


DVBEventElement* dvb_event_storage_prev (DVBEventStorage* self, DVBEventElement* element) {
	DVBEventElement* result = NULL;
	GSequenceIter* iter = NULL;
	GeeMap* _tmp0_ = NULL;
	DVBEventElement* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gpointer _tmp3_ = NULL;
	GSequenceIter* _tmp4_ = NULL;
	GSequenceIter* prev = NULL;
	GSequenceIter* _tmp5_ = NULL;
	GSequenceIter* _tmp6_ = NULL;
	DVBEventElement* _tmp7_ = NULL;
	GSequenceIter* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	DVBEventElement* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	_tmp0_ = self->priv->event_id_map;
	_tmp1_ = element;
	_tmp2_ = _tmp1_->id;
	_tmp3_ = gee_map_get (_tmp0_, (gpointer) ((guintptr) _tmp2_));
	iter = (GSequenceIter*) _tmp3_;
	_tmp4_ = iter;
	_vala_assert (_tmp4_ != NULL, "iter != null");
	_tmp5_ = iter;
	_tmp6_ = g_sequence_iter_prev (_tmp5_);
	prev = _tmp6_;
	_tmp8_ = prev;
	_tmp9_ = g_sequence_iter_is_begin (_tmp8_);
	if (_tmp9_) {
		_tmp7_ = NULL;
	} else {
		GSequenceIter* _tmp10_ = NULL;
		gconstpointer _tmp11_ = NULL;
		_tmp10_ = prev;
		_tmp11_ = g_sequence_get (_tmp10_);
		_tmp7_ = (DVBEventElement*) _tmp11_;
	}
	_tmp12_ = _g_object_ref0 (_tmp7_);
	result = _tmp12_;
	return result;
}


GeeList* dvb_event_storage_get_overlapping_events (DVBEventStorage* self, DVBEvent* event) {
	GeeList* result = NULL;
	DVBEventElement* element = NULL;
	DVBEvent* _tmp0_ = NULL;
	DVBEventElement* _tmp1_ = NULL;
	time_t event_end = 0;
	DVBEvent* _tmp2_ = NULL;
	time_t _tmp3_ = 0;
	GSequenceIter* start_iter = NULL;
	GSequence* _tmp4_ = NULL;
	DVBEventElement* _tmp5_ = NULL;
	GSequenceIter* _tmp6_ = NULL;
	GSequenceIter* _tmp7_ = NULL;
	GeeList* overlap = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GSequenceIter* end_iter = NULL;
	GSequenceIter* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event != NULL, NULL);
	_tmp0_ = event;
	_tmp1_ = dvb_event_element_new_from_event (_tmp0_);
	element = _tmp1_;
	_tmp2_ = event;
	_tmp3_ = dvb_event_get_end_timestamp (_tmp2_);
	event_end = _tmp3_;
	_tmp4_ = self->priv->events;
	_tmp5_ = element;
	_tmp6_ = g_sequence_search (_tmp4_, _tmp5_, _dvb_event_element_compare_gcompare_data_func, NULL);
	_tmp7_ = g_sequence_iter_prev (_tmp6_);
	start_iter = _tmp7_;
	_tmp8_ = gee_array_list_new (DVB_TYPE_EVENT_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	overlap = (GeeList*) _tmp8_;
	_tmp9_ = start_iter;
	end_iter = _tmp9_;
	while (TRUE) {
		GSequenceIter* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		DVBEventElement* data = NULL;
		GSequenceIter* _tmp12_ = NULL;
		gconstpointer _tmp13_ = NULL;
		DVBEventElement* _tmp14_ = NULL;
		DVBEventElement* _tmp15_ = NULL;
		time_t _tmp16_ = 0;
		time_t _tmp17_ = 0;
		GeeList* _tmp18_ = NULL;
		DVBEventElement* _tmp19_ = NULL;
		GSequenceIter* _tmp20_ = NULL;
		GSequenceIter* _tmp21_ = NULL;
		_tmp10_ = end_iter;
		_tmp11_ = g_sequence_iter_is_end (_tmp10_);
		if (!(!_tmp11_)) {
			break;
		}
		_tmp12_ = end_iter;
		_tmp13_ = g_sequence_get (_tmp12_);
		_tmp14_ = _g_object_ref0 ((DVBEventElement*) _tmp13_);
		data = _tmp14_;
		_tmp15_ = data;
		_tmp16_ = _tmp15_->starttime;
		_tmp17_ = event_end;
		if (_tmp16_ > _tmp17_) {
			_g_object_unref0 (data);
			break;
		}
		_tmp18_ = overlap;
		_tmp19_ = data;
		gee_collection_add ((GeeCollection*) _tmp18_, _tmp19_);
		_tmp20_ = end_iter;
		_tmp21_ = g_sequence_iter_next (_tmp20_);
		end_iter = _tmp21_;
		_g_object_unref0 (data);
	}
	result = overlap;
	_g_object_unref0 (element);
	return result;
}


static gboolean dvb_event_storage_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	DVBEventStorage * self;
	gboolean result = FALSE;
	GeeIterator* iter = NULL;
	GeeIterator* _tmp0_ = NULL;
	GeeForallFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	gboolean _tmp2_ = FALSE;
	self = (DVBEventStorage*) base;
	_tmp0_ = gee_iterable_iterator ((GeeIterable*) self);
	iter = _tmp0_;
	_tmp1_ = f;
	_tmp1__target = f_target;
	_tmp2_ = gee_traversable_foreach ((GeeTraversable*) iter, _tmp1_, _tmp1__target);
	result = _tmp2_;
	_g_object_unref0 (iter);
	return result;
}


static GeeIterator* dvb_event_storage_real_iterator (GeeIterable* base) {
	DVBEventStorage * self;
	GeeIterator* result = NULL;
	DVBEventStorageEventIterator* _tmp0_ = NULL;
	self = (DVBEventStorage*) base;
	_tmp0_ = dvb_event_storage_event_iterator_new (self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


GeeBidirIterator* dvb_event_storage_bidir_iterator (DVBEventStorage* self) {
	GeeBidirIterator* result = NULL;
	DVBEventStorageEventIterator* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_event_storage_event_iterator_new (self);
	result = (GeeBidirIterator*) _tmp0_;
	return result;
}


gint dvb_event_storage_get_size (DVBEventStorage* self) {
	gint result;
	GSequence* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->events;
	_tmp1_ = g_sequence_get_length (_tmp0_);
	result = _tmp1_;
	return result;
}


static GType dvb_event_storage_real_get_element_type (GeeTraversable* base) {
	GType result;
	DVBEventStorage* self;
	self = (DVBEventStorage*) base;
	result = DVB_TYPE_EVENT_ELEMENT;
	return result;
}


static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_construct (GType object_type, DVBEventStorage* storage) {
	DVBEventStorageEventIterator * self = NULL;
	DVBEventStorage* _tmp0_ = NULL;
	DVBEventStorage* _tmp1_ = NULL;
	DVBEventStorage* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (storage != NULL, NULL);
	self = (DVBEventStorageEventIterator*) g_object_new (object_type, NULL);
	_tmp0_ = storage;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	_tmp2_ = storage;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
	return self;
}


static DVBEventStorageEventIterator* dvb_event_storage_event_iterator_new (DVBEventStorage* storage) {
	return dvb_event_storage_event_iterator_construct (DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, storage);
}


static gboolean dvb_event_storage_event_iterator_real_next (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_iter;
	_tmp4_ = g_sequence_iter_is_end (_tmp3_);
	if (!_tmp4_) {
		GSequenceIter* _tmp5_ = NULL;
		GSequenceIter* _tmp6_ = NULL;
		_tmp5_ = self->priv->_iter;
		_tmp6_ = g_sequence_iter_next (_tmp5_);
		self->priv->_iter = _tmp6_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_has_next (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_iter;
	_tmp4_ = g_sequence_iter_is_end (_tmp3_);
	result = !_tmp4_;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_first (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	DVBEventStorage* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_storage;
	_tmp4_ = dvb_event_storage_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		DVBEventStorage* _tmp6_ = NULL;
		GSequence* _tmp7_ = NULL;
		GSequenceIter* _tmp8_ = NULL;
		_tmp6_ = self->priv->_storage;
		_tmp7_ = _tmp6_->priv->events;
		_tmp8_ = g_sequence_get_begin_iter (_tmp7_);
		self->priv->_iter = _tmp8_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static DVBEventElement* dvb_event_storage_event_iterator_real_get (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	DVBEventElement* result = NULL;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* _tmp3_ = NULL;
	GSequenceIter* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	DVBEventElement* _tmp6_ = NULL;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_iter;
	_vala_assert (_tmp3_ != NULL, "_iter != null");
	_tmp4_ = self->priv->_iter;
	_tmp5_ = g_sequence_get (_tmp4_);
	_tmp6_ = _g_object_ref0 ((DVBEventElement*) _tmp5_);
	result = _tmp6_;
	return result;
}


static void dvb_event_storage_event_iterator_real_remove (GeeIterator* base) {
	DVBEventStorageEventIterator * self;
	self = (DVBEventStorageEventIterator*) base;
}


static gboolean dvb_event_storage_event_iterator_real_previous (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_iter;
	_tmp4_ = g_sequence_iter_is_begin (_tmp3_);
	if (!_tmp4_) {
		GSequenceIter* _tmp5_ = NULL;
		GSequenceIter* _tmp6_ = NULL;
		_tmp5_ = self->priv->_iter;
		_tmp6_ = g_sequence_iter_prev (_tmp5_);
		self->priv->_iter = _tmp6_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_has_previous (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSequenceIter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_iter;
	_tmp4_ = g_sequence_iter_is_begin (_tmp3_);
	result = !_tmp4_;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_last (GeeBidirIterator* base) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	DVBEventStorage* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	_tmp3_ = self->priv->_storage;
	_tmp4_ = dvb_event_storage_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		DVBEventStorage* _tmp6_ = NULL;
		GSequence* _tmp7_ = NULL;
		GSequenceIter* _tmp8_ = NULL;
		_tmp6_ = self->priv->_storage;
		_tmp7_ = _tmp6_->priv->events;
		_tmp8_ = g_sequence_get_end_iter (_tmp7_);
		self->priv->_iter = _tmp8_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	DVBEventStorageEventIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEventStorage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = (DVBEventStorageEventIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_storage;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _storage._stamp");
	while (TRUE) {
		GSequenceIter* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GSequenceIter* _tmp5_ = NULL;
		GSequenceIter* _tmp6_ = NULL;
		GeeForallFunc _tmp7_ = NULL;
		void* _tmp7__target = NULL;
		GSequenceIter* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		DVBEventElement* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp3_ = self->priv->_iter;
		_tmp4_ = g_sequence_iter_is_end (_tmp3_);
		if (!(!_tmp4_)) {
			break;
		}
		_tmp5_ = self->priv->_iter;
		_tmp6_ = g_sequence_iter_next (_tmp5_);
		self->priv->_iter = _tmp6_;
		_tmp7_ = f;
		_tmp7__target = f_target;
		_tmp8_ = self->priv->_iter;
		_tmp9_ = g_sequence_get (_tmp8_);
		_tmp10_ = _g_object_ref0 ((DVBEventElement*) _tmp9_);
		_tmp11_ = _tmp7_ (_tmp10_, _tmp7__target);
		if (!_tmp11_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	DVBEventStorageEventIterator* self;
	self = (DVBEventStorageEventIterator*) base;
	result = TRUE;
	return result;
}


static gboolean dvb_event_storage_event_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	DVBEventStorageEventIterator* self;
	self = (DVBEventStorageEventIterator*) base;
	result = TRUE;
	return result;
}


static void dvb_event_storage_event_iterator_class_init (DVBEventStorageEventIteratorClass * klass) {
	dvb_event_storage_event_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEventStorageEventIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_event_storage_event_iterator_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_event_storage_event_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_EVENT_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_EVENT_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType dvb_event_storage_event_iterator_gee_traversable_get_g_type (DVBEventStorageEventIterator* self) {
	return DVB_TYPE_EVENT_ELEMENT;
}


static GBoxedCopyFunc dvb_event_storage_event_iterator_gee_traversable_get_g_dup_func (DVBEventStorageEventIterator* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_event_storage_event_iterator_gee_traversable_get_g_destroy_func (DVBEventStorageEventIterator* self) {
	return g_object_unref;
}


static void dvb_event_storage_event_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
	dvb_event_storage_event_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) dvb_event_storage_event_iterator_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) dvb_event_storage_event_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) dvb_event_storage_event_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) dvb_event_storage_event_iterator_gee_traversable_get_g_destroy_func;
}


static void dvb_event_storage_event_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	dvb_event_storage_event_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_has_next;
	iface->get = (gpointer (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) dvb_event_storage_event_iterator_real_remove;
	iface->get_valid = dvb_event_storage_event_iterator_real_get_valid;
	iface->get_read_only = dvb_event_storage_event_iterator_real_get_read_only;
}


static GType dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_type (DVBEventStorageEventIterator* self) {
	return DVB_TYPE_EVENT_ELEMENT;
}


static GBoxedCopyFunc dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_dup_func (DVBEventStorageEventIterator* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_destroy_func (DVBEventStorageEventIterator* self) {
	return g_object_unref;
}


static void dvb_event_storage_event_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	dvb_event_storage_event_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->first = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_first;
	iface->previous = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_previous;
	iface->has_previous = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_has_previous;
	iface->last = (gboolean (*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_real_last;
	iface->get_g_type = (GType(*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeBidirIterator*)) dvb_event_storage_event_iterator_gee_bidir_iterator_get_g_destroy_func;
}


static void dvb_event_storage_event_iterator_instance_init (DVBEventStorageEventIterator * self) {
	self->priv = DVB_EVENT_STORAGE_EVENT_ITERATOR_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void dvb_event_storage_event_iterator_finalize (GObject* obj) {
	DVBEventStorageEventIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIterator);
	_g_object_unref0 (self->priv->_storage);
	G_OBJECT_CLASS (dvb_event_storage_event_iterator_parent_class)->finalize (obj);
}


static GType dvb_event_storage_event_iterator_get_type (void) {
	static volatile gsize dvb_event_storage_event_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_storage_event_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventStorageEventIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_storage_event_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventStorageEventIterator), 0, (GInstanceInitFunc) dvb_event_storage_event_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) dvb_event_storage_event_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) dvb_event_storage_event_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) dvb_event_storage_event_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_event_storage_event_iterator_type_id;
		dvb_event_storage_event_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventStorageEventIterator", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_event_storage_event_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (dvb_event_storage_event_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (dvb_event_storage_event_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_once_init_leave (&dvb_event_storage_event_iterator_type_id__volatile, dvb_event_storage_event_iterator_type_id);
	}
	return dvb_event_storage_event_iterator_type_id__volatile;
}


static void _vala_dvb_event_storage_event_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBEventStorageEventIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_EVENT_STORAGE_TYPE_EVENT_ITERATOR, DVBEventStorageEventIterator);
	switch (property_id) {
		case DVB_EVENT_STORAGE_EVENT_ITERATOR_VALID:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case DVB_EVENT_STORAGE_EVENT_ITERATOR_READ_ONLY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_event_storage_class_init (DVBEventStorageClass * klass) {
	dvb_event_storage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEventStoragePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_event_storage_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_event_storage_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EVENT_STORAGE_ELEMENT_TYPE, g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType dvb_event_storage_gee_traversable_get_g_type (DVBEventStorage* self) {
	return DVB_TYPE_EVENT_ELEMENT;
}


static GBoxedCopyFunc dvb_event_storage_gee_traversable_get_g_dup_func (DVBEventStorage* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_event_storage_gee_traversable_get_g_destroy_func (DVBEventStorage* self) {
	return g_object_unref;
}


static void dvb_event_storage_gee_traversable_interface_init (GeeTraversableIface * iface) {
	dvb_event_storage_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) dvb_event_storage_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) dvb_event_storage_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) dvb_event_storage_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) dvb_event_storage_gee_traversable_get_g_destroy_func;
	iface->get_element_type = dvb_event_storage_real_get_element_type;
}


static GType dvb_event_storage_gee_iterable_get_g_type (DVBEventStorage* self) {
	return DVB_TYPE_EVENT_ELEMENT;
}


static GBoxedCopyFunc dvb_event_storage_gee_iterable_get_g_dup_func (DVBEventStorage* self) {
	return g_object_ref;
}


static GDestroyNotify dvb_event_storage_gee_iterable_get_g_destroy_func (DVBEventStorage* self) {
	return g_object_unref;
}


static void dvb_event_storage_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_event_storage_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_event_storage_real_iterator;
	iface->get_g_type = (GType(*)(GeeIterable*)) dvb_event_storage_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeIterable*)) dvb_event_storage_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeIterable*)) dvb_event_storage_gee_iterable_get_g_destroy_func;
}


static void dvb_event_storage_instance_init (DVBEventStorage * self) {
	self->priv = DVB_EVENT_STORAGE_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void dvb_event_storage_finalize (GObject* obj) {
	DVBEventStorage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_EVENT_STORAGE, DVBEventStorage);
	_g_sequence_free0 (self->priv->events);
	_g_object_unref0 (self->priv->event_id_map);
	G_OBJECT_CLASS (dvb_event_storage_parent_class)->finalize (obj);
}


GType dvb_event_storage_get_type (void) {
	static volatile gsize dvb_event_storage_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEventStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_event_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEventStorage), 0, (GInstanceInitFunc) dvb_event_storage_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) dvb_event_storage_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_event_storage_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_event_storage_type_id;
		dvb_event_storage_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEventStorage", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_event_storage_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (dvb_event_storage_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_once_init_leave (&dvb_event_storage_type_id__volatile, dvb_event_storage_type_id);
	}
	return dvb_event_storage_type_id__volatile;
}


static void _vala_dvb_event_storage_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBEventStorage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_EVENT_STORAGE, DVBEventStorage);
	switch (property_id) {
		case DVB_EVENT_STORAGE_SIZE:
		g_value_set_int (value, dvb_event_storage_get_size (self));
		break;
		case DVB_EVENT_STORAGE_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_traversable_get_element_type ((GeeTraversable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



