/* Device.c generated by valac 0.25.1, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gudev/gudev.h>
#include <gst/gst.h>


#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
typedef struct _DVBDevicePrivate DVBDevicePrivate;

#define DVB_TYPE_DVB_SRC_DELSYS (dvb_dvb_src_delsys_get_type ())

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBDevice {
	GObject parent_instance;
	DVBDevicePrivate * priv;
};

struct _DVBDeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_DELSYS_SYS_UNDEFINED,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B,
	DVB_DVB_SRC_DELSYS_SYS_DVBT,
	DVB_DVB_SRC_DELSYS_SYS_DSS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS2,
	DVB_DVB_SRC_DELSYS_SYS_DVBH,
	DVB_DVB_SRC_DELSYS_SYS_ISDBT,
	DVB_DVB_SRC_DELSYS_SYS_ISDBS,
	DVB_DVB_SRC_DELSYS_SYS_ISDBC,
	DVB_DVB_SRC_DELSYS_SYS_ATSC,
	DVB_DVB_SRC_DELSYS_SYS_ATSCMH,
	DVB_DVB_SRC_DELSYS_SYS_DTMB,
	DVB_DVB_SRC_DELSYS_SYS_CMMB,
	DVB_DVB_SRC_DELSYS_SYS_DAB,
	DVB_DVB_SRC_DELSYS_SYS_DVBT2,
	DVB_DVB_SRC_DELSYS_SYS_TURBO,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C
} DVBDvbSrcDelsys;

struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	gchar* _DevFile;
	gchar* _UID;
	gchar* _Name;
	GeeArrayList* delsys;
};


static gpointer dvb_device_parent_class = NULL;
static DVBLoggingLogger* dvb_device_log;
static DVBLoggingLogger* dvb_device_log = NULL;

GQuark dvb_device_error_quark (void);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_dvb_src_delsys_get_type (void) G_GNUC_CONST;
#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_DEV_FILE,
	DVB_DEVICE_UID,
	DVB_DEVICE_NAME
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_DEVICE_PRIME 31
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_udev (GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend);
DVBDevice* dvb_device_construct_with_udev (GType object_type, GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend);
const gchar* dvb_device_get_Name (DVBDevice* self);
static void dvb_device_set_Name (DVBDevice* self, const gchar* value);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_device_set_DevFile (DVBDevice* self, const gchar* value);
static void dvb_device_set_UID (DVBDevice* self, const gchar* value);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
guint dvb_device_hash (DVBDevice* device);
guint dvb_device_hash_without_device (guint adapter, guint frontend);
gboolean dvb_device_isTerrestrial (DVBDevice* self);
gboolean dvb_device_isCable (DVBDevice* self);
gboolean dvb_device_isSatellite (DVBDevice* self);
gboolean dvb_device_isDVB (DVBDevice* self);
gboolean dvb_device_isATSC (DVBDevice* self);
gboolean dvb_device_isISDB (DVBDevice* self);
gboolean dvb_device_isDelsys (DVBDevice* self, DVBDvbSrcDelsys delsys);
gboolean dvb_device_is_busy (DVBDevice* self);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
const gchar* dvb_device_get_DevFile (DVBDevice* self);
const gchar* dvb_device_get_UID (DVBDevice* self);
static void dvb_device_finalize (GObject* obj);
static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark dvb_device_error_quark (void) {
	return g_quark_from_static_string ("dvb_device_error-quark");
}


GType dvb_adapter_type_get_type (void) {
	static volatile gsize dvb_adapter_type_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_adapter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {DVB_ADAPTER_TYPE_TERRESTRIAL, "DVB_ADAPTER_TYPE_TERRESTRIAL", "terrestrial"}, {DVB_ADAPTER_TYPE_SATELLITE, "DVB_ADAPTER_TYPE_SATELLITE", "satellite"}, {DVB_ADAPTER_TYPE_CABLE, "DVB_ADAPTER_TYPE_CABLE", "cable"}, {0, NULL, NULL}};
		GType dvb_adapter_type_type_id;
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
		g_once_init_leave (&dvb_adapter_type_type_id__volatile, dvb_adapter_type_type_id);
	}
	return dvb_adapter_type_type_id__volatile;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend) {
	DVBDevice * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	self = (DVBDevice*) g_object_new (object_type, "Adapter", _tmp0_, "Frontend", _tmp1_, NULL);
	_tmp2_ = adapter;
	_tmp3_ = frontend;
	dvb_device_setAdapterTypeAndName (self, _tmp2_, _tmp3_);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend);
}


DVBDevice* dvb_device_construct_with_udev (GType object_type, GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend) {
	DVBDevice * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GUdevDevice* parent = NULL;
	GUdevDevice* _tmp4_ = NULL;
	GUdevDevice* _tmp5_ = NULL;
	gchar* name = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* tmp = NULL;
	GUdevDevice* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	DVBLoggingLogger* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GUdevDevice* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (dev_file != NULL, NULL);
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	self = (DVBDevice*) g_object_new (object_type, "Adapter", _tmp0_, "Frontend", _tmp1_, NULL);
	_tmp2_ = adapter;
	_tmp3_ = frontend;
	dvb_device_setAdapterTypeAndName (self, _tmp2_, _tmp3_);
	_tmp4_ = device;
	_tmp5_ = g_udev_device_get_parent (_tmp4_);
	parent = _tmp5_;
	_tmp6_ = self->priv->_Name;
	_tmp7_ = g_strdup (_tmp6_);
	name = _tmp7_;
	_tmp8_ = parent;
	_tmp9_ = g_udev_device_get_property (_tmp8_, "ID_MODEL_FROM_DATABASE");
	_tmp10_ = g_strdup (_tmp9_);
	tmp = _tmp10_;
	_tmp11_ = tmp;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = name;
		dvb_device_set_Name (self, _tmp12_);
	} else {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp13_ = tmp;
		_tmp14_ = g_strconcat (_tmp13_, ": ", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = name;
		_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		dvb_device_set_Name (self, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp15_);
	}
	_tmp19_ = dvb_device_log;
	_tmp20_ = self->priv->_Name;
	dvb_logging_logger_debug (_tmp19_, "Device.vala:75: Adding Device: %s", _tmp20_);
	_tmp21_ = dev_file;
	dvb_device_set_DevFile (self, _tmp21_);
	_tmp22_ = parent;
	_tmp23_ = g_udev_device_get_subsystem (_tmp22_);
	if (g_strcmp0 (_tmp23_, "pci") == 0) {
		gchar* uid = NULL;
		GUdevDevice* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GUdevDevice* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		DVBLoggingLogger* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp24_ = parent;
		_tmp25_ = g_udev_device_get_property (_tmp24_, "PCI_SLOT_NAME");
		_tmp26_ = g_strdup (_tmp25_);
		uid = _tmp26_;
		_tmp27_ = uid;
		_tmp28_ = parent;
		_tmp29_ = g_udev_device_get_property (_tmp28_, "PCI_SUBSYS_ID");
		_tmp30_ = g_strconcat (":", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp27_, _tmp31_, NULL);
		_g_free0 (uid);
		uid = _tmp32_;
		_g_free0 (_tmp31_);
		_tmp33_ = uid;
		_tmp34_ = name;
		_tmp35_ = g_strconcat (":", _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp33_, _tmp36_, NULL);
		_g_free0 (uid);
		uid = _tmp37_;
		_g_free0 (_tmp36_);
		_tmp38_ = dvb_device_log;
		_tmp39_ = uid;
		dvb_logging_logger_debug (_tmp38_, "Device.vala:84: UID: %s", _tmp39_);
		_tmp40_ = uid;
		dvb_device_set_UID (self, _tmp40_);
		_g_free0 (uid);
	} else {
		GUdevDevice* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		_tmp41_ = parent;
		_tmp42_ = g_udev_device_get_subsystem (_tmp41_);
		if (g_strcmp0 (_tmp42_, "usb") == 0) {
			gchar* uid = NULL;
			GUdevDevice* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			DVBLoggingLogger* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			_tmp43_ = parent;
			_tmp44_ = g_udev_device_get_property (_tmp43_, "ID_SERIAL");
			_tmp45_ = g_strdup (_tmp44_);
			uid = _tmp45_;
			_tmp46_ = uid;
			_tmp47_ = name;
			_tmp48_ = g_strconcat (":", _tmp47_, NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
			_g_free0 (uid);
			uid = _tmp50_;
			_g_free0 (_tmp49_);
			_tmp51_ = dvb_device_log;
			_tmp52_ = uid;
			dvb_logging_logger_debug (_tmp51_, "Device.vala:89: UID: %s", _tmp52_);
			_tmp53_ = uid;
			dvb_device_set_UID (self, _tmp53_);
			_g_free0 (uid);
		}
	}
	_g_free0 (tmp);
	_g_free0 (name);
	_g_object_unref0 (parent);
	return self;
}


DVBDevice* dvb_device_new_with_udev (GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend) {
	return dvb_device_construct_with_udev (DVB_TYPE_DEVICE, device, dev_file, adapter, frontend);
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DVBDevice* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	DVBDevice* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	DVBDevice* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	g_return_val_if_fail (dev1 != NULL, FALSE);
	g_return_val_if_fail (dev2 != NULL, FALSE);
	_tmp1_ = dev1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DVBDevice* _tmp2_ = NULL;
		_tmp2_ = dev2;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = dev1;
	_tmp5_ = _tmp4_->priv->_Adapter;
	_tmp6_ = dev2;
	_tmp7_ = _tmp6_->priv->_Adapter;
	if (_tmp5_ == _tmp7_) {
		DVBDevice* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		DVBDevice* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		_tmp8_ = dev1;
		_tmp9_ = _tmp8_->priv->_Frontend;
		_tmp10_ = dev2;
		_tmp11_ = _tmp10_->priv->_Frontend;
		_tmp3_ = _tmp9_ == _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	result = _tmp3_;
	return result;
}


guint dvb_device_hash (DVBDevice* device) {
	guint result = 0U;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	DVBDevice* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (device != NULL, 0U);
	_tmp0_ = device;
	if (_tmp0_ == NULL) {
		result = (guint) 0;
		return result;
	}
	_tmp1_ = device;
	_tmp2_ = _tmp1_->priv->_Adapter;
	_tmp3_ = device;
	_tmp4_ = _tmp3_->priv->_Frontend;
	_tmp5_ = dvb_device_hash_without_device (_tmp2_, _tmp4_);
	result = _tmp5_;
	return result;
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	result = ((2 * DVB_DEVICE_PRIME) + (DVB_DEVICE_PRIME * _tmp0_)) + _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean dvb_device_isTerrestrial (DVBDevice* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_DVBT:
				case DVB_DVB_SRC_DELSYS_SYS_DVBT2:
				case DVB_DVB_SRC_DELSYS_SYS_DVBH:
				case DVB_DVB_SRC_DELSYS_SYS_ATSC:
				case DVB_DVB_SRC_DELSYS_SYS_ATSCMH:
				case DVB_DVB_SRC_DELSYS_SYS_ISDBT:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_isCable (DVBDevice* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A:
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B:
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C:
				case DVB_DVB_SRC_DELSYS_SYS_ISDBC:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_isSatellite (DVBDevice* self) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = FALSE;
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_DVBS:
				case DVB_DVB_SRC_DELSYS_SYS_DVBS2:
				case DVB_DVB_SRC_DELSYS_SYS_ISDBS:
				case DVB_DVB_SRC_DELSYS_SYS_DSS:
				case DVB_DVB_SRC_DELSYS_SYS_TURBO:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = ret;
	return result;
}


gboolean dvb_device_isDVB (DVBDevice* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_DVBT:
				case DVB_DVB_SRC_DELSYS_SYS_DVBT2:
				case DVB_DVB_SRC_DELSYS_SYS_DVBS:
				case DVB_DVB_SRC_DELSYS_SYS_DVBS2:
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A:
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C:
				case DVB_DVB_SRC_DELSYS_SYS_DVBH:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_isATSC (DVBDevice* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B:
				case DVB_DVB_SRC_DELSYS_SYS_ATSC:
				case DVB_DVB_SRC_DELSYS_SYS_ATSCMH:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_isISDB (DVBDevice* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _delsys_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _delsys_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _delsys_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_delsys_list = _tmp1_;
		_tmp2_ = _delsys_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_delsys_size = _tmp4_;
		_delsys_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys delsys = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			_tmp5_ = _delsys_index;
			_delsys_index = _tmp5_ + 1;
			_tmp6_ = _delsys_index;
			_tmp7_ = _delsys_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _delsys_list;
			_tmp9_ = _delsys_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			delsys = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = delsys;
			switch (_tmp11_) {
				case DVB_DVB_SRC_DELSYS_SYS_ISDBT:
				case DVB_DVB_SRC_DELSYS_SYS_ISDBC:
				case DVB_DVB_SRC_DELSYS_SYS_ISDBS:
				{
					result = TRUE;
					_g_object_unref0 (_delsys_list);
					return result;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (_delsys_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_isDelsys (DVBDevice* self, DVBDvbSrcDelsys delsys) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _d_list = NULL;
		GeeArrayList* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		gint _d_size = 0;
		GeeArrayList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _d_index = 0;
		_tmp0_ = self->priv->delsys;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_d_list = _tmp1_;
		_tmp2_ = _d_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_d_size = _tmp4_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			DVBDvbSrcDelsys d = 0;
			GeeArrayList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			DVBDvbSrcDelsys _tmp11_ = 0;
			DVBDvbSrcDelsys _tmp12_ = 0;
			_tmp5_ = _d_index;
			_d_index = _tmp5_ + 1;
			_tmp6_ = _d_index;
			_tmp7_ = _d_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _d_list;
			_tmp9_ = _d_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			d = (DVBDvbSrcDelsys) ((gintptr) _tmp10_);
			_tmp11_ = d;
			_tmp12_ = delsys;
			if (_tmp11_ == _tmp12_) {
				result = TRUE;
				_g_object_unref0 (_d_list);
				return result;
			}
		}
		_g_object_unref0 (_d_list);
	}
	result = FALSE;
	return result;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	gboolean result = FALSE;
	GstElement* dvbsrc = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GstElement* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GstElement* pipeline = NULL;
	GstPipeline* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	GstElement* _tmp11_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp12_ = NULL;
	GstBus* _tmp13_ = NULL;
	gboolean busy_val = FALSE;
	GstElement* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	dvbsrc = _tmp0_;
	_tmp1_ = dvbsrc;
	if (_tmp1_ == NULL) {
		DVBLoggingLogger* _tmp2_ = NULL;
		_tmp2_ = dvb_device_log;
		dvb_logging_logger_error (_tmp2_, "Device.vala:217: Could not create dvbsrc element");
		result = TRUE;
		_g_object_unref0 (dvbsrc);
		return result;
	}
	_tmp3_ = dvbsrc;
	_tmp4_ = self->priv->_Adapter;
	g_object_set ((GObject*) _tmp3_, "adapter", _tmp4_, NULL);
	_tmp5_ = dvbsrc;
	_tmp6_ = self->priv->_Frontend;
	g_object_set ((GObject*) _tmp5_, "frontend", _tmp6_, NULL);
	_tmp7_ = (GstPipeline*) gst_pipeline_new ("");
	g_object_ref_sink (_tmp7_);
	pipeline = (GstElement*) _tmp7_;
	_tmp8_ = pipeline;
	_tmp9_ = dvbsrc;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gst_bin_get_type (), GstBin), _tmp10_);
	_tmp11_ = pipeline;
	gst_element_set_state (_tmp11_, GST_STATE_READY);
	_tmp12_ = pipeline;
	_tmp13_ = gst_element_get_bus (_tmp12_);
	bus = _tmp13_;
	busy_val = FALSE;
	while (TRUE) {
		GstBus* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		GstMessage* msg = NULL;
		GstBus* _tmp16_ = NULL;
		GstMessage* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		GstMessage* _tmp19_ = NULL;
		GstMessageType _tmp20_ = 0;
		_tmp14_ = bus;
		_tmp15_ = gst_bus_have_pending (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = bus;
		_tmp17_ = gst_bus_pop (_tmp16_);
		msg = _tmp17_;
		_tmp19_ = msg;
		_tmp20_ = _tmp19_->type;
		if (_tmp20_ == GST_MESSAGE_ERROR) {
			GstMessage* _tmp21_ = NULL;
			GstObject* _tmp22_ = NULL;
			GstElement* _tmp23_ = NULL;
			_tmp21_ = msg;
			_tmp22_ = _tmp21_->src;
			_tmp23_ = dvbsrc;
			_tmp18_ = _tmp22_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gst_object_get_type (), GstObject);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GError* gerror = NULL;
			gchar* debug_text = NULL;
			GstMessage* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			DVBLoggingLogger* _tmp27_ = NULL;
			GError* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			_tmp24_ = msg;
			gst_message_parse_error (_tmp24_, &_tmp25_, &_tmp26_);
			_g_error_free0 (gerror);
			gerror = _tmp25_;
			_g_free0 (debug_text);
			debug_text = _tmp26_;
			_tmp27_ = dvb_device_log;
			_tmp28_ = gerror;
			_tmp29_ = _tmp28_->message;
			_tmp30_ = debug_text;
			dvb_logging_logger_debug (_tmp27_, "Device.vala:239: Error tuning: %s; %s", _tmp29_, _tmp30_);
			busy_val = TRUE;
			_g_free0 (debug_text);
			_g_error_free0 (gerror);
		}
		_gst_message_unref0 (msg);
	}
	_tmp31_ = pipeline;
	gst_element_set_state (_tmp31_, GST_STATE_NULL);
	result = busy_val;
	_g_object_unref0 (bus);
	_g_object_unref0 (pipeline);
	_g_object_unref0 (dvbsrc);
	return result;
}


static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend) {
	gboolean result = FALSE;
	GstElement* dvbsrc = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GstElement* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GstElement* pipeline = NULL;
	GstPipeline* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	GstElement* _tmp11_ = NULL;
	GstBus* bus = NULL;
	GstElement* _tmp12_ = NULL;
	GstBus* _tmp13_ = NULL;
	gboolean success = FALSE;
	GeeArrayList* _tmp14_ = NULL;
	GstElement* _tmp95_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	if (_tmp0_ != NULL) {
		g_object_ref_sink (_tmp0_);
	}
	dvbsrc = _tmp0_;
	_tmp1_ = dvbsrc;
	if (_tmp1_ == NULL) {
		DVBLoggingLogger* _tmp2_ = NULL;
		_tmp2_ = dvb_device_log;
		dvb_logging_logger_error (_tmp2_, "Device.vala:253: Could not create dvbsrc element");
		result = FALSE;
		_g_object_unref0 (dvbsrc);
		return result;
	}
	_tmp3_ = dvbsrc;
	_tmp4_ = adapter;
	g_object_set ((GObject*) _tmp3_, "adapter", _tmp4_, NULL);
	_tmp5_ = dvbsrc;
	_tmp6_ = frontend;
	g_object_set ((GObject*) _tmp5_, "frontend", _tmp6_, NULL);
	_tmp7_ = (GstPipeline*) gst_pipeline_new ("type_name");
	g_object_ref_sink (_tmp7_);
	pipeline = (GstElement*) _tmp7_;
	_tmp8_ = pipeline;
	_tmp9_ = dvbsrc;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	gst_bin_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gst_bin_get_type (), GstBin), _tmp10_);
	_tmp11_ = pipeline;
	gst_element_set_state (_tmp11_, GST_STATE_READY);
	_tmp12_ = pipeline;
	_tmp13_ = gst_element_get_bus (_tmp12_);
	bus = _tmp13_;
	success = FALSE;
	_tmp14_ = gee_array_list_new (DVB_TYPE_DVB_SRC_DELSYS, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->delsys);
	self->priv->delsys = _tmp14_;
	while (TRUE) {
		GstBus* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GstMessage* msg = NULL;
		GstBus* _tmp17_ = NULL;
		GstMessage* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GstMessage* _tmp20_ = NULL;
		GstMessageType _tmp21_ = 0;
		_tmp15_ = bus;
		_tmp16_ = gst_bus_have_pending (_tmp15_);
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = bus;
		_tmp18_ = gst_bus_pop (_tmp17_);
		msg = _tmp18_;
		_tmp20_ = msg;
		_tmp21_ = _tmp20_->type;
		if (_tmp21_ == GST_MESSAGE_ELEMENT) {
			GstMessage* _tmp22_ = NULL;
			GstObject* _tmp23_ = NULL;
			GstElement* _tmp24_ = NULL;
			_tmp22_ = msg;
			_tmp23_ = _tmp22_->src;
			_tmp24_ = dvbsrc;
			_tmp19_ = _tmp23_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gst_object_get_type (), GstObject);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GstStructure* structure = NULL;
			GstMessage* _tmp25_ = NULL;
			GstStructure* _tmp26_ = NULL;
			GstStructure* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp25_ = msg;
			_tmp26_ = gst_message_get_structure (_tmp25_);
			structure = _tmp26_;
			_tmp27_ = structure;
			_tmp28_ = gst_structure_get_name (_tmp27_);
			if (g_strcmp0 (_tmp28_, "dvb-adapter") == 0) {
				GstStructure* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				GstStructure* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				GstStructure* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				GstStructure* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				GstStructure* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
				GstStructure* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				GstStructure* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				GstStructure* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
				GstStructure* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				GstStructure* _tmp57_ = NULL;
				gboolean _tmp58_ = FALSE;
				GstStructure* _tmp60_ = NULL;
				gboolean _tmp61_ = FALSE;
				GstStructure* _tmp63_ = NULL;
				gboolean _tmp64_ = FALSE;
				GstStructure* _tmp66_ = NULL;
				gboolean _tmp67_ = FALSE;
				GstStructure* _tmp69_ = NULL;
				gboolean _tmp70_ = FALSE;
				GstStructure* _tmp72_ = NULL;
				gboolean _tmp73_ = FALSE;
				GstStructure* _tmp75_ = NULL;
				gboolean _tmp76_ = FALSE;
				GstStructure* _tmp78_ = NULL;
				gboolean _tmp79_ = FALSE;
				GstStructure* _tmp81_ = NULL;
				gboolean _tmp82_ = FALSE;
				GstStructure* _tmp84_ = NULL;
				gboolean _tmp85_ = FALSE;
				_tmp29_ = structure;
				_tmp30_ = gst_structure_get_string (_tmp29_, "name");
				_tmp31_ = g_strdup_printf ("%s", _tmp30_);
				_tmp32_ = _tmp31_;
				dvb_device_set_Name (self, _tmp32_);
				_g_free0 (_tmp32_);
				_tmp33_ = structure;
				_tmp34_ = gst_structure_has_field (_tmp33_, "dvb-c-a");
				if (_tmp34_) {
					GeeArrayList* _tmp35_ = NULL;
					_tmp35_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A));
				}
				_tmp36_ = structure;
				_tmp37_ = gst_structure_has_field (_tmp36_, "dvb-c-b");
				if (_tmp37_) {
					GeeArrayList* _tmp38_ = NULL;
					_tmp38_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp38_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B));
				}
				_tmp39_ = structure;
				_tmp40_ = gst_structure_has_field (_tmp39_, "dvb-t");
				if (_tmp40_) {
					GeeArrayList* _tmp41_ = NULL;
					_tmp41_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBT));
				}
				_tmp42_ = structure;
				_tmp43_ = gst_structure_has_field (_tmp42_, "dss");
				if (_tmp43_) {
					GeeArrayList* _tmp44_ = NULL;
					_tmp44_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DSS));
				}
				_tmp45_ = structure;
				_tmp46_ = gst_structure_has_field (_tmp45_, "dvb-s");
				if (_tmp46_) {
					GeeArrayList* _tmp47_ = NULL;
					_tmp47_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBS));
				}
				_tmp48_ = structure;
				_tmp49_ = gst_structure_has_field (_tmp48_, "dvb-s2");
				if (_tmp49_) {
					GeeArrayList* _tmp50_ = NULL;
					_tmp50_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBS2));
				}
				_tmp51_ = structure;
				_tmp52_ = gst_structure_has_field (_tmp51_, "dvb-h");
				if (_tmp52_) {
					GeeArrayList* _tmp53_ = NULL;
					_tmp53_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBH));
				}
				_tmp54_ = structure;
				_tmp55_ = gst_structure_has_field (_tmp54_, "isdb-t");
				if (_tmp55_) {
					GeeArrayList* _tmp56_ = NULL;
					_tmp56_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_ISDBT));
				}
				_tmp57_ = structure;
				_tmp58_ = gst_structure_has_field (_tmp57_, "isdb-s");
				if (_tmp58_) {
					GeeArrayList* _tmp59_ = NULL;
					_tmp59_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_ISDBS));
				}
				_tmp60_ = structure;
				_tmp61_ = gst_structure_has_field (_tmp60_, "isdb-c");
				if (_tmp61_) {
					GeeArrayList* _tmp62_ = NULL;
					_tmp62_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_ISDBC));
				}
				_tmp63_ = structure;
				_tmp64_ = gst_structure_has_field (_tmp63_, "atsc");
				if (_tmp64_) {
					GeeArrayList* _tmp65_ = NULL;
					_tmp65_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_ATSC));
				}
				_tmp66_ = structure;
				_tmp67_ = gst_structure_has_field (_tmp66_, "atsc-mh");
				if (_tmp67_) {
					GeeArrayList* _tmp68_ = NULL;
					_tmp68_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_ATSCMH));
				}
				_tmp69_ = structure;
				_tmp70_ = gst_structure_has_field (_tmp69_, "dtmb");
				if (_tmp70_) {
					GeeArrayList* _tmp71_ = NULL;
					_tmp71_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DTMB));
				}
				_tmp72_ = structure;
				_tmp73_ = gst_structure_has_field (_tmp72_, "cmmb");
				if (_tmp73_) {
					GeeArrayList* _tmp74_ = NULL;
					_tmp74_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_CMMB));
				}
				_tmp75_ = structure;
				_tmp76_ = gst_structure_has_field (_tmp75_, "dab");
				if (_tmp76_) {
					GeeArrayList* _tmp77_ = NULL;
					_tmp77_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp77_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DAB));
				}
				_tmp78_ = structure;
				_tmp79_ = gst_structure_has_field (_tmp78_, "dvb-t2");
				if (_tmp79_) {
					GeeArrayList* _tmp80_ = NULL;
					_tmp80_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp80_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBT2));
				}
				_tmp81_ = structure;
				_tmp82_ = gst_structure_has_field (_tmp81_, "turbo");
				if (_tmp82_) {
					GeeArrayList* _tmp83_ = NULL;
					_tmp83_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_TURBO));
				}
				_tmp84_ = structure;
				_tmp85_ = gst_structure_has_field (_tmp84_, "dvb-c-c");
				if (_tmp85_) {
					GeeArrayList* _tmp86_ = NULL;
					_tmp86_ = self->priv->delsys;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, (gpointer) ((gintptr) DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C));
				}
				success = TRUE;
				_gst_message_unref0 (msg);
				break;
			}
		} else {
			GstMessage* _tmp87_ = NULL;
			GstMessageType _tmp88_ = 0;
			_tmp87_ = msg;
			_tmp88_ = _tmp87_->type;
			if (_tmp88_ == GST_MESSAGE_ERROR) {
				GError* gerror = NULL;
				gchar* debug = NULL;
				GstMessage* _tmp89_ = NULL;
				GError* _tmp90_ = NULL;
				gchar* _tmp91_ = NULL;
				GError* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				const gchar* _tmp94_ = NULL;
				_tmp89_ = msg;
				gst_message_parse_error (_tmp89_, &_tmp90_, &_tmp91_);
				_g_error_free0 (gerror);
				gerror = _tmp90_;
				_g_free0 (debug);
				debug = _tmp91_;
				_tmp92_ = gerror;
				_tmp93_ = _tmp92_->message;
				_tmp94_ = debug;
				g_warning ("Device.vala:340: %s %s", _tmp93_, _tmp94_);
				_g_free0 (debug);
				_g_error_free0 (gerror);
			}
		}
		_gst_message_unref0 (msg);
	}
	_tmp95_ = pipeline;
	gst_element_set_state (_tmp95_, GST_STATE_NULL);
	result = success;
	_g_object_unref0 (bus);
	_g_object_unref0 (pipeline);
	_g_object_unref0 (dvbsrc);
	return result;
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Adapter;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Adapter = _tmp0_;
	g_object_notify ((GObject *) self, "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Frontend;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Frontend = _tmp0_;
	g_object_notify ((GObject *) self, "Frontend");
}


const gchar* dvb_device_get_DevFile (DVBDevice* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_DevFile;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_DevFile (DVBDevice* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_DevFile);
	self->priv->_DevFile = _tmp1_;
	g_object_notify ((GObject *) self, "DevFile");
}


const gchar* dvb_device_get_UID (DVBDevice* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_UID;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_UID (DVBDevice* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_UID);
	self->priv->_UID = _tmp1_;
	g_object_notify ((GObject *) self, "UID");
}


const gchar* dvb_device_get_Name (DVBDevice* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Name;
	result = _tmp0_;
	return result;
}


static void dvb_device_set_Name (DVBDevice* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Name);
	self->priv->_Name = _tmp1_;
	g_object_notify ((GObject *) self, "Name");
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_DEV_FILE, g_param_spec_string ("DevFile", "DevFile", "DevFile", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_UID, g_param_spec_string ("UID", "UID", "UID", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_device_log = _tmp1_;
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_DEVICE, DVBDevice);
	_g_free0 (self->priv->_DevFile);
	_g_free0 (self->priv->_UID);
	_g_free0 (self->priv->_Name);
	_g_object_unref0 (self->priv->delsys);
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static volatile gsize dvb_device_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		GType dvb_device_type_id;
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
		g_once_init_leave (&dvb_device_type_id__volatile, dvb_device_type_id);
	}
	return dvb_device_type_id__volatile;
}


static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_DEVICE, DVBDevice);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_DEV_FILE:
		g_value_set_string (value, dvb_device_get_DevFile (self));
		break;
		case DVB_DEVICE_UID:
		g_value_set_string (value, dvb_device_get_UID (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_DEVICE, DVBDevice);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_DEV_FILE:
		dvb_device_set_DevFile (self, g_value_get_string (value));
		break;
		case DVB_DEVICE_UID:
		dvb_device_set_UID (self, g_value_get_string (value));
		break;
		case DVB_DEVICE_NAME:
		dvb_device_set_Name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



