/*
 * "Hello, World!" with Glyph Keeper and SDL
 *
 * Copyright (c) 2003-2007 Kirill Kryukov
 *
 * This file is part of Glyph Keeper library, and may only be used,
 * modified, and distributed under the terms of the Glyph Keeper
 * license, located in the file 'license.txt' within this package.
 */


#include <stdlib.h>
#include <stdio.h>
#include <SDL/SDL.h>
#include "glyph.h"


char* fontfile = "DejaVuSans.ttf";
char* font_search_path = "../fonts/";

int swidth = 640;
int sheight = 480;

FILE* logfile = 0;


void fprintf_messenger(const char* const msg)
{
    if (logfile) fprintf(logfile,msg);
}

void done(void)
{
    SDL_Quit();
    if (logfile)
    {
        fprintf(logfile,"All done, exiting\n");
        fclose(logfile); logfile = 0;
    }
}

int main(int argc,char **argv)
{
    GLYPH_FACE *face;
    GLYPH_REND *rend;
    int keypress = 0;
    SDL_Event event;
    SDL_Surface *screen;

    gk_set_messenger(fprintf_messenger);
    gk_set_font_path(font_search_path);
    atexit(done);
    logfile = fopen("hello_sdl.log","w");
    if (!logfile) { exit(1); }
    setbuf(logfile,0);
    fprintf(logfile,"Starting 'hello_sdl' (%s)\n",argv[0]);

    /* Loading a font face from file. */
    face = gk_load_face_from_file(fontfile,0);
    if (!face) { fprintf(logfile,"Can't load font from \"%s\"\n",fontfile); exit(1); }

    /* Setting up a renderer object. */
    rend = gk_create_renderer(face,0);
    if (!rend) { fprintf(logfile,"Can't create renderer\n"); exit(1); }
    gk_rend_set_size_pixels(rend,85,85);

    screen = SDL_SetVideoMode(swidth,sheight,32,SDL_SWSURFACE);
    if (!screen) { fprintf(logfile,"Can't set graphics mode\n"); exit(1); }

    gk_render_line_utf8(screen,rend,"Hello, World!",50,220);

    while (keypress<1)
    {
        while (SDL_PollEvent(&event))
        {
            if (event.type == SDL_KEYDOWN)
            {
                if (event.key.keysym.sym==SDLK_ESCAPE ||
                    event.key.keysym.sym==SDLK_SPACE ||
                    event.key.keysym.sym==SDLK_RETURN) keypress++;
            }
        }
    }

    return 0;
}
