/* backend.c generated by valac 0.29.3.10-b87a, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/libebook.h>
#include <gee.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks-test.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _EdsTestBackendPrepareSourceAsyncData EdsTestBackendPrepareSourceAsyncData;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
typedef struct _Block3Data Block3Data;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	gchar** _e_contacts;
	gint _e_contacts_length1;
	gint __e_contacts_size_;
	GList* _contacts;
	ESourceRegistry* _source_registry;
	ESource* _source;
	GFile* _source_file;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	EdsTestBackend* self;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	EdsTestBackend* self;
	gpointer _async_data_;
};

struct _EdsTestBackendPrepareSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gboolean is_default;
	Block2Data* _data2_;
	gchar* source_file_name;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* config_dir;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* source_file;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* source_file_content;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_;
	gint _tmp17__length1;
	ESourceRegistry* source_registry;
	ESourceRegistry* _tmp18_;
	ESourceRegistry* _tmp19_;
	ESourceRegistry* _tmp20_;
	gulong signal_id;
	ESourceRegistry* _tmp21_;
	gulong _tmp22_;
	ESourceRegistry* _tmp23_;
	const gchar* _tmp24_;
	ESource* _tmp25_;
	ESource* _tmp26_;
	ESource* _tmp27_;
	ESourceRegistry* _tmp28_;
	gulong _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	gboolean _tmp32_;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GSList* contacts;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* contact;
	EContact* _tmp2_;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	EContact* _tmp5_;
	EContact* _tmp6_;
	GSList* uids;
	EBookClient* _tmp7_;
	GSList* _tmp8_;
	GSList* _tmp9_;
	GSList* uid_collection;
	GSList* uid_it;
	const gchar* uid;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	EdsTestBackend* self;
	GMainLoop* main_loop;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

void e_source_registry_new (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ESourceRegistry* e_source_registry_new_finish (GAsyncResult* _res_, GError** error);
GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
EdsTestBackend* eds_test_backend_new (const gchar* name);
EdsTestBackend* eds_test_backend_construct (GType object_type, const gchar* name);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default);
static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default);
void eds_test_backend_set_as_default (EdsTestBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _eds_test_backend_prepare_source_async_data_free (gpointer _data);
static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda4_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s);
static void ___lambda4__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void eds_test_backend_commit_contacts_to_addressbook_sync (EdsTestBackend* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_, GObject* s, GAsyncResult* r);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str);
static void _vala_EContactAddress_free (EContactAddress* self);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
#line 43 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 351 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 43 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 43 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 360 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type, const gchar* name) {
	EdsTestBackend* self = NULL;
	gchar** _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 53 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 53 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 55 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 55 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 56 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 56 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 56 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 56 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 56 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 57 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = name;
#line 57 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 57 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 57 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook_name = _tmp2_;
#line 53 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return self;
#line 397 "backend.c"
}


EdsTestBackend* eds_test_backend_new (const gchar* name) {
#line 53 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND, name);
#line 404 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 62 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 411 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 60 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 60 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 62 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 62 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 62 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 60 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 430 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 443 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 450 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = updated_data;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 478 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 486 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 500 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 509 "backend.c"
		goto _state_0;
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 513 "backend.c"
		goto _state_1;
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 517 "backend.c"
		goto _state_2;
		default:
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 522 "backend.c"
	}
	_state_0:
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = NULL;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = 0;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = 0;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = NULL;
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 68 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 547 "backend.c"
	{
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = NULL;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = NULL;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 565 "backend.c"
		_state_1:
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 72 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 575 "backend.c"
			goto __catch0_g_error;
		}
#line 73 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = NULL;
#line 73 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 73 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = NULL;
#line 73 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 73 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = NULL;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = NULL;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 602 "backend.c"
		_state_2:
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 74 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 608 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 78 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:78: Couldn't update contact\n");
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 623 "backend.c"
	}
	__finally0:
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 70 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 640 "backend.c"
	}
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 652 "backend.c"
	} else {
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 656 "backend.c"
	}
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 662 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 673 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 697 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 705 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 719 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 728 "backend.c"
		goto _state_0;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 732 "backend.c"
		goto _state_1;
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 736 "backend.c"
		goto _state_2;
		default:
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 741 "backend.c"
	}
	_state_0:
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = NULL;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = 0;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = 0;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = NULL;
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 84 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 766 "backend.c"
	{
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = NULL;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = NULL;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 784 "backend.c"
		_state_1:
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 88 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 794 "backend.c"
			goto __catch1_g_error;
		}
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = NULL;
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = NULL;
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 811 "backend.c"
		_state_2:
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 89 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 817 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 93 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:93: Couldn't remove contact\n");
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 832 "backend.c"
	}
	__finally1:
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 86 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 847 "backend.c"
	}
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 857 "backend.c"
	} else {
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 861 "backend.c"
	}
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 82 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 867 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
	gchar** _tmp0_ = NULL;
#line 97 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 99 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 99 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 100 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 100 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 100 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 100 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 100 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 889 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default) {
	GError * _inner_error_ = NULL;
#line 104 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 897 "backend.c"
	{
		gboolean _tmp0_ = FALSE;
		EBookClient* _tmp1_ = NULL;
		ESource* _tmp2_ = NULL;
		EBookClient* _tmp3_ = NULL;
		EBookClient* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 108 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = source_is_default;
#line 108 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self, _tmp0_);
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp2_ = self->priv->_source;
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp3_ = e_book_client_connect_sync (_tmp2_, (guint32) 1, NULL, &_inner_error_);
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = _tmp3_;
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 917 "backend.c"
			goto __catch2_g_error;
		}
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp4_ = _tmp1_;
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = NULL;
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 109 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp4_;
#line 110 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp5_ = self->priv->_addressbook_name;
#line 110 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp5_, TRUE);
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp1_);
#line 934 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 115 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = e;
#line 115 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_->message;
#line 115 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:115: Unable to create test data: %s\n", _tmp7_);
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 954 "backend.c"
	}
	__finally2:
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 106 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return;
#line 965 "backend.c"
	}
}


void eds_test_backend_set_as_default (EdsTestBackend* self) {
	ESourceRegistry* _tmp0_ = NULL;
	ESource* _tmp1_ = NULL;
#line 119 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_source_registry;
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = self->priv->_source;
#line 121 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	e_source_registry_set_default_address_book (_tmp0_, _tmp1_);
#line 981 "backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return _data1_;
#line 990 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 999 "backend.c"
		EdsTestBackend* self;
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self = _data1_->self;
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 1009 "backend.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res) {
	EdsTestBackend* self;
	GError * _inner_error_ = NULL;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self = _data1_->self;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (async_res != NULL);
#line 1021 "backend.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = async_res;
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source_finish (self, _tmp0_, &_inner_error_);
#line 132 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1030 "backend.c"
			goto __catch3_g_error;
		}
#line 133 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_main_loop_quit (_data1_->mainloop);
#line 1035 "backend.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 137 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e;
#line 137 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_->message;
#line 137 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("backend.vala:137: %s", _tmp2_);
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 1055 "backend.c"
	}
	__finally3:
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 130 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1066 "backend.c"
	}
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__lambda5_ (self, source_object, res);
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	block1_data_unref (self);
#line 1076 "backend.c"
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data1_->_ref_count_ = 1;
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data1_->self = eds_test_backend_ref (self);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 126 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data1_->mainloop = _tmp0_;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 128 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async (self, _tmp1_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 141 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_main_loop_run (_data1_->mainloop);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	block1_data_unref (_data1_);
#line 124 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data1_ = NULL;
#line 1106 "backend.c"
}


static void _eds_test_backend_prepare_source_async_data_free (gpointer _data) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendPrepareSourceAsyncData, _data_);
#line 1117 "backend.c"
}


static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	EdsTestBackend* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendPrepareSourceAsyncData);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _eds_test_backend_prepare_source_async);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _eds_test_backend_prepare_source_async_data_free);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->is_default = _tmp1_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1141 "backend.c"
}


static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1151 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1155 "backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return _data2_;
#line 1164 "backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1173 "backend.c"
		EdsTestBackend* self;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self = _data2_->self;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 1181 "backend.c"
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1300 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1301 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1301 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1301 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1302 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1302 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1302 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1302 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1226 "backend.c"
	}
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1303 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1232 "backend.c"
}


static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1246 "backend.c"
}


static void __lambda4_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s) {
	EdsTestBackend* self;
	ESource* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	ESource* _tmp4_ = NULL;
	ESource* _tmp5_ = NULL;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self = _data2_->self;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (s != NULL);
#line 169 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = s;
#line 169 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_source_get_uid (_tmp0_);
#line 169 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = _tmp1_;
#line 169 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = self->priv->_addressbook_name;
#line 169 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
#line 170 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1276 "backend.c"
	}
#line 172 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = s;
#line 172 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 172 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 172 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp5_;
#line 173 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data2_->_async_data_);
#line 1288 "backend.c"
}


static void ___lambda4__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self) {
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__lambda4_ (self, _sender, source);
#line 1295 "backend.c"
}


static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_) {
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1304 "backend.c"
		goto _state_0;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1308 "backend.c"
		goto _state_1;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 1312 "backend.c"
		goto _state_2;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 3:
#line 1316 "backend.c"
		goto _state_3;
		default:
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1321 "backend.c"
	}
	_state_0:
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->self = eds_test_backend_ref (_data_->self);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 147 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = NULL;
#line 147 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_addressbook_name;
#line 147 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = NULL;
#line 147 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = g_strconcat (_data_->_tmp0_, ".source", NULL);
#line 147 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file_name = _data_->_tmp1_;
#line 149 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = NULL;
#line 149 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_get_user_config_dir ();
#line 149 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = NULL;
#line 149 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
#line 149 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->config_dir = _data_->_tmp3_;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp4_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp4_ = _data_->config_dir;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, "evolution");
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp6_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, "sources");
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp8_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp9_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp9_ = _data_->source_file_name;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = g_file_get_child (_data_->_tmp8_, _data_->_tmp9_);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp11_ = NULL;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp8_);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 150 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file = _data_->_tmp11_;
#line 153 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp12_ = NULL;
#line 153 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp12_ = _data_->self->priv->_addressbook_name;
#line 153 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = NULL;
#line 153 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = g_strdup_printf ("[Data Source]\n" "DisplayName=%s\n" "Enabled=true\n" "Parent=local-stub\n" "\n" "[Address Book]\n" "BackendName=local\n", _data_->_tmp12_);
#line 153 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file_content = _data_->_tmp13_;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = _data_->source_file;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp15_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp15_ = _data_->source_file_content;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16__length1 = 0;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16_ = string_get_data (_data_->_tmp15_, &_data_->_tmp16__length1);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17__length1 = 0;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17__length1 = _data_->_tmp16__length1;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 1;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_async (_data_->_tmp14_, _data_->_tmp17_, (gsize) _data_->_tmp17__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1428 "backend.c"
	_state_1:
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_finish (_data_->_tmp14_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1454 "backend.c"
		} else {
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1458 "backend.c"
		}
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 161 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1464 "backend.c"
	}
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 2;
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	e_source_registry_new (NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1472 "backend.c"
	_state_2:
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = NULL;
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error_);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->source_registry = _data_->_tmp18_;
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_error_free (_data_->_inner_error_);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1502 "backend.c"
		} else {
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1506 "backend.c"
		}
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1512 "backend.c"
	}
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp19_ = NULL;
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp19_ = _data_->source_registry;
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp20_ = NULL;
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_registry);
#line 166 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_registry = _data_->_tmp20_;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21_ = NULL;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21_ = _data_->source_registry;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22_ = 0UL;
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22_ = g_signal_connect_data (_data_->_tmp21_, "source-added", (GCallback) ___lambda4__e_source_registry_source_added, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 167 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->signal_id = _data_->_tmp22_;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp23_ = NULL;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp23_ = _data_->source_registry;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = NULL;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = _data_->self->priv->_addressbook_name;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = NULL;
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = e_source_registry_ref_source (_data_->_tmp23_, _data_->_tmp24_);
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source);
#line 177 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source = _data_->_tmp25_;
#line 178 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp26_ = NULL;
#line 178 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp26_ = _data_->self->priv->_source;
#line 178 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp26_ == NULL) {
#line 180 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 3;
#line 180 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1562 "backend.c"
		_state_3:
		;
	}
#line 184 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp27_ = NULL;
#line 184 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp27_ = _data_->self->priv->_source;
#line 184 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_vala_assert (_data_->_tmp27_ != NULL, "this._source != null");
#line 185 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp28_ = NULL;
#line 185 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp28_ = _data_->source_registry;
#line 185 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp29_ = 0UL;
#line 185 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp29_ = _data_->signal_id;
#line 185 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_signal_handler_disconnect ((GObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp30_ = NULL;
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp30_ = _data_->source_file;
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp31_ = NULL;
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_file);
#line 187 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_file = _data_->_tmp31_;
#line 189 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp32_ = FALSE;
#line 189 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp32_ = _data_->is_default;
#line 189 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp32_) {
#line 191 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_set_as_default (_data_->self);
#line 1602 "backend.c"
	}
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_registry);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_content);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_file);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->config_dir);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_name);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	block2_data_unref (_data_->_data2_);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = NULL;
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1622 "backend.c"
	} else {
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1626 "backend.c"
	}
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 144 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1632 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 1643 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_ = NULL;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1662 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1670 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1684 "backend.c"
}


static void _g_free0_ (gpointer var) {
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 1691 "backend.c"
}


static void _g_slist_free__g_free0_ (GSList* self) {
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1700 "backend.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if ((*length) == (*size)) {
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1711 "backend.c"
	}
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	(*array)[(*length)++] = value;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	(*array)[*length] = NULL;
#line 1717 "backend.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1726 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1735 "backend.c"
		goto _state_0;
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1739 "backend.c"
		goto _state_1;
		default:
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1744 "backend.c"
	}
	_state_0:
#line 197 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->contacts = NULL;
#line 199 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = NULL;
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1755 "backend.c"
	{
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = NULL;
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1767 "backend.c"
			{
#line 203 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = NULL;
#line 203 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 203 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 205 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = NULL;
#line 205 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 205 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = NULL;
#line 205 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 205 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 207 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp5_ = NULL;
#line 207 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp5_ = _data_->contact;
#line 207 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp6_ = NULL;
#line 207 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 207 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->contacts = g_slist_prepend (_data_->contacts, _data_->_tmp6_);
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 201 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1799 "backend.c"
			}
		}
	}
	{
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = NULL;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = NULL;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contacts;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = NULL;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1820 "backend.c"
		_state_1:
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->uids = _data_->_tmp9_;
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 214 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			__g_slist_free__g_free0_0 (_data_->uids);
#line 1832 "backend.c"
			goto __catch4_g_error;
		}
		{
#line 216 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_data_->uid_collection = _data_->uids;
#line 216 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			for (_data_->uid_it = _data_->uid_collection; _data_->uid_it != NULL; _data_->uid_it = _data_->uid_it->next) {
#line 216 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_data_->uid = (const gchar*) _data_->uid_it->data;
#line 1842 "backend.c"
				{
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = NULL;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10__length1 = 0;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->self->priv->_e_contacts;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10__length1 = _data_->self->priv->_e_contacts_length1;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp11_ = NULL;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp11_ = _data_->uid;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp12_ = NULL;
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 217 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_vala_array_add1 (&_data_->self->priv->_e_contacts, &_data_->self->priv->_e_contacts_length1, &_data_->self->priv->__e_contacts_size_, _data_->_tmp12_);
#line 1862 "backend.c"
				}
			}
		}
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 1868 "backend.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 221 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp13_ = NULL;
#line 221 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp13_ = _data_->e;
#line 221 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp14_ = NULL;
#line 221 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 221 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:221: Couldn't add contacts: %s\n", _data_->_tmp14_);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 1889 "backend.c"
	}
	__finally4:
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 210 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1902 "backend.c"
	}
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1910 "backend.c"
	} else {
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1914 "backend.c"
	}
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 195 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1920 "backend.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return _data3_;
#line 1929 "backend.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1938 "backend.c"
		EdsTestBackend* self;
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self = _data3_->self;
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data3_->main_loop);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block3Data, _data3_);
#line 1948 "backend.c"
	}
}


static void __lambda6_ (Block3Data* _data3_, GObject* s, GAsyncResult* r) {
	EdsTestBackend* self;
	GAsyncResult* _tmp0_ = NULL;
#line 229 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self = _data3_->self;
#line 229 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 231 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = r;
#line 231 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_finish (self, _tmp0_);
#line 232 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_main_loop_quit (_data3_->main_loop);
#line 1966 "backend.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 229 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__lambda6_ (self, source_object, res);
#line 229 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	block3_data_unref (self);
#line 1975 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_sync (EdsTestBackend* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_ = NULL;
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data3_->_ref_count_ = 1;
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data3_->self = eds_test_backend_ref (self);
#line 228 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 228 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data3_->main_loop = _tmp0_;
#line 229 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook (self, ___lambda6__gasync_ready_callback, block3_data_ref (_data3_));
#line 234 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	folks_test_utils_loop_run_with_timeout (_data3_->main_loop, 5);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	block3_data_unref (_data3_);
#line 226 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_data3_ = NULL;
#line 2002 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2035 "backend.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2044 "backend.c"
	}
#line 1235 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2050 "backend.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2059 "backend.c"
	}
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2065 "backend.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2074 "backend.c"
	} else {
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2078 "backend.c"
	}
#line 1238 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2086 "backend.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2095 "backend.c"
	} else {
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2099 "backend.c"
	}
#line 1239 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2121 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 2130 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 900 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 900 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 901 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 901 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 901 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 901 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 903 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 903 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2157 "backend.c"
		gchar* _tmp4_ = NULL;
#line 904 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 904 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 904 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2165 "backend.c"
	} else {
#line 906 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		result = -1;
#line 906 "/opt/gnome3/build/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2171 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 2179 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 2186 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 2193 "backend.c"
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
#line 2200 "backend.c"
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
#line 2207 "backend.c"
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
#line 336 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_vcard_attribute_get_type (), self);
#line 2214 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name = FALSE;
	EContactName* contact_name = NULL;
	EContactName* _tmp0_ = NULL;
	gchar* contact_field_name = NULL;
	gchar* _tmp1_ = NULL;
	gint min_len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp208_ = FALSE;
	GError * _inner_error_ = NULL;
#line 237 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 237 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 237 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 240 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 241 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 241 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 242 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 242 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 243 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 243 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 243 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 243 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 2254 "backend.c"
	{
		GeeIterator* _k_it = NULL;
		GeeHashMap* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _tmp10_ = NULL;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 2281 "backend.c"
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gchar* k = NULL;
			GeeIterator* _tmp13_ = NULL;
			gpointer _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				break;
#line 2300 "backend.c"
			}
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 2318 "backend.c"
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 2338 "backend.c"
			} else {
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 2342 "backend.c"
			}
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			if (_tmp15_) {
#line 2346 "backend.c"
				gchar* v = NULL;
				GeeHashMap* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gpointer _tmp27_ = NULL;
				GValue* _tmp28_ = NULL;
				GValue _tmp29_ = {0};
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp25_ = c;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp26_ = k;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp28_ = (GValue*) _tmp27_;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp29_ = *_tmp28_;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp30_ = g_value_get_string (&_tmp29_);
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_strdup (_tmp30_);
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp32_ = _tmp31_;
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp28_);
#line 249 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				v = _tmp32_;
#line 250 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp33_ = k;
#line 250 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp34_ = string_index_of (_tmp33_, "family", 0);
#line 250 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				if (_tmp34_ >= 0) {
#line 2384 "backend.c"
					EContactName* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
#line 252 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp35_ = contact_name;
#line 252 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp36_ = v;
#line 252 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp37_ = g_strdup (_tmp36_);
#line 252 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp35_->family);
#line 252 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp35_->family = _tmp37_;
#line 2398 "backend.c"
				} else {
					const gchar* _tmp38_ = NULL;
					gint _tmp39_ = 0;
#line 254 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp38_ = k;
#line 254 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp39_ = string_index_of (_tmp38_, "given", 0);
#line 254 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					if (_tmp39_ >= 0) {
#line 2408 "backend.c"
						EContactName* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
#line 256 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp40_ = contact_name;
#line 256 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp41_ = v;
#line 256 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp42_ = g_strdup (_tmp41_);
#line 256 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp40_->given);
#line 256 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp40_->given = _tmp42_;
#line 2422 "backend.c"
					} else {
						const gchar* _tmp43_ = NULL;
						gint _tmp44_ = 0;
#line 258 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp43_ = k;
#line 258 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp44_ = string_index_of (_tmp43_, "additional", 0);
#line 258 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						if (_tmp44_ >= 0) {
#line 2432 "backend.c"
							EContactName* _tmp45_ = NULL;
							const gchar* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
#line 260 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp45_ = contact_name;
#line 260 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp46_ = v;
#line 260 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp47_ = g_strdup (_tmp46_);
#line 260 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp45_->additional);
#line 260 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp45_->additional = _tmp47_;
#line 2446 "backend.c"
						} else {
							const gchar* _tmp48_ = NULL;
							gint _tmp49_ = 0;
#line 262 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp48_ = k;
#line 262 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp49_ = string_index_of (_tmp48_, "prefixes", 0);
#line 262 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							if (_tmp49_ >= 0) {
#line 2456 "backend.c"
								EContactName* _tmp50_ = NULL;
								const gchar* _tmp51_ = NULL;
								gchar* _tmp52_ = NULL;
#line 264 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp50_ = contact_name;
#line 264 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp51_ = v;
#line 264 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp52_ = g_strdup (_tmp51_);
#line 264 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp50_->prefixes);
#line 264 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp50_->prefixes = _tmp52_;
#line 2470 "backend.c"
							} else {
								const gchar* _tmp53_ = NULL;
								gint _tmp54_ = 0;
#line 266 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp53_ = k;
#line 266 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp54_ = string_index_of (_tmp53_, "suffixes", 0);
#line 266 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								if (_tmp54_ >= 0) {
#line 2480 "backend.c"
									EContactName* _tmp55_ = NULL;
									const gchar* _tmp56_ = NULL;
									gchar* _tmp57_ = NULL;
#line 268 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp55_ = contact_name;
#line 268 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp56_ = v;
#line 268 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp57_ = g_strdup (_tmp56_);
#line 268 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp55_->suffixes);
#line 268 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp55_->suffixes = _tmp57_;
#line 2494 "backend.c"
								}
							}
						}
					}
				}
#line 271 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 247 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 2504 "backend.c"
			} else {
				const gchar* _tmp58_ = NULL;
#line 273 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp58_ = k;
#line 273 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp58_, "avatar") == 0) {
#line 2511 "backend.c"
					gchar* v = NULL;
					GeeHashMap* _tmp59_ = NULL;
					const gchar* _tmp60_ = NULL;
					gpointer _tmp61_ = NULL;
					GValue* _tmp62_ = NULL;
					GValue _tmp63_ = {0};
					const gchar* _tmp64_ = NULL;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_ = NULL;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					GFile* file = NULL;
					const gchar* _tmp67_ = NULL;
					GFile* _tmp68_ = NULL;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp59_ = c;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp60_ = k;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, _tmp60_);
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp62_ = (GValue*) _tmp61_;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp63_ = *_tmp62_;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp64_ = g_value_get_string (&_tmp63_);
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp65_ = g_strdup (_tmp64_);
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp66_ = _tmp65_;
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp62_);
#line 275 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					v = _tmp66_;
#line 277 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp67_ = v;
#line 277 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp68_ = g_file_new_for_path (_tmp67_);
#line 277 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					file = _tmp68_;
#line 2553 "backend.c"
					{
						GFile* _tmp69_ = NULL;
						guint8* _tmp70_ = NULL;
						gsize _tmp71_;
						EContactPhoto* cp = NULL;
						EContactPhoto* _tmp72_ = NULL;
						EContactPhoto* _tmp73_ = NULL;
						EContactPhoto* _tmp74_ = NULL;
						guint8* _tmp75_ = NULL;
						gint _tmp75__length1 = 0;
						EContact* _tmp76_ = NULL;
						EContactField _tmp77_ = 0;
						EContactPhoto* _tmp78_ = NULL;
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp69_ = file;
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp69_, NULL, &_tmp70_, &_tmp71_, NULL, &_inner_error_);
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp70_;
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp71_;
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 281 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2581 "backend.c"
							goto __catch5_g_error;
						}
#line 283 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp72_ = e_contact_photo_new ();
#line 283 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						cp = _tmp72_;
#line 284 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp73_ = cp;
#line 284 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp73_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 285 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp74_ = cp;
#line 285 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp75_ = photo_content;
#line 285 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp75__length1 = photo_content_length1;
#line 285 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp74_, _tmp75_, (gsize) _tmp75__length1);
#line 287 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp76_ = contact;
#line 287 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp77_ = e_contact_field_id ("photo");
#line 287 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp78_ = cp;
#line 287 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp76_, _tmp77_, _tmp78_);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 2610 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp79_ = NULL;
						GError* _tmp80_ = NULL;
						const gchar* _tmp81_ = NULL;
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 291 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp79_ = v;
#line 291 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp80_ = e;
#line 291 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp81_ = _tmp80_->message;
#line 291 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:291: \n\nCan't load avatar %s: %s\n\n", _tmp79_, _tmp81_);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 2633 "backend.c"
					}
					__finally5:
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 279 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						return;
#line 2658 "backend.c"
					}
#line 273 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 273 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 273 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 2666 "backend.c"
				} else {
					const gchar* _tmp82_ = NULL;
#line 295 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					_tmp82_ = k;
#line 295 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp82_, "email_addresses") == 0) {
#line 2673 "backend.c"
						gchar* v = NULL;
						GeeHashMap* _tmp83_ = NULL;
						const gchar* _tmp84_ = NULL;
						gpointer _tmp85_ = NULL;
						GValue* _tmp86_ = NULL;
						GValue _tmp87_ = {0};
						const gchar* _tmp88_ = NULL;
						gchar* _tmp89_ = NULL;
						gchar* _tmp90_ = NULL;
						gchar** addresses = NULL;
						const gchar* _tmp91_ = NULL;
						gchar** _tmp92_ = NULL;
						gchar** _tmp93_ = NULL;
						gint addresses_length1 = 0;
						gint _addresses_size_ = 0;
						gchar** _tmp94_ = NULL;
						gint _tmp94__length1 = 0;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp83_ = c;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp84_ = k;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp85_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp83_, _tmp84_);
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp86_ = (GValue*) _tmp85_;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp87_ = *_tmp86_;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp88_ = g_value_get_string (&_tmp87_);
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp89_ = g_strdup (_tmp88_);
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp90_ = _tmp89_;
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp86_);
#line 297 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						v = _tmp90_;
#line 298 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp91_ = v;
#line 298 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp93_ = _tmp92_ = g_strsplit (_tmp91_, ",", 0);
#line 298 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						addresses = _tmp93_;
#line 298 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						addresses_length1 = _vala_array_length (_tmp92_);
#line 298 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_addresses_size_ = addresses_length1;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp94_ = addresses;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp94__length1 = addresses_length1;
#line 2725 "backend.c"
						{
							gchar** addr_collection = NULL;
							gint addr_collection_length1 = 0;
							gint _addr_collection_size_ = 0;
							gint addr_it = 0;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							addr_collection = _tmp94_;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							addr_collection_length1 = _tmp94__length1;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							for (addr_it = 0; addr_it < _tmp94__length1; addr_it = addr_it + 1) {
#line 2737 "backend.c"
								gchar* _tmp95_ = NULL;
								gchar* addr = NULL;
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp95_ = g_strdup (addr_collection[addr_it]);
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								addr = _tmp95_;
#line 2744 "backend.c"
								{
									EContact* _tmp96_ = NULL;
									EContactField _tmp97_ = 0;
									const gchar* _tmp98_ = NULL;
#line 302 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp96_ = contact;
#line 302 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp97_ = e_contact_field_id ("email");
#line 302 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp98_ = addr;
#line 302 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp96_, _tmp97_, _tmp98_);
#line 300 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2759 "backend.c"
								}
							}
						}
#line 295 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						addresses = (_vala_array_free (addresses, addresses_length1, (GDestroyNotify) g_free), NULL);
#line 295 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 2767 "backend.c"
					} else {
						const gchar* _tmp99_ = NULL;
#line 305 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						_tmp99_ = k;
#line 305 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp99_, "im_addresses") == 0) {
#line 2774 "backend.c"
							gchar* v = NULL;
							GeeHashMap* _tmp100_ = NULL;
							const gchar* _tmp101_ = NULL;
							gpointer _tmp102_ = NULL;
							GValue* _tmp103_ = NULL;
							GValue _tmp104_ = {0};
							const gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
							gchar* _tmp107_ = NULL;
							GeeHashMap* addresses = NULL;
							const gchar* _tmp108_ = NULL;
							GeeHashMap* _tmp109_ = NULL;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp100_ = c;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp101_ = k;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp102_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp100_, _tmp101_);
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp103_ = (GValue*) _tmp102_;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp104_ = *_tmp103_;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp105_ = g_value_get_string (&_tmp104_);
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp106_ = g_strdup (_tmp105_);
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp107_ = _tmp106_;
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp103_);
#line 307 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							v = _tmp107_;
#line 308 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp108_ = v;
#line 308 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp109_ = _eds_test_backend_parse_im_addrs (self, _tmp108_);
#line 308 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							addresses = _tmp109_;
#line 2813 "backend.c"
							{
								GeeIterator* _addr_it = NULL;
								GeeHashMap* _tmp110_ = NULL;
								GeeSet* _tmp111_ = NULL;
								GeeSet* _tmp112_ = NULL;
								GeeSet* _tmp113_ = NULL;
								GeeIterator* _tmp114_ = NULL;
								GeeIterator* _tmp115_ = NULL;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp110_ = addresses;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp111_ = gee_abstract_map_get_keys ((GeeMap*) _tmp110_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp112_ = _tmp111_;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp113_ = _tmp112_;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp114_ = gee_iterable_iterator ((GeeIterable*) _tmp113_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp115_ = _tmp114_;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_tmp113_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_addr_it = _tmp115_;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								while (TRUE) {
#line 2840 "backend.c"
									GeeIterator* _tmp116_ = NULL;
									gboolean _tmp117_ = FALSE;
									gchar* addr = NULL;
									GeeIterator* _tmp118_ = NULL;
									gpointer _tmp119_ = NULL;
									gchar* proto = NULL;
									GeeHashMap* _tmp120_ = NULL;
									const gchar* _tmp121_ = NULL;
									gpointer _tmp122_ = NULL;
									EContact* _tmp123_ = NULL;
									const gchar* _tmp124_ = NULL;
									EContactField _tmp125_ = 0;
									const gchar* _tmp126_ = NULL;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp116_ = _addr_it;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp117_ = gee_iterator_next (_tmp116_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									if (!_tmp117_) {
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
										break;
#line 2862 "backend.c"
									}
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp118_ = _addr_it;
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp119_ = gee_iterator_get (_tmp118_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									addr = (gchar*) _tmp119_;
#line 311 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp120_ = addresses;
#line 311 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp121_ = addr;
#line 311 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp122_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp120_, _tmp121_);
#line 311 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									proto = (gchar*) _tmp122_;
#line 312 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp123_ = contact;
#line 312 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp124_ = proto;
#line 312 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp125_ = e_contact_field_id (_tmp124_);
#line 312 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp126_ = addr;
#line 312 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp123_, _tmp125_, _tmp126_);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (proto);
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2892 "backend.c"
								}
#line 309 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_addr_it);
#line 2896 "backend.c"
							}
#line 305 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (addresses);
#line 305 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2902 "backend.c"
						} else {
							const gchar* _tmp127_ = NULL;
							const gchar* _tmp128_ = NULL;
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp127_ = k;
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							_tmp128_ = EDSF_PERSONA_address_fields[0];
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
							if (g_strcmp0 (_tmp127_, _tmp128_) == 0) {
#line 2912 "backend.c"
								FolksPostalAddressFieldDetails* pa_fd = NULL;
								GeeHashMap* _tmp129_ = NULL;
								const gchar* _tmp130_ = NULL;
								gpointer _tmp131_ = NULL;
								GValue* _tmp132_ = NULL;
								GValue _tmp133_ = {0};
								GObject* _tmp134_ = NULL;
								FolksPostalAddressFieldDetails* _tmp135_ = NULL;
								FolksPostalAddressFieldDetails* _tmp136_ = NULL;
								FolksPostalAddress* pa = NULL;
								FolksPostalAddressFieldDetails* _tmp137_ = NULL;
								gconstpointer _tmp138_ = NULL;
								FolksPostalAddress* _tmp139_ = NULL;
								FolksPostalAddress* _tmp140_ = NULL;
								EContactAddress* address = NULL;
								EContactAddress* _tmp141_ = NULL;
								EContactAddress* _tmp142_ = NULL;
								FolksPostalAddress* _tmp143_ = NULL;
								const gchar* _tmp144_ = NULL;
								const gchar* _tmp145_ = NULL;
								gchar* _tmp146_ = NULL;
								EContactAddress* _tmp147_ = NULL;
								FolksPostalAddress* _tmp148_ = NULL;
								const gchar* _tmp149_ = NULL;
								const gchar* _tmp150_ = NULL;
								gchar* _tmp151_ = NULL;
								EContactAddress* _tmp152_ = NULL;
								FolksPostalAddress* _tmp153_ = NULL;
								const gchar* _tmp154_ = NULL;
								const gchar* _tmp155_ = NULL;
								gchar* _tmp156_ = NULL;
								EContactAddress* _tmp157_ = NULL;
								FolksPostalAddress* _tmp158_ = NULL;
								const gchar* _tmp159_ = NULL;
								const gchar* _tmp160_ = NULL;
								gchar* _tmp161_ = NULL;
								EContactAddress* _tmp162_ = NULL;
								FolksPostalAddress* _tmp163_ = NULL;
								const gchar* _tmp164_ = NULL;
								const gchar* _tmp165_ = NULL;
								gchar* _tmp166_ = NULL;
								EContactAddress* _tmp167_ = NULL;
								FolksPostalAddress* _tmp168_ = NULL;
								const gchar* _tmp169_ = NULL;
								const gchar* _tmp170_ = NULL;
								gchar* _tmp171_ = NULL;
								EContactAddress* _tmp172_ = NULL;
								FolksPostalAddress* _tmp173_ = NULL;
								const gchar* _tmp174_ = NULL;
								const gchar* _tmp175_ = NULL;
								gchar* _tmp176_ = NULL;
								EContactAddress* _tmp177_ = NULL;
								FolksPostalAddress* _tmp178_ = NULL;
								const gchar* _tmp179_ = NULL;
								const gchar* _tmp180_ = NULL;
								gchar* _tmp181_ = NULL;
								EContact* _tmp182_ = NULL;
								const gchar* _tmp183_ = NULL;
								EContactField _tmp184_ = 0;
								EContactAddress* _tmp185_ = NULL;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp129_ = c;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp130_ = k;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp131_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp129_, _tmp130_);
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp132_ = (GValue*) _tmp131_;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp133_ = *_tmp132_;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp134_ = g_value_get_object (&_tmp133_);
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp135_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails));
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp136_ = _tmp135_;
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp132_);
#line 317 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								pa_fd = _tmp136_;
#line 318 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp137_ = pa_fd;
#line 318 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp138_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp137_);
#line 318 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp139_ = _tmp138_;
#line 318 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp140_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FolksPostalAddress*) _tmp139_, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress));
#line 318 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								pa = _tmp140_;
#line 319 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp141_ = e_contact_address_new ();
#line 319 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								address = _tmp141_;
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp142_ = address;
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp143_ = pa;
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp144_ = folks_postal_address_get_po_box (_tmp143_);
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp145_ = _tmp144_;
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp146_ = g_strdup (_tmp145_);
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp142_->po);
#line 320 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp142_->po = _tmp146_;
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp147_ = address;
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp148_ = pa;
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp149_ = folks_postal_address_get_extension (_tmp148_);
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp150_ = _tmp149_;
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp151_ = g_strdup (_tmp150_);
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp147_->ext);
#line 321 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp147_->ext = _tmp151_;
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp152_ = address;
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp153_ = pa;
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp154_ = folks_postal_address_get_street (_tmp153_);
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp155_ = _tmp154_;
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp156_ = g_strdup (_tmp155_);
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp152_->street);
#line 322 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp152_->street = _tmp156_;
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp157_ = address;
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp158_ = pa;
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp159_ = folks_postal_address_get_locality (_tmp158_);
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp160_ = _tmp159_;
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp161_ = g_strdup (_tmp160_);
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp157_->locality);
#line 323 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp157_->locality = _tmp161_;
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp162_ = address;
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp163_ = pa;
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp164_ = folks_postal_address_get_region (_tmp163_);
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp165_ = _tmp164_;
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp166_ = g_strdup (_tmp165_);
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp162_->region);
#line 324 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp162_->region = _tmp166_;
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp167_ = address;
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp168_ = pa;
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp169_ = folks_postal_address_get_postal_code (_tmp168_);
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp170_ = _tmp169_;
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp171_ = g_strdup (_tmp170_);
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp167_->code);
#line 325 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp167_->code = _tmp171_;
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp172_ = address;
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp173_ = pa;
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp174_ = folks_postal_address_get_country (_tmp173_);
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp175_ = _tmp174_;
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp176_ = g_strdup (_tmp175_);
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp172_->country);
#line 326 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp172_->country = _tmp176_;
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp177_ = address;
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp178_ = pa;
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp179_ = folks_postal_address_get_address_format (_tmp178_);
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp180_ = _tmp179_;
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp181_ = g_strdup (_tmp180_);
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp177_->address_format);
#line 327 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp177_->address_format = _tmp181_;
#line 329 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp182_ = contact;
#line 329 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp183_ = k;
#line 329 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp184_ = e_contact_field_id (_tmp183_);
#line 329 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp185_ = address;
#line 329 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp182_, _tmp184_, _tmp185_);
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								__vala_EContactAddress_free0 (address);
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa);
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa_fd);
#line 3135 "backend.c"
							} else {
								EContactField field_id = 0;
								const gchar* _tmp186_ = NULL;
								EContactField _tmp187_ = 0;
								gchar* v = NULL;
								GeeHashMap* _tmp188_ = NULL;
								const gchar* _tmp189_ = NULL;
								gpointer _tmp190_ = NULL;
								GValue* _tmp191_ = NULL;
								GValue _tmp192_ = {0};
								const gchar* _tmp193_ = NULL;
								gchar* _tmp194_ = NULL;
								gchar* _tmp195_ = NULL;
								EContactField _tmp196_ = 0;
#line 333 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp186_ = k;
#line 333 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp187_ = e_contact_field_id (_tmp186_);
#line 333 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								field_id = _tmp187_;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp188_ = c;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp189_ = k;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp190_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp188_, _tmp189_);
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp191_ = (GValue*) _tmp190_;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp192_ = *_tmp191_;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp193_ = g_value_get_string (&_tmp192_);
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp194_ = g_strdup (_tmp193_);
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp195_ = _tmp194_;
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp191_);
#line 334 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								v = _tmp195_;
#line 336 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_tmp196_ = field_id;
#line 336 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								if (_tmp196_ != 0) {
#line 3180 "backend.c"
									EContact* _tmp197_ = NULL;
									EContactField _tmp198_ = 0;
									const gchar* _tmp199_ = NULL;
#line 338 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp197_ = contact;
#line 338 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp198_ = field_id;
#line 338 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp199_ = v;
#line 338 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp197_, _tmp198_, _tmp199_);
#line 3192 "backend.c"
								} else {
									EVCard* vcard = NULL;
									EContact* _tmp200_ = NULL;
									EVCard* _tmp201_ = NULL;
									EVCardAttribute* attr = NULL;
									const gchar* _tmp202_ = NULL;
									EVCardAttribute* _tmp203_ = NULL;
									EVCard* _tmp204_ = NULL;
									EVCardAttribute* _tmp205_ = NULL;
									EVCardAttribute* _tmp206_ = NULL;
									const gchar* _tmp207_ = NULL;
#line 342 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp200_ = contact;
#line 342 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp201_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, e_vcard_get_type (), EVCard));
#line 342 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									vcard = _tmp201_;
#line 343 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp202_ = k;
#line 343 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp203_ = e_vcard_attribute_new (NULL, _tmp202_);
#line 343 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									attr = _tmp203_;
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp204_ = vcard;
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp205_ = attr;
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp206_ = __vala_EVCardAttribute_copy0 (_tmp205_);
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_tmp207_ = v;
#line 344 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									e_vcard_append_attribute_with_value (_tmp204_, _tmp206_, _tmp207_);
#line 336 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									__vala_EVCardAttribute_free0 (attr);
#line 336 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
									_g_object_unref0 (vcard);
#line 3230 "backend.c"
								}
#line 315 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (v);
#line 3234 "backend.c"
							}
						}
					}
				}
			}
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 3242 "backend.c"
		}
#line 245 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 3246 "backend.c"
	}
#line 348 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp208_ = added_contact_name;
#line 348 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (_tmp208_) {
#line 3252 "backend.c"
		EContact* _tmp209_ = NULL;
		EContactField _tmp210_ = 0;
		EContactName* _tmp211_ = NULL;
#line 350 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp209_ = contact;
#line 350 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp210_ = e_contact_field_id ("name");
#line 350 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp211_ = contact_name;
#line 350 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp209_, _tmp210_, _tmp211_);
#line 3264 "backend.c"
	}
#line 237 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 237 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 3270 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 354 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 356 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 3280 "backend.c"
	{
		GFile* _tmp0_ = NULL;
#line 361 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_source_file;
#line 361 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (_tmp0_ != NULL) {
#line 3287 "backend.c"
			const gchar* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp1_ = self->priv->_addressbook_name;
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp2_ = self->priv->_source_file;
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp3_ = g_file_get_path (_tmp2_);
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp4_ = _tmp3_;
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_debug ("backend.vala:363: Deleting address book ‘%s’ source file ‘%s’.", _tmp1_, _tmp4_);
#line 363 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_g_free0 (_tmp4_);
#line 365 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp5_ = self->priv->_source_file;
#line 365 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			g_file_delete (_tmp5_, NULL, &_inner_error_);
#line 365 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3311 "backend.c"
				goto __catch6_g_error;
			}
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = self->priv->_addressbook_name;
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = self->priv->_source_file;
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp8_ = g_file_get_path (_tmp7_);
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp9_ = _tmp8_;
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_tmp10_ = e->message;
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_error ("backend.vala:370: Unable to remove address book ‘%s’ source file ‘%s’:" \
" %s", _tmp6_, _tmp9_, _tmp10_);
#line 370 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_tmp9_);
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 3345 "backend.c"
	}
	__finally6:
	{
#line 375 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_file);
#line 375 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source_file = NULL;
#line 376 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source);
#line 376 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source = NULL;
#line 377 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 377 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 378 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_registry);
#line 378 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source_registry = NULL;
#line 3365 "backend.c"
	}
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 359 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return;
#line 3375 "backend.c"
	}
}


static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str) {
	GeeHashMap* result = NULL;
	GeeHashMap* ret = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gchar** im_addrs = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint im_addrs_length1 = 0;
	gint _im_addrs_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 382 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 382 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_str != NULL, NULL);
#line 384 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 384 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 385 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_str;
#line 385 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 385 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 385 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 385 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 3414 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 3426 "backend.c"
			gchar* _tmp5_ = NULL;
			gchar* a = NULL;
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 3433 "backend.c"
			{
				gchar** info = NULL;
				const gchar* _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gchar** _tmp8_ = NULL;
				gint info_length1 = 0;
				gint _info_size_ = 0;
				gchar* proto = NULL;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* addr = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				GeeHashMap* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 389 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 389 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 389 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 389 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 389 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 390 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 390 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 390 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 390 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 390 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 391 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 391 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 391 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 391 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 391 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 393 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 387 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 3514 "backend.c"
			}
		}
	}
#line 396 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 396 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 396 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return result;
#line 3524 "backend.c"
}


const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self) {
	const gchar* result;
	EBookClient* _tmp0_ = NULL;
	ESource* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_client_get_source ((EClient*) _tmp0_);
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_get_uid (_tmp1_);
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	result = _tmp2_;
#line 50 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return result;
#line 3545 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3552 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 3561 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 3571 "backend.c"
	} else {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3575 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3583 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3590 "backend.c"
		EdsTestBackend* object;
		object = collect_values[0].v_pointer;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3597 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3601 "backend.c"
		}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 3605 "backend.c"
	} else {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3609 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3613 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3624 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 3630 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3634 "backend.c"
	} else {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 3638 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3642 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3656 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3665 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 3685 "backend.c"
	} else {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3689 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3695 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend* old;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3714 "backend.c"
	} else {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3718 "backend.c"
	}
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3724 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	((EdsTestBackendClass *) klass)->finalize = eds_test_backend_finalize;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 3736 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 41 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook = NULL;
#line 44 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source_registry = NULL;
#line 45 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source = NULL;
#line 46 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source_file = NULL;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 3753 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend* obj) {
	EdsTestBackend * self;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_BACKEND, EdsTestBackend);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_signal_handlers_destroy (self);
#line 40 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 41 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 42 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 43 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 44 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_registry);
#line 45 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 46 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_file);
#line 3777 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	return instance;
#line 3802 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend* self;
	self = instance;
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 38 "/opt/gnome3/source/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3815 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



