/***************************************************************************
 *   Copyright (C) 2003 by Gav Wood                                        *
 *   gav@cs.york.ac.uk                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 ***************************************************************************/
#ifndef _GEDDEI_MLCONNECTION_H
#define _GEDDEI_MLCONNECTION_H

#ifdef __GEDDEI_BUILD
#include "buffer.h"
#include "xlconnection.h"
#else
#include <geddei/buffer.h>
#include <geddei/xlconnection.h>
#endif
using namespace Geddei;

namespace Geddei
{

class LMConnection;
class BufferReader;
class Processor;

/** @internal @ingroup Geddei
 * @brief Embodiment of Connection that delivers data from an LMConnection to a local Sink.
 * @author Gav Wood <gav@cs.york.ac.uk>
 *
 * A refinement of a flow control class for outbound communication.
 * This class implements a single-in, multiple-out connection paradigm.
 */
class MLConnection: public xLConnection
{
	//* Reimplementations from Connection
	virtual const SignalTypeRef type();

	//* Reimplementations from xLConnection
	virtual void reset();
	virtual void sinkStopping();
	virtual void sinkStopped();
	virtual const uint elementsReady() const;
	virtual void waitForElements(const uint elements) const;
	virtual const BufferData readElements(const uint elements);
	virtual const BufferData peekElements(const uint elements);
	virtual void enforceMinimum(const uint elements);
	virtual BufferReader *newReader();
	virtual void killReader();
	virtual void resurectReader();
	virtual const bool plungeSync(const uint samples) const;
	virtual const uint capacity() const;

protected:
	LMConnection *theConnection;
	BufferReader *theReader;

public:
	/**
	 * Blocks until sink is happy that all inputs are confirmed.
	 */
	const bool waitUntilReady();

	/**
	 * Resets the (essentially cached) type of the connection.
	 * Should be propogated between start & stop called
	 */
	void resetType();

	/**
	 * Sets the (wouldbe cached) type of the connection.
	 */
	void setType(const SignalType *type);
	
	/**
	 * Notifies the Sink that a fresh stream of plungers may be coming from the
	 * source.
	 */
	void startPlungers();
	
	/**
	 * Half the dispatchPlunger() operation. This one doesn't actually append
	 * the plunger to the Buffer, it simply notifies the Sink that a plunger
	 * has been appended.
	 */
	void plungerSent();
	
	/**
	 * Notifies the Sink that no more plungers will be on their way from this
	 * source.
	 */
	void noMorePlungers();
	
	MLConnection(Sink *sink, const uint sinkIndex, LMConnection *connection);
	virtual ~MLConnection();
};

};

#endif
