/*************************************************************************************************
 * Test unit for dynamic linking functions
 *************************************************************************************************/


#include <stdio.h>


/* function prototypes */
void estfilter(const char *infile, const char *outfile);


/* Filter for plain text files. */
void estfilter(const char *infile, const char *outfile){
  FILE *ifp, *ofp;
  int c;
  if((ifp = fopen(infile, "rb")) != NULL){
    if((ofp = fopen(outfile, "wb")) != NULL){
      fprintf(ofp, "<html><body><pre>");
      while((c = fgetc(ifp)) != EOF){
        switch(c){
        case '&': fprintf(ofp, "&amp;"); break;
        case '<': fprintf(ofp, "&lt;"); break;
        case '>': fprintf(ofp, "&gt;"); break;
        default: fputc(c, ofp); break;
        }
      }
      fclose(ofp);
      fprintf(ofp, "</pre></body></html>");
    }
    fclose(ifp);
  }
}



/* END OF FILE */
