#!/bin/bash

. ./common.sh $*

rm -rf $SRCDIR
(cd $TMPDIR; tarz $TLSRCDIR/texlive-2010072?-source.tar.xz)

# pxdvi
echo -e "\e[0;32m *** pxdvi ***\e[0m"
cd $SRCDIR/texk/
cp -r xdvik pxdvik
cd pxdvik
zpatch 1 $TLSRCDIR/ptex/xdvik-2010????-texlive2010.diff
mv texmf/xdvi.cfg texmf/pxdvi.cfg 
mv xdvizilla pxdvizilla
# update freetype2 and enable otvalid module
cd ../../libs/freetype2/
sedwrite configure.ac "s/2.3.11/$FTVER/"
tarz  $TLSRCDIR/freetype-$FTVER.tar.gz
rm -rf freetype-2.3.11
autoconf
cd freetype-$FTVER/
sedwrite modules.cfg 's/# (AUX_MODULES \+= otvalid)/\1/'
cd ../../../m4 
sedwrite kpse-pkgs.m4 "s/xdvik/xdvik\npxdvik/"


echo -e "\e[0;32m *** pxdvi ***\e[0m"
cd $SRCDIR/texk/
zpatch 0 $TLSRCDIR/ptex/ptexfam-common-texlive2010.diff # e-pTeX / upTeX common
                                                        # and wovp2ovf
# updmap
zpatch 2 $TLSRCDIR/ptex/updmap-no-r.patch               # Following 3 patches 
zpatch 2 $TLSRCDIR/ptex/updmap-nostop.patch             #   are from ptexlive-20100322
zpatch 2 $TLSRCDIR/ptex/updmap-live2009-4b.diff         #

# patch for pTeX
if [ "$FLG_PP" = "TRUE" ] ;then
  echo -e "\e[0;32m *** pTeX patch ***\e[0m"
  cd $SRCDIR/texk/web2c/ptexdir
  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.0711.diff
  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.0814-tl10.diff

  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.110119PB.diff 
    # patch for potential bug by Peter Breitenlohner

  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.110223_radical.diff 
  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.110224_boxdim.diff 

  zpatch 0 $TLSRCDIR/ptex/ptex-base.ch.boxdir.diff 
    # must be last

  cd ../..
  zpatch 0 $TLSRCDIR/ptex/dvipdfmx-110120-dtou.diff
  zpatch 0 $TLSRCDIR/ptex/pxdvik-20110118-dtou.diff
fi

# e-pTeX
if [ "$FLG_EP" = "TRUE" ] ;then
  echo -e "\e[0;32m *** e-pTeX patch ***\e[0m"
  cd $SRCDIR/texk/web2c
  cp -r ptexdir eptexdir
  cd eptexdir
  mv ptex.defines eptex.defines
  cp ptex-base.ch eptex-base.ch
  cp $TLSRCDIR/eptex/pdfstrcmp.ch ./
  cp $TLSRCDIR/eptex/pdfsavepos.ch ./
  cp $TLSRCDIR/eptex/etex-lrstat.ch ./
  cd ../..
  zpatch 0 $TLSRCDIR/eptex/eptex-??????-texlive2010.diff
  zpatch 0 $TLSRCDIR/eptex/ptexenc-110102-toUCS_export.diff
  chmod +x web2c/eptexdir/eptrip.test
  # include eptex.am
  sedwrite web2c/Makefile.am "s+#(.*/eptex.am)+\1+"
fi

# upTeX
if [ "$FLG_UP" = "TRUE" ] ;then
  echo -e "\e[0;32m *** upTeX patch ***\e[0m"
  # uptexenc (modified ptexenc for upTeX)
  cd $SRCDIR/texk/
  tarz $TLSRCDIR/uptex/uptexenc-*.tar.xz
  chmod +x uptexenc/configure
  cd ../m4
  cp kpse-ptexenc-flags.m4 kpse-uptexenc-flags.m4
  zpatch 0 ../texk/uptexenc/uptexenc-m4-texlive2010.diff
  # patches for dvipdfmx, pxdvi, makejvf 
  cd ../texk
  zpatch 1 $TLSRCDIR/uptex/uptex-*-dvipdfmx-texlive2010.diff
  zpatch 1 $TLSRCDIR/uptex/uptex-*-pxdvik-texlive2010.diff
  zpatch 1 $TLSRCDIR/uptex/uptex-*-makejvf-texlive2010.diff
  # Web2C
  cd web2c
  cp -r ptexdir uptexdir
  mv uptexdir/ptex-base.ch uptexdir/uptex-base.ch
  mv uptexdir/pbibtex.ch  uptexdir/upbibtex.ch
  mv uptexdir/ppltotf.ch  uptexdir/uppltotf.ch
  mv uptexdir/ptftopl.ch  uptexdir/uptftopl.ch
  mv uptexdir/pdvitype.ch uptexdir/updvitype.ch
  mv uptexdir/ptex.defines uptexdir/uptex.defines 
  cp $TLSRCDIR/uptex/uptex.am uptexdir/am/ # Makefile fragment for upTeX
  cd ..
  if [ "$FLG_PP" = "TRUE" ] ;then
    PMODE=ignore zpatch 0 $TLSRCDIR/uptex/uptex-*-uptexbase-texlive2010.diff
    zpatch 0 $TLSRCDIR/uptex/uptex-*-ptex100711-fix.diff
  else 
    zpatch 0 $TLSRCDIR/uptex/uptex-*-uptexbase-texlive2010.diff
  fi 
  zpatch 0 $TLSRCDIR/uptex/uptex-*-kcatcode_fix.diff
  zpatch 0 $TLSRCDIR/uptex/uptex-*-web2clib-texlive2010.diff
  cp web2c/omegaware/ovp2ovf.web web2c/omegaware/upovp2ovf.web 
  cp web2c/omegaware/ovp2ovf.ch  web2c/omegaware/upovp2ovf.ch
  zpatch 0 $TLSRCDIR/uptex/uptex-*-upovp2ovf-texlive2010.diff
  # include uptex.am
  sedwrite web2c/Makefile.am "s+#(.*/uptex.am)+\1+"
fi

# e-upTeX
if [ "$FLG_EP" = "TRUE" -a "$FLG_UP" = "TRUE" ] ;then
  echo -e "\e[0;32m *** e-upTeX patch ***\e[0m"
  cd $SRCDIR/texk/web2c/
  cp -r uptexdir euptexdir
  mv euptexdir/uptex-base.ch euptexdir/eptex-base.ch
  cd euptexdir
  cp $TLSRCDIR/eptex/pdfstrcmp.ch ./
  cp $TLSRCDIR/eptex/pdfsavepos.ch ./
  touch eptex.defines
  PMODE=ignore zpatch 2 $TLSRCDIR/eptex/eptex-??????-texlive2010.diff
  mv uptex.defines euptex.defines
  mv eptex-base.ch euptex-base.ch
  cp ../eptexdir/fam256.ch fam256.ch
  zpatch 0 $TLSRCDIR/eptex/euptex-??????-up*-texlive2010.diff
  chmod +x euptrip.test
  rm am/eptex.am
  cp $TLSRCDIR/eptex/euptex.am am/euptex.am
  cd ../..
  # include uptex.am
  sedwrite web2c/Makefile.am "s+#(.*/euptex.am)+\1+"
fi
exit 0
