/* Generated By:JavaCC: Do not edit this line. ASCII_UCodeESC_CharStream.java Version 0.7pre6 */

/*
 * Cobertura - http://cobertura.sourceforge.net/
 *
 * This file was taken from JavaNCSS
 * http://www.kclee.com/clemens/java/javancss/
 * Copyright (C) 2000 Chr. Clemens Lee <clemens a.t kclee d.o.t com>
 *
 * Cobertura is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * Cobertura is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package net.sourceforge.cobertura.javancss;

/**
 * An implementation of interface CharStream, where the stream is assumed to
 * contain only ASCII characters (with java-like unicode escape processing).
 */

public final class ASCII_UCodeESC_CharStream
{

	public static final boolean staticFlag = false;

	private static final int hexval(char c) throws java.io.IOException
	{
		switch (c)
		{
			case '0':
				return 0;
			case '1':
				return 1;
			case '2':
				return 2;
			case '3':
				return 3;
			case '4':
				return 4;
			case '5':
				return 5;
			case '6':
				return 6;
			case '7':
				return 7;
			case '8':
				return 8;
			case '9':
				return 9;

			case 'a':
			case 'A':
				return 10;
			case 'b':
			case 'B':
				return 11;
			case 'c':
			case 'C':
				return 12;
			case 'd':
			case 'D':
				return 13;
			case 'e':
			case 'E':
				return 14;
			case 'f':
			case 'F':
				return 15;
		}

		throw new java.io.IOException(); // Should never come here
	}

	private int bufpos = -1;
	private int bufsize;
	private int available;
	private int tokenBegin;
	private int bufline[];
	private int bufcolumn[];

	private int column = 0;
	private int line = 1;

	private java.io.Reader inputStream;

	private boolean prevCharIsCR = false;
	private boolean prevCharIsLF = false;

	private char[] nextCharBuf;
	private char[] buffer;
	private int maxNextCharInd = 0;
	private int nextCharInd = -1;
	private int inBuf = 0;

	private final void expandBuff(boolean wrapAround)
	{
		char[] newbuffer = new char[bufsize + 2048];
		int newbufline[] = new int[bufsize + 2048];
		int newbufcolumn[] = new int[bufsize + 2048];

		try
		{
			if (wrapAround)
			{
				System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
				System.arraycopy(buffer, 0, newbuffer, bufsize - tokenBegin, bufpos);
				buffer = newbuffer;

				System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
				System.arraycopy(bufline, 0, newbufline, bufsize - tokenBegin, bufpos);
				bufline = newbufline;

				System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
				System.arraycopy(bufcolumn, 0, newbufcolumn, bufsize - tokenBegin, bufpos);
				bufcolumn = newbufcolumn;

				bufpos += (bufsize - tokenBegin);
			}
			else
			{
				System.arraycopy(buffer, tokenBegin, newbuffer, 0, bufsize - tokenBegin);
				buffer = newbuffer;

				System.arraycopy(bufline, tokenBegin, newbufline, 0, bufsize - tokenBegin);
				bufline = newbufline;

				System.arraycopy(bufcolumn, tokenBegin, newbufcolumn, 0, bufsize - tokenBegin);
				bufcolumn = newbufcolumn;

				bufpos -= tokenBegin;
			}
		}
		catch (Throwable t)
		{
			throw new Error(t.getMessage());
		}

		available = (bufsize += 2048);
		tokenBegin = 0;
	}

	private final void fillBuff() throws java.io.IOException
	{
		int i;
		if (maxNextCharInd == 4096)
			maxNextCharInd = nextCharInd = 0;

		try
		{
			if ((i = inputStream.read(nextCharBuf, maxNextCharInd, 4096 - maxNextCharInd)) == -1)
			{
				inputStream.close();
				throw new java.io.IOException();
			}
			maxNextCharInd += i;
			return;
		}
		catch (java.io.IOException e)
		{
			if (bufpos != 0)
			{
				--bufpos;
				backup(0);
			}
			else
			{
				bufline[bufpos] = line;
				bufcolumn[bufpos] = column;
			}
			throw e;
		}
	}

	private final char readByte() throws java.io.IOException
	{
		if (++nextCharInd >= maxNextCharInd)
			fillBuff();

		return nextCharBuf[nextCharInd];
	}

	public final char beginToken() throws java.io.IOException
	{
		if (inBuf > 0)
		{
			--inBuf;
			return buffer[tokenBegin = (bufpos == bufsize - 1) ? (bufpos = 0) : ++bufpos];
		}

		tokenBegin = 0;
		bufpos = -1;

		return readChar();
	}

	private final void adjustBuffSize()
	{
		if (available == bufsize)
		{
			if (tokenBegin > 2048)
			{
				bufpos = 0;
				available = tokenBegin;
			}
			else
				expandBuff(false);
		}
		else if (available > tokenBegin)
			available = bufsize;
		else if ((tokenBegin - available) < 2048)
			expandBuff(true);
		else
			available = tokenBegin;
	}

	private final void updateLineColumn(char c)
	{
		column++;

		if (prevCharIsLF)
		{
			prevCharIsLF = false;
			line += (column = 1);
		}
		else if (prevCharIsCR)
		{
			prevCharIsCR = false;
			if (c == '\n')
			{
				prevCharIsLF = true;
			}
			else
				line += (column = 1);
		}

		switch (c)
		{
			case '\r':
				prevCharIsCR = true;
				break;
			case '\n':
				prevCharIsLF = true;
				break;
			case '\t':
				column--;
				column += (8 - (column & 07));
				break;
			default:
				break;
		}

		bufline[bufpos] = line;
		bufcolumn[bufpos] = column;
	}

	public final char readChar() throws java.io.IOException
	{
		if (inBuf > 0)
		{
			--inBuf;
			return buffer[(bufpos == bufsize - 1) ? (bufpos = 0) : ++bufpos];
		}

		char c;

		if (++bufpos == available)
			adjustBuffSize();

		if (((buffer[bufpos] = c = (char)((char)0xff & readByte())) == '\\'))
		{
			updateLineColumn(c);

			int backSlashCnt = 1;

			for (;;) // Read all the backslashes
			{
				if (++bufpos == available)
					adjustBuffSize();

				try
				{
					if ((buffer[bufpos] = c = (char)((char)0xff & readByte())) != '\\')
					{
						updateLineColumn(c);
						// found a non-backslash char.
						if ((c == 'u') && ((backSlashCnt & 1) == 1))
						{
							if (--bufpos < 0)
								bufpos = bufsize - 1;

							break;
						}

						backup(backSlashCnt);
						return '\\';
					}
				}
				catch (java.io.IOException e)
				{
					if (backSlashCnt > 1)
						backup(backSlashCnt);

					return '\\';
				}

				updateLineColumn(c);
				backSlashCnt++;
			}

			// Here, we have seen an odd number of backslash's followed by a 'u'
			try
			{
				while ((c = (char)((char)0xff & readByte())) == 'u')
					++column;

				buffer[bufpos] = c = (char)(hexval(c) << 12
						| hexval((char)((char)0xff & readByte())) << 8
						| hexval((char)((char)0xff & readByte())) << 4 | hexval((char)((char)0xff & readByte())));

				column += 4;
			}
			catch (java.io.IOException e)
			{
				throw new Error("Invalid escape character at line " + line + " column " + column
						+ ".");
			}

			if (backSlashCnt == 1)
				return c;

			backup(backSlashCnt - 1);
			return '\\';
		}

		updateLineColumn(c);
		return (c);
	}

	public final int getEndColumn()
	{
		return bufcolumn[bufpos];
	}

	public final int getEndLine()
	{
		return bufline[bufpos];
	}

	public final int getBeginColumn()
	{
		return bufcolumn[tokenBegin];
	}

	public final int getBeginLine()
	{
		return bufline[tokenBegin];
	}

	public final void backup(int amount)
	{

		inBuf += amount;
		if ((bufpos -= amount) < 0)
			bufpos += bufsize;
	}

	private ASCII_UCodeESC_CharStream(java.io.Reader dstream, int startline, int startcolumn,
			int buffersize)
	{
		inputStream = dstream;
		line = startline;
		column = startcolumn - 1;

		available = bufsize = buffersize;
		buffer = new char[buffersize];
		bufline = new int[buffersize];
		bufcolumn = new int[buffersize];
		nextCharBuf = new char[4096];
	}

	public ASCII_UCodeESC_CharStream(java.io.InputStream dstream, int startline, int startcolumn)
	{
		this(new java.io.InputStreamReader(dstream), startline, startcolumn, 4096);
	}

	public final String getImage()
	{
		if (bufpos >= tokenBegin)
			return new String(buffer, tokenBegin, bufpos - tokenBegin + 1);
		return new String(buffer, tokenBegin, bufsize - tokenBegin)
				+ new String(buffer, 0, bufpos + 1);
	}

	public final char[] getSuffix(int len)
	{
		char[] ret = new char[len];

		if ((bufpos + 1) >= len)
			System.arraycopy(buffer, bufpos - len + 1, ret, 0, len);
		else
		{
			System.arraycopy(buffer, bufsize - (len - bufpos - 1), ret, 0, len - bufpos - 1);
			System.arraycopy(buffer, 0, ret, len - bufpos - 1, bufpos + 1);
		}

		return ret;
	}

}
