/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.dom;

import java.io.IOException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.util.NestedIOException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xslt.dom.XPNBuilder;
import org.exolab.adaptx.xslt.util.Configuration;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XPNReader {
    private static final String REUSE_ERR = "This XPNReader was previously used. Please create a new one.";
    private URILocation _location = null;
    private Parser _parser = null;
    private boolean _saveLocation = false;
    private boolean _usable = true;

    public XPNReader(String string) throws IOException {
        if (string == null) {
            String string2 = "The argument 'url' may not be null.";
            throw new IllegalArgumentException(string2);
        }
        this._location = new URILocationImpl(string);
        this.initParser();
    }

    public XPNReader(URILocation uRILocation) throws IOException {
        if (uRILocation == null) {
            String string = "The argument 'location' may not be null.";
            throw new IllegalArgumentException(string);
        }
        this._location = uRILocation;
        this.initParser();
    }

    private void initParser() throws IOException {
        this._parser = Configuration.getSAXParser();
        if (this._parser == null) {
            throw new NestedIOException("unable to create SAX parser.");
        }
    }

    public XPathNode read() throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this._usable) {
                throw new IOException(REUSE_ERR);
            }
            this._usable = false;
        }
        object = new XPNBuilder();
        ((XPNBuilder)object).setSaveLocation(this._saveLocation);
        try {
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(this._location.getAbsoluteURI());
            inputSource.setCharacterStream(this._location.getReader());
            this._parser.setDocumentHandler((DocumentHandler)object);
            this._parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            SAXParseException sAXParseException = null;
            Exception exception = sAXException.getException();
            if (sAXException instanceof SAXParseException) {
                sAXParseException = (SAXParseException)sAXException;
            } else if (exception != null && exception instanceof SAXParseException) {
                sAXParseException = (SAXParseException)exception;
            }
            if (sAXParseException != null) {
                StringBuffer stringBuffer = new StringBuffer(((SAXException)sAXParseException).toString());
                stringBuffer.append("\n - ");
                stringBuffer.append(sAXParseException.getSystemId());
                stringBuffer.append("; line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(", column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                throw new NestedIOException(stringBuffer.toString(), sAXException);
            }
            throw new NestedIOException(sAXException);
        }
        return ((XPNBuilder)object).getRoot();
    }

    public void setSaveLocation(boolean bl) {
        this._saveLocation = bl;
    }
}

