/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.NodeExpression;

class NamespaceExpr
extends NodeExpression {
    private static final String WILD_CARD = "*";
    private boolean _isWild = false;
    private String _prefix;

    public NamespaceExpr() {
    }

    public NamespaceExpr(String string) throws XPathException {
        if (string == null) {
            throw new XPathException("Argument qname is null");
        }
        if (string.equals(WILD_CARD)) {
            this._prefix = WILD_CARD;
            this._isWild = true;
        } else {
            int n = string.indexOf(58);
            if (n >= 1) {
                this._prefix = string.substring(n + 1);
                if (!string.substring(0, n).equals("xmlns")) {
                    throw new XPathException("The prefix of the namespace declaration is not xmlns");
                }
            } else {
                this._prefix = string;
            }
        }
    }

    private void addNamespaces(XPathNode xPathNode, NodeSet nodeSet) {
        if (xPathNode == null) {
            return;
        }
        XPathNode xPathNode2 = xPathNode.getFirstNamespace();
        while (xPathNode2 != null) {
            String string = xPathNode2.getLocalName();
            if (string == null && this._prefix.length() == 0 || string.equals(this._prefix)) {
                nodeSet.add(xPathNode2);
            }
            xPathNode2 = xPathNode2.getNext();
        }
        this.addNamespaces(xPathNode.getParentNode(), nodeSet);
    }

    private void addNamespacesWild(XPathNode xPathNode, NodeSet nodeSet) {
        if (xPathNode == null) {
            return;
        }
        XPathNode xPathNode2 = xPathNode.getFirstNamespace();
        while (xPathNode2 != null) {
            nodeSet.add(xPathNode2);
            xPathNode2 = xPathNode2.getNext();
        }
        this.addNamespacesWild(xPathNode.getParentNode(), nodeSet);
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        XPathNode xPathNode = xPathContext.getNode();
        NodeSet nodeSet = xPathContext.newNodeSet();
        if (this._prefix.equals(WILD_CARD)) {
            this.addNamespacesWild(xPathNode, nodeSet);
        } else {
            this.addNamespaces(xPathNode, nodeSet);
        }
        return nodeSet;
    }

    public short getExprType() {
        return 7;
    }

    public short getNodeExprType() {
        return 10;
    }

    public boolean matches(XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (xPathNode == null) {
            return false;
        }
        if (xPathNode.getNodeType() == 13) {
            if (this._prefix.equals(WILD_CARD)) {
                return true;
            }
            String string = xPathNode.getLocalName();
            return string == null && this._prefix.length() == 0 || string.equals(this._prefix);
        }
        return false;
    }

    public String toString() {
        return this._prefix;
    }
}

