type token =
  | UCHAR of (UChar.t)
  | ASCII of (char)
  | DOT
  | ASTARISK
  | REPN of (int * (int option) * string)
  | PLUS
  | QUESTION
  | LEFT_BRACKET
  | RIGHT_BRACKET
  | MINUS
  | HAT
  | DOLLAR
  | ALT
  | LEFT_PAREN
  | RIGHT_PAREN
  | LEFT_BRACE
  | RIGHT_BRACE
  | SPACE
  | AND
  | OR
  | COLON
  | BOS
  | EOS
  | END

open Parsing;;
# 37 "internal/uReStrParser.mly"

let any =
  let excluded_chars = List.map UChar.chr_of_uint
      [0x2028; 0x2029; 0x0a; 0x0c; 0x0d; 0x85] in
  let s = List.fold_right USet.add excluded_chars USet.empty in
  USet.compl s

let line_separators =
  let cr = [UChar.chr_of_uint 0x0d] in
  let lf = [UChar.chr_of_uint 0x0a] in
  let crlf = cr @ lf in
  let ls = [UChar.chr_of_uint 0x2028] in
  let ps = [UChar.chr_of_uint 0x2029] in
  let ff = [UChar.chr_of_uint 0x0d] in
  let nel = [UChar.chr_of_uint 0x85] in
  let r = `String nel in
  let r = `Alt (`String ff, r) in
  let r = `Alt (`String lf, r) in
  let r = `Alt (`String cr, r) in
  let r = `Alt (`String crlf, r) in
  let r = `Alt (`String ps, r) in
  `Alt (`String ls, r)

let bol = `Alt (`BoS, `After line_separators)

let eol = `Alt (`EoS, `Before line_separators)

let string_of_list cs =
  let b = Buffer.create 0 in
  List.iter (Buffer.add_char b) cs;
  Buffer.contents b

let quoted_charset c =
  let s = USet.add (UChar.of_char '\\') USet.empty in
  USet.add (UChar.of_char c) s

let set_of_string s =
  let r = ref USet.empty in
  String.iter (fun c -> 
    r := USet.add (UChar.of_char c) !r)
    s;
  !r
  
# 73 "internal/uReStrParser.ml"
let yytransl_const = [|
  259 (* DOT *);
  260 (* ASTARISK *);
  262 (* PLUS *);
  263 (* QUESTION *);
  264 (* LEFT_BRACKET *);
  265 (* RIGHT_BRACKET *);
  266 (* MINUS *);
  267 (* HAT *);
  268 (* DOLLAR *);
  269 (* ALT *);
  270 (* LEFT_PAREN *);
  271 (* RIGHT_PAREN *);
  272 (* LEFT_BRACE *);
  273 (* RIGHT_BRACE *);
  274 (* SPACE *);
  275 (* AND *);
  276 (* OR *);
  277 (* COLON *);
  278 (* BOS *);
  279 (* EOS *);
  280 (* END *);
    0|]

let yytransl_block = [|
  257 (* UCHAR *);
  258 (* ASCII *);
  261 (* REPN *);
    0|]

let yylhs = "\255\255\
\001\000\001\000\002\000\002\000\002\000\002\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
\005\000\003\000\003\000\004\000\004\000\004\000\004\000\004\000\
\004\000\008\000\008\000\008\000\008\000\008\000\009\000\009\000\
\009\000\009\000\009\000\009\000\010\000\012\000\012\000\012\000\
\012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
\012\000\012\000\006\000\006\000\007\000\007\000\011\000\011\000\
\011\000\011\000\011\000\011\000\011\000\011\000\011\000\013\000\
\013\000\000\000"

let yylen = "\002\000\
\002\000\001\000\001\000\003\000\001\000\001\000\001\000\002\000\
\002\000\002\000\002\000\003\000\002\000\003\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\002\000\001\000\003\000\002\000\002\000\001\000\
\001\000\001\000\003\000\002\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\003\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\001\000\
\001\000\001\000\001\000\001\000\001\000\001\000\001\000\003\000\
\003\000\003\000\003\000\003\000\002\000\002\000\002\000\001\000\
\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\017\000\018\000\005\000\000\000\019\000\006\000\
\007\000\000\000\020\000\021\000\022\000\023\000\024\000\025\000\
\015\000\016\000\002\000\074\000\000\000\003\000\000\000\046\000\
\047\000\051\000\048\000\041\000\049\000\050\000\053\000\059\000\
\058\000\000\000\052\000\044\000\039\000\040\000\000\000\054\000\
\055\000\056\000\057\000\042\000\043\000\000\000\000\000\032\000\
\033\000\060\000\000\000\008\000\009\000\010\000\011\000\000\000\
\001\000\000\000\027\000\061\000\000\000\000\000\037\000\038\000\
\062\000\000\000\000\000\000\000\000\000\000\000\063\000\004\000\
\000\000\000\000\014\000\000\000\000\000\000\000\073\000\000\000\
\000\000\071\000\000\000\045\000\070\000\000\000\000\000\000\000\
\029\000\035\000\064\000\000\000\000\000\000\000\000\000"

let yydgoto = "\002\000\
\020\000\058\000\022\000\046\000\023\000\047\000\061\000\078\000\
\063\000\064\000\070\000\065\000\071\000"

let yysindex = "\006\000\
\063\255\000\000\000\000\000\000\000\000\087\255\000\000\000\000\
\000\000\038\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\016\255\000\000\118\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\179\255\000\000\000\000\000\000\000\000\041\255\000\000\
\000\000\000\000\000\000\000\000\000\000\110\255\003\255\000\000\
\000\000\000\000\133\255\000\000\000\000\000\000\000\000\038\000\
\000\000\248\255\000\000\000\000\004\255\061\000\000\000\000\000\
\000\000\013\255\087\255\041\255\041\255\036\255\000\000\000\000\
\015\000\106\000\000\000\248\255\106\000\015\000\000\000\156\255\
\007\255\000\000\041\255\000\000\000\000\041\255\041\255\041\255\
\000\000\000\000\000\000\026\255\007\255\122\000\007\255"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\082\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\202\255\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\054\255\000\000\000\000\225\255\141\000\000\000\000\000\
\000\000\081\000\000\000\000\000\000\000\000\000\000\000\000\000\
\252\254\000\000\000\000\029\000\000\000\253\254\000\000\000\000\
\147\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\031\255\153\000\247\254\159\000"

let yygindex = "\000\000\
\000\000\002\000\008\000\231\255\000\000\000\000\253\000\226\255\
\250\255\251\255\061\001\252\255\004\000"

let yytablesize = 436
let yytable = "\048\000\
\049\000\050\000\021\000\062\000\031\000\036\000\001\000\067\000\
\031\000\036\000\067\000\051\000\074\000\077\000\066\000\073\000\
\003\000\004\000\005\000\052\000\053\000\054\000\055\000\006\000\
\085\000\007\000\008\000\009\000\056\000\010\000\059\000\011\000\
\012\000\013\000\014\000\015\000\016\000\017\000\018\000\057\000\
\068\000\080\000\066\000\085\000\086\000\083\000\088\000\068\000\
\067\000\073\000\068\000\068\000\084\000\085\000\086\000\087\000\
\088\000\076\000\069\000\000\000\048\000\049\000\050\000\003\000\
\004\000\005\000\013\000\000\000\013\000\079\000\006\000\000\000\
\007\000\008\000\009\000\000\000\010\000\013\000\011\000\012\000\
\013\000\014\000\015\000\016\000\017\000\018\000\019\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\031\000\032\000\
\033\000\034\000\035\000\036\000\037\000\038\000\039\000\000\000\
\040\000\041\000\042\000\043\000\044\000\045\000\024\000\025\000\
\026\000\027\000\028\000\029\000\030\000\031\000\072\000\033\000\
\060\000\035\000\036\000\037\000\038\000\039\000\000\000\040\000\
\041\000\042\000\043\000\044\000\045\000\003\000\004\000\005\000\
\052\000\053\000\054\000\055\000\006\000\000\000\007\000\008\000\
\009\000\056\000\010\000\075\000\011\000\012\000\013\000\014\000\
\015\000\016\000\017\000\018\000\024\000\025\000\026\000\027\000\
\028\000\029\000\030\000\031\000\091\000\033\000\060\000\035\000\
\036\000\037\000\038\000\039\000\000\000\040\000\041\000\042\000\
\043\000\044\000\045\000\024\000\025\000\026\000\027\000\028\000\
\029\000\030\000\031\000\000\000\033\000\060\000\035\000\036\000\
\037\000\038\000\039\000\000\000\040\000\041\000\042\000\043\000\
\044\000\045\000\028\000\028\000\028\000\028\000\028\000\028\000\
\028\000\028\000\028\000\000\000\028\000\028\000\028\000\028\000\
\028\000\028\000\000\000\028\000\028\000\028\000\028\000\028\000\
\028\000\034\000\034\000\034\000\034\000\034\000\034\000\034\000\
\034\000\034\000\000\000\034\000\034\000\034\000\034\000\034\000\
\034\000\000\000\034\000\034\000\034\000\034\000\034\000\034\000\
\003\000\004\000\005\000\052\000\053\000\054\000\055\000\006\000\
\000\000\007\000\008\000\009\000\000\000\010\000\000\000\011\000\
\012\000\013\000\014\000\015\000\016\000\017\000\018\000\024\000\
\025\000\026\000\027\000\028\000\029\000\030\000\031\000\000\000\
\033\000\060\000\035\000\000\000\037\000\038\000\039\000\000\000\
\040\000\041\000\042\000\043\000\044\000\045\000\003\000\004\000\
\005\000\012\000\000\000\012\000\000\000\006\000\000\000\007\000\
\008\000\009\000\000\000\010\000\012\000\011\000\012\000\013\000\
\014\000\015\000\016\000\017\000\018\000\024\000\025\000\026\000\
\027\000\028\000\029\000\030\000\031\000\000\000\089\000\000\000\
\035\000\090\000\000\000\000\000\039\000\000\000\040\000\000\000\
\000\000\000\000\044\000\045\000\026\000\026\000\026\000\026\000\
\026\000\026\000\072\000\000\000\026\000\026\000\026\000\026\000\
\026\000\072\000\072\000\072\000\072\000\072\000\000\000\026\000\
\026\000\026\000\024\000\025\000\026\000\027\000\000\000\029\000\
\030\000\031\000\000\000\033\000\060\000\035\000\003\000\004\000\
\000\000\000\000\000\000\040\000\041\000\042\000\043\000\007\000\
\081\000\082\000\000\000\083\000\000\000\011\000\012\000\013\000\
\014\000\015\000\016\000\085\000\086\000\000\000\088\000\092\000\
\000\000\000\000\093\000\094\000\095\000\030\000\030\000\030\000\
\000\000\030\000\030\000\030\000\069\000\000\000\000\000\030\000\
\030\000\030\000\066\000\069\000\000\000\069\000\069\000\069\000\
\065\000\066\000\000\000\066\000\066\000\066\000\000\000\065\000\
\000\000\065\000\065\000\065\000"

let yycheck = "\006\000\
\006\000\006\000\001\000\034\000\009\001\009\001\001\000\017\001\
\013\001\013\001\020\001\010\000\010\001\010\001\002\001\046\000\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\008\001\
\018\001\010\001\011\001\012\001\013\001\014\001\023\000\016\001\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\024\001\
\010\001\067\000\002\001\018\001\019\001\010\001\021\001\017\001\
\008\001\080\000\020\001\011\001\017\001\018\001\019\001\020\001\
\021\001\056\000\018\001\255\255\067\000\067\000\067\000\001\001\
\002\001\003\001\013\001\255\255\015\001\066\000\008\001\255\255\
\010\001\011\001\012\001\255\255\014\001\024\001\016\001\017\001\
\018\001\019\001\020\001\021\001\022\001\023\001\024\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\009\001\
\010\001\011\001\012\001\013\001\014\001\015\001\016\001\255\255\
\018\001\019\001\020\001\021\001\022\001\023\001\001\001\002\001\
\003\001\004\001\005\001\006\001\007\001\008\001\009\001\010\001\
\011\001\012\001\013\001\014\001\015\001\016\001\255\255\018\001\
\019\001\020\001\021\001\022\001\023\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\255\255\010\001\011\001\
\012\001\013\001\014\001\015\001\016\001\017\001\018\001\019\001\
\020\001\021\001\022\001\023\001\001\001\002\001\003\001\004\001\
\005\001\006\001\007\001\008\001\009\001\010\001\011\001\012\001\
\013\001\014\001\015\001\016\001\255\255\018\001\019\001\020\001\
\021\001\022\001\023\001\001\001\002\001\003\001\004\001\005\001\
\006\001\007\001\008\001\255\255\010\001\011\001\012\001\013\001\
\014\001\015\001\016\001\255\255\018\001\019\001\020\001\021\001\
\022\001\023\001\001\001\002\001\003\001\004\001\005\001\006\001\
\007\001\008\001\009\001\255\255\011\001\012\001\013\001\014\001\
\015\001\016\001\255\255\018\001\019\001\020\001\021\001\022\001\
\023\001\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\255\255\011\001\012\001\013\001\014\001\015\001\
\016\001\255\255\018\001\019\001\020\001\021\001\022\001\023\001\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\008\001\
\255\255\010\001\011\001\012\001\255\255\014\001\255\255\016\001\
\017\001\018\001\019\001\020\001\021\001\022\001\023\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\008\001\255\255\
\010\001\011\001\012\001\255\255\014\001\015\001\016\001\255\255\
\018\001\019\001\020\001\021\001\022\001\023\001\001\001\002\001\
\003\001\013\001\255\255\015\001\255\255\008\001\255\255\010\001\
\011\001\012\001\255\255\014\001\024\001\016\001\017\001\018\001\
\019\001\020\001\021\001\022\001\023\001\001\001\002\001\003\001\
\004\001\005\001\006\001\007\001\008\001\255\255\074\000\255\255\
\012\001\077\000\255\255\255\255\016\001\255\255\018\001\255\255\
\255\255\255\255\022\001\023\001\003\001\004\001\005\001\006\001\
\007\001\008\001\010\001\255\255\011\001\012\001\013\001\014\001\
\015\001\017\001\018\001\019\001\020\001\021\001\255\255\022\001\
\023\001\024\001\001\001\002\001\003\001\004\001\255\255\006\001\
\007\001\008\001\255\255\010\001\011\001\012\001\001\001\002\001\
\255\255\255\255\255\255\018\001\019\001\020\001\021\001\010\001\
\068\000\069\000\255\255\010\001\255\255\016\001\017\001\018\001\
\019\001\020\001\021\001\018\001\019\001\255\255\021\001\083\000\
\255\255\255\255\086\000\087\000\088\000\009\001\010\001\011\001\
\255\255\013\001\014\001\015\001\010\001\255\255\255\255\019\001\
\020\001\021\001\010\001\017\001\255\255\019\001\020\001\021\001\
\010\001\017\001\255\255\019\001\020\001\021\001\255\255\017\001\
\255\255\019\001\020\001\021\001"

let yynames_const = "\
  DOT\000\
  ASTARISK\000\
  PLUS\000\
  QUESTION\000\
  LEFT_BRACKET\000\
  RIGHT_BRACKET\000\
  MINUS\000\
  HAT\000\
  DOLLAR\000\
  ALT\000\
  LEFT_PAREN\000\
  RIGHT_PAREN\000\
  LEFT_BRACE\000\
  RIGHT_BRACE\000\
  SPACE\000\
  AND\000\
  OR\000\
  COLON\000\
  BOS\000\
  EOS\000\
  END\000\
  "

let yynames_block = "\
  UCHAR\000\
  ASCII\000\
  REPN\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    Obj.repr(
# 123 "internal/uReStrParser.mly"
             (_1)
# 330 "internal/uReStrParser.ml"
               : UReStrParserType.tree))
; (fun __caml_parser_env ->
    Obj.repr(
# 124 "internal/uReStrParser.mly"
      (`Epsilon)
# 336 "internal/uReStrParser.ml"
               : UReStrParserType.tree))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'string) in
    Obj.repr(
# 127 "internal/uReStrParser.mly"
         (`String _1)
# 343 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'charset) in
    Obj.repr(
# 128 "internal/uReStrParser.mly"
                                     (`SetNotation _2)
# 350 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    Obj.repr(
# 129 "internal/uReStrParser.mly"
      (`Set any)
# 356 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    Obj.repr(
# 130 "internal/uReStrParser.mly"
      (bol)
# 362 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    Obj.repr(
# 131 "internal/uReStrParser.mly"
         (eol)
# 368 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    Obj.repr(
# 132 "internal/uReStrParser.mly"
                  (`Rep _1)
# 375 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : int * (int option) * string) in
    Obj.repr(
# 133 "internal/uReStrParser.mly"
              (let n, m, _ = _2 in `Repn (_1, n, m))
# 383 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    Obj.repr(
# 134 "internal/uReStrParser.mly"
              (`Seq (_1, (`Rep _1)))
# 390 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    Obj.repr(
# 135 "internal/uReStrParser.mly"
                  (`Alt (_1, `Epsilon))
# 397 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'regexp) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'regexp) in
    Obj.repr(
# 136 "internal/uReStrParser.mly"
                    (`Alt (_1, _3))
# 405 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'regexp) in
    Obj.repr(
# 137 "internal/uReStrParser.mly"
                             (`Seq (_1, _2))
# 413 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'regexp) in
    Obj.repr(
# 138 "internal/uReStrParser.mly"
                                (`Group _2)
# 420 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    Obj.repr(
# 139 "internal/uReStrParser.mly"
      (`BoS)
# 426 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    Obj.repr(
# 140 "internal/uReStrParser.mly"
      (`EoS)
# 432 "internal/uReStrParser.ml"
               : 'regexp))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : UChar.t) in
    Obj.repr(
# 143 "internal/uReStrParser.mly"
        (_1)
# 439 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : char) in
    Obj.repr(
# 144 "internal/uReStrParser.mly"
        (UChar.of_char _1)
# 446 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 145 "internal/uReStrParser.mly"
        (UChar.of_char '-')
# 452 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 146 "internal/uReStrParser.mly"
             (UChar.of_char '{')
# 458 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 147 "internal/uReStrParser.mly"
              (UChar.of_char '}')
# 464 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 148 "internal/uReStrParser.mly"
        (UChar.of_char ' ')
# 470 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 149 "internal/uReStrParser.mly"
      (UChar.of_char '&')
# 476 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 150 "internal/uReStrParser.mly"
     (UChar.of_char '|')
# 482 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    Obj.repr(
# 151 "internal/uReStrParser.mly"
        (UChar.of_char ':')
# 488 "internal/uReStrParser.ml"
               : 'uchar))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'uchar) in
    Obj.repr(
# 154 "internal/uReStrParser.mly"
        ([_1])
# 495 "internal/uReStrParser.ml"
               : 'string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'uchar) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string) in
    Obj.repr(
# 155 "internal/uReStrParser.mly"
               (_1 :: _2)
# 503 "internal/uReStrParser.ml"
               : 'string))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'head_charset_char) in
    Obj.repr(
# 158 "internal/uReStrParser.mly"
                    (`Set (USet.add _1 USet.empty))
# 510 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'head_charset_char) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'charset_char) in
    Obj.repr(
# 159 "internal/uReStrParser.mly"
                                       (`Set (USet.add_range _1 _3 USet.empty))
# 518 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tail_charset) in
    Obj.repr(
# 160 "internal/uReStrParser.mly"
                   (`Compl _2)
# 525 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'charset) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tail_charset) in
    Obj.repr(
# 161 "internal/uReStrParser.mly"
                                    (`Union (_1, _2))
# 533 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unquote) in
    Obj.repr(
# 162 "internal/uReStrParser.mly"
          (`Set _1)
# 540 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'set) in
    Obj.repr(
# 163 "internal/uReStrParser.mly"
      (_1)
# 547 "internal/uReStrParser.ml"
               : 'charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'charset_char) in
    Obj.repr(
# 166 "internal/uReStrParser.mly"
               (`Set (USet.add _1 USet.empty))
# 554 "internal/uReStrParser.ml"
               : 'tail_charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'charset_char) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'charset_char) in
    Obj.repr(
# 168 "internal/uReStrParser.mly"
    (`Set (USet.add_range _1 _3 USet.empty))
# 562 "internal/uReStrParser.ml"
               : 'tail_charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'tail_charset) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'tail_charset) in
    Obj.repr(
# 169 "internal/uReStrParser.mly"
                                         (`Union (_1, _2))
# 570 "internal/uReStrParser.ml"
               : 'tail_charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'unquote) in
    Obj.repr(
# 170 "internal/uReStrParser.mly"
          (`Set _1)
# 577 "internal/uReStrParser.ml"
               : 'tail_charset))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'set) in
    Obj.repr(
# 171 "internal/uReStrParser.mly"
      (_1)
# 584 "internal/uReStrParser.ml"
               : 'tail_charset))
; (fun __caml_parser_env ->
    Obj.repr(
# 174 "internal/uReStrParser.mly"
             (quoted_charset '(')
# 590 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    Obj.repr(
# 175 "internal/uReStrParser.mly"
              (quoted_charset ')')
# 596 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int * (int option) * string) in
    Obj.repr(
# 176 "internal/uReStrParser.mly"
       (let _, _, s = _1 in set_of_string s)
# 603 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    Obj.repr(
# 177 "internal/uReStrParser.mly"
      (quoted_charset '`')
# 609 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    Obj.repr(
# 178 "internal/uReStrParser.mly"
      (quoted_charset '\'')
# 615 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    Obj.repr(
# 179 "internal/uReStrParser.mly"
      (quoted_charset '|')
# 621 "internal/uReStrParser.ml"
               : 'unquote))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'set_notation) in
    Obj.repr(
# 182 "internal/uReStrParser.mly"
                                      (_2)
# 628 "internal/uReStrParser.ml"
               : 'set))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : UChar.t) in
    Obj.repr(
# 185 "internal/uReStrParser.mly"
        (_1)
# 635 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : char) in
    Obj.repr(
# 186 "internal/uReStrParser.mly"
        (UChar.of_char _1)
# 642 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 187 "internal/uReStrParser.mly"
           (UChar.of_char '*')
# 648 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 188 "internal/uReStrParser.mly"
       (UChar.of_char '+')
# 654 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 189 "internal/uReStrParser.mly"
           (UChar.of_char '?')
# 660 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 190 "internal/uReStrParser.mly"
      (UChar.of_char '.')
# 666 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 191 "internal/uReStrParser.mly"
         (UChar.of_char '$')
# 672 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 192 "internal/uReStrParser.mly"
               (UChar.of_char '[')
# 678 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 193 "internal/uReStrParser.mly"
        (UChar.of_char ' ')
# 684 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 194 "internal/uReStrParser.mly"
      (UChar.of_char '&')
# 690 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 195 "internal/uReStrParser.mly"
     (UChar.of_char '|')
# 696 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 196 "internal/uReStrParser.mly"
        (UChar.of_char ':')
# 702 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 197 "internal/uReStrParser.mly"
        (UChar.of_char '-')
# 708 "internal/uReStrParser.ml"
               : 'common_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 200 "internal/uReStrParser.mly"
                (UChar.of_char ']')
# 714 "internal/uReStrParser.ml"
               : 'head_charset_char))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'common_charset_char) in
    Obj.repr(
# 201 "internal/uReStrParser.mly"
                      (_1)
# 721 "internal/uReStrParser.ml"
               : 'head_charset_char))
; (fun __caml_parser_env ->
    Obj.repr(
# 204 "internal/uReStrParser.mly"
      (UChar.of_char '^')
# 727 "internal/uReStrParser.ml"
               : 'charset_char))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'common_charset_char) in
    Obj.repr(
# 205 "internal/uReStrParser.mly"
                      (_1)
# 734 "internal/uReStrParser.ml"
               : 'charset_char))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'property) in
    Obj.repr(
# 209 "internal/uReStrParser.mly"
    (let name = string_of_list _1 in `Property name)
# 741 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : 'charset) in
    Obj.repr(
# 210 "internal/uReStrParser.mly"
                                     (_2)
# 748 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'set_notation) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 211 "internal/uReStrParser.mly"
                                  (`Intr (_1, _3))
# 756 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'set_notation) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 212 "internal/uReStrParser.mly"
                                (`Intr (_1, _3))
# 764 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'set_notation) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 213 "internal/uReStrParser.mly"
                               (`Union (_1, _3))
# 772 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'set_notation) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 214 "internal/uReStrParser.mly"
                                  (`Diff (_1, _3))
# 780 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 215 "internal/uReStrParser.mly"
                   (`Compl _2)
# 787 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'set_notation) in
    Obj.repr(
# 216 "internal/uReStrParser.mly"
                     (_1)
# 794 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'set_notation) in
    Obj.repr(
# 217 "internal/uReStrParser.mly"
                     (_2)
# 801 "internal/uReStrParser.ml"
               : 'set_notation))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : char) in
    Obj.repr(
# 220 "internal/uReStrParser.mly"
        ([_1])
# 808 "internal/uReStrParser.ml"
               : 'property))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : char) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'property) in
    Obj.repr(
# 221 "internal/uReStrParser.mly"
                 (_1 :: _2)
# 816 "internal/uReStrParser.ml"
               : 'property))
(* Entry start *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let start (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : UReStrParserType.tree)
