"""
File:		Thread.py
Purpose:	Thread handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	from subprocess import *
except :
	Import.slException("Python")

# PyQt4
try :
	from	PyQt4	import QtCore
	"""
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
	"""
except :
	Import.slException("PyQt4")

# App 2
import	Display, File, Profile, Settings


### Threads

# Create
class tCreate(QtCore.QThread) :

	def create(self) :

		# Declare process
		self.pArc = QtCore.QProcess()

		# Declare paths
		dSource = QtCore.QDir()
		dOutput = QtCore.QDir()

		# Source
		dSource.setPath(self.oAI.Source.slFiles[self.oAI.Source.iNext])

		# Archive name
		sArcName = ""
		sExt = ""
		# User specified
		if self.oAI.Dest.bName and len(self.oAI.Dest.sName) :
			sArcName = self.oAI.Dest.sName
		# One input only or separate archives
		elif len(self.oAI.Source.slFiles) == 1 or self.oAI.Dest.bSeparate :
			sArcName = dSource.dirName()
		# Multiple inputs and only one archive
		else :
			sArcName = Settings.Application.sName

		dSource.cdUp()

		# CLI or GUI?
		if Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
			sCmd = Settings.Exec.P7Zip.CLI.sCommand
			sArgs = Settings.Exec.P7Zip.CLI.sArgs
		else :
			sCmd = Settings.Exec.P7Zip.GUI.sCommand
			sArgs = Settings.Exec.P7Zip.GUI.sArgs

		# Arguments
		sArcCmdArgs = ""
		slCmdArgs = []
		slArgs = sArgs.split()
		while len(slArgs) and len(slArgs[0]) :
			slCmdArgs.append(slArgs.pop(0))

		# Switches
		if self.oAI.Misc.bSwitches :
			slSwitches = self.oAI.Misc.sSwitches.strip().split()
			while len(slSwitches) and len(slSwitches[0]) :
				slCmdArgs.append(slSwitches.pop(0))

		# Algorithm
		if self.oAI.Type.sAlgorithm == "XZ" or self.oAI.Type.sAlgorithm == "BZip2" or self.oAI.Type.sAlgorithm == "GZip" or self.oAI.Type.sAlgorithm == "Tar" :

			# Command
			sCmd = Settings.Exec.Tar.sCommand

			# Format
			if self.oAI.Type.sAlgorithm == "XZ" :
				slCmdArgs.append("-J")
				sExt = ".tar.xz"
			elif self.oAI.Type.sAlgorithm == "BZip2" :
				slCmdArgs.append("-j")
				sExt = ".tar.bz2"
			elif self.oAI.Type.sAlgorithm == "GZip" :
				slCmdArgs.append("-z")
				sExt = ".tar.gz"
			else :
				sExt = ".tar"

			# Keep permissions
			slCmdArgs.append("-p")

			# Exclusions
			slWildcards = Settings.User.Syntax.sExclusions.split()
			while len(slWildcards) and len(slWildcards[0]) :
				slCmdArgs.append("--exclude=" + slWildcards.pop(0))

			# Working directory
			slCmdArgs.append("-cC")
			#slCmdArgs.append('\"' + dSource.path() + '\"')
			slCmdArgs.append(dSource.path())

			# Use relative paths for tarball contents
			if not self.oAI.Dest.bSeparate :
				for iEntry in range(0, len(self.oAI.Source.slFiles)) :
					self.oAI.Source.slFiles.insert(iEntry, dSource.relativeFilePath(self.oAI.Source.slFiles.pop(iEntry)))
			else :
				self.oAI.Source.slFiles.insert(self.oAI.Source.iNext, dSource.relativeFilePath(self.oAI.Source.slFiles.pop(self.oAI.Source.iNext)))

			# Archive file
			slCmdArgs.append("-f")

		else :

			# Format
			if self.oAI.Type.sAlgorithm == "7-Zip" :
				slCmdArgs.append("-t7z")
				sExt = ".7z"

				# Scrambled
				if not self.oAI.Security.bScramble :
					slCmdArgs.append("-mhe=off")
				else :
					slCmdArgs.append("-mhe=on")

				# Solid
				if not self.oAI.Type.bSolid :
					slCmdArgs.append("-ms=off")
				else :
					slCmdArgs.append("-ms=on")

				# Volumes
				if self.oAI.Type.sVolume == "Floppy" :
					slCmdArgs.append("-v1440k")
				elif self.oAI.Type.sVolume == "CD" :
					slCmdArgs.append("-v720000k")
				elif self.oAI.Type.sVolume == "DVD" :
					slCmdArgs.append("-v4700000000b")
				elif self.oAI.Type.sVolume == "Unlimited" :
					pass
				else :
					slCmdArgs.append("-v" + self.oAI.Type.sVolume)

			elif self.oAI.Type.sAlgorithm == "Zip" :
				slCmdArgs.append("-tzip")
				sExt = ".zip"

			# Compression level
			if self.oAI.Type.sComp == "None" :
				slCmdArgs.append("-mx0")
			elif self.oAI.Type.sComp == "Fastest" :
				slCmdArgs.append("-mx1")
			elif self.oAI.Type.sComp == "Fast" :
				slCmdArgs.append("-mx3")
			elif self.oAI.Type.sComp == "Normal" :
				slCmdArgs.append("-mx5")
			elif self.oAI.Type.sComp == "Maximum" :
				slCmdArgs.append("-mx7")
			elif self.oAI.Type.sComp == "Ultra" :
				slCmdArgs.append("-mx9")

			# Method
			if self.oAI.Type.sMethod == "Update" :
				slCmdArgs.append("u")
			elif self.oAI.Type.sMethod == "Sync" :
				slCmdArgs.append("u")
				slCmdArgs.append("-uq0")
			elif self.oAI.Type.sMethod == "Add" :
				slCmdArgs.append("a")

			# Yes to all
			slCmdArgs.append("-y")

			# Password
			if self.oAI.Security.bPassword and len(self.oAI.Security.sPassword) :
				slCmdArgs.append("-p" + self.oAI.Security.sPassword)

			# SFX
			if self.oAI.Type.bSFX :
				slCmdArgs.append("-sfx")
				sExt = ".exe"

			# Recursive
			slCmdArgs.append("-r0")

			# Exclusions
			slWildcards = Settings.User.Syntax.sExclusions.split()
			while len(slWildcards) and len(slWildcards[0]) :
				slCmdArgs.append("-x!" + slWildcards.pop(0))

		# Destination
		if not self.oAI.Dest.bDest or not len(self.oAI.Dest.sDir) :
			dOutput.setPath(dSource.path() + "/")
		else :
			dOutput.setPath(self.oAI.Dest.sDir + "/")

		# Structured
		if self.oAI.Dest.bStructured :
			dOutput.setPath(dOutput.path() + "/" + dSource.path().replace(':', '') + "/")

		# Test destination
		if not dOutput.exists() :
			dOutput.mkpath(dOutput.path())

		dOutput.setPath(dOutput.path() + "/" + sArcName + sExt)
		#self.oAI.Dest.sFullPath = "'" + dOutput.path() + "'"
		self.oAI.Dest.sFullPath = dOutput.path()

		# Append archive and file(s)
		slCmdArgs.append(self.oAI.Dest.sFullPath)

		# Input
		# Many archives
		if self.oAI.Dest.bSeparate :
			slCmdArgs.append(self.oAI.Source.slFiles[self.oAI.Source.iNext])
		# Single archive
		else :
			slCmdArgs.extend(self.oAI.Source.slFiles)

		# Volumes
		if self.oAI.Type.sVolume != "Unlimited" :
			self.oAI.Dest.sFullPath += ".001"

		# Globalise command
		Settings.Exec.sCommand = sCmd

		# Messages
		File.slMessage(Settings.Message.iInformation, "Input = " + self.oAI.Source.slFiles[self.oAI.Source.iNext])
		File.slMessage(Settings.Message.iInformation, "Archive = " + self.oAI.Dest.sFullPath)
		File.slMessage(Settings.Message.iInformation, "Command = " + sCmd)
		for iEntry in range(0, len(slCmdArgs)) :
			sArcCmdArgs += slCmdArgs[iEntry] + " "
		File.slMessage(Settings.Message.iInformation, "Arguments = " + sArcCmdArgs)

		# Execute process
		self.pArc.start(sCmd, slCmdArgs)

		if self.pArc.waitForStarted(Settings.Timer.Process.iPause) :

			# Messages
			File.slMessage(Settings.Message.iInformation, "The archiving process has started.")

			#iWaitCount = 0

			#if not self.pArc.waitForFinished(-1) :
			while not self.pArc.waitForFinished(Settings.Timer.Process.iPause) :
				pass
				#self.emit(QtCore.SIGNAL("error(QString)"), "The archiving process unexpectedly terminated.")
				"""
				if iWaitCount >= Settings.Timer.Process.iWaitMax :
					# Messages
					self.emit(QtCore.SIGNAL("error(QString)"), "The archiving process was taking too long to complete.")
					break
				iWaitCount += 1
				# Search for percentage indicator
				#sArcData = bytes.decode(self.pArc.readData(512))
				"""

			sOutput = bytes.decode(bytes(self.pArc.readAllStandardOutput()))
			sError = bytes.decode(bytes(self.pArc.readAllStandardError()))

			# Analyse exit-code
			if self.pArc.exitCode() is not 0 or sOutput.count("Break signaled") :

				# Progress
				self.oAI.iProgress = 0
				self.oAI.bSuccess = False

				# CLI or GUI?
				if not len(sOutput) :
					# Using Tar
					if sCmd == Settings.Exec.Tar.sCommand :
						sOutput = sError
					# Invisible or CLI
					elif Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
						sOutput = "An unspecified error occurred, perhaps due to a segmentation fault."

				self.emit(QtCore.SIGNAL("error(QString)"), sOutput)

				# Messages
				File.slMessage(Settings.Message.iError, "File "  + str(self.oAI.Source.iNext) + " failed to archive: " + self.oAI.Source.slFiles[self.oAI.Source.iNext])

				# Invisible?
				if Import.Init.bInvisible :
					Display.slQuit()

			else :

				# Progress
				if not self.oAI.Dest.bSeparate :
					self.oAI.iProgress = 100
				else :
					self.oAI.iProgress = 100 * (self.oAI.Source.iNext+1) / len(self.oAI.Source.slFiles)

				# Adjust percentage
				if self.oAI.bTest :
					self.oAI.iProgress /= 2

				# Messages
				File.slMessage(Settings.Message.iInformation, "File " + str(self.oAI.Source.iNext) + " was successfully archived.")

				"""
				# Separate
				if self.oAI.Dest.bSeparate :
					self.oAI.Source.iNext += 1
				"""

			self.emit(QtCore.SIGNAL("done(int)"), self.oAI.iProgress)

		else :
			self.emit(QtCore.SIGNAL("error(QString)"), "Can't start the archiving process.")

		#return self.oAI

	def stop(self) :

		try :
			# Stop archiving
			if self.pArc.state() == QtCore.QProcess.Running :
				self.pArc.kill()
				pShell = Popen(["killall", Settings.Exec.sCommand], stdout=PIPE, stderr=PIPE)
				pShell.communicate()[0]
				#pShell = Popen(["kill", str(self.pArc.pid()+1)], stdout=PIPE, stderr=PIPE)
				#pShell.communicate()[0]
				# Messages
				File.slMessage(Settings.Message.iWarning, "The archiving process was stopped by the user.")
			else :
				tiExtract.stop()
		except :
			pass

		# Exit
		self.exit()

	def run(self) :

		# Invisible?
		if not Import.Init.bInvisible :
			# Priority
			self.setPriority(QtCore.QThread.LowPriority)

		# Process
		#self.pArc = QtCore.QProcess()

		# Profile
		#self.oAI = QtCore.QObject()
		self.oAI = Profile.oInfo

		# Operation
		self.oAI.iOperation = Settings.Operation.iCreate

		# GUI
		Display.slGuiProfileGetCreate(self.oAI)

		# Execute archiver
		for self.oAI.Source.iNext in range(0, len(self.oAI.Source.slFiles)) :

			# Proceed?
			if self.oAI.bSuccess and not Settings.Exec.bKilled :
				# Set GUI
				self.emit(QtCore.SIGNAL("operation(int)"), Settings.Operation.iCreate)
				self.create()
			else :
				break

			# Proceed?
			if self.oAI.bSuccess and not Settings.Exec.bKilled :

				if not self.oAI.Dest.bSeparate :

					# Test the archive
					if self.oAI.bTest :

						# Operation
						self.oAI.iSource = Settings.Operation.iCreate
						self.oAI.iOperation = Settings.Operation.iTest

						# Get GUI
						Display.slGuiProfileGetExtract(self.oAI)

						# Archive
						self.oAI.Source.slFiles = []
						self.oAI.Source.slFiles.append(self.oAI.Dest.sFullPath)

						# Set GUI
						self.emit(QtCore.SIGNAL("operation(int)"), Settings.Operation.iTest)

						# Test
						tiExtract.extract(self.oAI)

					break

				else :
					self.oAI.Source.iNext += 1

			else :
				break

			# Start event loop
			#self.exec_()

		else :
			self.emit(QtCore.SIGNAL("error(QString)"), "")

		# Invisible?
		if Import.Init.bInvisible :
			Display.slQuit()


# Extract the archive
class tExtract(QtCore.QThread) :

	def extract(self, oAI) :

		# Declare process
		self.pArc = QtCore.QProcess()

		# Declare paths
		dSource = QtCore.QDir()
		dOutput = QtCore.QDir()

		# Source
		dSource.setPath(oAI.Source.slFiles[0])
		dSource.makeAbsolute()

		# Beneath
		sBeneath = dSource.dirName().rsplit('.', 1)[0]
		dSource.cdUp()

		# Destination
		if not oAI.Dest.bDest or not len(oAI.Dest.sDir) :
			dOutput.setPath(dSource.path() + "/")
		else :
			dOutput.setPath(oAI.Dest.sDir + "/")

		# Filename
		if oAI.Dest.bName :
			dOutput.setPath(dOutput.path() + "/" + oAI.Dest.sName)

		if oAI.Dest.bBeneath :
			dOutput.setPath(dOutput.path() + "/" + sBeneath)

		# CLI or GUI?
		if Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
			sCmd = Settings.Exec.P7Zip.CLI.sCommand
			sArgs = Settings.Exec.P7Zip.CLI.sArgs
		else :
			sCmd = Settings.Exec.P7Zip.GUI.sCommand
			sArgs = Settings.Exec.P7Zip.GUI.sArgs

		# Arguments
		sArcCmdArgs = ""
		slCmdArgs = []
		slArgs = sArgs.split()
		while len(slArgs) and len(slArgs[0]) :
			slCmdArgs.append(slArgs.pop(0))

		"""
		# Switches
		if oAI.Misc.bSwitches :
			slSwitches = oAI.Misc.sSwitches.strip().split()
			while len(slSwitches) and len(slSwitches[0]) :
				slCmdArgs.append(slSwitches.pop(0))
		"""

		# Algorithm
		#if oAI.iOperation == Settings.Operation.iExtract
		if oAI.Source.slFiles[0].endswith(".tar.xz") or oAI.Source.slFiles[0].endswith(".tar.bz2") or oAI.Source.slFiles[0].endswith(".tar.gz") or oAI.Source.slFiles[0].endswith(".tar") :

			# Command
			sCmd = Settings.Exec.Tar.sCommand

			# Extract or test
			if oAI.iOperation == Settings.Operation.iExtract :
				slCmdArgs.append("-x")
			else :
				slCmdArgs.append("-t")

			# Keep permissions
			slCmdArgs.append("-p")

			# Exclusions
			slWildcards = Settings.User.Syntax.sExclusions.split()
			while len(slWildcards) and len(slWildcards[0]) :
				slCmdArgs.append("--exclude=" + slWildcards.pop(0))

			# Working directory
			slCmdArgs.append("-C")
			#slCmdArgs.append("'" + dOutput.path() + "/" + "'")
			slCmdArgs.append(dOutput.path() + "/")

			# Archive file
			slCmdArgs.append("-f")

			# Archive
			#slCmdArgs.append("'" + oAI.Source.slFiles[0] + "'")
			slCmdArgs.append(oAI.Source.slFiles[0])

		else :

			# Extract or test
			if oAI.iOperation == Settings.Operation.iExtract :
				slCmdArgs.append("x")
			else :
				slCmdArgs.append("t")

			# Answer 'yes' to all queries
			slCmdArgs.append("-y")

			# Recursive
			slCmdArgs.append("-r0")

			# Exclusions
			slWildcards = Settings.User.Syntax.sExclusions.split()
			while len(slWildcards) and len(slWildcards[0]) :
				slCmdArgs.append("-x!" + slWildcards.pop(0))

			# Output directory
			#slCmdArgs.append("-o'" + dOutput.path() + "/" + "'")
			slCmdArgs.append("-o" + dOutput.path() + "/")

			# Password
			if oAI.Security.bPassword and len(oAI.Security.sPassword) :
				slCmdArgs.append("-p" + oAI.Security.sPassword)
			else :
				slCmdArgs.append("-pNoPassword")

			# Archive
			#slCmdArgs.append("'" + oAI.Source.slFiles[0] + "'")
			slCmdArgs.append(oAI.Source.slFiles[0])

		# Test destination
		if not dOutput.exists() :
			dOutput.mkpath(dOutput.path())

		# Globalise command
		Settings.Exec.sCommand = sCmd

		# Messages
		File.slMessage(Settings.Message.iInformation, "Archive = " + oAI.Source.slFiles[0])
		File.slMessage(Settings.Message.iInformation, "Destination = " + dOutput.path() + "/")
		File.slMessage(Settings.Message.iInformation, "Command = " + sCmd)
		for iEntry in range(0, len(slCmdArgs)) :
			sArcCmdArgs += slCmdArgs[iEntry] + " "
		File.slMessage(Settings.Message.iInformation, "Arguments = " + sArcCmdArgs)

		# Execute process
		self.pArc.start(sCmd, slCmdArgs)

		if self.pArc.waitForStarted(Settings.Timer.Process.iPause) :

			# Messages
			File.slMessage(Settings.Message.iInformation, "The extracting/testing process has started.")

			#iWaitCount = 0

			#if not self.pArc.waitForFinished(-1) :
			while not self.pArc.waitForFinished(Settings.Timer.Process.iPause) :
				pass
				#self.emit(QtCore.SIGNAL("error(QString)"), "The extracting/testing process unexpectedly terminated.")
				"""
				if iWaitCount >= Settings.Timer.Process.iWaitMax :
					# Messages
					self.emit(QtCore.SIGNAL("error(QString)"), "The extracting/testing process was taking too long to complete.")
					break
				iWaitCount += 1

				# Get output
				sArcData = bytes.decode(self.pArc.readData(512))

				# Password?
				if sArcData.count("Enter password") :

					# Messages
					File.slMessage(Settings.Message.iInformation, "Password Requested")

					idPassword = QtGui.QInputDialog()
					Main.uiMain.leEPassword.setText(idPassword.getText(QtGui.QWidget, Settings.Application.sName + ": Enter Password", Settings.Application.sName + ": Enter Password"))
				"""

			sOutput = bytes.decode(bytes(self.pArc.readAllStandardOutput()))
			sError = bytes.decode(bytes(self.pArc.readAllStandardError()))

			# Analyse exit-code
			if self.pArc.exitCode() is not 0 or sOutput.count("Break signaled") :

				oAI.iProgress = 0
				oAI.bSuccess = False

				# CLI or GUI?
				if not len(sOutput) :
					# Using Tar
					if sCmd == Settings.Exec.Tar.sCommand :
						sOutput = sError
					# Invisible or CLI
					elif Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
						sOutput = "An unspecified error occurred, perhaps due to a segmentation fault."

				self.emit(QtCore.SIGNAL("error(QString)"), sOutput)

				File.slMessage(Settings.Message.iError, "File " + str(oAI.Source.iNext) + " failed to extract/test: " + oAI.Source.slFiles[0])

				# Invisible?
				if Import.Init.bInvisible :
					Display.slQuit()

			else :

				oAI.iProgress = 100
				#oAI.bSuccess = True

				# Messages
				File.slMessage(Settings.Message.iInformation, "File " + str(oAI.Source.iNext) + " was successfully extracted/tested.")

			self.emit(QtCore.SIGNAL("done(int)"), oAI.iProgress)

		else :
			self.emit(QtCore.SIGNAL("error(QString)"), "Can't start the extracting/testing process.")

		return oAI

	def stop(self) :

		try :
			# Stop archiving
			if self.pArc.state() == QtCore.QProcess.Running :
				self.pArc.kill()
				pShell = Popen(["killall", Settings.Exec.sCommand], stdout=PIPE, stderr=PIPE)
				pShell.communicate()[0]
				#pShell = Popen(["kill", str(self.pArc.pid()+1)], stdout=PIPE, stderr=PIPE)
				#pShell.communicate()[0]
				# Messages
				File.slMessage(Settings.Message.iWarning, "The extracting/testing process was stopped by the user.")
		except :
			pass

		# Exit
		self.exit()

	def run(self) :

		# Invisible?
		if not Import.Init.bInvisible :
			# Priority
			self.setPriority(QtCore.QThread.LowPriority)

		# Process
		#self.pArc = QtCore.QProcess()

		# Profile
		#self.oAI = QtCore.QObject()
		self.oAI = Profile.oInfo

		# Operation
		self.oAI.iSource = Settings.Operation.iExtract

		# Get GUI
		Display.slGuiProfileGetExtract(self.oAI)

		# Proceed?
		if len(self.oAI.Source.slFiles[0]) and not Settings.Exec.bKilled :

			# Extract or test
			if self.oAI.bTest :
				self.oAI.iOperation = Settings.Operation.iTest
				self.emit(QtCore.SIGNAL("operation(int)"), Settings.Operation.iTest)
			else :
				self.oAI.iOperation = Settings.Operation.iExtract
				self.emit(QtCore.SIGNAL("operation(int)"), Settings.Operation.iExtract)

			# Extract/Test archive
			self.extract(self.oAI)

			# Start event loop
			#self.exec_()

		else :
			self.emit(QtCore.SIGNAL("error(QString)"), "")

		# Invisible?
		if Import.Init.bInvisible :
			Display.slQuit()


### Variables

tiCreate	= tCreate()
tiExtract	= tExtract()
