"""
File:		Profile.py
Purpose:	Profile handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")

# App 2
import	Display, Settings


### Variables

# Profile
oInfo								= QtCore.QObject()
oInfo.Type							= QtCore.QObject()
oInfo.Type.sAlgorithm		= ""
oInfo.Type.sMethod			= ""
oInfo.Type.sCompression	= ""
oInfo.Type.sVolume			= ""
oInfo.Type.bSFX					= False
oInfo.Type.bSolid				= False
oInfo.Security					= QtCore.QObject()
oInfo.Security.bScramble = False
oInfo.Security.bPassword = False
oInfo.Security.sPassword = ""
oInfo.Source					= QtCore.QObject()
oInfo.Source.iNext		= 0
oInfo.Source.slFiles		= []
oInfo.Dest						= QtCore.QObject()
oInfo.Dest.bDest			= False
oInfo.Dest.bStructured	= False
oInfo.Dest.bSeparate		= False
oInfo.Dest.bBeneath		= False
oInfo.Dest.sDir				= ""
oInfo.Dest.bName			= False
oInfo.Dest.sName			= ""
oInfo.Misc						= QtCore.QObject()
oInfo.Misc.bSwitches		= False
oInfo.Misc.sSwitches		= ""


### Slots

# Load profile
def slLoad(sName) :

	sPath = Settings.Path.App.sConfig + "/Profiles/"

	# Choose file
	if len(sName) :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName(None, Settings.Application.sName + " - Open File", sPath, "Profiles (*.txt)")

	if len(sPath) :

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# Profile file
		fPro = QtCore.QFile(sPath)

		# Determine filename
		sName = fPro.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		if not fPro.open(QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text) :

			# Messages
			Display.slMessage(Settings.Message.iError, "Can't load the '" + sName + "' profile")

		else :

			# Profile
			oPI = oInfo

			# Defaults
			oPI.Misc.bSwitches = False
			oPI.Misc.sSwitches = ""

			# Prepare text stream
			tsPro = QtCore.QTextStream(fPro)

			while not tsPro.atEnd() :
				sLine = tsPro.readLine()
				slLine = sLine.split(' ', 2)

				if len(slLine) >= 3 :

					# Recognised options

					# Type
					if slLine[0] == "Archive_Format" :
						oPI.Type.sAlgorithm = slLine[2]
					elif slLine[0] == "Creation_Method" :
						oPI.Type.sMethod = slLine[2]
					elif slLine[0] == "Compression_Level" :
						oPI.Type.sComp = slLine[2]
					elif slLine[0] == "Volume_Size" :
						oPI.Type.sVolume = slLine[2].strip()
					elif slLine[0] == "SFX" :
						if slLine[2] == "Yes" :
							oPI.Type.bSFX = True
						else :
							oPI.Type.bSFX = False
					elif slLine[0] == "Solid" :
						if slLine[2] == "Yes" :
							oPI.Type.bSolid = True
						else :
							oPI.Type.bSolid = False

					# Security
					elif slLine[0] == "Scramble" :
						if slLine[2] == "Yes" :
							oPI.Security.bScramble = True
						else :
							oPI.Security.bScramble = False
					elif slLine[0] == "Password" :
						if slLine[2] == "Yes" :
							oPI.Security.bPassword = True
						else :
							oPI.Security.bPassword = False

					# Destination
					elif slLine[0] == "Destination" :
						if slLine[2] == "Yes" :
							oPI.Dest.bDest = True
						else :
							oPI.Dest.bDest = False
					elif slLine[0] == "Structured" :
						if slLine[2] == "Yes" :
							oPI.Dest.bStructured = True
						else :
							oPI.Dest.bStructured = False
					elif slLine[0] == "Separate" :
						if slLine[2] == "Yes" :
							oPI.Dest.bSeparate = True
						else :
							oPI.Dest.bSeparate = False
					elif slLine[0] == "Destination_Dir" :
						oPI.Dest.sDir = slLine[2]
					elif slLine[0] == "Archive_Name" :
						if slLine[2] == "Yes" :
							oPI.Dest.bName = True
						else :
							oPI.Dest.bName = False

					# Misc
					elif slLine[0] == "Switches" :
						if slLine[2] == "Yes" :
							oPI.Misc.bSwitches = True
						else :
							oPI.Misc.bSwitches = False
					if slLine[0] == "Switches_List" :
						oPI.Misc.sSwitches = slLine[2].strip()

			fPro.close()

			# Messages
			Display.slMessage(Settings.Message.iStatus, "Loaded the '" + sName + "' profile")

			# Set GUI
			Display.slGuiProfileSetCreate(oPI)


# Load 'Other' profile
def slLoadOther() :
	slLoad("")

# Load 'Default' profile
def slLoadDefault() :
	slLoad("Default")

# Load 'Flash' profile
def slLoadFlash() :
	slLoad("Flash")

# Load 'Local' profile
def slLoadLocal() :
	slLoad("Local")

# Load 'Remote' profile
def slLoadRemote() :
	slLoad("Remote")

# Load 'Secure' profile
def slLoadSecure() :
	slLoad("Secure")

# Load 'Storage' profile
def slLoadStorage() :
	slLoad("Storage")


# Save profile
def slSave(sName) :

	sPath = Settings.Path.App.sConfig + "/Profiles/"

	# Choose file
	if len(sName) :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getSaveFileName(None, Settings.Application.sName + " - Save File", sPath, "Profiles (*.txt)", QtGui.QFileDialog.DontConfirmOverwrite)

	if len(sPath) :

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# Profile file
		fPro = QtCore.QFile(sPath)

		# Determine filename
		sName = fPro.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		if not fPro.open(QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text) :

			# Messages
			Display.slMessage(Settings.Message.iError, "Can't save the '" + sName + "' profile")

		else :

			# Profile
			oPI = oInfo

			# Get GUI
			Display.slGuiProfileGetCreate(oPI)

			# Prepare text stream
			tsPro = QtCore.QTextStream(fPro)

			# Header
			tsPro << "### " + Settings.Application.sName + " v" + Settings.Application.sVersion + ": Profile\n"

			# Recognised options

			# Type
			tsPro << "\n# Type\n"
			tsPro << "Archive_Format = " + oPI.Type.sAlgorithm + "\n"
			tsPro << "Creation_Method = " + oPI.Type.sMethod + "\n"
			tsPro << "Compression_Level = " + oPI.Type.sComp + "\n"
			tsPro << "Volume_Size = " + oPI.Type.sVolume.strip() + "\n"
			if not oPI.Type.bSFX :
				tsPro << "SFX = No\n"
			else :
				tsPro << "SFX = Yes\n"
			if not oPI.Type.bSolid :
				tsPro << "Solid = No\n"
			else :
				tsPro << "Solid = Yes\n"

			# Security
			tsPro << "\n# Security\n"
			if not oPI.Security.bScramble :
				tsPro << "Scramble = No\n"
			else :
				tsPro << "Scramble = Yes\n"
			if not oPI.Security.bPassword :
				tsPro << "Password = No\n"
			else :
				tsPro << "Password = Yes\n"

			# Destination
			tsPro << "\n# Destination\n"
			if not oPI.Dest.bDest :
				tsPro << "Destination = No\n"
			else :
				tsPro << "Destination = Yes\n"
			if not oPI.Dest.bStructured :
				tsPro << "Structured = No\n"
			else :
				tsPro << "Structured = Yes\n"
			if not oPI.Dest.bSeparate :
				tsPro << "Separate = No\n"
			else :
				tsPro << "Separate = Yes\n"
			tsPro << "Destination_Dir = " + oPI.Dest.sDir + "\n"
			if not oPI.Dest.bName :
				tsPro << "Archive_Name = No\n"
			else :
				tsPro << "Archive_Name = Yes\n"

			# Misc
			tsPro << "\n# Misc\n"
			if not oPI.Misc.bSwitches :
				tsPro << "Switches = No\n"
			else :
				tsPro << "Switches = Yes\n"
			tsPro << "Switches_List = " + oPI.Misc.sSwitches.strip() + "\n"

			fPro.close()

			# Messages
			Display.slMessage(Settings.Message.iStatus, "Saved the '" + sName + "' profile")

# Save 'Other' profile
def slSaveOther() :
	slSave("")

# Save 'Default' profile
def slSaveDefault() :
	slSave("Default")

# Save 'Flash' profile
def slSaveFlash() :
	slSave("Flash")

# Save 'Local' profile
def slSaveLocal() :
	slSave("Local")

# Save 'Remote' profile
def slSaveRemote() :
	slSave("Remote")

# Save 'Secure' profile
def slSaveSecure() :
	slSave("Secure")

# Save 'Storage' profile
def slSaveStorage() :
	slSave("Storage")


# Reset profile
def slReset(sName) :

	bRet = True
	sBackupPath = Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/Profiles/"
	sBackupPath += sName + ".txt"
	sPath = Settings.Path.App.sConfig + "/Profiles/" + sName + ".txt"

	# Remove current
	QtCore.QFile.remove(sPath)

	# Copy original
	if QtCore.QFile.copy(sBackupPath, sPath) :
		Display.slMessage(Settings.Message.iStatus, "Reset the '" + sName + "' profile")
	else :
		bRet = False
		Display.slMessage(Settings.Message.iError, "Can't reset the '" + sName + "' profile")

	return bRet

# Reset 'Default' profile
def slResetDefault() :
	slReset("Default")

# Reset 'Flash' profile
def slResetFlash() :
	slReset("Flash")

# Reset 'Local' profile
def slResetLocal() :
	slReset("Local")

# Reset 'Remote' profile
def slResetRemote() :
	slReset("Remote")

# Reset 'Secure' profile
def slResetSecure() :
	slReset("Secure")

# Reset 'Storage' profile
def slResetStorage() :
	slReset("Storage")
