"""
File:		Input.py
Purpose:	Input arguments handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException("Python")

"""
# PyQt4
try :
	from	PyQt4	import QtCore
except :
	Import.slException("PyQt4")
"""

# App 2
import	Settings


### Slots

# CLI Arguments
def slArgTest() :

	# Supplied arguments
	if Settings.Input.iNumArgs >= 2 :

		# Help
		if "h" in sys.argv[1] :

			# About
			print(Settings.Application.sAbout1 + Settings.Application.sAbout2 + Settings.Application.sUsage)

			# Exit
			sys.exit()

		"""
		# Verbose
		if "v" in sys.argv[1] :

			Import.Init.bVerbose = True

			File.slAbout()
		"""

		# Profile
		if "f" in sys.argv[1] :
			Settings.Init.Create.sProfile = "Flash"
		elif "l" in sys.argv[1] :
			Settings.Init.Create.sProfile = "Local"
		elif "r" in sys.argv[1] :
			Settings.Init.Create.sProfile = "Remote"
		elif "s" in sys.argv[1] :
			Settings.Init.Create.sProfile = "Storage"
		else :
			Settings.Init.Create.sProfile = "Default"

		# Auto-Updates
		if "u" in sys.argv[1] :
			Settings.Init.bAutoUpdate = False

		# Supplied arguments
		if Settings.Input.iNumArgs >= 3 :

			"""
			# Visibility
			if "i" in sys.argv[1] :
				Settings.Init.bInvisible = True
			"""
			#Settings.Init.bInvisible = Import.Init.bInvisible

			# List
			if "L" in sys.argv[1] :
				Settings.Init.Create.sList = sys.argv[2]
			else :
				# List of files to archive
				for iEntry in range(2, Settings.Input.iNumArgs) :
					Settings.List.slFiles.append(sys.argv[iEntry])
					#Settings.List.slFiles.append(sys.argv[iEntry].decode('utf-8'))

			# Create Archive
			if "c" in sys.argv[1] :

				# Operation
				Settings.Operation.iActive = Settings.Operation.iCreate

				# Auto-quit
				if "d" in sys.argv[1] or "f" in sys.argv[1] or "l" in sys.argv[1] or "r" in sys.argv[1] or "s" in sys.argv[1] :
					Settings.Init.bAutoQuit = True

			# Extract Archive
			elif "e" in sys.argv[1] :

				# Operation
				Settings.Operation.iActive = Settings.Operation.iExtract

				# Beneath
				if "b" in sys.argv[1] :
					Settings.Init.Extract.bBeneath = True

				# Profile
				if "d" in sys.argv[1] :
					Settings.Init.bAutoQuit = True

			# Test Archive
			elif "t" in sys.argv[1] :

				# Operation
				Settings.Operation.iActive = Settings.Operation.iTest

				# Default
				if "d" in sys.argv[1] :
					Settings.Init.bAutoQuit = True
