"""
File:		Display.py
Purpose:	Display handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException("Python")

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")

# App 2
import	File, Help, Main, Settings


### Slots

# Display init
def slInits() :

	# Visible?
	if not Import.Init.bInvisible :

		slToggles()

		Main.mwMain.show()


# Choose the source creation directory
def slCGetSDir() :
	Main.uiMain.cbSDir.setEditText(QtGui.QFileDialog.getExistingDirectory(None, Settings.Application.sName + " - Choose Folder", Main.uiMain.cbSDir.currentText()))

# Choose the source extraction archive
def slEGetSArc() :
	dOutput = QtCore.QDir()
	dOutput.setPath(Main.uiMain.cbArchive.currentText())
	Main.uiMain.cbArchive.setEditText(QtGui.QFileDialog.getOpenFileName(None, Settings.Application.sName + " - Open File", dOutput.path(), "All Files(*)"))

# Choose the destination creation directory
def slCGetDDir() :
	Main.uiMain.cbCDDir.setEditText(QtGui.QFileDialog.getExistingDirectory(None, Settings.Application.sName + " - Choose Folder", Main.uiMain.cbCDDir.currentText()))

# Choose the destination extraction directory
def slEGetDDir() :
	Main.uiMain.cbEDDir.setEditText(QtGui.QFileDialog.getExistingDirectory(None, Settings.Application.sName + " - Choose Folder", Main.uiMain.cbEDDir.currentText()))


# Enable or disable items
def slToggles() :

	# Check boxes
	# Destinations
	if not Main.uiMain.gbCDestination.isChecked() :
		Main.uiMain.chbCName.setCheckState(QtCore.Qt.Unchecked)
		Main.uiMain.cbStructured.setCheckState(QtCore.Qt.Unchecked)
		Main.uiMain.cbSeparate.setCheckState(QtCore.Qt.Unchecked)
	# Separate
	if Main.uiMain.cbSeparate.isChecked() :
		Main.uiMain.chbCName.setCheckState(QtCore.Qt.Unchecked)
		Main.uiMain.cbCTest.setCheckState(QtCore.Qt.Unchecked)
	if not Main.uiMain.gbEDestination.isChecked() :
		Main.uiMain.chbEName.setCheckState(QtCore.Qt.Unchecked)
		Main.uiMain.cbBeneath.setCheckState(QtCore.Qt.Unchecked)

	# Menus
	Main.uiMain.aVerbose.setChecked(Import.Init.bVerbose)
	Main.uiMain.aAReview.setEnabled(Import.Init.bVerbose)
	Main.uiMain.aAutoQuit.setChecked(Settings.Init.bAutoQuit)


# GUI Profile Get Create
def slGuiProfileGetCreate(oPI) :

	# Source
	oPI.Source.slFiles = []
	if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
		if len(Main.uiMain.cbSDir.currentText()) :
			oPI.Source.slFiles.append(Main.uiMain.cbSDir.currentText())
	else :
		oPI.Source.slFiles.extend(Settings.List.slFiles)
	oPI.Source.iNext		= 0

	# Misc
	oPI.bTest				= False
	oPI.bSuccess			= True
	oPI.iProgress			= 0

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		oPI.Type.sAlgorithm 	= Main.uiMain.cbAlgorithm.currentText()
		oPI.Type.sMethod		= Main.uiMain.cbMethod.currentText()
		oPI.Type.sComp			= Main.uiMain.cbComp.currentText()
		oPI.Type.sVolume		= Main.uiMain.cbVolume.currentText()
		oPI.Type.bSFX			= Main.uiMain.cbSFX.isChecked()
		oPI.Type.bSolid			= Main.uiMain.cbSolid.isChecked()

		# Security
		oPI.Security.bScramble	= Main.uiMain.cbScramble.isChecked()
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

		# Destination
		oPI.Dest.bDest			= Main.uiMain.gbCDestination.isChecked()
		oPI.Dest.bStructured	= Main.uiMain.cbStructured.isChecked()
		oPI.Dest.bSeparate		= Main.uiMain.cbSeparate.isChecked()
		oPI.Dest.sDir			= Main.uiMain.cbCDDir.currentText()
		oPI.Dest.bName			= Main.uiMain.chbCName.isChecked()
		oPI.Dest.sName			= Main.uiMain.cobCName.currentText()
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.Misc.bSwitches		= Main.uiMain.chbCSwitches.isChecked()
		oPI.Misc.sSwitches		= Main.uiMain.cobCSwitches.currentText()
		oPI.bTest				= Main.uiMain.cbCTest.isChecked()


# GUI Profile Set Create
def slGuiProfileSetCreate(oPI) :

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		Main.uiMain.cbAlgorithm.setCurrentIndex(Main.uiMain.cbAlgorithm.findText(oPI.Type.sAlgorithm))
		Main.uiMain.cbMethod.setCurrentIndex(Main.uiMain.cbMethod.findText(oPI.Type.sMethod))
		Main.uiMain.cbComp.setCurrentIndex(Main.uiMain.cbComp.findText(oPI.Type.sComp))
		if Main.uiMain.cbVolume.findText(oPI.Type.sVolume) >= 0 :
			Main.uiMain.cbVolume.setCurrentIndex(Main.uiMain.cbVolume.findText(oPI.Type.sVolume))
		else :
			Main.uiMain.cbVolume.setCurrentIndex(Main.uiMain.cbVolume.findText("Custom"))
			Main.uiMain.cbVolume.setEditText(oPI.Type.sVolume)
		if not oPI.Type.bSFX :
			Main.uiMain.cbSFX.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbSFX.setCheckState(QtCore.Qt.Checked)
		if not oPI.Type.bSolid :
			Main.uiMain.cbSolid.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbSolid.setCheckState(QtCore.Qt.Checked)
		# Security
		if not oPI.Security.bScramble :
			Main.uiMain.cbScramble.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbScramble.setCheckState(QtCore.Qt.Checked)
		if not oPI.Security.bPassword :
			Main.uiMain.cbCPassword.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbCPassword.setCheckState(QtCore.Qt.Checked)
		# Destination
		if not oPI.Dest.bDest :
			Main.uiMain.gbCDestination.setChecked(False)
		else :
			Main.uiMain.gbCDestination.setChecked(True)
		if not oPI.Dest.bStructured :
			Main.uiMain.cbStructured.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbStructured.setCheckState(QtCore.Qt.Checked)
		if not oPI.Dest.bSeparate :
			Main.uiMain.cbSeparate.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.cbSeparate.setCheckState(QtCore.Qt.Checked)
		Main.uiMain.cbCDDir.setEditText(oPI.Dest.sDir)
		if not oPI.Dest.bName :
			Main.uiMain.chbCName.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.chbCName.setCheckState(QtCore.Qt.Checked)
		# Misc
		if not oPI.Misc.bSwitches :
			Main.uiMain.chbCSwitches.setCheckState(QtCore.Qt.Unchecked)
		else :
			Main.uiMain.chbCSwitches.setCheckState(QtCore.Qt.Checked)
		Main.uiMain.cobCSwitches.setEditText(oPI.Misc.sSwitches)

# GUI Profile Get Extract
def slGuiProfileGetExtract(oPI) :

	# Source operation
	if oPI.iSource == Settings.Operation.iCreate :

		# Security
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

	else :

		# Source
		oPI.Source.slFiles = []
		if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
			#if len(Main.uiMain.cbArchive.currentText()) :
			oPI.Source.slFiles.append(Main.uiMain.cbArchive.currentText())
		else :
			oPI.Source.slFiles.extend(Settings.List.slFiles)
		oPI.Source.iNext		= 0

		# Destination
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.bTest				= False
		oPI.bSuccess			= True
		oPI.iProgress			= 0

		# Visible?
		if not Import.Init.bInvisible :

			# Security
			oPI.Security.bPassword	= Main.uiMain.cbEPassword.isChecked()
			oPI.Security.sPassword	= Main.uiMain.leEPassword.displayText()

			# Destination
			oPI.Dest.bDest			= Main.uiMain.gbEDestination.isChecked()
			oPI.Dest.bBeneath		= Main.uiMain.cbBeneath.isChecked()
			oPI.Dest.sDir			= Main.uiMain.cbEDDir.currentText()
			oPI.Dest.bName			= Main.uiMain.chbEName.isChecked()
			oPI.Dest.sName			= Main.uiMain.cobEName.currentText()

			# Misc
			oPI.bTest				= Main.uiMain.cbETest.isChecked()


# Progress
def slProgress(iRetVal) :

	# Visible?
	if not Import.Init.bInvisible :

		# Update
		Main.uiMain.pbComplete.setValue(iRetVal)

# Enable GUI
def slEnableGUI() :

	# Visible?
	if not Import.Init.bInvisible :

		Main.uiMain.aAStop.setEnabled(False)
		Main.uiMain.pbStop.setEnabled(False)
		Main.uiMain.pbComplete.setEnabled(False)
		Main.uiMain.twOperations.setEnabled(True)

		slTabPage()

		slMessage(Settings.Message.iClear, "")

# Disable GUI
def slDisableGUI() :

	# Visible?
	if not Import.Init.bInvisible :

		# Reset or disable items
		Main.uiMain.twOperations.setEnabled(False)
		Main.uiMain.aAStop.setEnabled(True)
		Main.uiMain.pbComplete.setEnabled(True)
		Main.uiMain.pbStop.setEnabled(True)
		Main.uiMain.pbComplete.setValue(0)
		Main.uiMain.aACreate.setEnabled(False)
		Main.uiMain.aAExtract.setEnabled(False)

# External files
def slGUIExternal(iOperation) :

	# Visible?
	if not Import.Init.bInvisible :

		# Create
		Main.uiMain.cbSDir.setEditText("External File(s)")
		Main.uiMain.cbSDir.setEnabled(False)
		Main.uiMain.pbSDir.setEnabled(False)

		# Extract
		Main.uiMain.cbArchive.setEditText("External File(s)")
		Main.uiMain.cbArchive.setEnabled(False)
		Main.uiMain.pbSArc.setEnabled(False)

		# FIXME: These lines are minor hacks
		Settings.Input.iNumArgs = 3

		# Operation
		if iOperation == Settings.Operation.iCreate :
			Main.uiMain.twOperations.setCurrentIndex(0)
			Main.uiMain.twOperations.setTabEnabled(1, False)
		elif iOperation == Settings.Operation.iExtract :
			Main.uiMain.twOperations.setCurrentIndex(1)
			Main.uiMain.twOperations.setTabEnabled(0, False)
			# Beneath
			if Settings.Init.Extract.bBeneath :
				Main.uiMain.gbEDestination.setChecked(True)
				Main.uiMain.cbBeneath.setCheckState(QtCore.Qt.Checked)
		elif iOperation == Settings.Operation.iTest :
			Main.uiMain.twOperations.setCurrentIndex(1)
			Main.uiMain.twOperations.setTabEnabled(0, False)
			Main.uiMain.cbETest.setChecked(True)

		slTabPage()


# Add MRU items
def slCAddMRU() :

	# Visible and staying?
	if not Import.Init.bInvisible and not Settings.Init.bAutoQuit :
		# Switches
		if Main.uiMain.cobCSwitches.isEnabled() and len(Main.uiMain.cobCSwitches.currentText()) :
			Main.uiMain.cobCSwitches.insertItem(0, Main.uiMain.cobCSwitches.currentText())
		# Source dir
		if Main.uiMain.cbSDir.isEnabled() and len(Main.uiMain.cbSDir.currentText()) :
			Main.uiMain.cbSDir.insertItem(0, Main.uiMain.cbSDir.currentText())
		# Destination dir
		if Main.uiMain.cbCDDir.isEnabled() and len(Main.uiMain.cbCDDir.currentText()) :
			Main.uiMain.cbCDDir.insertItem(0, Main.uiMain.cbCDDir.currentText())
		# Archive name
		if Main.uiMain.cobCName.isEnabled() and len(Main.uiMain.cobCName.currentText()) :
			Main.uiMain.cobCName.insertItem(0, Main.uiMain.cobCName.currentText())

# Add MRU items
def slEAddMRU() :

	# Visible and staying?
	if not Import.Init.bInvisible and not Settings.Init.bAutoQuit :
		# Source archive
		if Main.uiMain.cbArchive.isEnabled() and len(Main.uiMain.cbArchive.currentText()) :
			Main.uiMain.cbArchive.insertItem(0, Main.uiMain.cbArchive.currentText())
		# Destination dir
		if Main.uiMain.cbEDDir.isEnabled() and len(Main.uiMain.cbEDDir.currentText()) :
			Main.uiMain.cbEDDir.insertItem(0, Main.uiMain.cbEDDir.currentText())
		# Folder name
		if Main.uiMain.cobEName.isEnabled() and len(Main.uiMain.cobEName.currentText()) :
			Main.uiMain.cobEName.insertItem(0, Main.uiMain.cobEName.currentText())


# TabPage
def slTabPage() :

	# Which tab is active?
	if Main.uiMain.twOperations.currentWidget() == Main.uiMain.tCreate :

		# Menus
		Main.uiMain.mProfile.setEnabled(True)
		Main.uiMain.mList.setEnabled(True)

		# Menu entries
		Main.uiMain.aACreate.setEnabled(True)
		Main.uiMain.aAExtract.setEnabled(False)

		# Buttons
		Main.uiMain.pbCreate.setDefault(True)

	if Main.uiMain.twOperations.currentWidget() == Main.uiMain.tExtract :

		# Menus
		Main.uiMain.mProfile.setEnabled(False)
		Main.uiMain.mList.setEnabled(False)

		# Menu entries
		Main.uiMain.aACreate.setEnabled(False)
		Main.uiMain.aAExtract.setEnabled(True)

		# Buttons
		Main.uiMain.pbExtract.setDefault(True)

# Operation
def slOperation(iOperation) :

	# Messages
	if iOperation == Settings.Operation.iCreate :
		slMessage(Settings.Message.iTitle, "Creating ...")
		slMessage(Settings.Message.iStatus, "Creating the archive(s) ...")
	elif iOperation == Settings.Operation.iExtract :
		slMessage(Settings.Message.iTitle, "Extracting ...")
		slMessage(Settings.Message.iStatus, "Extracting the archive(s) ...")
	elif iOperation == Settings.Operation.iTest :
		slMessage(Settings.Message.iTitle, "Testing ...")
		slMessage(Settings.Message.iStatus, "Testing the archive(s) ...")


# Message
def slMessage(iType, sMessage) :

	bResult = False

	# Visible?
	if not Import.Init.bInvisible :

		bResult = QtGui.QMessageBox.Ok

		# Clear
		if iType == Settings.Message.iClear :
			Main.mwMain.setWindowTitle(Settings.Application.sName)
			Main.uiMain.sbMain.clearMessage()
		# Title bar
		elif iType == Settings.Message.iTitle :
			Main.mwMain.setWindowTitle(Settings.Application.sName + " - " + sMessage)
		# Status bar or system tray
		elif iType == Settings.Message.iStatus or iType == Settings.Message.iTray :
			Main.uiMain.sbMain.showMessage(sMessage)
		"""
		# Tray icon tip
		elif iType == Settings.Message.iTrayTip :
			Main.stiMain.setToolTip(Settings.Application.sName + " - " + sMessage)
		"""

		# Dialog?
		if len(sMessage) and Main.mwMain.isVisible() :
			# Information
			if iType == Settings.Message.iInformation :
				QtGui.QMessageBox.information(Main.uiMain.cwMain, Settings.Application.sName + " - Information", sMessage, QtGui.QMessageBox.Ok)
			# Warning
			elif iType == Settings.Message.iWarning :
				QtGui.QMessageBox.warning(Main.uiMain.cwMain, Settings.Application.sName + " - Warning", sMessage, QtGui.QMessageBox.Ok)
			# Error
			elif iType == Settings.Message.iError :
				QtGui.QMessageBox.critical(Main.uiMain.cwMain, Settings.Application.sName + " - Error", sMessage, QtGui.QMessageBox.Ok)
			# Question
			elif iType == Settings.Message.iQuestion :
				bResult = QtGui.QMessageBox.question(Main.uiMain.cwMain, Settings.Application.sName + " - Question", sMessage, QtGui.QMessageBox.Yes | QtGui.QMessageBox.No)
		"""
		else :
			# Tray icon message
			if iType == Settings.Message.iTray and QtGui.QSystemTrayIcon.supportsMessages() :
				Main.stiMain.showMessage(Settings.Application.sName, sMessage, QtGui.QSystemTrayIcon.Information, Settings.Timer.Control.iLaunched)
		"""

	else :

		sMessage = sMessage.replace("<br>", "\n")

		if len(sMessage) :
			# Error
			if iType == Settings.Message.iError :
				print("Error: " + sMessage)

	File.slMessage(iType, sMessage)

	return bResult


# No binary
def slNoBinary(sApp, sWebsite) :

	# Launch website
	if len(sWebsite) :
		Help.slUOpen(QtCore.QUrl(sWebsite))

	# Message
	slMessage(Settings.Message.iError, "The required " + sApp + " executable file can't be found.  Download and install it, then restart " + Settings.Application.sName + ".")


# Quit
def slQuit() :

	# Visible?
	if not Import.Init.bInvisible :

		# Save
		Settings.slSave()

		# Close main window
		Main.mwMain.close()

	else :

		# Exit
		sys.exit()
